
/*---------------------------------------------------------------
  SQL DB BACKUP 07.07.2021 22:59 
  HOST: localhost
  DATABASE: spp_live
  TABLES: *
  ---------------------------------------------------------------*/

/*---------------------------------------------------------------
  TABLE: `angsurantoko`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `angsurantoko`;
CREATE TABLE `angsurantoko` (
  `id_angsurantoko` varchar(10) NOT NULL,
  `id_hutangtoko` varchar(10) NOT NULL,
  `tanggal` date NOT NULL,
  `angsuran` int(11) NOT NULL,
  PRIMARY KEY (`id_angsurantoko`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*---------------------------------------------------------------
  TABLE: `bulan`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `bulan`;
CREATE TABLE `bulan` (
  `idBulan` varchar(15) NOT NULL DEFAULT '0',
  `nmBulan` varchar(25) DEFAULT NULL,
  `urutan` int(2) DEFAULT NULL,
  PRIMARY KEY (`idBulan`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
INSERT INTO `bulan` VALUES   ('1','Januari','7');
INSERT INTO `bulan` VALUES ('10','Oktober','4');
INSERT INTO `bulan` VALUES ('11','November','5');
INSERT INTO `bulan` VALUES ('12','Desember','6');
INSERT INTO `bulan` VALUES ('2','Februari','8');
INSERT INTO `bulan` VALUES ('3','Maret','9');
INSERT INTO `bulan` VALUES ('4','April','10');
INSERT INTO `bulan` VALUES ('5','Mei','11');
INSERT INTO `bulan` VALUES ('6','Juni','12');
INSERT INTO `bulan` VALUES ('7','Juli','1');
INSERT INTO `bulan` VALUES ('8','Agustus','2');
INSERT INTO `bulan` VALUES ('9','September','3');

/*---------------------------------------------------------------
  TABLE: `hutangtoko`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `hutangtoko`;
CREATE TABLE `hutangtoko` (
  `id_hutangtoko` varchar(10) NOT NULL,
  `hutangke` varchar(50) NOT NULL,
  `tanggal` date NOT NULL,
  `ket` varchar(100) NOT NULL,
  `nominal` int(11) NOT NULL,
  `sisa` int(11) NOT NULL,
  PRIMARY KEY (`id_hutangtoko`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

/*---------------------------------------------------------------
  TABLE: `identitas`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `identitas`;
CREATE TABLE `identitas` (
  `npsn` varchar(8) NOT NULL,
  `nmSekolah` varchar(100) DEFAULT NULL,
  `alamat` varchar(255) DEFAULT NULL,
  `kabupaten` varchar(100) NOT NULL,
  `propinsi` varchar(100) NOT NULL,
  `nipKepsek` varchar(20) DEFAULT NULL,
  `nmKepsek` varchar(100) DEFAULT NULL,
  `nipKaTU` varchar(20) DEFAULT NULL,
  `nmKaTU` varchar(100) DEFAULT NULL,
  `nipBendahara` varchar(20) DEFAULT NULL,
  `nmBendahara` varchar(100) DEFAULT NULL,
  `logo_kiri` varchar(255) DEFAULT NULL,
  `logo_kanan` varchar(100) NOT NULL,
  PRIMARY KEY (`npsn`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
INSERT INTO `identitas` VALUES   ('10700295','SMK TARUNA HARAPAN 1 CIPATAT','Jl. Raya Cipatat No.28, Ciptaharja, Kec. Cipatat, Kabupaten Bandung Barat, Jawa Barat 40554','Cipatat','Jawa Barat','-','Liwa Ulhamdi, S.Pd, MM.','-','Robi Sanusi, S.Pd','-','Robi Sanusi, S.Pd','download.jpg','1594106208386_auto_x2.png');

/*---------------------------------------------------------------
  TABLE: `jenis_bayar`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `jenis_bayar`;
CREATE TABLE `jenis_bayar` (
  `idJenisBayar` int(10) NOT NULL AUTO_INCREMENT,
  `idPosBayar` int(5) DEFAULT NULL,
  `idTahunAjaran` int(5) DEFAULT NULL,
  `nmJenisBayar` varchar(100) DEFAULT NULL,
  `tipeBayar` enum('bulanan','bebas') DEFAULT 'bulanan',
  PRIMARY KEY (`idJenisBayar`),
  KEY `fk_pos` (`idPosBayar`),
  KEY `fk_tahun` (`idTahunAjaran`),
  CONSTRAINT `fk_pos` FOREIGN KEY (`idPosBayar`) REFERENCES `pos_bayar` (`idPosBayar`) ON UPDATE CASCADE,
  CONSTRAINT `fk_tahun` FOREIGN KEY (`idTahunAjaran`) REFERENCES `tahun_ajaran` (`idTahunAjaran`) ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=latin1;
INSERT INTO `jenis_bayar` VALUES   ('20','9','9','SPP Bulanan Kelas X','bulanan');
INSERT INTO `jenis_bayar` VALUES ('21','10','9','SPP Bulanan Kelas XI','bulanan');
INSERT INTO `jenis_bayar` VALUES ('22','12','9','Pembayaran PTS','bebas');
INSERT INTO `jenis_bayar` VALUES ('23','13','9','Pembayaran PAT','bebas');
INSERT INTO `jenis_bayar` VALUES ('24','14','9','Pembayaran Wisuda','bebas');

/*---------------------------------------------------------------
  TABLE: `jurnal_umum`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `jurnal_umum`;
CREATE TABLE `jurnal_umum` (
  `id` int(50) NOT NULL AUTO_INCREMENT,
  `tgl` date DEFAULT NULL,
  `ket` varchar(100) DEFAULT NULL,
  `penerimaan` int(10) DEFAULT '0',
  `pengeluaran` int(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*---------------------------------------------------------------
  TABLE: `kas`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `kas`;
CREATE TABLE `kas` (
  `kode` int(11) NOT NULL AUTO_INCREMENT,
  `keterangan` varchar(300) NOT NULL,
  `idKelas` int(50) NOT NULL,
  `tgl` date NOT NULL,
  `jumlah` int(10) NOT NULL,
  `jenis` varchar(20) NOT NULL,
  `keluar` int(20) NOT NULL,
  PRIMARY KEY (`kode`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*---------------------------------------------------------------
  TABLE: `kelas_siswa`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `kelas_siswa`;
CREATE TABLE `kelas_siswa` (
  `idKelas` int(5) NOT NULL AUTO_INCREMENT,
  `nmKelas` varchar(20) DEFAULT NULL,
  `ketKelas` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`idKelas`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=latin1;
INSERT INTO `kelas_siswa` VALUES   ('16','X RPL 1','Kelas Sepuluh RPL 1');
INSERT INTO `kelas_siswa` VALUES ('17','X RPL 2','');
INSERT INTO `kelas_siswa` VALUES ('18','X RPL 3','');
INSERT INTO `kelas_siswa` VALUES ('19','X RPL 4','');
INSERT INTO `kelas_siswa` VALUES ('20','XI RPL 1','');
INSERT INTO `kelas_siswa` VALUES ('21','XI RPL 2','');
INSERT INTO `kelas_siswa` VALUES ('22','XII RPL 1','');
INSERT INTO `kelas_siswa` VALUES ('23','XII RPL 2','');

/*---------------------------------------------------------------
  TABLE: `kwitansi`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `kwitansi`;
CREATE TABLE `kwitansi` (
  `id_kwitansi` varchar(30) NOT NULL,
  `id_siswa` int(11) NOT NULL,
  `tgl_cetak` datetime NOT NULL,
  PRIMARY KEY (`id_kwitansi`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
INSERT INTO `kwitansi` VALUES   ('KWT00000001','422','2021-07-06 06:48:12');

/*---------------------------------------------------------------
  TABLE: `memodb`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `memodb`;
CREATE TABLE `memodb` (
  `kwnum` varchar(20) NOT NULL,
  `nominal` int(11) NOT NULL,
  `payee` varchar(25) NOT NULL,
  `pic` varchar(25) NOT NULL,
  `tglkw` varchar(20) NOT NULL,
  `ktrg` text NOT NULL,
  PRIMARY KEY (`kwnum`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*---------------------------------------------------------------
  TABLE: `pos_bayar`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `pos_bayar`;
CREATE TABLE `pos_bayar` (
  `idPosBayar` int(5) NOT NULL AUTO_INCREMENT,
  `nmPosBayar` varchar(100) DEFAULT NULL,
  `ketPosBayar` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`idPosBayar`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=latin1;
INSERT INTO `pos_bayar` VALUES   ('9','SPP Bulanan','');
INSERT INTO `pos_bayar` VALUES ('10','SPP Bulanan Kelas XI','');
INSERT INTO `pos_bayar` VALUES ('12','Pembayaran PTS','');
INSERT INTO `pos_bayar` VALUES ('13','Pembayaran PAT','');
INSERT INTO `pos_bayar` VALUES ('14','Pembayaran Wisuda','');

/*---------------------------------------------------------------
  TABLE: `siswa`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `siswa`;
CREATE TABLE `siswa` (
  `idSiswa` int(10) NOT NULL AUTO_INCREMENT,
  `nisSiswa` varchar(25) DEFAULT NULL,
  `nisnSiswa` varchar(25) DEFAULT NULL,
  `nmSiswa` varchar(100) DEFAULT NULL,
  `jkSiswa` varchar(15) DEFAULT NULL,
  `unitSiswa` varchar(100) NOT NULL,
  `agamaSiswa` varchar(15) DEFAULT NULL,
  `idKelas` int(5) DEFAULT NULL,
  `statusSiswa` enum('Aktif','Non Aktif','Pindah','Drop Out','Lulus') DEFAULT 'Aktif',
  `username` varchar(20) NOT NULL,
  `password` varchar(200) DEFAULT NULL,
  `level` varchar(10) NOT NULL,
  `nmOrtu` varchar(40) DEFAULT NULL,
  `alamatOrtu` varchar(100) DEFAULT NULL,
  `noHpOrtu` varchar(30) DEFAULT NULL,
  `saldo` double NOT NULL,
  PRIMARY KEY (`idSiswa`),
  KEY `fk_kelas` (`idKelas`),
  KEY `fk_status` (`statusSiswa`),
  CONSTRAINT `fk_kelas` FOREIGN KEY (`idKelas`) REFERENCES `kelas_siswa` (`idKelas`) ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=427 DEFAULT CHARSET=latin1;
INSERT INTO `siswa` VALUES   ('422','1','1','Dodi','L','','Islam','17','Lulus','siswa','siswa','siswa','rehan','Jl. Ters. Nilem Barat No. 49, B No.Kel, Pasirluyu, Kec. Regol, Kota Bandung, Jawa Barat 40254','+6281398161612','0');
INSERT INTO `siswa` VALUES ('423','2','2','restu','L','','Islam','16','Lulus','siswa','siswa','siswa','Fahmi','Jl. Ters. Nilem Barat No. 49, B No.Kel, Pasirluyu, Kec. Regol, Kota Bandung, Jawa Barat 40254','+10225208735','0');
INSERT INTO `siswa` VALUES ('424','3','3','deni','L','','Islam','20','Aktif','siswa','siswa','siswa','rehan','Jl. Terusan Nilem Barat No. 49B, Selatan Kec. Regol, Pasirluyu, Regol, Kota Bandung, Jawa Barat 4025','+10225208735','0');
INSERT INTO `siswa` VALUES ('425','4','4','reza','L','','Islam','22','Aktif','siswa','siswa','siswa','rehan','Jl. Terusan Nilem Barat No. 49B, Selatan Kec. Regol, Pasirluyu, Regol, Kota Bandung, Jawa Barat 4025','+10225208735','0');
INSERT INTO `siswa` VALUES ('426','5','5','deden','L','','Islam','18','Aktif','deden','deden','siswa','deden','Jl. Ters. Nilem Barat No. 49, B No.Kel, Pasirluyu, Kec. Regol, Kota Bandung, Jawa Barat 40254','+10225208735','0');

/*---------------------------------------------------------------
  TABLE: `tagihan_bebas`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `tagihan_bebas`;
CREATE TABLE `tagihan_bebas` (
  `idTagihanBebas` int(50) NOT NULL AUTO_INCREMENT,
  `idJenisBayar` int(5) DEFAULT NULL,
  `idSiswa` int(10) DEFAULT NULL,
  `idKelas` int(5) DEFAULT NULL,
  `totalTagihan` int(10) DEFAULT NULL,
  `statusBayar` enum('0','1','2') DEFAULT '0',
  `TglTagihan` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idTagihanBebas`),
  KEY `fk_t_jenis` (`idJenisBayar`),
  KEY `fk_t_siswa` (`idSiswa`),
  KEY `fk_t_kelas` (`idKelas`),
  CONSTRAINT `tagihan_bebas_ibfk_2` FOREIGN KEY (`idJenisBayar`) REFERENCES `jenis_bayar` (`idJenisBayar`) ON UPDATE CASCADE,
  CONSTRAINT `tagihan_bebas_ibfk_3` FOREIGN KEY (`idKelas`) REFERENCES `kelas_siswa` (`idKelas`) ON UPDATE CASCADE,
  CONSTRAINT `tagihan_bebas_ibfk_4` FOREIGN KEY (`idSiswa`) REFERENCES `siswa` (`idSiswa`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=latin1;
INSERT INTO `tagihan_bebas` VALUES   ('15','22','423','16','75000','2','2021-07-07 00:03:26');
INSERT INTO `tagihan_bebas` VALUES ('16','22','422','17','75000','2','2021-07-06 23:04:15');
INSERT INTO `tagihan_bebas` VALUES ('17','22','424','20','150000','2','2021-07-06 19:19:59');
INSERT INTO `tagihan_bebas` VALUES ('18','22','425','22','350000','1','2021-07-06 19:21:31');
INSERT INTO `tagihan_bebas` VALUES ('19','22','426','18','75000','2','2021-07-07 23:45:59');

/*---------------------------------------------------------------
  TABLE: `tagihan_bebas_bayar`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `tagihan_bebas_bayar`;
CREATE TABLE `tagihan_bebas_bayar` (
  `idTagihanBebasBayar` int(50) NOT NULL AUTO_INCREMENT,
  `idTagihanBebas` int(50) DEFAULT NULL,
  `tglBayar` date DEFAULT NULL,
  `jumlahBayar` int(10) DEFAULT NULL,
  `ketBayar` varchar(100) DEFAULT NULL,
  `caraBayar` enum('Tunai','Transfer') DEFAULT 'Tunai',
  PRIMARY KEY (`idTagihanBebasBayar`),
  KEY `fkbayarbebas` (`idTagihanBebas`),
  CONSTRAINT `fkbayarbebas` FOREIGN KEY (`idTagihanBebas`) REFERENCES `tagihan_bebas` (`idTagihanBebas`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=latin1;
INSERT INTO `tagihan_bebas_bayar` VALUES   ('5','17','2021-07-06','150000','Lunas','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('6','16','2021-07-06','20000','Angsuran 1','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('7','18','2021-07-06','100000','Angsuran 1','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('8','16','2021-07-06','55000','Lunas','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('9','15','2021-07-06','50000','Angsuran 1','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('10','15','2021-07-06','12500','Angsuran 2','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('11','15','2021-07-06','12500','Lunas','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('12','19','2021-07-07','25000','Angsuran 1','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('13','19','2021-07-07','25000','Angsuran 2','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('14','19','2021-07-07','25000','Lunas','Tunai');

/*---------------------------------------------------------------
  TABLE: `tagihan_bulanan`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `tagihan_bulanan`;
CREATE TABLE `tagihan_bulanan` (
  `idTagihanBulanan` int(50) NOT NULL AUTO_INCREMENT,
  `idJenisBayar` int(5) DEFAULT NULL,
  `idSiswa` int(10) DEFAULT NULL,
  `idKelas` int(5) DEFAULT NULL,
  `idBulan` varchar(15) DEFAULT NULL,
  `jumlahBayar` int(10) DEFAULT NULL,
  `TglTagihan` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `tglBayar` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `tglUpdate` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `statusBayar` enum('0','1') DEFAULT '0',
  `caraBayar` enum('Tunai','Transfer') DEFAULT 'Tunai',
  PRIMARY KEY (`idTagihanBulanan`),
  KEY `fk_t_jenis` (`idJenisBayar`),
  KEY `fk_t_siswa` (`idSiswa`),
  KEY `fk_t_kelas` (`idKelas`),
  KEY `fk_t_bulan` (`idBulan`),
  CONSTRAINT `fk_t_bulan` FOREIGN KEY (`idBulan`) REFERENCES `bulan` (`idBulan`) ON UPDATE CASCADE,
  CONSTRAINT `fk_t_jenis` FOREIGN KEY (`idJenisBayar`) REFERENCES `jenis_bayar` (`idJenisBayar`) ON UPDATE CASCADE,
  CONSTRAINT `fk_t_kelas` FOREIGN KEY (`idKelas`) REFERENCES `kelas_siswa` (`idKelas`) ON UPDATE CASCADE,
  CONSTRAINT `fk_t_siswa` FOREIGN KEY (`idSiswa`) REFERENCES `siswa` (`idSiswa`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=529 DEFAULT CHARSET=latin1;
INSERT INTO `tagihan_bulanan` VALUES   ('469','20','423','16','1','100000','2021-07-06 19:15:46',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('470','20','423','16','2','100000','2021-07-06 19:15:46',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('471','20','423','16','3','100000','2021-07-06 19:15:46',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('472','20','423','16','4','100000','2021-07-06 19:15:46',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('473','20','423','16','5','100000','2021-07-06 19:15:47',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('474','20','423','16','6','100000','2021-07-06 19:15:47',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('475','20','423','16','7','100000','2021-07-06 19:21:06','2021-07-06 00:00:00','2021-07-06 19:21:06','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('476','20','423','16','8','100000','2021-07-06 19:15:47',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('477','20','423','16','9','100000','2021-07-06 19:15:47',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('478','20','423','16','10','100000','2021-07-06 19:15:47',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('479','20','423','16','11','100000','2021-07-06 19:15:47',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('480','20','423','16','12','100000','2021-07-06 19:15:47',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('481','20','422','17','1','100000','2021-07-07 00:13:39','2021-07-06 00:00:00','2021-07-07 00:13:39','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('482','20','422','17','2','100000','2021-07-07 00:13:41','2021-07-06 00:00:00','2021-07-07 00:13:41','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('483','20','422','17','3','100000','2021-07-07 00:13:42','2021-07-06 00:00:00','2021-07-07 00:13:42','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('484','20','422','17','4','100000','2021-07-07 00:13:43','2021-07-06 00:00:00','2021-07-07 00:13:43','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('485','20','422','17','5','100000','2021-07-07 00:13:44','2021-07-06 00:00:00','2021-07-07 00:13:44','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('486','20','422','17','6','100000','2021-07-07 00:13:44','2021-07-06 00:00:00','2021-07-07 00:13:44','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('487','20','422','17','7','100000','2021-07-06 19:20:30','2021-07-06 00:00:00','2021-07-06 19:20:30','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('488','20','422','17','8','100000','2021-07-06 19:20:30','2021-07-06 00:00:00','2021-07-06 19:20:30','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('489','20','422','17','9','100000','2021-07-06 19:20:31','2021-07-06 00:00:00','2021-07-06 19:20:31','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('490','20','422','17','10','100000','2021-07-06 19:20:32','2021-07-06 00:00:00','2021-07-06 19:20:32','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('491','20','422','17','11','100000','2021-07-06 19:20:33','2021-07-06 00:00:00','2021-07-06 19:20:33','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('492','20','422','17','12','100000','2021-07-06 23:27:54','2021-07-06 00:00:00','2021-07-06 23:27:54','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('493','20','424','20','1','200000','2021-07-06 19:16:17',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('494','20','424','20','2','200000','2021-07-06 19:16:17',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('495','20','424','20','3','200000','2021-07-06 19:16:17',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('496','20','424','20','4','200000','2021-07-06 19:16:17',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('497','20','424','20','5','200000','2021-07-06 19:16:17',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('498','20','424','20','6','200000','2021-07-06 19:16:17',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('499','20','424','20','7','200000','2021-07-06 19:19:35','2021-07-06 00:00:00','2021-07-06 19:19:35','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('500','20','424','20','8','200000','2021-07-06 19:19:38','2021-07-06 00:00:00','2021-07-06 19:19:38','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('501','20','424','20','9','200000','2021-07-06 23:59:44','2021-07-06 00:00:00','2021-07-06 23:59:44','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('502','20','424','20','10','200000','2021-07-06 19:16:17',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('503','20','424','20','11','200000','2021-07-06 19:16:18',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('504','20','424','20','12','200000','2021-07-06 19:16:18',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('505','20','425','22','1','0','2021-07-06 19:16:29',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('506','20','425','22','2','0','2021-07-06 19:16:29',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('507','20','425','22','3','0','2021-07-06 19:16:29',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('508','20','425','22','4','0','2021-07-06 19:16:29',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('509','20','425','22','5','0','2021-07-06 19:16:29',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('510','20','425','22','6','0','2021-07-06 19:16:29',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('511','20','425','22','7','0','2021-07-06 19:21:15','2021-07-06 00:00:00','2021-07-06 19:21:15','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('512','20','425','22','8','0','2021-07-06 19:21:17','2021-07-06 00:00:00','2021-07-06 19:21:17','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('513','20','425','22','9','0','2021-07-06 19:21:16','2021-07-06 00:00:00','2021-07-06 19:21:16','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('514','20','425','22','10','0','2021-07-06 19:21:18','2021-07-06 00:00:00','2021-07-06 19:21:18','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('515','20','425','22','11','0','2021-07-06 19:21:18','2021-07-06 00:00:00','2021-07-06 19:21:18','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('516','20','425','22','12','0','2021-07-06 19:16:30',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('517','20','426','18','1','100000','2021-07-07 23:08:15',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('518','20','426','18','2','100000','2021-07-07 23:08:15',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('519','20','426','18','3','100000','2021-07-07 23:08:15',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('520','20','426','18','4','100000','2021-07-07 23:08:15',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('521','20','426','18','5','100000','2021-07-07 23:08:15',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('522','20','426','18','6','100000','2021-07-07 23:08:16',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('523','20','426','18','7','100000','2021-07-07 23:09:59','2021-07-07 00:00:00','2021-07-07 23:09:59','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('524','20','426','18','8','100000','2021-07-07 23:10:41','2021-07-07 00:00:00','2021-07-07 23:10:41','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('525','20','426','18','9','100000','2021-07-07 23:11:33','2021-07-07 00:00:00','2021-07-07 23:11:33','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('526','20','426','18','10','100000','2021-07-07 23:11:34','2021-07-07 00:00:00','2021-07-07 23:11:34','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('527','20','426','18','11','100000','2021-07-07 23:11:35','2021-07-07 00:00:00','2021-07-07 23:11:35','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('528','20','426','18','12','100000','2021-07-07 23:08:17',NULL,NULL,'0','Tunai');

/*---------------------------------------------------------------
  TABLE: `tahun_ajaran`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `tahun_ajaran`;
CREATE TABLE `tahun_ajaran` (
  `idTahunAjaran` int(5) NOT NULL AUTO_INCREMENT,
  `nmTahunAjaran` varchar(9) DEFAULT NULL,
  `aktif` enum('Y','T') DEFAULT 'Y',
  PRIMARY KEY (`idTahunAjaran`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;
INSERT INTO `tahun_ajaran` VALUES   ('9','2020/2021','Y');

/*---------------------------------------------------------------
  TABLE: `transaksi`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `transaksi`;
CREATE TABLE `transaksi` (
  `id_transaksi` varchar(50) NOT NULL,
  `idSiswa` varchar(50) NOT NULL,
  `tanggal` date NOT NULL,
  `debit` int(10) NOT NULL,
  `kredit` int(10) NOT NULL,
  `keterangan` varchar(50) NOT NULL,
  PRIMARY KEY (`id_transaksi`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

/*---------------------------------------------------------------
  TABLE: `users`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `username` varchar(50) COLLATE latin1_general_ci NOT NULL,
  `password` varchar(50) COLLATE latin1_general_ci NOT NULL,
  `nama_lengkap` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `email` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `no_telp` varchar(20) COLLATE latin1_general_ci NOT NULL,
  `level` varchar(20) COLLATE latin1_general_ci NOT NULL DEFAULT 'admin',
  `unit` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `blokir` enum('Y','N') COLLATE latin1_general_ci NOT NULL DEFAULT 'N',
  `idKelas` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `id_session` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `last_login` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`username`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;
INSERT INTO `users` VALUES   ('dodidarmawan@smktarpan1.sch.id','de28f8f7998f23ab4194b51a6029416f','dodidarmawan','dodidarmawan@smktarpan1.sch.id','082218327154','kasir','','N','','',NULL);
INSERT INTO `users` VALUES ('mrizkyandram@smktarpan1.sch.id','8f49a731effe19ecc5cb67179a21a949','Muhammad Rizky Andra Muchlis','muhammadrizkyandra@smktarpan1.sch.id','082218327154','admin','','N','','',NULL);
INSERT INTO `users` VALUES ('rizal@smktarpan1.sch.id','f80ef4b61dd49d31cbfc38759341a13d','rizal','rizal@smktarpan1.sch.id','082218327154','adminunit','','N','','',NULL);
INSERT INTO `users` VALUES ('robisanusi@smktarpan1.sch.id','c9ccd7f3c1145515a9d3f7415d5bcbea','robisanusi','robisanusi@smktarpan1.sch.id','082218327154','bendahara','9','N','','',NULL);

/*---------------------------------------------------------------
  TABLE: `view_detil_jenis_bayar`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `view_detil_jenis_bayar`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `view_detil_jenis_bayar` AS select `jenis_bayar`.`idJenisBayar` AS `idJenisBayar`,`jenis_bayar`.`idPosBayar` AS `idPosBayar`,`jenis_bayar`.`idTahunAjaran` AS `idTahunAjaran`,`jenis_bayar`.`nmJenisBayar` AS `nmJenisBayar`,`jenis_bayar`.`tipeBayar` AS `tipeBayar`,`pos_bayar`.`nmPosBayar` AS `nmPosBayar`,`tahun_ajaran`.`nmTahunAjaran` AS `nmTahunAjaran`,`tahun_ajaran`.`aktif` AS `aktif` from ((`jenis_bayar` join `pos_bayar` on((`jenis_bayar`.`idPosBayar` = `pos_bayar`.`idPosBayar`))) join `tahun_ajaran` on((`jenis_bayar`.`idTahunAjaran` = `tahun_ajaran`.`idTahunAjaran`)));
INSERT INTO `view_detil_jenis_bayar` VALUES   ('20','9','9','SPP Bulanan Kelas X','bulanan','SPP Bulanan','2020/2021','Y');
INSERT INTO `view_detil_jenis_bayar` VALUES ('21','10','9','SPP Bulanan Kelas XI','bulanan','SPP Bulanan Kelas XI','2020/2021','Y');
INSERT INTO `view_detil_jenis_bayar` VALUES ('22','12','9','Pembayaran PTS','bebas','Pembayaran PTS','2020/2021','Y');
INSERT INTO `view_detil_jenis_bayar` VALUES ('23','13','9','Pembayaran PAT','bebas','Pembayaran PAT','2020/2021','Y');
INSERT INTO `view_detil_jenis_bayar` VALUES ('24','14','9','Pembayaran Wisuda','bebas','Pembayaran Wisuda','2020/2021','Y');

/*---------------------------------------------------------------
  TABLE: `view_detil_siswa`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `view_detil_siswa`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `view_detil_siswa` AS select `siswa`.`idSiswa` AS `idSiswa`,`siswa`.`nisSiswa` AS `nisSiswa`,`siswa`.`nisnSiswa` AS `nisnSiswa`,`siswa`.`nmSiswa` AS `nmSiswa`,`siswa`.`jkSiswa` AS `jkSiswa`,`siswa`.`unitSiswa` AS `unitSiswa`,`siswa`.`agamaSiswa` AS `agamaSiswa`,`siswa`.`idKelas` AS `idKelas`,`siswa`.`statusSiswa` AS `statusSiswa`,`siswa`.`username` AS `username`,`siswa`.`password` AS `password`,`kelas_siswa`.`nmKelas` AS `nmKelas`,`kelas_siswa`.`ketKelas` AS `ketKelas`,`siswa`.`nmOrtu` AS `nmOrtu`,`siswa`.`alamatOrtu` AS `alamatOrtu`,`siswa`.`noHpOrtu` AS `noHpOrtu`,`siswa`.`saldo` AS `saldo` from (`siswa` join `kelas_siswa` on((`siswa`.`idKelas` = `kelas_siswa`.`idKelas`)));
INSERT INTO `view_detil_siswa` VALUES   ('422','1','1','Dodi','L','','Islam','17','Lulus','siswa','siswa','X RPL 2','','rehan','Jl. Ters. Nilem Barat No. 49, B No.Kel, Pasirluyu, Kec. Regol, Kota Bandung, Jawa Barat 40254','+6281398161612','0');
INSERT INTO `view_detil_siswa` VALUES ('423','2','2','restu','L','','Islam','16','Lulus','siswa','siswa','X RPL 1','Kelas Sepuluh RPL 1','Fahmi','Jl. Ters. Nilem Barat No. 49, B No.Kel, Pasirluyu, Kec. Regol, Kota Bandung, Jawa Barat 40254','+10225208735','0');
INSERT INTO `view_detil_siswa` VALUES ('424','3','3','deni','L','','Islam','20','Aktif','siswa','siswa','XI RPL 1','','rehan','Jl. Terusan Nilem Barat No. 49B, Selatan Kec. Regol, Pasirluyu, Regol, Kota Bandung, Jawa Barat 4025','+10225208735','0');
INSERT INTO `view_detil_siswa` VALUES ('425','4','4','reza','L','','Islam','22','Aktif','siswa','siswa','XII RPL 1','','rehan','Jl. Terusan Nilem Barat No. 49B, Selatan Kec. Regol, Pasirluyu, Regol, Kota Bandung, Jawa Barat 4025','+10225208735','0');
INSERT INTO `view_detil_siswa` VALUES ('426','5','5','deden','L','','Islam','18','Aktif','deden','deden','X RPL 3','','deden','Jl. Ters. Nilem Barat No. 49, B No.Kel, Pasirluyu, Kec. Regol, Kota Bandung, Jawa Barat 40254','+10225208735','0');

/*---------------------------------------------------------------
  TABLE: `view_laporan_bayar_bulanan`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `view_laporan_bayar_bulanan`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `view_laporan_bayar_bulanan` AS select `tagihan_bulanan`.`idTagihanBulanan` AS `idTagihanBulanan`,`tagihan_bulanan`.`idJenisBayar` AS `idJenisBayar`,`tagihan_bulanan`.`idSiswa` AS `idSiswa`,`tagihan_bulanan`.`idKelas` AS `idKelas`,`tagihan_bulanan`.`idBulan` AS `idBulan`,`tagihan_bulanan`.`jumlahBayar` AS `jumlahBayar`,`tagihan_bulanan`.`tglBayar` AS `tglBayar`,`tagihan_bulanan`.`tglUpdate` AS `tglUpdate`,`tagihan_bulanan`.`statusBayar` AS `statusBayar`,`jenis_bayar`.`idTahunAjaran` AS `idTahunAjaran`,`jenis_bayar`.`nmJenisBayar` AS `nmJenisBayar`,`tahun_ajaran`.`nmTahunAjaran` AS `nmTahunAjaran`,`siswa`.`nisSiswa` AS `nisSiswa`,`siswa`.`nmSiswa` AS `nmSiswa`,`kelas_siswa`.`nmKelas` AS `nmKelas`,`bulan`.`nmBulan` AS `nmBulan`,`bulan`.`urutan` AS `urutan`,`tagihan_bulanan`.`caraBayar` AS `caraBayar` from (((((`tagihan_bulanan` join `jenis_bayar` on((`tagihan_bulanan`.`idJenisBayar` = `jenis_bayar`.`idJenisBayar`))) join `tahun_ajaran` on((`jenis_bayar`.`idTahunAjaran` = `tahun_ajaran`.`idTahunAjaran`))) join `siswa` on((`tagihan_bulanan`.`idSiswa` = `siswa`.`idSiswa`))) join `kelas_siswa` on((`siswa`.`idKelas` = `kelas_siswa`.`idKelas`))) join `bulan` on((`tagihan_bulanan`.`idBulan` = `bulan`.`idBulan`)));
INSERT INTO `view_laporan_bayar_bulanan` VALUES   ('481','20','422','17','1','100000','2021-07-06 00:00:00','2021-07-07 00:13:39','1','9','SPP Bulanan Kelas X','2020/2021','1','Dodi','X RPL 2','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('482','20','422','17','2','100000','2021-07-06 00:00:00','2021-07-07 00:13:41','1','9','SPP Bulanan Kelas X','2020/2021','1','Dodi','X RPL 2','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('483','20','422','17','3','100000','2021-07-06 00:00:00','2021-07-07 00:13:42','1','9','SPP Bulanan Kelas X','2020/2021','1','Dodi','X RPL 2','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('484','20','422','17','4','100000','2021-07-06 00:00:00','2021-07-07 00:13:43','1','9','SPP Bulanan Kelas X','2020/2021','1','Dodi','X RPL 2','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('485','20','422','17','5','100000','2021-07-06 00:00:00','2021-07-07 00:13:44','1','9','SPP Bulanan Kelas X','2020/2021','1','Dodi','X RPL 2','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('486','20','422','17','6','100000','2021-07-06 00:00:00','2021-07-07 00:13:44','1','9','SPP Bulanan Kelas X','2020/2021','1','Dodi','X RPL 2','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('487','20','422','17','7','100000','2021-07-06 00:00:00','2021-07-06 19:20:30','1','9','SPP Bulanan Kelas X','2020/2021','1','Dodi','X RPL 2','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('488','20','422','17','8','100000','2021-07-06 00:00:00','2021-07-06 19:20:30','1','9','SPP Bulanan Kelas X','2020/2021','1','Dodi','X RPL 2','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('489','20','422','17','9','100000','2021-07-06 00:00:00','2021-07-06 19:20:31','1','9','SPP Bulanan Kelas X','2020/2021','1','Dodi','X RPL 2','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('490','20','422','17','10','100000','2021-07-06 00:00:00','2021-07-06 19:20:32','1','9','SPP Bulanan Kelas X','2020/2021','1','Dodi','X RPL 2','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('491','20','422','17','11','100000','2021-07-06 00:00:00','2021-07-06 19:20:33','1','9','SPP Bulanan Kelas X','2020/2021','1','Dodi','X RPL 2','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('492','20','422','17','12','100000','2021-07-06 00:00:00','2021-07-06 23:27:54','1','9','SPP Bulanan Kelas X','2020/2021','1','Dodi','X RPL 2','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('469','20','423','16','1','100000',NULL,NULL,'0','9','SPP Bulanan Kelas X','2020/2021','2','restu','X RPL 1','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('470','20','423','16','2','100000',NULL,NULL,'0','9','SPP Bulanan Kelas X','2020/2021','2','restu','X RPL 1','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('471','20','423','16','3','100000',NULL,NULL,'0','9','SPP Bulanan Kelas X','2020/2021','2','restu','X RPL 1','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('472','20','423','16','4','100000',NULL,NULL,'0','9','SPP Bulanan Kelas X','2020/2021','2','restu','X RPL 1','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('473','20','423','16','5','100000',NULL,NULL,'0','9','SPP Bulanan Kelas X','2020/2021','2','restu','X RPL 1','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('474','20','423','16','6','100000',NULL,NULL,'0','9','SPP Bulanan Kelas X','2020/2021','2','restu','X RPL 1','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('475','20','423','16','7','100000','2021-07-06 00:00:00','2021-07-06 19:21:06','1','9','SPP Bulanan Kelas X','2020/2021','2','restu','X RPL 1','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('476','20','423','16','8','100000',NULL,NULL,'0','9','SPP Bulanan Kelas X','2020/2021','2','restu','X RPL 1','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('477','20','423','16','9','100000',NULL,NULL,'0','9','SPP Bulanan Kelas X','2020/2021','2','restu','X RPL 1','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('478','20','423','16','10','100000',NULL,NULL,'0','9','SPP Bulanan Kelas X','2020/2021','2','restu','X RPL 1','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('479','20','423','16','11','100000',NULL,NULL,'0','9','SPP Bulanan Kelas X','2020/2021','2','restu','X RPL 1','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('480','20','423','16','12','100000',NULL,NULL,'0','9','SPP Bulanan Kelas X','2020/2021','2','restu','X RPL 1','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('493','20','424','20','1','200000',NULL,NULL,'0','9','SPP Bulanan Kelas X','2020/2021','3','deni','XI RPL 1','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('494','20','424','20','2','200000',NULL,NULL,'0','9','SPP Bulanan Kelas X','2020/2021','3','deni','XI RPL 1','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('495','20','424','20','3','200000',NULL,NULL,'0','9','SPP Bulanan Kelas X','2020/2021','3','deni','XI RPL 1','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('496','20','424','20','4','200000',NULL,NULL,'0','9','SPP Bulanan Kelas X','2020/2021','3','deni','XI RPL 1','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('497','20','424','20','5','200000',NULL,NULL,'0','9','SPP Bulanan Kelas X','2020/2021','3','deni','XI RPL 1','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('498','20','424','20','6','200000',NULL,NULL,'0','9','SPP Bulanan Kelas X','2020/2021','3','deni','XI RPL 1','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('499','20','424','20','7','200000','2021-07-06 00:00:00','2021-07-06 19:19:35','1','9','SPP Bulanan Kelas X','2020/2021','3','deni','XI RPL 1','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('500','20','424','20','8','200000','2021-07-06 00:00:00','2021-07-06 19:19:38','1','9','SPP Bulanan Kelas X','2020/2021','3','deni','XI RPL 1','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('501','20','424','20','9','200000','2021-07-06 00:00:00','2021-07-06 23:59:44','1','9','SPP Bulanan Kelas X','2020/2021','3','deni','XI RPL 1','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('502','20','424','20','10','200000',NULL,NULL,'0','9','SPP Bulanan Kelas X','2020/2021','3','deni','XI RPL 1','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('503','20','424','20','11','200000',NULL,NULL,'0','9','SPP Bulanan Kelas X','2020/2021','3','deni','XI RPL 1','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('504','20','424','20','12','200000',NULL,NULL,'0','9','SPP Bulanan Kelas X','2020/2021','3','deni','XI RPL 1','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('505','20','425','22','1','0',NULL,NULL,'0','9','SPP Bulanan Kelas X','2020/2021','4','reza','XII RPL 1','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('506','20','425','22','2','0',NULL,NULL,'0','9','SPP Bulanan Kelas X','2020/2021','4','reza','XII RPL 1','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('507','20','425','22','3','0',NULL,NULL,'0','9','SPP Bulanan Kelas X','2020/2021','4','reza','XII RPL 1','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('508','20','425','22','4','0',NULL,NULL,'0','9','SPP Bulanan Kelas X','2020/2021','4','reza','XII RPL 1','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('509','20','425','22','5','0',NULL,NULL,'0','9','SPP Bulanan Kelas X','2020/2021','4','reza','XII RPL 1','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('510','20','425','22','6','0',NULL,NULL,'0','9','SPP Bulanan Kelas X','2020/2021','4','reza','XII RPL 1','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('511','20','425','22','7','0','2021-07-06 00:00:00','2021-07-06 19:21:15','1','9','SPP Bulanan Kelas X','2020/2021','4','reza','XII RPL 1','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('512','20','425','22','8','0','2021-07-06 00:00:00','2021-07-06 19:21:17','1','9','SPP Bulanan Kelas X','2020/2021','4','reza','XII RPL 1','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('513','20','425','22','9','0','2021-07-06 00:00:00','2021-07-06 19:21:16','1','9','SPP Bulanan Kelas X','2020/2021','4','reza','XII RPL 1','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('514','20','425','22','10','0','2021-07-06 00:00:00','2021-07-06 19:21:18','1','9','SPP Bulanan Kelas X','2020/2021','4','reza','XII RPL 1','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('515','20','425','22','11','0','2021-07-06 00:00:00','2021-07-06 19:21:18','1','9','SPP Bulanan Kelas X','2020/2021','4','reza','XII RPL 1','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('516','20','425','22','12','0',NULL,NULL,'0','9','SPP Bulanan Kelas X','2020/2021','4','reza','XII RPL 1','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('517','20','426','18','1','100000',NULL,NULL,'0','9','SPP Bulanan Kelas X','2020/2021','5','deden','X RPL 3','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('518','20','426','18','2','100000',NULL,NULL,'0','9','SPP Bulanan Kelas X','2020/2021','5','deden','X RPL 3','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('519','20','426','18','3','100000',NULL,NULL,'0','9','SPP Bulanan Kelas X','2020/2021','5','deden','X RPL 3','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('520','20','426','18','4','100000',NULL,NULL,'0','9','SPP Bulanan Kelas X','2020/2021','5','deden','X RPL 3','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('521','20','426','18','5','100000',NULL,NULL,'0','9','SPP Bulanan Kelas X','2020/2021','5','deden','X RPL 3','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('522','20','426','18','6','100000',NULL,NULL,'0','9','SPP Bulanan Kelas X','2020/2021','5','deden','X RPL 3','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('523','20','426','18','7','100000','2021-07-07 00:00:00','2021-07-07 23:09:59','1','9','SPP Bulanan Kelas X','2020/2021','5','deden','X RPL 3','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('524','20','426','18','8','100000','2021-07-07 00:00:00','2021-07-07 23:10:41','1','9','SPP Bulanan Kelas X','2020/2021','5','deden','X RPL 3','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('525','20','426','18','9','100000','2021-07-07 00:00:00','2021-07-07 23:11:33','1','9','SPP Bulanan Kelas X','2020/2021','5','deden','X RPL 3','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('526','20','426','18','10','100000','2021-07-07 00:00:00','2021-07-07 23:11:34','1','9','SPP Bulanan Kelas X','2020/2021','5','deden','X RPL 3','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('527','20','426','18','11','100000','2021-07-07 00:00:00','2021-07-07 23:11:35','1','9','SPP Bulanan Kelas X','2020/2021','5','deden','X RPL 3','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('528','20','426','18','12','100000',NULL,NULL,'0','9','SPP Bulanan Kelas X','2020/2021','5','deden','X RPL 3','Desember','6','Tunai');
