<?php
include "./lib/fpdf181/fpdf.php";

class PDF extends FPDF{
	// Page header
	function Header(){
		// Logo
		$this->Image('gambar/tutwuri.png',10,6,20);
		// Arial bold 15
		$this->SetFont('Arial','B',15);
		// Move to the right
		$this->Cell(10);
		// Title
		$this->Cell(200,10,'SMA NEGERI 1 PUTRI HIJAU',1,0,'C');
		// Line break
		$this->Ln(20);
	}

	// Page footer
	function Footer(){
		// Position at 1.5 cm from bottom
		$this->SetY(-15);
		// Arial italic 8
		$this->SetFont('Arial','I',8);
		// Page number
		$this->Cell(0,10,'Page '.$this->PageNo().'/{nb}',0,0,'C');
	}
}
// Instanciation of inherited class
$pdf = new PDF();
$pdf->AliasNbPages();
$pdf->AddPage();
$pdf->SetFont('Arial','',11);
for($i=1;$i<=40;$i++)
    $pdf->Cell(0,10,'Printing line number '.$i,0,1);
$pdf->Output();
?>