
/*---------------------------------------------------------------
  SQL DB BACKUP 21.06.2020 09:53 
  HOST: localhost
  DATABASE: spp_live
  TABLES: *
  ---------------------------------------------------------------*/

/*---------------------------------------------------------------
  TABLE: `angsurantoko`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `angsurantoko`;
CREATE TABLE `angsurantoko` (
  `id_angsurantoko` varchar(10) NOT NULL,
  `id_hutangtoko` varchar(10) NOT NULL,
  `tanggal` date NOT NULL,
  `angsuran` int(11) NOT NULL,
  PRIMARY KEY (`id_angsurantoko`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
INSERT INTO `angsurantoko` VALUES   ('AP001','HT001','2019-11-05','2000');
INSERT INTO `angsurantoko` VALUES ('AP002','HT001','2020-01-16','3000');
INSERT INTO `angsurantoko` VALUES ('AP003','HT001','2020-01-25','3');
INSERT INTO `angsurantoko` VALUES ('AP004','HT002','2020-01-25','600000');
INSERT INTO `angsurantoko` VALUES ('AP005','HT003','2020-01-26','120000');
INSERT INTO `angsurantoko` VALUES ('AP006','HT001','2020-01-26','440000');
INSERT INTO `angsurantoko` VALUES ('AP007','HT003','2020-01-27','100000');
INSERT INTO `angsurantoko` VALUES ('AP008','HT001','2020-02-18','20000');
INSERT INTO `angsurantoko` VALUES ('AP009','HT004','2020-02-18','200000');
INSERT INTO `angsurantoko` VALUES ('AP010','HT005','2020-02-23','100000');
INSERT INTO `angsurantoko` VALUES ('AP011','HT003','2020-03-09','0');
INSERT INTO `angsurantoko` VALUES ('AP012','HT007','2020-03-11','100000');
INSERT INTO `angsurantoko` VALUES ('AP013','HT008','2020-03-11','250000000');
INSERT INTO `angsurantoko` VALUES ('AP014','HT008','2020-03-11','250000000');
INSERT INTO `angsurantoko` VALUES ('AP015','HT009','2020-04-28','50000');
INSERT INTO `angsurantoko` VALUES ('AP016','HT001','2020-06-10','0');

/*---------------------------------------------------------------
  TABLE: `bulan`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `bulan`;
CREATE TABLE `bulan` (
  `idBulan` varchar(15) NOT NULL DEFAULT '0',
  `nmBulan` varchar(25) DEFAULT NULL,
  `urutan` int(2) DEFAULT NULL,
  PRIMARY KEY (`idBulan`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
INSERT INTO `bulan` VALUES   ('1','Januari','7');
INSERT INTO `bulan` VALUES ('10','Oktober','4');
INSERT INTO `bulan` VALUES ('11','November','5');
INSERT INTO `bulan` VALUES ('12','Desember','6');
INSERT INTO `bulan` VALUES ('2','Februari','8');
INSERT INTO `bulan` VALUES ('3','Maret','9');
INSERT INTO `bulan` VALUES ('4','April','10');
INSERT INTO `bulan` VALUES ('5','Mei','11');
INSERT INTO `bulan` VALUES ('6','Juni','12');
INSERT INTO `bulan` VALUES ('7','Juli','1');
INSERT INTO `bulan` VALUES ('8','Agustus','2');
INSERT INTO `bulan` VALUES ('9','September','3');

/*---------------------------------------------------------------
  TABLE: `hutangtoko`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `hutangtoko`;
CREATE TABLE `hutangtoko` (
  `id_hutangtoko` varchar(10) NOT NULL,
  `hutangke` varchar(50) NOT NULL,
  `tanggal` date NOT NULL,
  `ket` varchar(100) NOT NULL,
  `nominal` int(11) NOT NULL,
  `sisa` int(11) NOT NULL,
  PRIMARY KEY (`id_hutangtoko`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;
INSERT INTO `hutangtoko` VALUES   ('HT001','Saya','2020-01-16','Aku','2000000','1534997');
INSERT INTO `hutangtoko` VALUES ('HT002','ada','2020-01-25','modal','1200000','600000');
INSERT INTO `hutangtoko` VALUES ('HT003','Koperasi','2020-01-26','Suhender','650000','430000');
INSERT INTO `hutangtoko` VALUES ('HT004','MA','2020-02-18','Pak Budi','2000000','1800000');
INSERT INTO `hutangtoko` VALUES ('HT005','FIF','2020-02-23','Aku','2000000','1900000');
INSERT INTO `hutangtoko` VALUES ('HT006','JOJOWIK','2020-03-04','JUNED','200000','200000');
INSERT INTO `hutangtoko` VALUES ('HT007','potocopy','2020-03-11','nadea','1000000','900000');
INSERT INTO `hutangtoko` VALUES ('HT008','UMS','2020-03-11','Universitas Muhammadiyah Surakarta','1000000000','500000000');
INSERT INTO `hutangtoko` VALUES ('HT009','Sekolah','2020-04-28','Ahmad Bayhaqi','100000','50000');

/*---------------------------------------------------------------
  TABLE: `identitas`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `identitas`;
CREATE TABLE `identitas` (
  `npsn` varchar(8) NOT NULL,
  `nmSekolah` varchar(100) DEFAULT NULL,
  `alamat` varchar(255) DEFAULT NULL,
  `kabupaten` varchar(100) NOT NULL,
  `propinsi` varchar(100) NOT NULL,
  `nipKepsek` varchar(20) DEFAULT NULL,
  `nmKepsek` varchar(100) DEFAULT NULL,
  `nipKaTU` varchar(20) DEFAULT NULL,
  `nmKaTU` varchar(100) DEFAULT NULL,
  `nipBendahara` varchar(20) DEFAULT NULL,
  `nmBendahara` varchar(100) DEFAULT NULL,
  `logo_kiri` varchar(255) DEFAULT NULL,
  `logo_kanan` varchar(100) NOT NULL,
  PRIMARY KEY (`npsn`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
INSERT INTO `identitas` VALUES   ('10700295','SMKPERCOBAAN','Jl. Angker No.111','Surabaya','Jawa Timur ','-','Jojon.Spd.','-','ANISA ANJARSARI ','','SHOLIHATUL FAHMI','APA AJA.png','Barokah Channel.png');

/*---------------------------------------------------------------
  TABLE: `jenis_bayar`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `jenis_bayar`;
CREATE TABLE `jenis_bayar` (
  `idJenisBayar` int(10) NOT NULL AUTO_INCREMENT,
  `idPosBayar` int(5) DEFAULT NULL,
  `idTahunAjaran` int(5) DEFAULT NULL,
  `nmJenisBayar` varchar(100) DEFAULT NULL,
  `tipeBayar` enum('bulanan','bebas') DEFAULT 'bulanan',
  PRIMARY KEY (`idJenisBayar`),
  KEY `fk_pos` (`idPosBayar`),
  KEY `fk_tahun` (`idTahunAjaran`),
  CONSTRAINT `fk_pos` FOREIGN KEY (`idPosBayar`) REFERENCES `pos_bayar` (`idPosBayar`) ON UPDATE CASCADE,
  CONSTRAINT `fk_tahun` FOREIGN KEY (`idTahunAjaran`) REFERENCES `tahun_ajaran` (`idTahunAjaran`) ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=67 DEFAULT CHARSET=latin1;
INSERT INTO `jenis_bayar` VALUES   ('2','1','3','Pembangunan 1819','bebas');
INSERT INTO `jenis_bayar` VALUES ('4','1','3','spp','bulanan');
INSERT INTO `jenis_bayar` VALUES ('5','1','4','DANA BULANAN','bulanan');
INSERT INTO `jenis_bayar` VALUES ('6','1','4','DAFTAR ULANG','bebas');
INSERT INTO `jenis_bayar` VALUES ('7','1','4','DANA KEG. (AGUSTUSAN)','bebas');
INSERT INTO `jenis_bayar` VALUES ('8','1','4','DANA KEG. (QURBAN)','bebas');
INSERT INTO `jenis_bayar` VALUES ('9','1','4','DANA KEG.(CLASSMEETING)','bebas');
INSERT INTO `jenis_bayar` VALUES ('10','1','4','DANA KEG.(PHBI)','bebas');
INSERT INTO `jenis_bayar` VALUES ('11','1','4','DANA KEG.(OSIS)','bebas');
INSERT INTO `jenis_bayar` VALUES ('12','1','4','EKSTRAKULIKULER','bebas');
INSERT INTO `jenis_bayar` VALUES ('13','1','4','KEPRAMUKAAN','bebas');
INSERT INTO `jenis_bayar` VALUES ('14','1','4','KARTU PELAJAR','bebas');
INSERT INTO `jenis_bayar` VALUES ('15','1','4','DANA PERPUS','bebas');
INSERT INTO `jenis_bayar` VALUES ('16','1','4','UTS (SMST1)','bebas');
INSERT INTO `jenis_bayar` VALUES ('17','1','4','UTS (SMST2)','bebas');
INSERT INTO `jenis_bayar` VALUES ('18','1','4','UAS(SMST1)','bebas');
INSERT INTO `jenis_bayar` VALUES ('19','1','4','UAS(SMST2)','bebas');
INSERT INTO `jenis_bayar` VALUES ('20','1','4','RAPORT','bebas');
INSERT INTO `jenis_bayar` VALUES ('21','1','4','PERKEMAHAN/PERJARI','bebas');
INSERT INTO `jenis_bayar` VALUES ('22','1','4','SERAGAM ALMAMATER','bebas');
INSERT INTO `jenis_bayar` VALUES ('23','1','4','DANA PRAKTIKUM','bebas');
INSERT INTO `jenis_bayar` VALUES ('24','1','4','DANA SARPARAS','bebas');
INSERT INTO `jenis_bayar` VALUES ('25','1','4','KALENDER SEKOLAH','bebas');
INSERT INTO `jenis_bayar` VALUES ('26','1','4','NOMINATIF','bebas');
INSERT INTO `jenis_bayar` VALUES ('27','1','4','PENDALAMAN MATERI','bebas');
INSERT INTO `jenis_bayar` VALUES ('28','1','4','PENGADAAN SARANA UNBK','bebas');
INSERT INTO `jenis_bayar` VALUES ('29','1','4','FOTO IJAZAH','bebas');
INSERT INTO `jenis_bayar` VALUES ('30','1','4','BUKU PENDAMPING UN & LKS','bebas');
INSERT INTO `jenis_bayar` VALUES ('31','1','4','SIMULASI (1&2)','bebas');
INSERT INTO `jenis_bayar` VALUES ('32','1','4','TRYOUT (1&2)','bebas');
INSERT INTO `jenis_bayar` VALUES ('33','1','4','USBN BK','bebas');
INSERT INTO `jenis_bayar` VALUES ('34','1','4','UNBK','bebas');
INSERT INTO `jenis_bayar` VALUES ('35','1','4','PRA UKK','bebas');
INSERT INTO `jenis_bayar` VALUES ('36','1','4','UKK','bebas');
INSERT INTO `jenis_bayar` VALUES ('37','1','4','BUKU KENANGAN','bebas');
INSERT INTO `jenis_bayar` VALUES ('38','1','4','IJASAH & SKHUN','bebas');
INSERT INTO `jenis_bayar` VALUES ('39','1','4','SAMPUL IJASAH','bebas');
INSERT INTO `jenis_bayar` VALUES ('40','1','4','FC.PENULISAN IJASAH','bebas');
INSERT INTO `jenis_bayar` VALUES ('41','1','4','CENDERAMATA SEKOLAH','bebas');
INSERT INTO `jenis_bayar` VALUES ('42','1','4','PERPISAHAN','bebas');
INSERT INTO `jenis_bayar` VALUES ('43','1','4','PRAKERIN/TABLE MANER','bebas');
INSERT INTO `jenis_bayar` VALUES ('44','2','4','UAS','bebas');
INSERT INTO `jenis_bayar` VALUES ('45','1','5','PTS Susulan','bebas');
INSERT INTO `jenis_bayar` VALUES ('46','1','5','PAS Susulan','bebas');
INSERT INTO `jenis_bayar` VALUES ('49','4','4','PSG','bebas');
INSERT INTO `jenis_bayar` VALUES ('50','1','4','','bebas');
INSERT INTO `jenis_bayar` VALUES ('51','1','4','SPP 01 20','bebas');
INSERT INTO `jenis_bayar` VALUES ('52','1','4','kaoskaki','bebas');
INSERT INTO `jenis_bayar` VALUES ('53','1','5','SPP Bulanan','bulanan');
INSERT INTO `jenis_bayar` VALUES ('54','6','4','Uang Pangkal','bebas');
INSERT INTO `jenis_bayar` VALUES ('55','1','4','Ikhtifalan','bebas');
INSERT INTO `jenis_bayar` VALUES ('56','1','5','bilungal','bebas');
INSERT INTO `jenis_bayar` VALUES ('57','1','4','bp','bebas');
INSERT INTO `jenis_bayar` VALUES ('58','1','8','','bulanan');
INSERT INTO `jenis_bayar` VALUES ('59','5','8','susulan','bulanan');
INSERT INTO `jenis_bayar` VALUES ('60','1','8','susulan','bulanan');
INSERT INTO `jenis_bayar` VALUES ('61','6','8','Uang Keamanan','bebas');
INSERT INTO `jenis_bayar` VALUES ('62','1','10','SPP KJP','bulanan');
INSERT INTO `jenis_bayar` VALUES ('63','4','10','','bulanan');
INSERT INTO `jenis_bayar` VALUES ('64','4','10','psg','bulanan');
INSERT INTO `jenis_bayar` VALUES ('65','9','8','SPP BULAN JUNI','bulanan');
INSERT INTO `jenis_bayar` VALUES ('66','8','8','Uang Makan','bulanan');

/*---------------------------------------------------------------
  TABLE: `jurnal_umum`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `jurnal_umum`;
CREATE TABLE `jurnal_umum` (
  `id` int(50) NOT NULL AUTO_INCREMENT,
  `tgl` date DEFAULT NULL,
  `ket` varchar(100) DEFAULT NULL,
  `penerimaan` int(10) DEFAULT '0',
  `pengeluaran` int(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=latin1;
INSERT INTO `jurnal_umum` VALUES   ('1','2020-01-15','transport','1000000','100000');
INSERT INTO `jurnal_umum` VALUES ('2','2020-01-15','MAKAN SIANG','100000','50000');
INSERT INTO `jurnal_umum` VALUES ('3','2020-01-15','UAS','20000','0');
INSERT INTO `jurnal_umum` VALUES ('4','2020-01-15','MIS','0','0');
INSERT INTO `jurnal_umum` VALUES ('5','2020-01-25','Transport ke Surabaya','1','200000');
INSERT INTO `jurnal_umum` VALUES ('6','2020-03-06','Bos','14000000','0');
INSERT INTO `jurnal_umum` VALUES ('8','2020-03-11','bayar fotocopy man','0','1000000');
INSERT INTO `jurnal_umum` VALUES ('9','2020-03-11','Saldo Awal','12000000','0');
INSERT INTO `jurnal_umum` VALUES ('10','2020-04-06','Coba Aja','10000','20000');
INSERT INTO `jurnal_umum` VALUES ('11','2020-06-18','pembelian buku','0','250000');

/*---------------------------------------------------------------
  TABLE: `kas`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `kas`;
CREATE TABLE `kas` (
  `kode` int(11) NOT NULL AUTO_INCREMENT,
  `keterangan` varchar(300) NOT NULL,
  `idKelas` int(50) NOT NULL,
  `tgl` date NOT NULL,
  `jumlah` int(10) NOT NULL,
  `jenis` varchar(20) NOT NULL,
  `keluar` int(20) NOT NULL,
  PRIMARY KEY (`kode`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
INSERT INTO `kas` VALUES   ('2','Juli','1','2020-06-21','25000','masuk','0');

/*---------------------------------------------------------------
  TABLE: `kelas_siswa`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `kelas_siswa`;
CREATE TABLE `kelas_siswa` (
  `idKelas` int(5) NOT NULL AUTO_INCREMENT,
  `nmKelas` varchar(20) DEFAULT NULL,
  `ketKelas` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`idKelas`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=latin1;
INSERT INTO `kelas_siswa` VALUES   ('1','X OTKP','-');
INSERT INTO `kelas_siswa` VALUES ('3','X APH','');
INSERT INTO `kelas_siswa` VALUES ('4','X TKJ','');
INSERT INTO `kelas_siswa` VALUES ('5','XI TKJ','');
INSERT INTO `kelas_siswa` VALUES ('6','XI OTKP','');
INSERT INTO `kelas_siswa` VALUES ('7','XI APH','');
INSERT INTO `kelas_siswa` VALUES ('8','XII APH','');
INSERT INTO `kelas_siswa` VALUES ('9','X RPL','');
INSERT INTO `kelas_siswa` VALUES ('10','IX A','');

/*---------------------------------------------------------------
  TABLE: `memodb`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `memodb`;
CREATE TABLE `memodb` (
  `kwnum` varchar(20) NOT NULL,
  `nominal` int(11) NOT NULL,
  `payee` varchar(25) NOT NULL,
  `pic` varchar(25) NOT NULL,
  `tglkw` varchar(20) NOT NULL,
  `ktrg` text NOT NULL,
  PRIMARY KEY (`kwnum`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
INSERT INTO `memodb` VALUES   ('001/KHS-KWT/X/19','120000','Rivani vhan','dfsdf','11 Oktober 2019','dfss');

/*---------------------------------------------------------------
  TABLE: `pos_bayar`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `pos_bayar`;
CREATE TABLE `pos_bayar` (
  `idPosBayar` int(5) NOT NULL AUTO_INCREMENT,
  `nmPosBayar` varchar(100) DEFAULT NULL,
  `ketPosBayar` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`idPosBayar`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=latin1;
INSERT INTO `pos_bayar` VALUES   ('1','SMK','SMK ASWAJA');
INSERT INTO `pos_bayar` VALUES ('2','SD AJA','SD AJA');
INSERT INTO `pos_bayar` VALUES ('3','LSPP SMA','Luar Syahriyah SMA');
INSERT INTO `pos_bayar` VALUES ('4','PSG','PSG');
INSERT INTO `pos_bayar` VALUES ('5','SPP','SPP Bulanan');
INSERT INTO `pos_bayar` VALUES ('6','MA','Uang Pangkal');
INSERT INTO `pos_bayar` VALUES ('7','Ikhtifalan','sumbangan');
INSERT INTO `pos_bayar` VALUES ('8','Syahriyah','kamar dan nasi');
INSERT INTO `pos_bayar` VALUES ('9','SPP Bulan Juni','');
INSERT INTO `pos_bayar` VALUES ('10','SPP Bulan Juli','');

/*---------------------------------------------------------------
  TABLE: `siswa`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `siswa`;
CREATE TABLE `siswa` (
  `idSiswa` int(10) NOT NULL AUTO_INCREMENT,
  `nisSiswa` varchar(25) DEFAULT NULL,
  `nisnSiswa` varchar(25) DEFAULT NULL,
  `nmSiswa` varchar(100) DEFAULT NULL,
  `jkSiswa` varchar(15) DEFAULT NULL,
  `agamaSiswa` varchar(15) DEFAULT NULL,
  `idKelas` int(5) DEFAULT NULL,
  `statusSiswa` enum('Aktif','Non Aktif','Pindah','Drop Out','Lulus') DEFAULT 'Aktif',
  `username` varchar(20) NOT NULL,
  `password` varchar(200) DEFAULT NULL,
  `level` varchar(10) NOT NULL,
  `nmOrtu` varchar(40) DEFAULT NULL,
  `alamatOrtu` varchar(100) DEFAULT NULL,
  `noHpOrtu` varchar(30) DEFAULT NULL,
  `saldo` double NOT NULL,
  PRIMARY KEY (`idSiswa`),
  KEY `fk_kelas` (`idKelas`),
  KEY `fk_status` (`statusSiswa`),
  CONSTRAINT `fk_kelas` FOREIGN KEY (`idKelas`) REFERENCES `kelas_siswa` (`idKelas`) ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=417 DEFAULT CHARSET=latin1;
INSERT INTO `siswa` VALUES   ('278','361/059/116','0031242223','Dewi Pitasari','P','Islam','6','Aktif','siswa2','siswa','ketuakelas','Jauhari','Dsn. Sukodadi RT.04/RW.01 Ds. Sraten ','6825233072661','100000');
INSERT INTO `siswa` VALUES ('280','363/061/116','0047537539','Eka Dian Saputri','P','Islam','6','Lulus','',NULL,'','','Dsn. Sukodadi RT.03/RW.02 Ds. Sraten ','','0');
INSERT INTO `siswa` VALUES ('282','366/064/116','0036076018','Haliyatul Fitri','P','Islam','6','Lulus','',NULL,'','HANIPAN','SRAMPON','','0');
INSERT INTO `siswa` VALUES ('284','368/066/116','0036492698','Hillah Maulana','L','Islam','6','Lulus','',NULL,'','','Dsn. Sukodadi RT.03/RW.02 Ds. Sraten ','','0');
INSERT INTO `siswa` VALUES ('285','369/067/116','0045002559','Israhul Amalia','P','Islam','6','Lulus','',NULL,'','','Dsn. Krajan RT.03/RW.03 Ds. Kedayunan','','0');
INSERT INTO `siswa` VALUES ('286','370/068/116','0031890173','LISA NUR AYU GUNAWATI','P','Islam','6','Lulus','',NULL,'','Sujarno','Sukodadi','','0');
INSERT INTO `siswa` VALUES ('287','371/069/116','0023395015','Mirna Putri Uhrowi','P','Islam','6','Lulus','',NULL,'','','Dsn. Sumberjeruk RT.03/RW.03 Ds. Tamanagung','','0');
INSERT INTO `siswa` VALUES ('289','373/071/116','0043434098','Moh. Taqinaqi Khoirusima Yusuf','L','Islam','6','Lulus','',NULL,'','','Dsn. Kejoyo RT.01/04 Ds. Tambong','','0');
INSERT INTO `siswa` VALUES ('290','374/072/116','0039621557','Muhammad Hendrawan','L','Islam','6','Lulus','',NULL,'','','Dsn. Krajan RT.04/RW.04 Ds. Sraten','','0');
INSERT INTO `siswa` VALUES ('291','375/073/116','0036533502','Nafila Kurnia Alvianda','P','Islam','6','Lulus','',NULL,'','','Dsn. Krajan RT.02/RW.01 Ds. Sukojati','','0');
INSERT INTO `siswa` VALUES ('292','376/074/116','0037619590','Nining Arbailah','P','Islam','6','Lulus','',NULL,'','','Dsn. Krajan RT.02/RW.07 Ds. Pakistaji','','0');
INSERT INTO `siswa` VALUES ('293','377/075/116','3007000000','Nur Aini','P','Islam','6','Lulus','',NULL,'','','Dsn. Gumukagung RT.03/RW.05 Ds. Gintangan','','0');
INSERT INTO `siswa` VALUES ('294','378/076/116','0041817964','Puspa Rida Umma','P','Islam','6','Lulus','',NULL,'','HUSNAN','JL. BANYU CINDIH','','0');
INSERT INTO `siswa` VALUES ('295','380/078/116','0035612410','Seza Aprilia','P','Islam','6','Lulus','',NULL,'','','Dsn. Krajan RT.02/RW.07 Ds. Gladag','','0');
INSERT INTO `siswa` VALUES ('296','382/080/116','0044995733','Siti Wasilah','P','Islam','6','Lulus','',NULL,'','','Dsn. Krajan RT.03/RW.02 Ds. Kaligung','','0');
INSERT INTO `siswa` VALUES ('297','383/081/116','0035663108','Wahyudi Ismail','L','Islam','6','Lulus','',NULL,'','','Dsn. Kedungsari RT.02/RW.01 Ds. Gintangan','','0');
INSERT INTO `siswa` VALUES ('298','384/082/116','0043344704','Yeni Fitriani','P','Islam','6','Lulus','',NULL,'','','Dsn Krajan RT.02/RW.01 Ds. Sraten','','0');
INSERT INTO `siswa` VALUES ('299','373/046/110','0041807508','Amalia Ilmiah','P','Islam','1','Aktif','ilmi','ilmi','ketuakelas','Hadiri','sampangan','085233072661','0');
INSERT INTO `siswa` VALUES ('300','374/047/110','0044717785','Anisa Tri Wahyuni','P','Islam','1','Lulus','',NULL,'','','Dsn. Pekiwen RT.03/RW.02 Ds. Kaligung','','0');
INSERT INTO `siswa` VALUES ('302','376/049/110','0033302744','Diana Ulfa','P','Islam','8','Lulus','',NULL,'','','','','450000');
INSERT INTO `siswa` VALUES ('303','377/050/110','0047992668','Dimas Viktor Risman','L','Islam','5','Aktif','',NULL,'','','','','0');
INSERT INTO `siswa` VALUES ('304','378/051/110','0048336113','Dini Asmawati','P','Islam','1','Lulus','',NULL,'','','Dsn. Krajan RT.02/RW.02 Ds. Blimbingsari','','0');
INSERT INTO `siswa` VALUES ('305','379/052/110','0042201099','Dini Putri Hidayah','P','Islam','1','Lulus','',NULL,'','','Rejosari','','15000');
INSERT INTO `siswa` VALUES ('306','380/053/110','0047377251','Eka Agustina Rahayu','P','Islam','1','Lulus','',NULL,'','','Sukodadi Sraten','','0');
INSERT INTO `siswa` VALUES ('307','381/054/110','0036492699','Hedi Saputra','L','Islam','1','Lulus','',NULL,'','','Dsn. Babakan RT.01/RW.04 Ds. Kedayunan','','0');
INSERT INTO `siswa` VALUES ('308','382/055/110','0040573762','Indah Tri Wulandari','P','Islam','1','Lulus','',NULL,'','Surip','Krajan','','0');
INSERT INTO `siswa` VALUES ('309','383/056/110','0039182496','Istikomah','P','Islam','1','Lulus','',NULL,'','','Dsn. Kedungsari RT.02/RW.01  Ds. Gintangan','','0');
INSERT INTO `siswa` VALUES ('311','385/058/110','0036413579','Maulida Yuli Fitri','P','Islam','1','Lulus','',NULL,'','','Dsn. Krajan Timur RT.03/RW.03 Ds. Segobang Licin','','0');
INSERT INTO `siswa` VALUES ('312','395/059/110','0031048961','Mira Agustin','P','Islam','3','Aktif','',NULL,'','Orang Tua','Dsn. Krajan Ds. Songgon','085233072661','0');
INSERT INTO `siswa` VALUES ('313','396/060/110','0044324638','Nadifatul Insiyah','P','Islam','1','Lulus','',NULL,'','','Ds. Sasakbomo RT.01/RW.02 Ds. Mangir','','0');
INSERT INTO `siswa` VALUES ('314','397/061/110','0035764814','Nuris Soleha','P','Islam','1','Lulus','',NULL,'','MAD RAJI','PALUREJO','','0');
INSERT INTO `siswa` VALUES ('316','399/063/110','0036380287','Roekhatul Habibah','P','Islam','1','Lulus','',NULL,'','','sampangan','085233072661','0');
INSERT INTO `siswa` VALUES ('317','400/064/110','0035593330','Ulfa Hanin Khumairoh','P','Islam','1','Lulus','',NULL,'','','Dsn. Rejosari RT.06/RW.01 Ds. Benculuk','','0');
INSERT INTO `siswa` VALUES ('318','401/087/66','0039250453','Abd. Rohim','L','Islam','4','Lulus','',NULL,'','','Giri','','0');
INSERT INTO `siswa` VALUES ('319','402/088/66','0039782572','Abdul Latip','L','Islam','5','Aktif','',NULL,'','Sudirman','Desa Tanjung Mulya','','0');
INSERT INTO `siswa` VALUES ('320','403/089/66','0014102305','Abdul Rohman','L','Islam','5','Aktif','',NULL,'','','Dsn. Cengkokan RT.01/RW.01 Ds. Mangir','','0');
INSERT INTO `siswa` VALUES ('321','404/090/66','0049747742','Ahmad Balya Irsyaduddin','L','Islam','5','Aktif','',NULL,'','','Dsn. Sumbersari  RT.01/RW.02 Ds. Mangir','','0');
INSERT INTO `siswa` VALUES ('322','405/091/66','0048101100','Ahmad Fathurrohman','L','Islam','5','Aktif','',NULL,'','','Dsn. Kramatagung RT.03/RW.02 Ds. Kaligung','','0');
INSERT INTO `siswa` VALUES ('323','406/092/66','0047902281','Ahmad Taufiqur Rohman','L','Islam','5','Aktif','',NULL,'','','Dsn. Sumbersari  RT.02/RW.02 Ds. Mangir','','0');
INSERT INTO `siswa` VALUES ('324','317/043/66','0037262310','Andri Kristina Putra','L','Islam','5','Aktif','',NULL,'','','Dsn. Rejosari RT.01/RW.01 Ds. Karangrejo','','0');
INSERT INTO `siswa` VALUES ('325','408/094/66','0042037288','Ayu Uut Wulandari','P','Islam','5','Aktif','',NULL,'','','Dsn. Krajan RT.05/RW.02 Ds. Bomo','','0');
INSERT INTO `siswa` VALUES ('326','428/113/66','0036431103','Dina Mukarromah','P','Islam','5','Aktif','',NULL,'','','JAMBEARUM PUGER JEMBER','','0');
INSERT INTO `siswa` VALUES ('327','429/114/66','0036431104','Dini Mukarromah','P','Islam','5','Aktif','',NULL,'','','JAMBEARUM PUGER JEMBER','','0');
INSERT INTO `siswa` VALUES ('328','409/095/66','0036057891','ERVINA GUSMIARNI','P','Islam','5','Aktif','',NULL,'','KUSNEN','JL.GUMUK KANTONG','','0');
INSERT INTO `siswa` VALUES ('330','411/097/66','0049516358','Hayatun Thoyyibah','P','Islam','5','Aktif','',NULL,'','NASERI','Jl. Kramat','','0');
INSERT INTO `siswa` VALUES ('331','412/098/66','0035657766','Imam Mustofa','L','Islam','5','Aktif','',NULL,'','','Dsn. Rejosari RT.03/RW.01 Ds. Karangrejo','','0');
INSERT INTO `siswa` VALUES ('332','413/099/66','0034686802','Ismia Umul Azam','P','Islam','5','Aktif','',NULL,'','SUGIANTO','JL. KEDAYUNAN','','0');
INSERT INTO `siswa` VALUES ('333','414/100/66','0031469023','Kartika Trisna Devi','P','Islam','5','Aktif','',NULL,'','BASORI','Krajan','','0');
INSERT INTO `siswa` VALUES ('334','415/101/66','0033680235','M. Azwar Anas','L','Islam','5','Aktif','',NULL,'','Misnan','Dsn, Sumbersari','','0');
INSERT INTO `siswa` VALUES ('335','416/102/66','0050455300','Mas Hilmi Mubarrok','L','Islam','5','Aktif','',NULL,'','','Dsn. Babakan RT.01/RW.04 Ds.Kedayunan','','0');
INSERT INTO `siswa` VALUES ('336','417/103/66','0037811820','Moh. Fikri Andriansyah','L','Islam','5','Aktif','',NULL,'','AGUS MUJIB','JL. PRING SEJUTA','','0');
INSERT INTO `siswa` VALUES ('337','419/105/66','0046777477','Nanang Bahroji','L','Islam','5','Aktif','',NULL,'','','JL. WATUGONG','','0');
INSERT INTO `siswa` VALUES ('338','420/106/66','0045631789','Nidia Rin Triana','P','Islam','5','Aktif','',NULL,'','','Dsn. Kedunen RT.03/RW.02 Ds. Bomo','','0');
INSERT INTO `siswa` VALUES ('339','421/107/66','0042520889','Nuril Islam','L','Islam','5','Aktif','',NULL,'','','Dsn. Malar Ds. Macanputih','','0');
INSERT INTO `siswa` VALUES ('341','423/109/66','0036452057','Sela Arista','P','Islam','5','Aktif','',NULL,'','','Dsn. Pendarungan RT.01/RW.01 Ds. Karangrejo','','0');
INSERT INTO `siswa` VALUES ('342','424/110/66','0045236290','Sinta Annuriyah','P','Islam','5','Aktif','',NULL,'','Tuhaini','Jl. Kramat','','0');
INSERT INTO `siswa` VALUES ('343','425/111/66','0042258489','Very Prasetiyo','L','Islam','5','Aktif','',NULL,'','','Dsn. Pekiwen RT.01/RW.02 Ds. Kaligung','','0');
INSERT INTO `siswa` VALUES ('345','427/046/66','0044255385','Wisnu Wardana','L','Islam','5','Aktif','',NULL,'','MOH. SUPRIYANTO ROUTOMO','KRAJAN','','0');
INSERT INTO `siswa` VALUES ('346','320/037/116','0022045685','AHMAD SULAIMI','L','Islam','5','Aktif','',NULL,'','','Babagan RT01/RW01 Kedayunan Kabat','','0');
INSERT INTO `siswa` VALUES ('347','335/051/116','0019297552','Arkanul Muslimin','L','Islam','5','Aktif','',NULL,'','','Curahpacul RT03/RW04 Tambakrejo Muncar','','0');
INSERT INTO `siswa` VALUES ('348','341/053/116','0016977296','DENI PURWANTO','L','Islam','5','Aktif','',NULL,'','','Yosowinangun RT06/RW03 Jajag Gambiran','','0');
INSERT INTO `siswa` VALUES ('349','321/038/116','0034332522','DHILA ARIESTYA','P','Islam','5','Aktif','',NULL,'','','Muncar RT03/RW05 Kedungrejo Muncar','','0');
INSERT INTO `siswa` VALUES ('350','324/040/116','0036495560','Muhamad Firli Abdika','L','Islam','5','Aktif','',NULL,'','','Krajan RT04/RW02 Sraten Cluring','','0');
INSERT INTO `siswa` VALUES ('351','326/042/116','0025512733','Nur Alfi Ansyah','P','Islam','5','Aktif','',NULL,'','HADI SURYANTO','SRONO','','0');
INSERT INTO `siswa` VALUES ('352','325/041/116','0039907311','Nuril Maulidiyah','P','Islam','5','Aktif','',NULL,'','FATKHAL MUNIR','KRAJAN','','0');
INSERT INTO `siswa` VALUES ('353','327/043/116','0031970784','Orlando Pilipus','L','Islam','5','Aktif','',NULL,'','DIDIK HARIYADI','DUSUN BLANGKON','','0');
INSERT INTO `siswa` VALUES ('354','328/044/116','0010062760','Putra Adi Prasetya','L','Islam','5','Aktif','',NULL,'','','Plosorejo RT02/RW01 Kaliploso Cluring','','0');
INSERT INTO `siswa` VALUES ('355','329/045/116','0039075959','Putri Amelia Larosa','P','Islam','5','Aktif','',NULL,'','Khusnun','Suwaluh','','0');
INSERT INTO `siswa` VALUES ('358','330/046/116','0056677245','S. Eka Nurul Hikmah','P','Islam','5','Aktif','',NULL,'','Yusup','Pekiringan','','0');
INSERT INTO `siswa` VALUES ('359','331/047/116','0013717789','Sayu Ulandari','P','Islam','5','Aktif','',NULL,'','','Sukodadi RT04/RW01 Sraten Cluring','','0');
INSERT INTO `siswa` VALUES ('362','332/048/116','0023393443','Siti Kholifah','P','Islam','5','Aktif','',NULL,'','','Krajan RT03/RW02 Sraten Cluring','','0');
INSERT INTO `siswa` VALUES ('363','416/055/116','0013563839','Siti Nur Lutfiyah','P','Islam','5','Aktif','',NULL,'','AHMAD QUSOYI','Jl.segobang','','0');
INSERT INTO `siswa` VALUES ('364','417/056/116','0002341623','Sri Dwi Wahyuni','P','Islam','5','Aktif','',NULL,'','SUROSO','Jl.sukonatar','','10000');
INSERT INTO `siswa` VALUES ('365','333/049/116','0030992539','Syekh Maulana Ishaq','L','Islam','5','Aktif','',NULL,'','','Kramatagung RT03/RW01 Kaligung Blimbingsari','','0');
INSERT INTO `siswa` VALUES ('366','334/050/116','0033770586','Umarudin','L','Islam','5','Aktif','',NULL,'','','Krajan RT01/RW08 Sraten Cluring','','0');
INSERT INTO `siswa` VALUES ('370','313/039/110','0035134146','Arjun Rhamadani','L','Islam','6','Lulus','',NULL,'','EKO SANTOSO','CEMPOKOSARI','','0');
INSERT INTO `siswa` VALUES ('371','314/040/110','0036552923','Dewi Aisah','P','Islam','6','Lulus','',NULL,'','','Krajan RT01/RW08 Dadapan Kabat','','0');
INSERT INTO `siswa` VALUES ('372','315/041/110','0011769512','Fita Ratnaningtiyas','P','Islam','6','Lulus','',NULL,'','MUHTADI','TUGUNG','','0');
INSERT INTO `siswa` VALUES ('374','316/042/110','0022222882','Mita Agustin','P','Islam','6','Lulus','',NULL,'','SURIYONO','SUMBERJOYO','','0');
INSERT INTO `siswa` VALUES ('377','319/045/110','0025570684','Sintia Ayu Lestari','P','Islam','6','Lulus','',NULL,'','','Sukosari','','0');
INSERT INTO `siswa` VALUES ('378','337/069/66','0036682272','Andre Gunawan','L','Islam','5','Aktif','',NULL,'','','Biyan Tengah RT01/RW02 Kaduara Barat Larangan','','0');
INSERT INTO `siswa` VALUES ('379','338/070/66','0034088266','ANGGI NOVITASARI','P','Islam','5','Aktif','',NULL,'','','Patoman Barat RT02/RW02 Patoman Blimbingsari','','0');
INSERT INTO `siswa` VALUES ('380','339/071/66','0027589635','ARIF SETIAWAN','L','Islam','5','Aktif','',NULL,'','','Patoman Barat RT02/RW02 Patoman Blimbingsari','','0');
INSERT INTO `siswa` VALUES ('381','340/072/66','0033009795','AYUK OKTAVIA','P','Islam','5','Aktif','',NULL,'','','Babakan RT01/RW04 Kedayunan Kabat ','','0');
INSERT INTO `siswa` VALUES ('382','342/073/66','0036921533','Diyana','P','Islam','5','Aktif','',NULL,'','AGUS','JL. TAMBONG','','0');
INSERT INTO `siswa` VALUES ('383','343/074/66','0036113469','Erviyadi Luqman Asmawi','L','Islam','5','Aktif','',NULL,'','','Krajan RT02/RW04 Kaligung Rogojampi','','0');
INSERT INTO `siswa` VALUES ('384','344/075/66','0036378894','Lilis Widya Astutik','P','Islam','5','Aktif','',NULL,'','SAIKONI','PAKEL','','0');
INSERT INTO `siswa` VALUES ('385','349/080/66','0037870073','M Ali Murtadlo','L','Islam','5','Aktif','',NULL,'','','Temuguruh Sempu','','0');
INSERT INTO `siswa` VALUES ('387','345/076/66','0036413345','Moch Nurul Fawaiz','L','Islam','5','Aktif','',NULL,'','','Segobang','','0');
INSERT INTO `siswa` VALUES ('388','351/082/66','0026203553','Mochammad Marzuqi','L','Islam','5','Aktif','',NULL,'','','Tapansari RT03/RW01 Sraten Cluring','','0');
INSERT INTO `siswa` VALUES ('390','346/077/66','0023173932','Moh. Gufron','L','Islam','5','Aktif','',NULL,'','SUMITO','JL. PRING SEJUTA','','0');
INSERT INTO `siswa` VALUES ('391','347/078/66','0038927770','Mohammad Nabil','L','Islam','5','Aktif','',NULL,'','NUR KHOLIS','SRONO','','0');
INSERT INTO `siswa` VALUES ('392','348/079/66','0020425650','Muhamad Ifroni','L','Islam','5','Aktif','',NULL,'','BUKHORI','JL. PRING SEJUTA','','0');
INSERT INTO `siswa` VALUES ('393','350/081/66','0035733377','Muhammad Azkanafsi','L','Islam','5','Aktif','',NULL,'','','Seloagung RT04/RW03 Siliragung Siliragung','','0');
INSERT INTO `siswa` VALUES ('394','352/083/66','0026362601','Nur Laila Hidayah','P','Islam','5','Aktif','',NULL,'','','Krajan RT05/RW02 Barurejo Siliragung','','0');
INSERT INTO `siswa` VALUES ('395','353/084/66','0038926644','Rizki Ari Saputra','L','Islam','5','Aktif','',NULL,'','JONO SUPARNO','Tanah Hitam','','0');
INSERT INTO `siswa` VALUES ('396','354/085/66','0029051204','Siti  Mudawamah','P','Islam','5','Aktif','',NULL,'','','Kebonsari','','0');
INSERT INTO `siswa` VALUES ('397','358/089/66','0009813878','Siti Nur Azizah','P','Islam','5','Aktif','',NULL,'','FAHRUDIN','Jl.sraten','','0');
INSERT INTO `siswa` VALUES ('398','355/086/66','0037604093','Syaiful Islam','L','Islam','5','Aktif','',NULL,'','','Kedungsumur RT02/RW14 Jambearum Puger','','0');
INSERT INTO `siswa` VALUES ('399','301/035/098','0014832615','Adelia P','P','Islam','8','Lulus','',NULL,'','','Dsn.Sritanjung 001/006 Ds.Wirolegi Kec.sumbersari','','0');
INSERT INTO `siswa` VALUES ('400','299/033/098','0019767038','Ahmad Syaifulloh','L','Islam','8','Lulus','',NULL,'','PONIRAN','SUWALUH','','0');
INSERT INTO `siswa` VALUES ('401','294/028/098','0012388010','Aprilia Prahesti Utami','L','Islam','8','Lulus','',NULL,'','SUGIYONO','KRAJAN','','0');
INSERT INTO `siswa` VALUES ('402','302/036/098','0034260832','Davit Agung Prayogo','L','Islam','8','Lulus','',NULL,'','SUGIONO','SUWALUH','','0');
INSERT INTO `siswa` VALUES ('403','295/029/098','0020824994','Eka Ulansari','P','Islam','8','Lulus','',NULL,'','SAFRUDIN','rimpis','','0');
INSERT INTO `siswa` VALUES ('404','296/030/098','0016430243','Faizatul Fitri','P','Islam','8','Lulus','',NULL,'','MEIYANTO','Krajan','','0');
INSERT INTO `siswa` VALUES ('405','311/033/098','0025558288','Faris Abid Muwaffaq','L','Islam','8','Lulus','',NULL,'','ABDUL KARIM','BULUAGUNG SILIRAGUNG BANYUWANGI','','0');
INSERT INTO `siswa` VALUES ('406','297/031/098','0009438458','Firman Bastomi','L','Islam','8','Lulus','',NULL,'','BUSAINI','ABDUL BASAR','','0');
INSERT INTO `siswa` VALUES ('407','300/034/098','0029658269','Medi Denes Saputra','L','Islam','8','Lulus','',NULL,'','GATOT BAMBANG SUGIONO','BLANGKON','','45000');
INSERT INTO `siswa` VALUES ('408','298/032/098','0028439399','Rika Supiyati','P','Islam','8','Lulus','',NULL,'','Rohmad','Pendarungan','','0');
INSERT INTO `siswa` VALUES ('409','123','0031242229','rsad','L','Islam','1','Lulus','siswa2','siswa','siswa','Hadiri','Jalan Raya Gedangan','999999999999','20000');
INSERT INTO `siswa` VALUES ('410','21787878','676687','Asep Keraton','L','Katolik','5','Aktif','',NULL,'','usluk','','','5000');
INSERT INTO `siswa` VALUES ('411','12345678','123456789','kimin','L','Islam','1','Lulus','',NULL,'','kiming','takes','321321123','100000');
INSERT INTO `siswa` VALUES ('412','7612641827','783585391','Ahmad Baihaqi','L','Islam','9','Lulus','',NULL,'','Sudin Samsudin','Alamatnya','092507235','500000');
INSERT INTO `siswa` VALUES ('413','1234','','wanda','P','Islam','3','Aktif','wanda','wahyuni','siswa','suhdi','Yossudarso','08123456789','0');
INSERT INTO `siswa` VALUES ('414','88','88','wanda','P','Islam','3','Aktif','wanda1','wanda1','siswa','suhdi','Yossudarso','08123456789','0');
INSERT INTO `siswa` VALUES ('415','0001','414','abcd','L','Islam','1','Lulus','12345678','12345678','siswa','qqq','qqqqqqqqqq','999999999999','0');
INSERT INTO `siswa` VALUES ('416','0002','12345678','Fauzan','L','Islam','5','Aktif','12345678','123','siswa','Setiyo','Sidoarjo','909090','10000');

/*---------------------------------------------------------------
  TABLE: `tagihan_bebas`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `tagihan_bebas`;
CREATE TABLE `tagihan_bebas` (
  `idTagihanBebas` int(50) NOT NULL AUTO_INCREMENT,
  `idJenisBayar` int(5) DEFAULT NULL,
  `idSiswa` int(10) DEFAULT NULL,
  `idKelas` int(5) DEFAULT NULL,
  `totalTagihan` int(10) DEFAULT NULL,
  `statusBayar` enum('0','1','2') DEFAULT '0',
  PRIMARY KEY (`idTagihanBebas`),
  KEY `fk_t_jenis` (`idJenisBayar`),
  KEY `fk_t_siswa` (`idSiswa`),
  KEY `fk_t_kelas` (`idKelas`),
  CONSTRAINT `tagihan_bebas_ibfk_2` FOREIGN KEY (`idJenisBayar`) REFERENCES `jenis_bayar` (`idJenisBayar`) ON UPDATE CASCADE,
  CONSTRAINT `tagihan_bebas_ibfk_3` FOREIGN KEY (`idKelas`) REFERENCES `kelas_siswa` (`idKelas`) ON UPDATE CASCADE,
  CONSTRAINT `tagihan_bebas_ibfk_4` FOREIGN KEY (`idSiswa`) REFERENCES `siswa` (`idSiswa`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2245 DEFAULT CHARSET=latin1;
INSERT INTO `tagihan_bebas` VALUES   ('1','6','399','8','250000','2');
INSERT INTO `tagihan_bebas` VALUES ('2','6','400','8','250000','0');
INSERT INTO `tagihan_bebas` VALUES ('3','6','401','8','250000','0');
INSERT INTO `tagihan_bebas` VALUES ('4','6','402','8','250000','2');
INSERT INTO `tagihan_bebas` VALUES ('5','6','403','8','250000','0');
INSERT INTO `tagihan_bebas` VALUES ('6','6','404','8','250000','0');
INSERT INTO `tagihan_bebas` VALUES ('7','6','405','8','250000','2');
INSERT INTO `tagihan_bebas` VALUES ('8','6','406','8','250000','0');
INSERT INTO `tagihan_bebas` VALUES ('9','6','407','8','250000','0');
INSERT INTO `tagihan_bebas` VALUES ('10','6','408','8','250000','0');
INSERT INTO `tagihan_bebas` VALUES ('11','7','399','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('12','7','400','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('13','7','401','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('14','7','402','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('15','7','403','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('16','7','404','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('17','7','405','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('18','7','406','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('19','7','407','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('20','7','408','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('21','8','399','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('22','8','400','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('23','8','401','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('24','8','402','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('25','8','403','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('26','8','404','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('27','8','405','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('28','8','406','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('29','8','407','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('30','8','408','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('31','9','399','8','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('32','9','400','8','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('33','9','401','8','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('34','9','402','8','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('35','9','403','8','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('36','9','404','8','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('37','9','405','8','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('38','9','406','8','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('39','9','407','8','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('40','9','408','8','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('41','13','399','8','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('42','13','400','8','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('43','13','401','8','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('44','13','402','8','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('45','13','403','8','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('46','13','404','8','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('47','13','405','8','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('48','13','406','8','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('49','13','407','8','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('50','13','408','8','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('51','15','399','8','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('52','15','400','8','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('53','15','401','8','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('54','15','402','8','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('55','15','403','8','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('56','15','404','8','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('57','15','405','8','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('58','15','406','8','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('59','15','407','8','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('60','15','408','8','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('61','16','399','8','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('62','16','400','8','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('63','16','401','8','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('64','16','402','8','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('65','16','403','8','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('66','16','404','8','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('67','16','405','8','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('68','16','406','8','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('69','16','407','8','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('70','16','408','8','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('71','18','399','8','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('72','18','400','8','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('73','18','401','8','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('74','18','402','8','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('75','18','403','8','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('76','18','404','8','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('77','18','405','8','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('78','18','406','8','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('79','18','407','8','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('80','18','408','8','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('81','19','399','8','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('82','19','400','8','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('83','19','401','8','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('84','19','402','8','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('85','19','403','8','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('86','19','404','8','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('87','19','405','8','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('88','19','406','8','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('89','19','407','8','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('90','19','408','8','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('91','23','399','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('92','23','400','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('93','23','401','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('94','23','402','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('95','23','403','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('96','23','404','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('97','23','405','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('98','23','406','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('99','23','407','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('100','23','408','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('101','24','399','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('102','24','400','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('103','24','401','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('104','24','402','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('105','24','403','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('106','24','404','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('107','24','405','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('108','24','406','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('109','24','407','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('110','24','408','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('111','25','399','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('112','25','400','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('113','25','401','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('114','25','402','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('115','25','403','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('116','25','404','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('117','25','405','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('118','25','406','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('119','25','407','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('120','25','408','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('121','26','399','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('122','26','400','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('123','26','401','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('124','26','402','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('125','26','403','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('126','26','404','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('127','26','405','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('128','26','406','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('129','26','407','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('130','26','408','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('131','27','399','8','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('132','27','400','8','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('133','27','401','8','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('134','27','402','8','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('135','27','403','8','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('136','27','404','8','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('137','27','405','8','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('138','27','406','8','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('139','27','407','8','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('140','27','408','8','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('141','28','399','8','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('142','28','400','8','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('143','28','401','8','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('144','28','402','8','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('145','28','403','8','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('146','28','404','8','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('147','28','405','8','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('148','28','406','8','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('149','28','407','8','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('150','28','408','8','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('151','29','399','8','70000','0');
INSERT INTO `tagihan_bebas` VALUES ('152','29','400','8','70000','0');
INSERT INTO `tagihan_bebas` VALUES ('153','29','401','8','70000','0');
INSERT INTO `tagihan_bebas` VALUES ('154','29','402','8','70000','0');
INSERT INTO `tagihan_bebas` VALUES ('155','29','403','8','70000','0');
INSERT INTO `tagihan_bebas` VALUES ('156','29','404','8','70000','0');
INSERT INTO `tagihan_bebas` VALUES ('157','29','405','8','70000','0');
INSERT INTO `tagihan_bebas` VALUES ('158','29','406','8','70000','0');
INSERT INTO `tagihan_bebas` VALUES ('159','29','407','8','70000','0');
INSERT INTO `tagihan_bebas` VALUES ('160','29','408','8','70000','0');
INSERT INTO `tagihan_bebas` VALUES ('161','30','399','8','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('162','30','400','8','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('163','30','401','8','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('164','30','402','8','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('165','30','403','8','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('166','30','404','8','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('167','30','405','8','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('168','30','406','8','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('169','30','407','8','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('170','30','408','8','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('181','32','399','8','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('182','32','400','8','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('183','32','401','8','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('184','32','402','8','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('185','32','403','8','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('186','32','404','8','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('187','32','405','8','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('188','32','406','8','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('189','32','407','8','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('190','32','408','8','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('191','33','399','8','850000','0');
INSERT INTO `tagihan_bebas` VALUES ('192','33','400','8','850000','0');
INSERT INTO `tagihan_bebas` VALUES ('193','33','401','8','850000','0');
INSERT INTO `tagihan_bebas` VALUES ('194','33','402','8','850000','0');
INSERT INTO `tagihan_bebas` VALUES ('195','33','403','8','850000','0');
INSERT INTO `tagihan_bebas` VALUES ('196','33','404','8','850000','0');
INSERT INTO `tagihan_bebas` VALUES ('197','33','405','8','850000','0');
INSERT INTO `tagihan_bebas` VALUES ('198','33','406','8','850000','0');
INSERT INTO `tagihan_bebas` VALUES ('199','33','407','8','850000','0');
INSERT INTO `tagihan_bebas` VALUES ('200','33','408','8','850000','0');
INSERT INTO `tagihan_bebas` VALUES ('201','34','399','8','1250000','0');
INSERT INTO `tagihan_bebas` VALUES ('202','34','400','8','1250000','0');
INSERT INTO `tagihan_bebas` VALUES ('203','34','401','8','1250000','0');
INSERT INTO `tagihan_bebas` VALUES ('204','34','402','8','1250000','0');
INSERT INTO `tagihan_bebas` VALUES ('205','34','403','8','1250000','0');
INSERT INTO `tagihan_bebas` VALUES ('206','34','404','8','1250000','0');
INSERT INTO `tagihan_bebas` VALUES ('207','34','405','8','1250000','0');
INSERT INTO `tagihan_bebas` VALUES ('208','34','406','8','1250000','0');
INSERT INTO `tagihan_bebas` VALUES ('209','34','407','8','1250000','0');
INSERT INTO `tagihan_bebas` VALUES ('210','34','408','8','1250000','0');
INSERT INTO `tagihan_bebas` VALUES ('211','35','399','8','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('212','35','400','8','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('213','35','401','8','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('214','35','402','8','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('215','35','403','8','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('216','35','404','8','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('217','35','405','8','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('218','35','406','8','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('219','35','407','8','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('220','35','408','8','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('221','36','399','8','350000','0');
INSERT INTO `tagihan_bebas` VALUES ('222','36','400','8','350000','0');
INSERT INTO `tagihan_bebas` VALUES ('223','36','401','8','350000','0');
INSERT INTO `tagihan_bebas` VALUES ('224','36','402','8','350000','0');
INSERT INTO `tagihan_bebas` VALUES ('225','36','403','8','350000','0');
INSERT INTO `tagihan_bebas` VALUES ('226','36','404','8','350000','0');
INSERT INTO `tagihan_bebas` VALUES ('227','36','405','8','350000','0');
INSERT INTO `tagihan_bebas` VALUES ('228','36','406','8','350000','0');
INSERT INTO `tagihan_bebas` VALUES ('229','36','407','8','350000','0');
INSERT INTO `tagihan_bebas` VALUES ('230','36','408','8','350000','0');
INSERT INTO `tagihan_bebas` VALUES ('231','38','399','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('232','38','400','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('233','38','401','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('234','38','402','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('235','38','403','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('236','38','404','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('237','38','405','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('238','38','406','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('239','38','407','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('240','38','408','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('241','39','399','8','35000','0');
INSERT INTO `tagihan_bebas` VALUES ('242','39','400','8','35000','0');
INSERT INTO `tagihan_bebas` VALUES ('243','39','401','8','35000','0');
INSERT INTO `tagihan_bebas` VALUES ('244','39','402','8','35000','0');
INSERT INTO `tagihan_bebas` VALUES ('245','39','403','8','35000','0');
INSERT INTO `tagihan_bebas` VALUES ('246','39','404','8','35000','0');
INSERT INTO `tagihan_bebas` VALUES ('247','39','405','8','35000','0');
INSERT INTO `tagihan_bebas` VALUES ('248','39','406','8','35000','0');
INSERT INTO `tagihan_bebas` VALUES ('249','39','407','8','35000','0');
INSERT INTO `tagihan_bebas` VALUES ('250','39','408','8','35000','0');
INSERT INTO `tagihan_bebas` VALUES ('251','40','399','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('252','40','400','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('253','40','401','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('254','40','402','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('255','40','403','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('256','40','404','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('257','40','405','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('258','40','406','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('259','40','407','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('260','40','408','8','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('261','31','399','8','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('262','31','400','8','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('263','31','401','8','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('264','31','402','8','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('265','31','403','8','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('266','31','404','8','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('267','31','405','8','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('268','31','406','8','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('269','31','407','8','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('270','31','408','8','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('271','6','299','1','1750000','2');
INSERT INTO `tagihan_bebas` VALUES ('272','6','300','1','1750000','2');
INSERT INTO `tagihan_bebas` VALUES ('273','6','302','1','1750000','2');
INSERT INTO `tagihan_bebas` VALUES ('274','6','303','1','1750000','2');
INSERT INTO `tagihan_bebas` VALUES ('275','6','304','1','1750000','2');
INSERT INTO `tagihan_bebas` VALUES ('276','6','305','1','1750000','2');
INSERT INTO `tagihan_bebas` VALUES ('277','6','306','1','1750000','0');
INSERT INTO `tagihan_bebas` VALUES ('278','6','307','1','1750000','2');
INSERT INTO `tagihan_bebas` VALUES ('279','6','308','1','1750000','1');
INSERT INTO `tagihan_bebas` VALUES ('280','6','309','1','1750000','2');
INSERT INTO `tagihan_bebas` VALUES ('282','6','311','1','1750000','0');
INSERT INTO `tagihan_bebas` VALUES ('283','6','312','1','1750000','2');
INSERT INTO `tagihan_bebas` VALUES ('284','6','313','1','1750000','2');
INSERT INTO `tagihan_bebas` VALUES ('285','6','314','1','1750000','1');
INSERT INTO `tagihan_bebas` VALUES ('286','6','316','1','1750000','0');
INSERT INTO `tagihan_bebas` VALUES ('287','6','317','1','1750000','0');
INSERT INTO `tagihan_bebas` VALUES ('288','6','278','3','1750000','2');
INSERT INTO `tagihan_bebas` VALUES ('289','6','280','3','1750000','0');
INSERT INTO `tagihan_bebas` VALUES ('290','6','282','3','1750000','0');
INSERT INTO `tagihan_bebas` VALUES ('291','6','284','3','1750000','0');
INSERT INTO `tagihan_bebas` VALUES ('292','6','285','3','1750000','0');
INSERT INTO `tagihan_bebas` VALUES ('293','6','286','3','1750000','0');
INSERT INTO `tagihan_bebas` VALUES ('294','6','287','3','1750000','0');
INSERT INTO `tagihan_bebas` VALUES ('295','6','289','3','1750000','0');
INSERT INTO `tagihan_bebas` VALUES ('296','6','290','3','1750000','0');
INSERT INTO `tagihan_bebas` VALUES ('297','6','291','3','1750000','1');
INSERT INTO `tagihan_bebas` VALUES ('298','6','292','3','1750000','0');
INSERT INTO `tagihan_bebas` VALUES ('299','6','293','3','1750000','0');
INSERT INTO `tagihan_bebas` VALUES ('300','6','294','3','1750000','2');
INSERT INTO `tagihan_bebas` VALUES ('301','6','295','3','1750000','0');
INSERT INTO `tagihan_bebas` VALUES ('302','6','296','3','1750000','0');
INSERT INTO `tagihan_bebas` VALUES ('303','6','297','3','1750000','0');
INSERT INTO `tagihan_bebas` VALUES ('304','6','298','3','1750000','0');
INSERT INTO `tagihan_bebas` VALUES ('305','6','318','4','1750000','0');
INSERT INTO `tagihan_bebas` VALUES ('306','6','319','4','1750000','0');
INSERT INTO `tagihan_bebas` VALUES ('307','6','320','4','1750000','0');
INSERT INTO `tagihan_bebas` VALUES ('308','6','321','4','1750000','0');
INSERT INTO `tagihan_bebas` VALUES ('309','6','322','4','1750000','0');
INSERT INTO `tagihan_bebas` VALUES ('310','6','323','4','1750000','0');
INSERT INTO `tagihan_bebas` VALUES ('311','6','324','4','1750000','0');
INSERT INTO `tagihan_bebas` VALUES ('312','6','325','4','1750000','0');
INSERT INTO `tagihan_bebas` VALUES ('313','6','326','4','1750000','0');
INSERT INTO `tagihan_bebas` VALUES ('314','6','327','4','1750000','0');
INSERT INTO `tagihan_bebas` VALUES ('315','6','328','4','1750000','0');
INSERT INTO `tagihan_bebas` VALUES ('316','6','330','4','1750000','0');
INSERT INTO `tagihan_bebas` VALUES ('317','6','331','4','1750000','0');
INSERT INTO `tagihan_bebas` VALUES ('318','6','332','4','1750000','0');
INSERT INTO `tagihan_bebas` VALUES ('319','6','333','4','1750000','0');
INSERT INTO `tagihan_bebas` VALUES ('320','6','334','4','1750000','0');
INSERT INTO `tagihan_bebas` VALUES ('321','6','335','4','1750000','0');
INSERT INTO `tagihan_bebas` VALUES ('322','6','336','4','1750000','0');
INSERT INTO `tagihan_bebas` VALUES ('323','6','337','4','1750000','0');
INSERT INTO `tagihan_bebas` VALUES ('324','6','338','4','1750000','0');
INSERT INTO `tagihan_bebas` VALUES ('325','6','339','4','1750000','0');
INSERT INTO `tagihan_bebas` VALUES ('326','6','341','4','1750000','0');
INSERT INTO `tagihan_bebas` VALUES ('327','6','342','4','1750000','0');
INSERT INTO `tagihan_bebas` VALUES ('328','6','343','4','1750000','0');
INSERT INTO `tagihan_bebas` VALUES ('329','6','345','4','1750000','0');
INSERT INTO `tagihan_bebas` VALUES ('330','6','378','5','250000','0');
INSERT INTO `tagihan_bebas` VALUES ('331','6','379','5','250000','0');
INSERT INTO `tagihan_bebas` VALUES ('332','6','380','5','250000','2');
INSERT INTO `tagihan_bebas` VALUES ('333','6','381','5','250000','0');
INSERT INTO `tagihan_bebas` VALUES ('334','6','382','5','250000','0');
INSERT INTO `tagihan_bebas` VALUES ('335','6','383','5','250000','0');
INSERT INTO `tagihan_bebas` VALUES ('336','6','384','5','250000','0');
INSERT INTO `tagihan_bebas` VALUES ('337','6','385','5','250000','0');
INSERT INTO `tagihan_bebas` VALUES ('338','6','387','5','250000','0');
INSERT INTO `tagihan_bebas` VALUES ('339','6','388','5','250000','0');
INSERT INTO `tagihan_bebas` VALUES ('340','6','390','5','250000','0');
INSERT INTO `tagihan_bebas` VALUES ('341','6','391','5','250000','0');
INSERT INTO `tagihan_bebas` VALUES ('342','6','392','5','250000','0');
INSERT INTO `tagihan_bebas` VALUES ('343','6','393','5','250000','0');
INSERT INTO `tagihan_bebas` VALUES ('344','6','394','5','250000','0');
INSERT INTO `tagihan_bebas` VALUES ('345','6','395','5','250000','0');
INSERT INTO `tagihan_bebas` VALUES ('346','6','396','5','250000','0');
INSERT INTO `tagihan_bebas` VALUES ('347','6','397','5','250000','0');
INSERT INTO `tagihan_bebas` VALUES ('348','6','398','5','250000','0');
INSERT INTO `tagihan_bebas` VALUES ('349','6','370','6','250000','0');
INSERT INTO `tagihan_bebas` VALUES ('350','6','371','6','250000','0');
INSERT INTO `tagihan_bebas` VALUES ('351','6','372','6','250000','0');
INSERT INTO `tagihan_bebas` VALUES ('352','6','374','6','250000','0');
INSERT INTO `tagihan_bebas` VALUES ('353','6','377','6','250000','2');
INSERT INTO `tagihan_bebas` VALUES ('354','6','346','7','250000','0');
INSERT INTO `tagihan_bebas` VALUES ('355','6','347','7','250000','0');
INSERT INTO `tagihan_bebas` VALUES ('356','6','348','7','250000','0');
INSERT INTO `tagihan_bebas` VALUES ('357','6','349','7','250000','0');
INSERT INTO `tagihan_bebas` VALUES ('358','6','350','7','250000','0');
INSERT INTO `tagihan_bebas` VALUES ('359','6','351','7','250000','0');
INSERT INTO `tagihan_bebas` VALUES ('360','6','352','7','250000','0');
INSERT INTO `tagihan_bebas` VALUES ('361','6','353','7','250000','0');
INSERT INTO `tagihan_bebas` VALUES ('362','6','354','7','250000','0');
INSERT INTO `tagihan_bebas` VALUES ('363','6','355','7','250000','0');
INSERT INTO `tagihan_bebas` VALUES ('364','6','358','7','250000','0');
INSERT INTO `tagihan_bebas` VALUES ('365','6','359','7','250000','0');
INSERT INTO `tagihan_bebas` VALUES ('366','6','362','7','250000','0');
INSERT INTO `tagihan_bebas` VALUES ('367','6','363','7','250000','0');
INSERT INTO `tagihan_bebas` VALUES ('368','6','364','7','250000','0');
INSERT INTO `tagihan_bebas` VALUES ('369','6','365','7','250000','0');
INSERT INTO `tagihan_bebas` VALUES ('370','6','366','7','250000','0');
INSERT INTO `tagihan_bebas` VALUES ('371','7','299','1','50000','2');
INSERT INTO `tagihan_bebas` VALUES ('372','7','300','1','50000','2');
INSERT INTO `tagihan_bebas` VALUES ('373','7','302','1','50000','1');
INSERT INTO `tagihan_bebas` VALUES ('374','7','303','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('375','7','304','1','50000','2');
INSERT INTO `tagihan_bebas` VALUES ('376','7','305','1','50000','2');
INSERT INTO `tagihan_bebas` VALUES ('377','7','306','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('378','7','307','1','50000','1');
INSERT INTO `tagihan_bebas` VALUES ('379','7','308','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('380','7','309','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('382','7','311','1','50000','2');
INSERT INTO `tagihan_bebas` VALUES ('383','7','312','1','50000','1');
INSERT INTO `tagihan_bebas` VALUES ('384','7','313','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('385','7','314','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('386','7','316','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('387','7','317','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('388','7','278','3','50000','2');
INSERT INTO `tagihan_bebas` VALUES ('389','7','280','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('390','7','282','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('391','7','284','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('392','7','285','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('393','7','286','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('394','7','287','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('395','7','289','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('396','7','290','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('397','7','291','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('398','7','292','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('399','7','293','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('400','7','294','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('401','7','295','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('402','7','296','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('403','7','297','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('404','7','298','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('405','7','318','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('406','7','319','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('407','7','320','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('408','7','321','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('409','7','322','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('410','7','323','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('411','7','324','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('412','7','325','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('413','7','326','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('414','7','327','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('415','7','328','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('416','7','330','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('417','7','331','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('418','7','332','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('419','7','333','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('420','7','334','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('421','7','335','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('422','7','336','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('423','7','337','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('424','7','338','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('425','7','339','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('426','7','341','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('427','7','342','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('428','7','343','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('429','7','345','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('430','7','378','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('431','7','379','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('432','7','380','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('433','7','381','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('434','7','382','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('435','7','383','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('436','7','384','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('437','7','385','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('438','7','387','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('439','7','388','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('440','7','390','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('441','7','391','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('442','7','392','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('443','7','393','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('444','7','394','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('445','7','395','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('446','7','396','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('447','7','397','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('448','7','398','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('449','7','370','6','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('450','7','371','6','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('451','7','372','6','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('452','7','374','6','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('453','7','377','6','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('454','7','346','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('455','7','347','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('456','7','348','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('457','7','349','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('458','7','350','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('459','7','351','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('460','7','352','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('461','7','353','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('462','7','354','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('463','7','355','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('464','7','358','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('465','7','359','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('466','7','362','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('467','7','363','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('468','7','364','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('469','7','365','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('470','7','366','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('471','8','299','1','50000','2');
INSERT INTO `tagihan_bebas` VALUES ('472','8','300','1','50000','2');
INSERT INTO `tagihan_bebas` VALUES ('473','8','302','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('474','8','303','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('475','8','304','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('476','8','305','1','50000','2');
INSERT INTO `tagihan_bebas` VALUES ('477','8','306','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('478','8','307','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('479','8','308','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('480','8','309','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('482','8','311','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('483','8','312','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('484','8','313','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('485','8','314','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('486','8','316','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('487','8','317','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('488','8','278','3','50000','2');
INSERT INTO `tagihan_bebas` VALUES ('489','8','280','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('490','8','282','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('491','8','284','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('492','8','285','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('493','8','286','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('494','8','287','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('495','8','289','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('496','8','290','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('497','8','291','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('498','8','292','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('499','8','293','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('500','8','294','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('501','8','295','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('502','8','296','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('503','8','297','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('504','8','298','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('505','8','318','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('506','8','319','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('507','8','320','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('508','8','321','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('509','8','322','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('510','8','323','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('511','8','324','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('512','8','325','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('513','8','326','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('514','8','327','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('515','8','328','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('516','8','330','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('517','8','331','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('518','8','332','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('519','8','333','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('520','8','334','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('521','8','335','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('522','8','336','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('523','8','337','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('524','8','338','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('525','8','339','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('526','8','341','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('527','8','342','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('528','8','343','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('529','8','345','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('530','8','378','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('531','8','379','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('532','8','380','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('533','8','381','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('534','8','382','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('535','8','383','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('536','8','384','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('537','8','385','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('538','8','387','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('539','8','388','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('540','8','390','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('541','8','391','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('542','8','392','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('543','8','393','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('544','8','394','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('545','8','395','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('546','8','396','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('547','8','397','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('548','8','398','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('549','8','370','6','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('550','8','371','6','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('551','8','372','6','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('552','8','374','6','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('553','8','377','6','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('554','8','346','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('555','8','347','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('556','8','348','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('557','8','349','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('558','8','350','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('559','8','351','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('560','8','352','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('561','8','353','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('562','8','354','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('563','8','355','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('564','8','358','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('565','8','359','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('566','8','362','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('567','8','363','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('568','8','364','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('569','8','365','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('570','8','366','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('571','9','299','1','40000','2');
INSERT INTO `tagihan_bebas` VALUES ('572','9','300','1','40000','1');
INSERT INTO `tagihan_bebas` VALUES ('573','9','302','1','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('574','9','303','1','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('575','9','304','1','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('576','9','305','1','40000','1');
INSERT INTO `tagihan_bebas` VALUES ('577','9','306','1','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('578','9','307','1','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('579','9','308','1','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('580','9','309','1','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('582','9','311','1','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('583','9','312','1','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('584','9','313','1','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('585','9','314','1','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('586','9','316','1','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('587','9','317','1','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('588','9','278','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('589','9','280','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('590','9','282','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('591','9','284','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('592','9','285','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('593','9','286','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('594','9','287','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('595','9','289','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('596','9','290','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('597','9','291','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('598','9','292','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('599','9','293','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('600','9','294','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('601','9','295','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('602','9','296','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('603','9','297','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('604','9','298','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('605','9','318','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('606','9','319','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('607','9','320','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('608','9','321','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('609','9','322','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('610','9','323','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('611','9','324','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('612','9','325','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('613','9','326','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('614','9','327','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('615','9','328','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('616','9','330','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('617','9','331','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('618','9','332','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('619','9','333','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('620','9','334','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('621','9','335','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('622','9','336','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('623','9','337','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('624','9','338','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('625','9','339','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('626','9','341','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('627','9','342','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('628','9','343','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('629','9','345','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('630','9','378','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('631','9','379','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('632','9','380','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('633','9','381','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('634','9','382','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('635','9','383','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('636','9','384','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('637','9','385','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('638','9','387','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('639','9','388','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('640','9','390','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('641','9','391','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('642','9','392','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('643','9','393','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('644','9','394','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('645','9','395','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('646','9','396','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('647','9','397','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('648','9','398','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('649','9','370','6','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('650','9','371','6','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('651','9','372','6','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('652','9','374','6','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('653','9','377','6','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('654','9','346','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('655','9','347','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('656','9','348','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('657','9','349','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('658','9','350','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('659','9','351','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('660','9','352','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('661','9','353','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('662','9','354','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('663','9','355','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('664','9','358','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('665','9','359','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('666','9','362','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('667','9','363','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('668','9','364','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('669','9','365','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('670','9','366','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('671','10','299','1','75000','2');
INSERT INTO `tagihan_bebas` VALUES ('672','10','300','1','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('673','10','302','1','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('674','10','303','1','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('675','10','304','1','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('676','10','305','1','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('677','10','306','1','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('678','10','307','1','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('679','10','308','1','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('680','10','309','1','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('682','10','311','1','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('683','10','312','1','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('684','10','313','1','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('685','10','314','1','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('686','10','316','1','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('687','10','317','1','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('688','10','278','3','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('689','10','280','3','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('690','10','282','3','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('691','10','284','3','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('692','10','285','3','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('693','10','286','3','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('694','10','287','3','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('695','10','289','3','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('696','10','290','3','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('697','10','291','3','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('698','10','292','3','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('699','10','293','3','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('700','10','294','3','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('701','10','295','3','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('702','10','296','3','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('703','10','297','3','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('704','10','298','3','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('705','10','318','4','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('706','10','319','4','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('707','10','320','4','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('708','10','321','4','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('709','10','322','4','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('710','10','323','4','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('711','10','324','4','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('712','10','325','4','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('713','10','326','4','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('714','10','327','4','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('715','10','328','4','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('716','10','330','4','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('717','10','331','4','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('718','10','332','4','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('719','10','333','4','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('720','10','334','4','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('721','10','335','4','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('722','10','336','4','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('723','10','337','4','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('724','10','338','4','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('725','10','339','4','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('726','10','341','4','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('727','10','342','4','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('728','10','343','4','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('729','10','345','4','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('730','10','378','5','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('731','10','379','5','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('732','10','380','5','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('733','10','381','5','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('734','10','382','5','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('735','10','383','5','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('736','10','384','5','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('737','10','385','5','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('738','10','387','5','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('739','10','388','5','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('740','10','390','5','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('741','10','391','5','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('742','10','392','5','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('743','10','393','5','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('744','10','394','5','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('745','10','395','5','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('746','10','396','5','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('747','10','397','5','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('748','10','398','5','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('749','10','370','6','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('750','10','371','6','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('751','10','372','6','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('752','10','374','6','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('753','10','377','6','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('754','10','346','7','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('755','10','347','7','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('756','10','348','7','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('757','10','349','7','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('758','10','350','7','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('759','10','351','7','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('760','10','352','7','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('761','10','353','7','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('762','10','354','7','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('763','10','355','7','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('764','10','358','7','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('765','10','359','7','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('766','10','362','7','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('767','10','363','7','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('768','10','364','7','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('769','10','365','7','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('770','10','366','7','75000','0');
INSERT INTO `tagihan_bebas` VALUES ('771','11','299','1','50000','2');
INSERT INTO `tagihan_bebas` VALUES ('772','11','300','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('773','11','302','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('774','11','303','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('775','11','304','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('776','11','305','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('777','11','306','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('778','11','307','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('779','11','308','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('780','11','309','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('782','11','311','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('783','11','312','1','50000','2');
INSERT INTO `tagihan_bebas` VALUES ('784','11','313','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('785','11','314','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('786','11','316','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('787','11','317','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('788','11','278','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('789','11','280','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('790','11','282','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('791','11','284','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('792','11','285','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('793','11','286','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('794','11','287','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('795','11','289','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('796','11','290','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('797','11','291','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('798','11','292','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('799','11','293','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('800','11','294','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('801','11','295','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('802','11','296','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('803','11','297','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('804','11','298','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('805','11','318','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('806','11','319','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('807','11','320','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('808','11','321','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('809','11','322','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('810','11','323','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('811','11','324','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('812','11','325','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('813','11','326','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('814','11','327','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('815','11','328','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('816','11','330','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('817','11','331','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('818','11','332','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('819','11','333','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('820','11','334','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('821','11','335','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('822','11','336','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('823','11','337','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('824','11','338','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('825','11','339','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('826','11','341','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('827','11','342','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('828','11','343','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('829','11','345','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('830','11','378','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('831','11','379','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('832','11','380','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('833','11','381','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('834','11','382','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('835','11','383','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('836','11','384','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('837','11','385','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('838','11','387','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('839','11','388','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('840','11','390','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('841','11','391','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('842','11','392','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('843','11','393','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('844','11','394','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('845','11','395','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('846','11','396','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('847','11','397','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('848','11','398','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('849','11','370','6','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('850','11','371','6','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('851','11','372','6','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('852','11','374','6','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('853','11','377','6','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('854','11','346','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('855','11','347','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('856','11','348','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('857','11','349','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('858','11','350','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('859','11','351','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('860','11','352','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('861','11','353','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('862','11','354','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('863','11','355','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('864','11','358','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('865','11','359','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('866','11','362','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('867','11','363','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('868','11','364','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('869','11','365','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('870','11','366','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('871','13','299','1','200000','2');
INSERT INTO `tagihan_bebas` VALUES ('872','13','300','1','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('873','13','302','1','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('874','13','303','1','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('875','13','304','1','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('876','13','305','1','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('877','13','306','1','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('878','13','307','1','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('879','13','308','1','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('880','13','309','1','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('882','13','311','1','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('883','13','312','1','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('884','13','313','1','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('885','13','314','1','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('886','13','316','1','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('887','13','317','1','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('888','13','278','3','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('889','13','280','3','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('890','13','282','3','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('891','13','284','3','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('892','13','285','3','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('893','13','286','3','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('894','13','287','3','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('895','13','289','3','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('896','13','290','3','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('897','13','291','3','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('898','13','292','3','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('899','13','293','3','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('900','13','294','3','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('901','13','295','3','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('902','13','296','3','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('903','13','297','3','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('904','13','298','3','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('905','13','318','4','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('906','13','319','4','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('907','13','320','4','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('908','13','321','4','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('909','13','322','4','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('910','13','323','4','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('911','13','324','4','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('912','13','325','4','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('913','13','326','4','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('914','13','327','4','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('915','13','328','4','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('916','13','330','4','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('917','13','331','4','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('918','13','332','4','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('919','13','333','4','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('920','13','334','4','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('921','13','335','4','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('922','13','336','4','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('923','13','337','4','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('924','13','338','4','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('925','13','339','4','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('926','13','341','4','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('927','13','342','4','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('928','13','343','4','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('929','13','345','4','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('930','13','378','5','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('931','13','379','5','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('932','13','380','5','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('933','13','381','5','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('934','13','382','5','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('935','13','383','5','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('936','13','384','5','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('937','13','385','5','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('938','13','387','5','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('939','13','388','5','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('940','13','390','5','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('941','13','391','5','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('942','13','392','5','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('943','13','393','5','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('944','13','394','5','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('945','13','395','5','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('946','13','396','5','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('947','13','397','5','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('948','13','398','5','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('949','13','370','6','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('950','13','371','6','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('951','13','372','6','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('952','13','374','6','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('953','13','377','6','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('954','13','346','7','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('955','13','347','7','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('956','13','348','7','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('957','13','349','7','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('958','13','350','7','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('959','13','351','7','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('960','13','352','7','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('961','13','353','7','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('962','13','354','7','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('963','13','355','7','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('964','13','358','7','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('965','13','359','7','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('966','13','362','7','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('967','13','363','7','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('968','13','364','7','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('969','13','365','7','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('970','13','366','7','200000','0');
INSERT INTO `tagihan_bebas` VALUES ('971','14','299','1','25000','2');
INSERT INTO `tagihan_bebas` VALUES ('972','14','300','1','25000','0');
INSERT INTO `tagihan_bebas` VALUES ('973','14','302','1','25000','0');
INSERT INTO `tagihan_bebas` VALUES ('974','14','303','1','25000','0');
INSERT INTO `tagihan_bebas` VALUES ('975','14','304','1','25000','0');
INSERT INTO `tagihan_bebas` VALUES ('976','14','305','1','25000','0');
INSERT INTO `tagihan_bebas` VALUES ('977','14','306','1','25000','0');
INSERT INTO `tagihan_bebas` VALUES ('978','14','307','1','25000','0');
INSERT INTO `tagihan_bebas` VALUES ('979','14','308','1','25000','0');
INSERT INTO `tagihan_bebas` VALUES ('980','14','309','1','25000','0');
INSERT INTO `tagihan_bebas` VALUES ('982','14','311','1','25000','0');
INSERT INTO `tagihan_bebas` VALUES ('983','14','312','1','25000','0');
INSERT INTO `tagihan_bebas` VALUES ('984','14','313','1','25000','0');
INSERT INTO `tagihan_bebas` VALUES ('985','14','314','1','25000','0');
INSERT INTO `tagihan_bebas` VALUES ('986','14','316','1','25000','0');
INSERT INTO `tagihan_bebas` VALUES ('987','14','317','1','25000','0');
INSERT INTO `tagihan_bebas` VALUES ('988','14','278','3','25000','0');
INSERT INTO `tagihan_bebas` VALUES ('989','14','280','3','25000','0');
INSERT INTO `tagihan_bebas` VALUES ('990','14','282','3','25000','0');
INSERT INTO `tagihan_bebas` VALUES ('991','14','284','3','25000','0');
INSERT INTO `tagihan_bebas` VALUES ('992','14','285','3','25000','0');
INSERT INTO `tagihan_bebas` VALUES ('993','14','286','3','25000','0');
INSERT INTO `tagihan_bebas` VALUES ('994','14','287','3','25000','0');
INSERT INTO `tagihan_bebas` VALUES ('995','14','289','3','25000','0');
INSERT INTO `tagihan_bebas` VALUES ('996','14','290','3','25000','0');
INSERT INTO `tagihan_bebas` VALUES ('997','14','291','3','25000','0');
INSERT INTO `tagihan_bebas` VALUES ('998','14','292','3','25000','0');
INSERT INTO `tagihan_bebas` VALUES ('999','14','293','3','25000','0');
INSERT INTO `tagihan_bebas` VALUES ('1000','14','294','3','25000','0');
INSERT INTO `tagihan_bebas` VALUES ('1001','14','295','3','25000','0');
INSERT INTO `tagihan_bebas` VALUES ('1002','14','296','3','25000','0');
INSERT INTO `tagihan_bebas` VALUES ('1003','14','297','3','25000','0');
INSERT INTO `tagihan_bebas` VALUES ('1004','14','298','3','25000','0');
INSERT INTO `tagihan_bebas` VALUES ('1005','14','318','4','25000','0');
INSERT INTO `tagihan_bebas` VALUES ('1006','14','319','4','25000','0');
INSERT INTO `tagihan_bebas` VALUES ('1007','14','320','4','25000','0');
INSERT INTO `tagihan_bebas` VALUES ('1008','14','321','4','25000','0');
INSERT INTO `tagihan_bebas` VALUES ('1009','14','322','4','25000','0');
INSERT INTO `tagihan_bebas` VALUES ('1010','14','323','4','25000','0');
INSERT INTO `tagihan_bebas` VALUES ('1011','14','324','4','25000','0');
INSERT INTO `tagihan_bebas` VALUES ('1012','14','325','4','25000','0');
INSERT INTO `tagihan_bebas` VALUES ('1013','14','326','4','25000','0');
INSERT INTO `tagihan_bebas` VALUES ('1014','14','327','4','25000','0');
INSERT INTO `tagihan_bebas` VALUES ('1015','14','328','4','25000','0');
INSERT INTO `tagihan_bebas` VALUES ('1016','14','330','4','25000','0');
INSERT INTO `tagihan_bebas` VALUES ('1017','14','331','4','25000','0');
INSERT INTO `tagihan_bebas` VALUES ('1018','14','332','4','25000','0');
INSERT INTO `tagihan_bebas` VALUES ('1019','14','333','4','25000','0');
INSERT INTO `tagihan_bebas` VALUES ('1020','14','334','4','25000','0');
INSERT INTO `tagihan_bebas` VALUES ('1021','14','335','4','25000','0');
INSERT INTO `tagihan_bebas` VALUES ('1022','14','336','4','25000','0');
INSERT INTO `tagihan_bebas` VALUES ('1023','14','337','4','25000','0');
INSERT INTO `tagihan_bebas` VALUES ('1024','14','338','4','25000','0');
INSERT INTO `tagihan_bebas` VALUES ('1025','14','339','4','25000','0');
INSERT INTO `tagihan_bebas` VALUES ('1026','14','341','4','25000','0');
INSERT INTO `tagihan_bebas` VALUES ('1027','14','342','4','25000','0');
INSERT INTO `tagihan_bebas` VALUES ('1028','14','343','4','25000','0');
INSERT INTO `tagihan_bebas` VALUES ('1029','14','345','4','25000','0');
INSERT INTO `tagihan_bebas` VALUES ('1071','15','299','1','40000','2');
INSERT INTO `tagihan_bebas` VALUES ('1072','15','300','1','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1073','15','302','1','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1074','15','303','1','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1075','15','304','1','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1076','15','305','1','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1077','15','306','1','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1078','15','307','1','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1079','15','308','1','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1080','15','309','1','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1082','15','311','1','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1083','15','312','1','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1084','15','313','1','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1085','15','314','1','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1086','15','316','1','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1087','15','317','1','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1088','15','278','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1089','15','280','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1090','15','282','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1091','15','284','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1092','15','285','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1093','15','286','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1094','15','287','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1095','15','289','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1096','15','290','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1097','15','291','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1098','15','292','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1099','15','293','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1100','15','294','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1101','15','295','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1102','15','296','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1103','15','297','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1104','15','298','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1105','15','318','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1106','15','319','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1107','15','320','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1108','15','321','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1109','15','322','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1110','15','323','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1111','15','324','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1112','15','325','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1113','15','326','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1114','15','327','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1115','15','328','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1116','15','330','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1117','15','331','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1118','15','332','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1119','15','333','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1120','15','334','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1121','15','335','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1122','15','336','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1123','15','337','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1124','15','338','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1125','15','339','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1126','15','341','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1127','15','342','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1128','15','343','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1129','15','345','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1130','15','378','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1131','15','379','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1132','15','380','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1133','15','381','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1134','15','382','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1135','15','383','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1136','15','384','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1137','15','385','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1138','15','387','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1139','15','388','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1140','15','390','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1141','15','391','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1142','15','392','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1143','15','393','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1144','15','394','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1145','15','395','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1146','15','396','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1147','15','397','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1148','15','398','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1149','15','370','6','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1150','15','371','6','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1151','15','372','6','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1152','15','374','6','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1153','15','377','6','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1154','15','346','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1155','15','347','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1156','15','348','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1157','15','349','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1158','15','350','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1159','15','351','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1160','15','352','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1161','15','353','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1162','15','354','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1163','15','355','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1164','15','358','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1165','15','359','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1166','15','362','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1167','15','363','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1168','15','364','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1169','15','365','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1170','15','366','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1171','21','299','1','80000','2');
INSERT INTO `tagihan_bebas` VALUES ('1172','21','300','1','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1173','21','302','1','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1174','21','303','1','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1175','21','304','1','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1176','21','305','1','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1177','21','306','1','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1178','21','307','1','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1179','21','308','1','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1180','21','309','1','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1182','21','311','1','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1183','21','312','1','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1184','21','313','1','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1185','21','314','1','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1186','21','316','1','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1187','21','317','1','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1188','21','278','3','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1189','21','280','3','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1190','21','282','3','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1191','21','284','3','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1192','21','285','3','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1193','21','286','3','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1194','21','287','3','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1195','21','289','3','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1196','21','290','3','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1197','21','291','3','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1198','21','292','3','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1199','21','293','3','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1200','21','294','3','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1201','21','295','3','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1202','21','296','3','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1203','21','297','3','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1204','21','298','3','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1205','21','318','4','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1206','21','319','4','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1207','21','320','4','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1208','21','321','4','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1209','21','322','4','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1210','21','323','4','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1211','21','324','4','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1212','21','325','4','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1213','21','326','4','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1214','21','327','4','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1215','21','328','4','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1216','21','330','4','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1217','21','331','4','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1218','21','332','4','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1219','21','333','4','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1220','21','334','4','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1221','21','335','4','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1222','21','336','4','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1223','21','337','4','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1224','21','338','4','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1225','21','339','4','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1226','21','341','4','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1227','21','342','4','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1228','21','343','4','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1229','21','345','4','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1230','21','378','5','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1231','21','379','5','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1232','21','380','5','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1233','21','381','5','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1234','21','382','5','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1235','21','383','5','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1236','21','384','5','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1237','21','385','5','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1238','21','387','5','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1239','21','388','5','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1240','21','390','5','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1241','21','391','5','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1242','21','392','5','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1243','21','393','5','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1244','21','394','5','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1245','21','395','5','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1246','21','396','5','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1247','21','397','5','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1248','21','398','5','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1249','21','370','6','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1250','21','371','6','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1251','21','372','6','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1252','21','374','6','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1253','21','377','6','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1254','21','346','7','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1255','21','347','7','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1256','21','348','7','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1257','21','349','7','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1258','21','350','7','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1259','21','351','7','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1260','21','352','7','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1261','21','353','7','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1262','21','354','7','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1263','21','355','7','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1264','21','358','7','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1265','21','359','7','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1266','21','362','7','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1267','21','363','7','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1268','21','364','7','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1269','21','365','7','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1270','21','366','7','80000','0');
INSERT INTO `tagihan_bebas` VALUES ('1271','16','299','1','40000','1');
INSERT INTO `tagihan_bebas` VALUES ('1272','16','300','1','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1273','16','302','1','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1274','16','303','1','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1275','16','304','1','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1276','16','305','1','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1277','16','306','1','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1278','16','307','1','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1279','16','308','1','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1280','16','309','1','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1282','16','311','1','40000','2');
INSERT INTO `tagihan_bebas` VALUES ('1283','16','312','1','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1284','16','313','1','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1285','16','314','1','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1286','16','316','1','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1287','16','317','1','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1288','16','278','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1289','16','280','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1290','16','282','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1291','16','284','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1292','16','285','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1293','16','286','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1294','16','287','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1295','16','289','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1296','16','290','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1297','16','291','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1298','16','292','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1299','16','293','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1300','16','294','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1301','16','295','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1302','16','296','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1303','16','297','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1304','16','298','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1305','16','318','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1306','16','319','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1307','16','320','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1308','16','321','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1309','16','322','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1310','16','323','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1311','16','324','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1312','16','325','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1313','16','326','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1314','16','327','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1315','16','328','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1316','16','330','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1317','16','331','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1318','16','332','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1319','16','333','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1320','16','334','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1321','16','335','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1322','16','336','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1323','16','337','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1324','16','338','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1325','16','339','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1326','16','341','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1327','16','342','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1328','16','343','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1329','16','345','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1330','16','378','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1331','16','379','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1332','16','380','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1333','16','381','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1334','16','382','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1335','16','383','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1336','16','384','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1337','16','385','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1338','16','387','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1339','16','388','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1340','16','390','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1341','16','391','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1342','16','392','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1343','16','393','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1344','16','394','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1345','16','395','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1346','16','396','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1347','16','397','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1348','16','398','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1349','16','370','6','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1350','16','371','6','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1351','16','372','6','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1352','16','374','6','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1353','16','377','6','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1354','16','346','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1355','16','347','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1356','16','348','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1357','16','349','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1358','16','350','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1359','16','351','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1360','16','352','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1361','16','353','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1362','16','354','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1363','16','355','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1364','16','358','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1365','16','359','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1366','16','362','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1367','16','363','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1368','16','364','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1369','16','365','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1370','16','366','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1371','17','299','1','40000','2');
INSERT INTO `tagihan_bebas` VALUES ('1372','17','300','1','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1373','17','302','1','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1374','17','303','1','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1375','17','304','1','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1376','17','305','1','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1377','17','306','1','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1378','17','307','1','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1379','17','308','1','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1380','17','309','1','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1382','17','311','1','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1383','17','312','1','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1384','17','313','1','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1385','17','314','1','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1386','17','316','1','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1387','17','317','1','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1388','17','278','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1389','17','280','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1390','17','282','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1391','17','284','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1392','17','285','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1393','17','286','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1394','17','287','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1395','17','289','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1396','17','290','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1397','17','291','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1398','17','292','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1399','17','293','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1400','17','294','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1401','17','295','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1402','17','296','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1403','17','297','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1404','17','298','3','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1405','17','318','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1406','17','319','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1407','17','320','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1408','17','321','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1409','17','322','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1410','17','323','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1411','17','324','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1412','17','325','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1413','17','326','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1414','17','327','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1415','17','328','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1416','17','330','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1417','17','331','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1418','17','332','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1419','17','333','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1420','17','334','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1421','17','335','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1422','17','336','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1423','17','337','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1424','17','338','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1425','17','339','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1426','17','341','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1427','17','342','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1428','17','343','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1429','17','345','4','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1430','17','378','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1431','17','379','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1432','17','380','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1433','17','381','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1434','17','382','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1435','17','383','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1436','17','384','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1437','17','385','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1438','17','387','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1439','17','388','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1440','17','390','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1441','17','391','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1442','17','392','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1443','17','393','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1444','17','394','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1445','17','395','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1446','17','396','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1447','17','397','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1448','17','398','5','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1449','17','370','6','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1450','17','371','6','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1451','17','372','6','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1452','17','374','6','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1453','17','377','6','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1454','17','346','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1455','17','347','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1456','17','348','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1457','17','349','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1458','17','350','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1459','17','351','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1460','17','352','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1461','17','353','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1462','17','354','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1463','17','355','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1464','17','358','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1465','17','359','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1466','17','362','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1467','17','363','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1468','17','364','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1469','17','365','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1470','17','366','7','40000','0');
INSERT INTO `tagihan_bebas` VALUES ('1471','18','299','1','85000','2');
INSERT INTO `tagihan_bebas` VALUES ('1472','18','300','1','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1473','18','302','1','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1474','18','303','1','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1475','18','304','1','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1476','18','305','1','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1477','18','306','1','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1478','18','307','1','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1479','18','308','1','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1480','18','309','1','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1482','18','311','1','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1483','18','312','1','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1484','18','313','1','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1485','18','314','1','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1486','18','316','1','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1487','18','317','1','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1488','18','278','3','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1489','18','280','3','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1490','18','282','3','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1491','18','284','3','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1492','18','285','3','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1493','18','286','3','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1494','18','287','3','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1495','18','289','3','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1496','18','290','3','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1497','18','291','3','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1498','18','292','3','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1499','18','293','3','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1500','18','294','3','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1501','18','295','3','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1502','18','296','3','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1503','18','297','3','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1504','18','298','3','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1505','18','318','4','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1506','18','319','4','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1507','18','320','4','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1508','18','321','4','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1509','18','322','4','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1510','18','323','4','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1511','18','324','4','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1512','18','325','4','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1513','18','326','4','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1514','18','327','4','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1515','18','328','4','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1516','18','330','4','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1517','18','331','4','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1518','18','332','4','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1519','18','333','4','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1520','18','334','4','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1521','18','335','4','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1522','18','336','4','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1523','18','337','4','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1524','18','338','4','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1525','18','339','4','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1526','18','341','4','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1527','18','342','4','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1528','18','343','4','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1529','18','345','4','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1530','18','378','5','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1531','18','379','5','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1532','18','380','5','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1533','18','381','5','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1534','18','382','5','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1535','18','383','5','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1536','18','384','5','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1537','18','385','5','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1538','18','387','5','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1539','18','388','5','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1540','18','390','5','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1541','18','391','5','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1542','18','392','5','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1543','18','393','5','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1544','18','394','5','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1545','18','395','5','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1546','18','396','5','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1547','18','397','5','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1548','18','398','5','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1549','18','370','6','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1550','18','371','6','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1551','18','372','6','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1552','18','374','6','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1553','18','377','6','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1554','18','346','7','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1555','18','347','7','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1556','18','348','7','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1557','18','349','7','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1558','18','350','7','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1559','18','351','7','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1560','18','352','7','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1561','18','353','7','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1562','18','354','7','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1563','18','355','7','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1564','18','358','7','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1565','18','359','7','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1566','18','362','7','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1567','18','363','7','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1568','18','364','7','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1569','18','365','7','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1570','18','366','7','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1571','19','299','1','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1572','19','300','1','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1573','19','302','1','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1574','19','303','1','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1575','19','304','1','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1576','19','305','1','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1577','19','306','1','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1578','19','307','1','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1579','19','308','1','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1580','19','309','1','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1582','19','311','1','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1583','19','312','1','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1584','19','313','1','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1585','19','314','1','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1586','19','316','1','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1587','19','317','1','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1588','19','278','3','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1589','19','280','3','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1590','19','282','3','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1591','19','284','3','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1592','19','285','3','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1593','19','286','3','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1594','19','287','3','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1595','19','289','3','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1596','19','290','3','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1597','19','291','3','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1598','19','292','3','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1599','19','293','3','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1600','19','294','3','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1601','19','295','3','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1602','19','296','3','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1603','19','297','3','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1604','19','298','3','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1605','19','318','4','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1606','19','319','4','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1607','19','320','4','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1608','19','321','4','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1609','19','322','4','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1610','19','323','4','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1611','19','324','4','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1612','19','325','4','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1613','19','326','4','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1614','19','327','4','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1615','19','328','4','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1616','19','330','4','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1617','19','331','4','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1618','19','332','4','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1619','19','333','4','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1620','19','334','4','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1621','19','335','4','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1622','19','336','4','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1623','19','337','4','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1624','19','338','4','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1625','19','339','4','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1626','19','341','4','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1627','19','342','4','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1628','19','343','4','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1629','19','345','4','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1630','19','378','5','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1631','19','379','5','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1632','19','380','5','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1633','19','381','5','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1634','19','382','5','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1635','19','383','5','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1636','19','384','5','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1637','19','385','5','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1638','19','387','5','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1639','19','388','5','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1640','19','390','5','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1641','19','391','5','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1642','19','392','5','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1643','19','393','5','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1644','19','394','5','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1645','19','395','5','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1646','19','396','5','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1647','19','397','5','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1648','19','398','5','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1649','19','370','6','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1650','19','371','6','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1651','19','372','6','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1652','19','374','6','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1653','19','377','6','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1654','19','346','7','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1655','19','347','7','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1656','19','348','7','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1657','19','349','7','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1658','19','350','7','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1659','19','351','7','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1660','19','352','7','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1661','19','353','7','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1662','19','354','7','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1663','19','355','7','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1664','19','358','7','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1665','19','359','7','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1666','19','362','7','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1667','19','363','7','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1668','19','364','7','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1669','19','365','7','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1670','19','366','7','85000','0');
INSERT INTO `tagihan_bebas` VALUES ('1671','20','299','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1672','20','300','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1673','20','302','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1674','20','303','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1675','20','304','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1676','20','305','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1677','20','306','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1678','20','307','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1679','20','308','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1680','20','309','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1682','20','311','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1683','20','312','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1684','20','313','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1685','20','314','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1686','20','316','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1687','20','317','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1688','20','278','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1689','20','280','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1690','20','282','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1691','20','284','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1692','20','285','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1693','20','286','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1694','20','287','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1695','20','289','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1696','20','290','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1697','20','291','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1698','20','292','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1699','20','293','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1700','20','294','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1701','20','295','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1702','20','296','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1703','20','297','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1704','20','298','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1705','20','318','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1706','20','319','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1707','20','320','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1708','20','321','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1709','20','322','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1710','20','323','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1711','20','324','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1712','20','325','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1713','20','326','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1714','20','327','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1715','20','328','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1716','20','330','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1717','20','331','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1718','20','332','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1719','20','333','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1720','20','334','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1721','20','335','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1722','20','336','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1723','20','337','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1724','20','338','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1725','20','339','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1726','20','341','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1727','20','342','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1728','20','343','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1729','20','345','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('1749','22','299','1','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1750','22','300','1','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1751','22','302','1','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1752','22','303','1','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1753','22','304','1','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1754','22','305','1','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1755','22','306','1','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1756','22','307','1','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1757','22','308','1','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1758','22','309','1','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1760','22','311','1','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1761','22','312','1','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1762','22','313','1','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1763','22','314','1','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1764','22','316','1','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1765','22','317','1','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1766','22','278','3','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1767','22','280','3','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1768','22','282','3','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1769','22','284','3','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1770','22','285','3','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1771','22','286','3','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1772','22','287','3','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1773','22','289','3','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1774','22','290','3','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1775','22','291','3','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1776','22','292','3','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1777','22','293','3','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1778','22','294','3','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1779','22','295','3','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1780','22','296','3','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1781','22','297','3','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1782','22','298','3','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1783','22','318','4','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1784','22','319','4','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1785','22','320','4','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1786','22','321','4','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1787','22','322','4','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1788','22','323','4','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1789','22','324','4','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1790','22','325','4','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1791','22','326','4','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1792','22','327','4','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1793','22','328','4','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1794','22','330','4','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1795','22','331','4','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1796','22','332','4','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1797','22','333','4','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1798','22','334','4','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1799','22','335','4','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1800','22','336','4','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1801','22','337','4','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1802','22','338','4','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1803','22','339','4','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1804','22','341','4','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1805','22','342','4','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1806','22','343','4','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1807','22','345','4','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('1808','23','299','1','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1809','23','300','1','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1810','23','302','1','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1811','23','303','1','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1812','23','304','1','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1813','23','305','1','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1814','23','306','1','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1815','23','307','1','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1816','23','308','1','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1817','23','309','1','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1819','23','311','1','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1820','23','312','1','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1821','23','313','1','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1822','23','314','1','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1823','23','316','1','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1824','23','317','1','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1825','23','278','3','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1826','23','280','3','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1827','23','282','3','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1828','23','284','3','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1829','23','285','3','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1830','23','286','3','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1831','23','287','3','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1832','23','289','3','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1833','23','290','3','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1834','23','291','3','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1835','23','292','3','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1836','23','293','3','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1837','23','294','3','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1838','23','295','3','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1839','23','296','3','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1840','23','297','3','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1841','23','298','3','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1842','23','318','4','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1843','23','319','4','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1844','23','320','4','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1845','23','321','4','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1846','23','322','4','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1847','23','323','4','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1848','23','324','4','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1849','23','325','4','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1850','23','326','4','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1851','23','327','4','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1852','23','328','4','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1853','23','330','4','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1854','23','331','4','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1855','23','332','4','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1856','23','333','4','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1857','23','334','4','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1858','23','335','4','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1859','23','336','4','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1860','23','337','4','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1861','23','338','4','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1862','23','339','4','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1863','23','341','4','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1864','23','342','4','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1865','23','343','4','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1866','23','345','4','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1867','23','378','5','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1868','23','379','5','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1869','23','380','5','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1870','23','381','5','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1871','23','382','5','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1872','23','383','5','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1873','23','384','5','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1874','23','385','5','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1875','23','387','5','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1876','23','388','5','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1877','23','390','5','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1878','23','391','5','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1879','23','392','5','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1880','23','393','5','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1881','23','394','5','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1882','23','395','5','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1883','23','396','5','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1884','23','397','5','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1885','23','398','5','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1886','23','370','6','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1887','23','371','6','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1888','23','372','6','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1889','23','374','6','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1890','23','377','6','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1891','23','346','7','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1892','23','347','7','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1893','23','348','7','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1894','23','349','7','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1895','23','350','7','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1896','23','351','7','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1897','23','352','7','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1898','23','353','7','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1899','23','354','7','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1900','23','355','7','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1901','23','358','7','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1902','23','359','7','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1903','23','362','7','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1904','23','363','7','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1905','23','364','7','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1906','23','365','7','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1907','23','366','7','125000','0');
INSERT INTO `tagihan_bebas` VALUES ('1908','24','299','1','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1909','24','300','1','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1910','24','302','1','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1911','24','303','1','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1912','24','304','1','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1913','24','305','1','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1914','24','306','1','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1915','24','307','1','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1916','24','308','1','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1917','24','309','1','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1919','24','311','1','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1920','24','312','1','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1921','24','313','1','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1922','24','314','1','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1923','24','316','1','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1924','24','317','1','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1925','24','278','3','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1926','24','280','3','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1927','24','282','3','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1928','24','284','3','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1929','24','285','3','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1930','24','286','3','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1931','24','287','3','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1932','24','289','3','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1933','24','290','3','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1934','24','291','3','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1935','24','292','3','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1936','24','293','3','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1937','24','294','3','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1938','24','295','3','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1939','24','296','3','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1940','24','297','3','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1941','24','298','3','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1942','24','318','4','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1943','24','319','4','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1944','24','320','4','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1945','24','321','4','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1946','24','322','4','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1947','24','323','4','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1948','24','324','4','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1949','24','325','4','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1950','24','326','4','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1951','24','327','4','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1952','24','328','4','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1953','24','330','4','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1954','24','331','4','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1955','24','332','4','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1956','24','333','4','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1957','24','334','4','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1958','24','335','4','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1959','24','336','4','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1960','24','337','4','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1961','24','338','4','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1962','24','339','4','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1963','24','341','4','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1964','24','342','4','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1965','24','343','4','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1966','24','345','4','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1967','24','378','5','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1968','24','379','5','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1969','24','380','5','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1970','24','381','5','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1971','24','382','5','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1972','24','383','5','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1973','24','384','5','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1974','24','385','5','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1975','24','387','5','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1976','24','388','5','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1977','24','390','5','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1978','24','391','5','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1979','24','392','5','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1980','24','393','5','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1981','24','394','5','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1982','24','395','5','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1983','24','396','5','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1984','24','397','5','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1985','24','398','5','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1986','24','370','6','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1987','24','371','6','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1988','24','372','6','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1989','24','374','6','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1990','24','377','6','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1991','24','346','7','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1992','24','347','7','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1993','24','348','7','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1994','24','349','7','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1995','24','350','7','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1996','24','351','7','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1997','24','352','7','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1998','24','353','7','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('1999','24','354','7','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('2000','24','355','7','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('2001','24','358','7','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('2002','24','359','7','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('2003','24','362','7','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('2004','24','363','7','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('2005','24','364','7','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('2006','24','365','7','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('2007','24','366','7','100000','0');
INSERT INTO `tagihan_bebas` VALUES ('2008','25','299','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2009','25','300','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2010','25','302','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2011','25','303','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2012','25','304','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2013','25','305','1','50000','2');
INSERT INTO `tagihan_bebas` VALUES ('2014','25','306','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2015','25','307','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2016','25','308','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2017','25','309','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2019','25','311','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2020','25','312','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2021','25','313','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2022','25','314','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2023','25','316','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2024','25','317','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2025','25','278','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2026','25','280','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2027','25','282','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2028','25','284','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2029','25','285','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2030','25','286','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2031','25','287','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2032','25','289','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2033','25','290','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2034','25','291','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2035','25','292','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2036','25','293','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2037','25','294','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2038','25','295','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2039','25','296','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2040','25','297','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2041','25','298','3','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2042','25','318','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2043','25','319','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2044','25','320','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2045','25','321','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2046','25','322','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2047','25','323','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2048','25','324','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2049','25','325','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2050','25','326','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2051','25','327','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2052','25','328','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2053','25','330','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2054','25','331','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2055','25','332','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2056','25','333','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2057','25','334','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2058','25','335','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2059','25','336','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2060','25','337','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2061','25','338','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2062','25','339','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2063','25','341','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2064','25','342','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2065','25','343','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2066','25','345','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2067','25','378','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2068','25','379','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2069','25','380','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2070','25','381','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2071','25','382','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2072','25','383','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2073','25','384','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2074','25','385','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2075','25','387','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2076','25','388','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2077','25','390','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2078','25','391','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2079','25','392','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2080','25','393','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2081','25','394','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2082','25','395','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2083','25','396','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2084','25','397','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2085','25','398','5','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2086','25','370','6','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2087','25','371','6','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2088','25','372','6','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2089','25','374','6','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2090','25','377','6','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2091','25','346','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2092','25','347','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2093','25','348','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2094','25','349','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2095','25','350','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2096','25','351','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2097','25','352','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2098','25','353','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2099','25','354','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2100','25','355','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2101','25','358','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2102','25','359','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2103','25','362','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2104','25','363','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2105','25','364','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2106','25','365','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2107','25','366','7','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2108','43','378','5','450000','0');
INSERT INTO `tagihan_bebas` VALUES ('2109','43','379','5','450000','0');
INSERT INTO `tagihan_bebas` VALUES ('2110','43','380','5','450000','0');
INSERT INTO `tagihan_bebas` VALUES ('2111','43','381','5','450000','0');
INSERT INTO `tagihan_bebas` VALUES ('2112','43','382','5','450000','0');
INSERT INTO `tagihan_bebas` VALUES ('2113','43','383','5','450000','0');
INSERT INTO `tagihan_bebas` VALUES ('2114','43','384','5','450000','0');
INSERT INTO `tagihan_bebas` VALUES ('2115','43','385','5','450000','0');
INSERT INTO `tagihan_bebas` VALUES ('2116','43','387','5','450000','0');
INSERT INTO `tagihan_bebas` VALUES ('2117','43','388','5','450000','0');
INSERT INTO `tagihan_bebas` VALUES ('2118','43','390','5','450000','0');
INSERT INTO `tagihan_bebas` VALUES ('2119','43','391','5','450000','0');
INSERT INTO `tagihan_bebas` VALUES ('2120','43','392','5','450000','0');
INSERT INTO `tagihan_bebas` VALUES ('2121','43','393','5','450000','0');
INSERT INTO `tagihan_bebas` VALUES ('2122','43','394','5','450000','0');
INSERT INTO `tagihan_bebas` VALUES ('2123','43','395','5','450000','0');
INSERT INTO `tagihan_bebas` VALUES ('2124','43','396','5','450000','0');
INSERT INTO `tagihan_bebas` VALUES ('2125','43','397','5','450000','0');
INSERT INTO `tagihan_bebas` VALUES ('2126','43','398','5','450000','0');
INSERT INTO `tagihan_bebas` VALUES ('2127','43','370','6','450000','0');
INSERT INTO `tagihan_bebas` VALUES ('2128','43','371','6','450000','0');
INSERT INTO `tagihan_bebas` VALUES ('2129','43','372','6','450000','0');
INSERT INTO `tagihan_bebas` VALUES ('2130','43','374','6','450000','0');
INSERT INTO `tagihan_bebas` VALUES ('2131','43','377','6','450000','0');
INSERT INTO `tagihan_bebas` VALUES ('2132','43','346','7','450000','0');
INSERT INTO `tagihan_bebas` VALUES ('2133','43','347','7','450000','0');
INSERT INTO `tagihan_bebas` VALUES ('2134','43','348','7','450000','0');
INSERT INTO `tagihan_bebas` VALUES ('2135','43','349','7','450000','0');
INSERT INTO `tagihan_bebas` VALUES ('2136','43','350','7','450000','0');
INSERT INTO `tagihan_bebas` VALUES ('2137','43','351','7','450000','0');
INSERT INTO `tagihan_bebas` VALUES ('2138','43','352','7','450000','0');
INSERT INTO `tagihan_bebas` VALUES ('2139','43','353','7','450000','0');
INSERT INTO `tagihan_bebas` VALUES ('2140','43','354','7','450000','0');
INSERT INTO `tagihan_bebas` VALUES ('2141','43','355','7','450000','0');
INSERT INTO `tagihan_bebas` VALUES ('2142','43','358','7','450000','0');
INSERT INTO `tagihan_bebas` VALUES ('2143','43','359','7','450000','0');
INSERT INTO `tagihan_bebas` VALUES ('2144','43','362','7','450000','0');
INSERT INTO `tagihan_bebas` VALUES ('2145','43','363','7','450000','0');
INSERT INTO `tagihan_bebas` VALUES ('2146','43','364','7','450000','0');
INSERT INTO `tagihan_bebas` VALUES ('2147','43','365','7','450000','0');
INSERT INTO `tagihan_bebas` VALUES ('2148','43','366','7','450000','0');
INSERT INTO `tagihan_bebas` VALUES ('2149','49','302','4','550000','0');
INSERT INTO `tagihan_bebas` VALUES ('2150','49','319','4','550000','0');
INSERT INTO `tagihan_bebas` VALUES ('2151','49','320','4','550000','0');
INSERT INTO `tagihan_bebas` VALUES ('2152','49','321','4','550000','0');
INSERT INTO `tagihan_bebas` VALUES ('2153','49','322','4','550000','0');
INSERT INTO `tagihan_bebas` VALUES ('2154','49','323','4','550000','2');
INSERT INTO `tagihan_bebas` VALUES ('2155','49','324','4','550000','0');
INSERT INTO `tagihan_bebas` VALUES ('2156','49','325','4','550000','0');
INSERT INTO `tagihan_bebas` VALUES ('2157','49','326','4','550000','0');
INSERT INTO `tagihan_bebas` VALUES ('2158','49','327','4','550000','0');
INSERT INTO `tagihan_bebas` VALUES ('2159','49','328','4','550000','0');
INSERT INTO `tagihan_bebas` VALUES ('2160','49','330','4','550000','0');
INSERT INTO `tagihan_bebas` VALUES ('2161','49','331','4','550000','0');
INSERT INTO `tagihan_bebas` VALUES ('2162','49','332','4','550000','0');
INSERT INTO `tagihan_bebas` VALUES ('2163','49','333','4','550000','0');
INSERT INTO `tagihan_bebas` VALUES ('2164','49','334','4','550000','0');
INSERT INTO `tagihan_bebas` VALUES ('2165','49','335','4','550000','0');
INSERT INTO `tagihan_bebas` VALUES ('2166','49','336','4','550000','0');
INSERT INTO `tagihan_bebas` VALUES ('2167','49','337','4','550000','0');
INSERT INTO `tagihan_bebas` VALUES ('2168','49','338','4','550000','0');
INSERT INTO `tagihan_bebas` VALUES ('2169','49','339','4','550000','0');
INSERT INTO `tagihan_bebas` VALUES ('2170','49','341','4','550000','2');
INSERT INTO `tagihan_bebas` VALUES ('2171','49','342','4','550000','0');
INSERT INTO `tagihan_bebas` VALUES ('2172','49','343','4','550000','0');
INSERT INTO `tagihan_bebas` VALUES ('2173','49','345','4','550000','0');
INSERT INTO `tagihan_bebas` VALUES ('2174','51','303','1','375000','0');
INSERT INTO `tagihan_bebas` VALUES ('2175','51','409','1','375000','2');
INSERT INTO `tagihan_bebas` VALUES ('2176','52','409','1','10000','1');
INSERT INTO `tagihan_bebas` VALUES ('2177','54','303','1','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('2178','54','409','1','150000','0');
INSERT INTO `tagihan_bebas` VALUES ('2179','6','302','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2180','6','303','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2181','6','410','4','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2182','56','411','1','50000','0');
INSERT INTO `tagihan_bebas` VALUES ('2183','61','303','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2184','61','319','7','10000','0');
INSERT INTO `tagihan_bebas` VALUES ('2185','61','320','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2186','61','321','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2187','61','322','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2188','61','323','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2189','61','324','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2190','61','325','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2191','61','326','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2192','61','327','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2193','61','328','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2194','61','330','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2195','61','331','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2196','61','332','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2197','61','333','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2198','61','334','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2199','61','335','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2200','61','336','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2201','61','337','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2202','61','338','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2203','61','339','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2204','61','341','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2205','61','342','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2206','61','343','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2207','61','345','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2208','61','346','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2209','61','347','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2210','61','348','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2211','61','349','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2212','61','350','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2213','61','351','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2214','61','352','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2215','61','353','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2216','61','354','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2217','61','355','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2218','61','358','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2219','61','359','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2220','61','362','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2221','61','363','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2222','61','364','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2223','61','365','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2224','61','366','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2225','61','378','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2226','61','379','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2227','61','380','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2228','61','381','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2229','61','382','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2230','61','383','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2231','61','384','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2232','61','385','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2233','61','387','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2234','61','388','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2235','61','390','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2236','61','391','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2237','61','392','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2238','61','393','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2239','61','394','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2240','61','395','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2241','61','396','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2242','61','397','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2243','61','398','7','20000','0');
INSERT INTO `tagihan_bebas` VALUES ('2244','61','410','7','20000','0');

/*---------------------------------------------------------------
  TABLE: `tagihan_bebas_bayar`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `tagihan_bebas_bayar`;
CREATE TABLE `tagihan_bebas_bayar` (
  `idTagihanBebasBayar` int(50) NOT NULL AUTO_INCREMENT,
  `idTagihanBebas` int(50) DEFAULT NULL,
  `tglBayar` date DEFAULT NULL,
  `jumlahBayar` int(10) DEFAULT NULL,
  `ketBayar` varchar(100) DEFAULT NULL,
  `caraBayar` enum('Tunai','Transfer') DEFAULT 'Tunai',
  PRIMARY KEY (`idTagihanBebasBayar`),
  KEY `fkbayarbebas` (`idTagihanBebas`),
  CONSTRAINT `fkbayarbebas` FOREIGN KEY (`idTagihanBebas`) REFERENCES `tagihan_bebas` (`idTagihanBebas`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=73 DEFAULT CHARSET=latin1;
INSERT INTO `tagihan_bebas_bayar` VALUES   ('4','280','2020-01-15','1750000','Lunas','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('6','274','2020-01-23','1750000','Angsuran 1','Transfer');
INSERT INTO `tagihan_bebas_bayar` VALUES ('7','273','2020-01-25','1750000','Lunas','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('8','373','2020-01-25','25000','Angsuran 1','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('9','271','2020-01-27','1750000','Lunas','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('11','371','2020-01-30','50000','Lunas','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('12','471','2020-01-30','50000','Lunas','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('13','288','2020-01-30','1750000','Lunas','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('14','388','2020-01-30','50000','Lunas','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('15','488','2020-01-30','50000','Lunas','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('16','300','2020-01-30','1750000','Lunas','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('17','332','2020-01-30','250000','Lunas','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('18','272','2020-01-30','1750000','Lunas','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('19','2175','2020-01-30','375000','Lunas','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('20','571','2020-02-02','40000','Lunas','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('21','2154','2020-02-03','550000','Lunas','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('22','671','2020-02-11','75000','Lunas','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('23','276','2020-02-12','1750000','Lunas','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('24','7','2020-02-13','250000','Lunas','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('25','283','2020-02-14','1750000','Lunas','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('27','383','2020-02-14','30000','Lunas','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('28','783','2020-02-16','50000','Lunas','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('29','2176','2020-02-18','5000','Angsuran 1','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('30','771','2020-02-29','50000','Lunas','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('31','1','2020-03-03','250000','Lunas','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('32','2170','2020-03-04','550000','Angsuran 5','Transfer');
INSERT INTO `tagihan_bebas_bayar` VALUES ('33','871','2020-03-04','200000','Lunas','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('34','284','2020-03-11','50000','Angsuran 1','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('35','971','2020-03-11','25000','Lunas','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('36','297','2020-03-12','800000','Lunas','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('37','297','2020-03-12','200000','Lunas','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('38','1071','2020-03-14','40000','Lunas','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('41','376','2020-03-15','50000','Lunas','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('42','476','2020-03-16','50000','Angsuran 1','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('44','2013','2020-03-24','50000','Lunas','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('45','372','2020-03-25','50000','Lunas','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('48','275','2020-03-25','500000','Lunas','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('49','4','2020-03-30','30000','Angsuran 1','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('50','4','2020-03-30','220000','Angsuran 1','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('51','382','2020-04-01','50000','Lunas','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('52','1282','2020-04-01','40000','Lunas','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('53','275','2020-04-09','1250000','Lunas','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('54','576','2020-04-09','20000','Angsuran 1','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('55','1271','2020-04-09','4000','Angsuran 1','Transfer');
INSERT INTO `tagihan_bebas_bayar` VALUES ('56','278','2020-04-13','1750000','Angsuran 1','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('57','284','2019-12-11','1700000','Lunas','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('58','375','2020-04-28','40000','Lunas','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('59','375','2020-04-28','10000','Lunas','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('60','1371','2020-05-02','40000','Lunas','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('61','1271','2020-05-02','3600','Lunas','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('62','1271','2020-05-02','3240','Lunas','Transfer');
INSERT INTO `tagihan_bebas_bayar` VALUES ('63','1271','2020-05-02','2916','Angsuran 4','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('64','353','2020-05-10','250000','Lunas','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('65','472','2020-05-12','50000','Lunas','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('66','572','2020-05-18','20000','Angsuran 1','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('67','1171','2020-06-06','80000','Lunas','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('68','1471','2020-06-07','85000','Lunas','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('69','279','2020-06-09','750000','Angsuran 1','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('70','378','2020-06-18','20000','Angsuran 1','Tunai');
INSERT INTO `tagihan_bebas_bayar` VALUES ('72','285','2020-06-18','500000','Angsuran 1','Tunai');

/*---------------------------------------------------------------
  TABLE: `tagihan_bulanan`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `tagihan_bulanan`;
CREATE TABLE `tagihan_bulanan` (
  `idTagihanBulanan` int(50) NOT NULL AUTO_INCREMENT,
  `idJenisBayar` int(5) DEFAULT NULL,
  `idSiswa` int(10) DEFAULT NULL,
  `idKelas` int(5) DEFAULT NULL,
  `idBulan` varchar(15) DEFAULT NULL,
  `jumlahBayar` int(10) DEFAULT NULL,
  `tglBayar` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `tglUpdate` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `statusBayar` enum('0','1') DEFAULT '0',
  `caraBayar` enum('Tunai','Transfer') DEFAULT 'Tunai',
  PRIMARY KEY (`idTagihanBulanan`),
  KEY `fk_t_jenis` (`idJenisBayar`),
  KEY `fk_t_siswa` (`idSiswa`),
  KEY `fk_t_kelas` (`idKelas`),
  KEY `fk_t_bulan` (`idBulan`),
  CONSTRAINT `fk_t_bulan` FOREIGN KEY (`idBulan`) REFERENCES `bulan` (`idBulan`) ON UPDATE CASCADE,
  CONSTRAINT `fk_t_jenis` FOREIGN KEY (`idJenisBayar`) REFERENCES `jenis_bayar` (`idJenisBayar`) ON UPDATE CASCADE,
  CONSTRAINT `fk_t_kelas` FOREIGN KEY (`idKelas`) REFERENCES `kelas_siswa` (`idKelas`) ON UPDATE CASCADE,
  CONSTRAINT `fk_t_siswa` FOREIGN KEY (`idSiswa`) REFERENCES `siswa` (`idSiswa`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1621 DEFAULT CHARSET=latin1;
INSERT INTO `tagihan_bulanan` VALUES   ('229','5','399','8','1','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('230','5','399','8','2','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('231','5','399','8','3','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('232','5','399','8','4','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('233','5','399','8','5','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('234','5','399','8','6','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('235','5','399','8','7','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('236','5','399','8','8','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('237','5','399','8','9','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('238','5','399','8','10','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('239','5','399','8','11','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('240','5','399','8','12','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('241','5','400','8','1','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('242','5','400','8','2','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('243','5','400','8','3','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('244','5','400','8','4','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('245','5','400','8','5','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('246','5','400','8','6','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('247','5','400','8','7','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('248','5','400','8','8','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('249','5','400','8','9','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('250','5','400','8','10','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('251','5','400','8','11','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('252','5','400','8','12','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('253','5','401','8','1','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('254','5','401','8','2','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('255','5','401','8','3','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('256','5','401','8','4','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('257','5','401','8','5','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('258','5','401','8','6','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('259','5','401','8','7','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('260','5','401','8','8','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('261','5','401','8','9','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('262','5','401','8','10','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('263','5','401','8','11','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('264','5','401','8','12','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('265','5','402','8','1','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('266','5','402','8','2','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('267','5','402','8','3','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('268','5','402','8','4','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('269','5','402','8','5','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('270','5','402','8','6','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('271','5','402','8','7','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('272','5','402','8','8','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('273','5','402','8','9','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('274','5','402','8','10','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('275','5','402','8','11','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('276','5','402','8','12','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('277','5','403','8','1','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('278','5','403','8','2','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('279','5','403','8','3','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('280','5','403','8','4','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('281','5','403','8','5','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('282','5','403','8','6','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('283','5','403','8','7','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('284','5','403','8','8','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('285','5','403','8','9','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('286','5','403','8','10','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('287','5','403','8','11','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('288','5','403','8','12','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('289','5','404','8','1','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('290','5','404','8','2','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('291','5','404','8','3','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('292','5','404','8','4','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('293','5','404','8','5','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('294','5','404','8','6','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('295','5','404','8','7','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('296','5','404','8','8','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('297','5','404','8','9','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('298','5','404','8','10','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('299','5','404','8','11','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('300','5','404','8','12','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('301','5','405','8','1','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('302','5','405','8','2','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('303','5','405','8','3','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('304','5','405','8','4','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('305','5','405','8','5','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('306','5','405','8','6','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('307','5','405','8','7','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('308','5','405','8','8','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('309','5','405','8','9','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('310','5','405','8','10','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('311','5','405','8','11','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('312','5','405','8','12','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('313','5','406','8','1','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('314','5','406','8','2','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('315','5','406','8','3','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('316','5','406','8','4','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('317','5','406','8','5','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('318','5','406','8','6','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('319','5','406','8','7','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('320','5','406','8','8','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('321','5','406','8','9','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('322','5','406','8','10','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('323','5','406','8','11','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('324','5','406','8','12','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('325','5','407','8','1','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('326','5','407','8','2','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('327','5','407','8','3','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('328','5','407','8','4','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('329','5','407','8','5','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('330','5','407','8','6','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('331','5','407','8','7','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('332','5','407','8','8','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('333','5','407','8','9','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('334','5','407','8','10','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('335','5','407','8','11','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('336','5','407','8','12','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('337','5','408','8','1','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('338','5','408','8','2','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('339','5','408','8','3','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('340','5','408','8','4','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('341','5','408','8','5','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('342','5','408','8','6','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('343','5','408','8','7','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('344','5','408','8','8','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('345','5','408','8','9','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('346','5','408','8','10','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('347','5','408','8','11','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('348','5','408','8','12','75000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('349','5','299','1','1','55000','2020-02-20 00:00:00','2020-02-20 12:12:12','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('350','5','299','1','2','55000','2020-02-20 00:00:00','2020-02-20 12:12:19','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('351','5','299','1','3','55000','2020-02-20 00:00:00','2020-02-20 12:13:03','1','Transfer');
INSERT INTO `tagihan_bulanan` VALUES ('352','5','299','1','4','55000','2020-02-20 00:00:00','2020-02-20 15:15:50','1','Transfer');
INSERT INTO `tagihan_bulanan` VALUES ('353','5','299','1','5','55000','2020-02-20 00:00:00','2020-02-20 15:15:53','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('354','5','299','1','6','55000','2020-02-20 00:00:00','2020-02-20 15:15:56','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('355','5','299','1','7','55000','2020-01-25 00:00:00','2020-01-25 22:02:41','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('356','5','299','1','8','55000','2020-01-30 00:00:00','2020-01-30 13:03:20','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('357','5','299','1','9','55000','2020-01-30 00:00:00','2020-01-30 13:03:23','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('358','5','299','1','10','55000','2020-02-18 00:00:00','2020-02-18 02:46:03','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('359','5','299','1','11','55000','2020-02-18 00:00:00','2020-02-18 02:46:06','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('360','5','299','1','12','55000','2020-02-20 00:00:00','2020-02-20 12:12:04','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('361','5','300','1','1','55000','2020-03-28 00:00:00','2020-03-28 23:09:21','1','Transfer');
INSERT INTO `tagihan_bulanan` VALUES ('362','5','300','1','2','55000','2020-05-11 00:00:00','2020-05-11 13:00:40','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('363','5','300','1','3','55000','2020-05-12 00:00:00','2020-05-12 22:11:08','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('364','5','300','1','4','55000','2020-05-12 00:00:00','2020-05-12 22:11:11','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('365','5','300','1','5','55000','0000-00-00 00:00:00','2020-05-18 23:50:16','0','');
INSERT INTO `tagihan_bulanan` VALUES ('366','5','300','1','6','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('367','5','300','1','7','55000','2020-01-15 00:00:00','2020-01-15 20:37:08','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('368','5','300','1','8','55000','2020-01-15 00:00:00','2020-01-15 20:37:21','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('369','5','300','1','9','55000','2020-01-30 00:00:00','2020-01-30 14:33:52','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('370','5','300','1','10','55000','2020-03-28 00:00:00','2020-03-28 23:09:02','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('371','5','300','1','11','55000','2020-03-28 00:00:00','2020-03-28 23:09:06','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('372','5','300','1','12','55000','2020-03-28 00:00:00','2020-03-28 23:09:12','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('373','5','302','1','1','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('374','5','302','1','2','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('375','5','302','1','3','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('376','5','302','1','4','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('377','5','302','1','5','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('378','5','302','1','6','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('379','5','302','1','7','55000','2020-01-25 00:00:00','2020-01-25 21:10:07','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('380','5','302','1','8','55000','2020-02-10 00:00:00','2020-02-10 13:51:03','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('381','5','302','1','9','55000','2020-02-10 00:00:00','2020-02-10 13:51:05','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('382','5','302','1','10','55000','2020-02-10 00:00:00','2020-02-10 13:51:08','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('383','5','302','1','11','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('384','5','302','1','12','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('385','5','303','1','1','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('386','5','303','1','2','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('387','5','303','1','3','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('388','5','303','1','4','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('389','5','303','1','5','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('390','5','303','1','6','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('391','5','303','1','7','55000','0000-00-00 00:00:00','2020-01-22 23:49:21','0','');
INSERT INTO `tagihan_bulanan` VALUES ('392','5','303','1','8','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('393','5','303','1','9','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('394','5','303','1','10','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('395','5','303','1','11','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('396','5','303','1','12','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('397','5','304','1','1','55000','2020-06-21 00:00:00','2020-06-21 09:40:10','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('398','5','304','1','2','55000','2020-05-03 00:00:00','2020-05-03 04:46:24','1','Transfer');
INSERT INTO `tagihan_bulanan` VALUES ('399','5','304','1','3','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('400','5','304','1','4','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('401','5','304','1','5','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('402','5','304','1','6','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('403','5','304','1','7','55000','2020-03-04 00:00:00','2020-03-04 11:11:08','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('404','5','304','1','8','55000','2020-03-25 00:00:00','2020-03-25 22:24:58','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('405','5','304','1','9','55000','2020-03-25 00:00:00','2020-03-25 22:25:02','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('406','5','304','1','10','55000','2020-03-25 00:00:00','2020-03-25 22:25:05','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('407','5','304','1','11','55000','2020-03-25 00:00:00','2020-03-25 22:25:08','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('408','5','304','1','12','55000','2020-05-03 00:00:00','2020-05-03 04:45:57','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('409','5','305','1','1','55000','2020-04-08 00:00:00','2020-04-08 19:27:33','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('410','5','305','1','2','55000','2020-04-08 00:00:00','2020-04-08 19:27:43','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('411','5','305','1','3','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('412','5','305','1','4','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('413','5','305','1','5','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('414','5','305','1','6','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('415','5','305','1','7','55000','2020-02-11 00:00:00','2020-02-11 13:38:51','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('416','5','305','1','8','55000','2020-03-11 00:00:00','2020-03-11 01:25:12','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('417','5','305','1','9','55000','2020-03-15 00:00:00','2020-03-15 22:51:25','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('418','5','305','1','10','55000','2020-03-15 00:00:00','2020-03-15 22:51:30','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('419','5','305','1','11','55000','2020-04-01 00:00:00','2020-04-01 14:54:07','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('420','5','305','1','12','55000','2020-03-24 00:00:00','2020-03-24 09:48:24','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('421','5','306','1','1','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('422','5','306','1','2','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('423','5','306','1','3','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('424','5','306','1','4','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('425','5','306','1','5','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('426','5','306','1','6','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('427','5','306','1','7','55000','2020-03-25 00:00:00','2020-03-25 12:56:51','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('428','5','306','1','8','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('429','5','306','1','9','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('430','5','306','1','10','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('431','5','306','1','11','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('432','5','306','1','12','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('433','5','307','1','1','55000','2020-04-13 00:00:00','2020-04-13 20:11:46','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('434','5','307','1','2','55000','2020-04-13 00:00:00','2020-04-13 20:12:35','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('435','5','307','1','3','55000','2020-04-13 00:00:00','2020-04-13 20:12:30','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('436','5','307','1','4','55000','2020-04-13 00:00:00','2020-04-13 20:12:24','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('437','5','307','1','5','55000','2020-04-13 00:00:00','2020-04-13 20:12:18','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('438','5','307','1','6','55000','2020-04-13 00:00:00','2020-04-13 20:12:12','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('439','5','307','1','7','55000','2020-02-12 00:00:00','2020-02-12 09:16:20','1','Transfer');
INSERT INTO `tagihan_bulanan` VALUES ('440','5','307','1','8','55000','2020-02-12 00:00:00','2020-02-12 09:16:50','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('441','5','307','1','9','55000','2020-02-12 00:00:00','2020-02-12 09:17:03','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('442','5','307','1','10','55000','2020-02-04 00:00:00','2020-02-29 21:29:23','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('443','5','307','1','11','55000','2020-02-29 00:00:00','2020-02-29 21:29:30','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('444','5','307','1','12','55000','2020-02-29 00:00:00','2020-02-29 21:29:35','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('445','5','308','1','1','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('446','5','308','1','2','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('447','5','308','1','3','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('448','5','308','1','4','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('449','5','308','1','5','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('450','5','308','1','6','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('451','5','308','1','7','55000','2020-01-21 00:00:00','2020-01-21 04:04:07','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('452','5','308','1','8','55000','2020-01-23 00:00:00','2020-01-23 21:21:42','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('453','5','308','1','9','55000','2020-03-11 00:00:00','2020-03-11 13:47:03','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('454','5','308','1','10','55000','2020-05-12 00:00:00','2020-05-12 22:38:21','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('455','5','308','1','11','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('456','5','308','1','12','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('457','5','309','1','1','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('458','5','309','1','2','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('459','5','309','1','3','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('460','5','309','1','4','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('461','5','309','1','5','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('462','5','309','1','6','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('463','5','309','1','7','55000','2020-01-30 00:00:00','2020-01-30 12:13:30','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('464','5','309','1','8','55000','2020-01-30 00:00:00','2020-01-30 12:13:32','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('465','5','309','1','9','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('466','5','309','1','10','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('467','5','309','1','11','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('468','5','309','1','12','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('481','5','311','1','1','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('482','5','311','1','2','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('483','5','311','1','3','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('484','5','311','1','4','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('485','5','311','1','5','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('486','5','311','1','6','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('487','5','311','1','7','55000','2020-05-11 00:00:00','2020-05-11 12:37:17','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('488','5','311','1','8','55000','2020-06-10 00:00:00','2020-06-10 12:33:50','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('489','5','311','1','9','55000','2020-06-10 00:00:00','2020-06-10 12:34:01','1','Transfer');
INSERT INTO `tagihan_bulanan` VALUES ('490','5','311','1','10','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('491','5','311','1','11','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('492','5','311','1','12','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('493','5','312','1','1','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('494','5','312','1','2','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('495','5','312','1','3','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('496','5','312','1','4','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('497','5','312','1','5','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('498','5','312','1','6','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('499','5','312','1','7','55000','2020-05-03 00:00:00','2020-05-03 13:34:35','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('500','5','312','1','8','55000','2020-05-03 00:00:00','2020-05-03 13:34:54','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('501','5','312','1','9','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('502','5','312','1','10','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('503','5','312','1','11','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('504','5','312','1','12','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('505','5','313','1','1','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('506','5','313','1','2','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('507','5','313','1','3','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('508','5','313','1','4','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('509','5','313','1','5','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('510','5','313','1','6','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('511','5','313','1','7','55000','0000-00-00 00:00:00','2020-04-13 21:47:30','0','');
INSERT INTO `tagihan_bulanan` VALUES ('512','5','313','1','8','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('513','5','313','1','9','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('514','5','313','1','10','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('515','5','313','1','11','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('516','5','313','1','12','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('517','5','314','1','1','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('518','5','314','1','2','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('519','5','314','1','3','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('520','5','314','1','4','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('521','5','314','1','5','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('522','5','314','1','6','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('523','5','314','1','7','55000','2020-03-04 00:00:00','2020-03-04 13:51:50','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('524','5','314','1','8','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('525','5','314','1','9','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('526','5','314','1','10','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('527','5','314','1','11','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('528','5','314','1','12','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('529','5','316','1','1','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('530','5','316','1','2','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('531','5','316','1','3','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('532','5','316','1','4','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('533','5','316','1','5','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('534','5','316','1','6','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('535','5','316','1','7','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('536','5','316','1','8','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('537','5','316','1','9','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('538','5','316','1','10','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('539','5','316','1','11','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('540','5','316','1','12','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('541','5','317','1','1','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('542','5','317','1','2','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('543','5','317','1','3','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('544','5','317','1','4','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('545','5','317','1','5','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('546','5','317','1','6','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('547','5','317','1','7','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('548','5','317','1','8','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('549','5','317','1','9','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('550','5','317','1','10','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('551','5','317','1','11','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('552','5','317','1','12','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('553','5','278','3','1','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('554','5','278','3','2','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('555','5','278','3','3','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('556','5','278','3','4','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('557','5','278','3','5','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('558','5','278','3','6','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('559','5','278','3','7','55000','2020-01-30 00:00:00','2020-01-30 13:05:33','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('560','5','278','3','8','55000','2020-01-30 00:00:00','2020-01-30 13:05:36','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('561','5','278','3','9','55000','2020-01-30 00:00:00','2020-01-30 13:05:38','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('562','5','278','3','10','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('563','5','278','3','11','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('564','5','278','3','12','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('565','5','280','3','1','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('566','5','280','3','2','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('567','5','280','3','3','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('568','5','280','3','4','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('569','5','280','3','5','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('570','5','280','3','6','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('571','5','280','3','7','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('572','5','280','3','8','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('573','5','280','3','9','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('574','5','280','3','10','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('575','5','280','3','11','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('576','5','280','3','12','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('577','5','282','3','1','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('578','5','282','3','2','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('579','5','282','3','3','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('580','5','282','3','4','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('581','5','282','3','5','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('582','5','282','3','6','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('583','5','282','3','7','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('584','5','282','3','8','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('585','5','282','3','9','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('586','5','282','3','10','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('587','5','282','3','11','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('588','5','282','3','12','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('589','5','284','3','1','55000','2020-02-10 00:00:00','2020-02-10 13:50:05','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('590','5','284','3','2','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('591','5','284','3','3','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('592','5','284','3','4','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('593','5','284','3','5','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('594','5','284','3','6','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('595','5','284','3','7','55000','2020-02-10 00:00:00','2020-02-10 13:49:42','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('596','5','284','3','8','55000','2020-02-10 00:00:00','2020-02-10 13:49:48','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('597','5','284','3','9','55000','2020-02-10 00:00:00','2020-02-10 13:49:51','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('598','5','284','3','10','55000','2020-02-10 00:00:00','2020-02-10 13:49:56','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('599','5','284','3','11','55000','2020-02-10 00:00:00','2020-02-10 13:49:59','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('600','5','284','3','12','55000','2020-02-10 00:00:00','2020-02-10 13:50:02','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('601','5','285','3','1','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('602','5','285','3','2','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('603','5','285','3','3','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('604','5','285','3','4','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('605','5','285','3','5','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('606','5','285','3','6','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('607','5','285','3','7','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('608','5','285','3','8','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('609','5','285','3','9','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('610','5','285','3','10','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('611','5','285','3','11','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('612','5','285','3','12','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('613','5','286','3','1','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('614','5','286','3','2','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('615','5','286','3','3','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('616','5','286','3','4','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('617','5','286','3','5','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('618','5','286','3','6','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('619','5','286','3','7','55000','2020-03-13 00:00:00','2020-03-13 16:57:35','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('620','5','286','3','8','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('621','5','286','3','9','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('622','5','286','3','10','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('623','5','286','3','11','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('624','5','286','3','12','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('625','5','287','3','1','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('626','5','287','3','2','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('627','5','287','3','3','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('628','5','287','3','4','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('629','5','287','3','5','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('630','5','287','3','6','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('631','5','287','3','7','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('632','5','287','3','8','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('633','5','287','3','9','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('634','5','287','3','10','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('635','5','287','3','11','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('636','5','287','3','12','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('637','5','289','3','1','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('638','5','289','3','2','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('639','5','289','3','3','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('640','5','289','3','4','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('641','5','289','3','5','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('642','5','289','3','6','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('643','5','289','3','7','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('644','5','289','3','8','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('645','5','289','3','9','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('646','5','289','3','10','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('647','5','289','3','11','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('648','5','289','3','12','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('649','5','290','3','1','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('650','5','290','3','2','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('651','5','290','3','3','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('652','5','290','3','4','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('653','5','290','3','5','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('654','5','290','3','6','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('655','5','290','3','7','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('656','5','290','3','8','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('657','5','290','3','9','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('658','5','290','3','10','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('659','5','290','3','11','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('660','5','290','3','12','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('661','5','291','3','1','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('662','5','291','3','2','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('663','5','291','3','3','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('664','5','291','3','4','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('665','5','291','3','5','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('666','5','291','3','6','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('667','5','291','3','7','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('668','5','291','3','8','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('669','5','291','3','9','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('670','5','291','3','10','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('671','5','291','3','11','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('672','5','291','3','12','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('673','5','292','3','1','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('674','5','292','3','2','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('675','5','292','3','3','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('676','5','292','3','4','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('677','5','292','3','5','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('678','5','292','3','6','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('679','5','292','3','7','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('680','5','292','3','8','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('681','5','292','3','9','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('682','5','292','3','10','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('683','5','292','3','11','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('684','5','292','3','12','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('685','5','293','3','1','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('686','5','293','3','2','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('687','5','293','3','3','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('688','5','293','3','4','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('689','5','293','3','5','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('690','5','293','3','6','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('691','5','293','3','7','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('692','5','293','3','8','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('693','5','293','3','9','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('694','5','293','3','10','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('695','5','293','3','11','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('696','5','293','3','12','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('697','5','294','3','1','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('698','5','294','3','2','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('699','5','294','3','3','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('700','5','294','3','4','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('701','5','294','3','5','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('702','5','294','3','6','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('703','5','294','3','7','55000','2020-01-30 00:00:00','2020-01-30 13:06:07','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('704','5','294','3','8','55000','2020-01-30 00:00:00','2020-01-30 13:06:10','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('705','5','294','3','9','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('706','5','294','3','10','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('707','5','294','3','11','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('708','5','294','3','12','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('709','5','295','3','1','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('710','5','295','3','2','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('711','5','295','3','3','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('712','5','295','3','4','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('713','5','295','3','5','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('714','5','295','3','6','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('715','5','295','3','7','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('716','5','295','3','8','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('717','5','295','3','9','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('718','5','295','3','10','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('719','5','295','3','11','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('720','5','295','3','12','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('721','5','296','3','1','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('722','5','296','3','2','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('723','5','296','3','3','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('724','5','296','3','4','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('725','5','296','3','5','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('726','5','296','3','6','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('727','5','296','3','7','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('728','5','296','3','8','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('729','5','296','3','9','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('730','5','296','3','10','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('731','5','296','3','11','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('732','5','296','3','12','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('733','5','297','3','1','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('734','5','297','3','2','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('735','5','297','3','3','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('736','5','297','3','4','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('737','5','297','3','5','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('738','5','297','3','6','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('739','5','297','3','7','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('740','5','297','3','8','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('741','5','297','3','9','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('742','5','297','3','10','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('743','5','297','3','11','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('744','5','297','3','12','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('745','5','298','3','1','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('746','5','298','3','2','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('747','5','298','3','3','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('748','5','298','3','4','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('749','5','298','3','5','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('750','5','298','3','6','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('751','5','298','3','7','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('752','5','298','3','8','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('753','5','298','3','9','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('754','5','298','3','10','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('755','5','298','3','11','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('756','5','298','3','12','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('757','5','318','4','1','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('758','5','318','4','2','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('759','5','318','4','3','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('760','5','318','4','4','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('761','5','318','4','5','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('762','5','318','4','6','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('763','5','318','4','7','55000','2020-06-07 00:00:00','2020-06-07 15:47:34','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('764','5','318','4','8','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('765','5','318','4','9','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('766','5','318','4','10','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('767','5','318','4','11','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('768','5','318','4','12','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('769','5','319','4','1','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('770','5','319','4','2','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('771','5','319','4','3','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('772','5','319','4','4','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('773','5','319','4','5','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('774','5','319','4','6','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('775','5','319','4','7','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('776','5','319','4','8','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('777','5','319','4','9','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('778','5','319','4','10','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('779','5','319','4','11','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('780','5','319','4','12','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('781','5','320','4','1','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('782','5','320','4','2','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('783','5','320','4','3','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('784','5','320','4','4','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('785','5','320','4','5','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('786','5','320','4','6','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('787','5','320','4','7','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('788','5','320','4','8','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('789','5','320','4','9','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('790','5','320','4','10','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('791','5','320','4','11','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('792','5','320','4','12','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('793','5','321','4','1','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('794','5','321','4','2','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('795','5','321','4','3','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('796','5','321','4','4','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('797','5','321','4','5','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('798','5','321','4','6','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('799','5','321','4','7','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('800','5','321','4','8','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('801','5','321','4','9','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('802','5','321','4','10','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('803','5','321','4','11','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('804','5','321','4','12','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('805','5','322','4','1','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('806','5','322','4','2','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('807','5','322','4','3','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('808','5','322','4','4','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('809','5','322','4','5','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('810','5','322','4','6','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('811','5','322','4','7','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('812','5','322','4','8','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('813','5','322','4','9','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('814','5','322','4','10','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('815','5','322','4','11','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('816','5','322','4','12','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('817','5','323','4','1','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('818','5','323','4','2','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('819','5','323','4','3','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('820','5','323','4','4','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('821','5','323','4','5','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('822','5','323','4','6','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('823','5','323','4','7','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('824','5','323','4','8','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('825','5','323','4','9','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('826','5','323','4','10','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('827','5','323','4','11','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('828','5','323','4','12','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('829','5','324','4','1','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('830','5','324','4','2','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('831','5','324','4','3','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('832','5','324','4','4','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('833','5','324','4','5','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('834','5','324','4','6','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('835','5','324','4','7','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('836','5','324','4','8','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('837','5','324','4','9','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('838','5','324','4','10','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('839','5','324','4','11','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('840','5','324','4','12','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('841','5','325','4','1','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('842','5','325','4','2','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('843','5','325','4','3','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('844','5','325','4','4','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('845','5','325','4','5','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('846','5','325','4','6','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('847','5','325','4','7','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('848','5','325','4','8','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('849','5','325','4','9','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('850','5','325','4','10','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('851','5','325','4','11','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('852','5','325','4','12','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('853','5','326','4','1','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('854','5','326','4','2','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('855','5','326','4','3','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('856','5','326','4','4','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('857','5','326','4','5','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('858','5','326','4','6','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('859','5','326','4','7','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('860','5','326','4','8','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('861','5','326','4','9','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('862','5','326','4','10','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('863','5','326','4','11','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('864','5','326','4','12','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('865','5','327','4','1','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('866','5','327','4','2','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('867','5','327','4','3','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('868','5','327','4','4','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('869','5','327','4','5','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('870','5','327','4','6','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('871','5','327','4','7','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('872','5','327','4','8','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('873','5','327','4','9','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('874','5','327','4','10','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('875','5','327','4','11','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('876','5','327','4','12','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('877','5','328','4','1','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('878','5','328','4','2','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('879','5','328','4','3','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('880','5','328','4','4','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('881','5','328','4','5','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('882','5','328','4','6','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('883','5','328','4','7','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('884','5','328','4','8','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('885','5','328','4','9','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('886','5','328','4','10','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('887','5','328','4','11','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('888','5','328','4','12','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('889','5','330','4','1','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('890','5','330','4','2','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('891','5','330','4','3','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('892','5','330','4','4','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('893','5','330','4','5','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('894','5','330','4','6','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('895','5','330','4','7','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('896','5','330','4','8','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('897','5','330','4','9','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('898','5','330','4','10','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('899','5','330','4','11','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('900','5','330','4','12','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('901','5','331','4','1','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('902','5','331','4','2','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('903','5','331','4','3','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('904','5','331','4','4','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('905','5','331','4','5','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('906','5','331','4','6','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('907','5','331','4','7','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('908','5','331','4','8','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('909','5','331','4','9','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('910','5','331','4','10','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('911','5','331','4','11','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('912','5','331','4','12','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('913','5','332','4','1','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('914','5','332','4','2','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('915','5','332','4','3','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('916','5','332','4','4','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('917','5','332','4','5','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('918','5','332','4','6','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('919','5','332','4','7','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('920','5','332','4','8','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('921','5','332','4','9','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('922','5','332','4','10','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('923','5','332','4','11','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('924','5','332','4','12','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('925','5','333','4','1','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('926','5','333','4','2','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('927','5','333','4','3','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('928','5','333','4','4','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('929','5','333','4','5','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('930','5','333','4','6','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('931','5','333','4','7','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('932','5','333','4','8','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('933','5','333','4','9','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('934','5','333','4','10','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('935','5','333','4','11','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('936','5','333','4','12','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('937','5','334','4','1','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('938','5','334','4','2','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('939','5','334','4','3','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('940','5','334','4','4','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('941','5','334','4','5','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('942','5','334','4','6','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('943','5','334','4','7','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('944','5','334','4','8','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('945','5','334','4','9','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('946','5','334','4','10','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('947','5','334','4','11','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('948','5','334','4','12','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('949','5','335','4','1','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('950','5','335','4','2','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('951','5','335','4','3','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('952','5','335','4','4','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('953','5','335','4','5','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('954','5','335','4','6','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('955','5','335','4','7','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('956','5','335','4','8','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('957','5','335','4','9','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('958','5','335','4','10','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('959','5','335','4','11','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('960','5','335','4','12','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('961','5','336','4','1','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('962','5','336','4','2','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('963','5','336','4','3','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('964','5','336','4','4','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('965','5','336','4','5','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('966','5','336','4','6','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('967','5','336','4','7','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('968','5','336','4','8','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('969','5','336','4','9','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('970','5','336','4','10','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('971','5','336','4','11','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('972','5','336','4','12','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('973','5','337','4','1','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('974','5','337','4','2','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('975','5','337','4','3','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('976','5','337','4','4','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('977','5','337','4','5','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('978','5','337','4','6','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('979','5','337','4','7','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('980','5','337','4','8','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('981','5','337','4','9','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('982','5','337','4','10','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('983','5','337','4','11','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('984','5','337','4','12','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('985','5','338','4','1','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('986','5','338','4','2','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('987','5','338','4','3','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('988','5','338','4','4','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('989','5','338','4','5','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('990','5','338','4','6','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('991','5','338','4','7','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('992','5','338','4','8','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('993','5','338','4','9','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('994','5','338','4','10','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('995','5','338','4','11','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('996','5','338','4','12','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('997','5','339','4','1','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('998','5','339','4','2','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('999','5','339','4','3','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1000','5','339','4','4','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1001','5','339','4','5','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1002','5','339','4','6','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1003','5','339','4','7','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1004','5','339','4','8','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1005','5','339','4','9','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1006','5','339','4','10','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1007','5','339','4','11','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1008','5','339','4','12','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1009','5','341','4','1','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1010','5','341','4','2','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1011','5','341','4','3','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1012','5','341','4','4','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1013','5','341','4','5','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1014','5','341','4','6','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1015','5','341','4','7','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1016','5','341','4','8','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1017','5','341','4','9','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1018','5','341','4','10','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1019','5','341','4','11','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1020','5','341','4','12','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1021','5','342','4','1','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1022','5','342','4','2','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1023','5','342','4','3','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1024','5','342','4','4','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1025','5','342','4','5','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1026','5','342','4','6','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1027','5','342','4','7','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1028','5','342','4','8','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1029','5','342','4','9','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1030','5','342','4','10','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1031','5','342','4','11','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1032','5','342','4','12','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1033','5','343','4','1','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1034','5','343','4','2','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1035','5','343','4','3','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1036','5','343','4','4','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1037','5','343','4','5','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1038','5','343','4','6','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1039','5','343','4','7','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1040','5','343','4','8','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1041','5','343','4','9','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1042','5','343','4','10','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1043','5','343','4','11','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1044','5','343','4','12','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1045','5','345','4','1','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1046','5','345','4','2','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1047','5','345','4','3','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1048','5','345','4','4','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1049','5','345','4','5','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1050','5','345','4','6','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1051','5','345','4','7','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1052','5','345','4','8','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1053','5','345','4','9','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1054','5','345','4','10','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1055','5','345','4','11','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1056','5','345','4','12','55000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1057','5','378','5','1','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1058','5','378','5','2','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1059','5','378','5','3','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1060','5','378','5','4','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1061','5','378','5','5','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1062','5','378','5','6','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1063','5','378','5','7','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1064','5','378','5','8','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1065','5','378','5','9','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1066','5','378','5','10','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1067','5','378','5','11','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1068','5','378','5','12','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1069','5','379','5','1','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1070','5','379','5','2','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1071','5','379','5','3','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1072','5','379','5','4','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1073','5','379','5','5','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1074','5','379','5','6','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1075','5','379','5','7','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1076','5','379','5','8','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1077','5','379','5','9','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1078','5','379','5','10','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1079','5','379','5','11','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1080','5','379','5','12','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1081','5','380','5','1','65000','2020-01-30 00:00:00','2020-01-30 13:15:37','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1082','5','380','5','2','65000','2020-01-30 00:00:00','2020-01-30 13:15:40','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1083','5','380','5','3','65000','2020-01-30 00:00:00','2020-01-30 13:15:42','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1084','5','380','5','4','65000','2020-01-30 00:00:00','2020-01-30 13:15:44','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1085','5','380','5','5','65000','2020-01-30 00:00:00','2020-01-30 13:15:46','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1086','5','380','5','6','65000','2020-01-30 00:00:00','2020-01-30 13:15:49','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1087','5','380','5','7','65000','2020-01-30 00:00:00','2020-01-30 13:12:36','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1088','5','380','5','8','65000','2020-01-30 00:00:00','2020-01-30 13:12:38','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1089','5','380','5','9','65000','2020-01-30 00:00:00','2020-01-30 13:12:44','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1090','5','380','5','10','65000','2020-01-30 00:00:00','2020-01-30 13:12:48','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1091','5','380','5','11','65000','2020-01-30 00:00:00','2020-01-30 13:15:32','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1092','5','380','5','12','65000','2020-01-30 00:00:00','2020-01-30 13:15:35','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1093','5','381','5','1','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1094','5','381','5','2','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1095','5','381','5','3','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1096','5','381','5','4','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1097','5','381','5','5','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1098','5','381','5','6','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1099','5','381','5','7','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1100','5','381','5','8','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1101','5','381','5','9','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1102','5','381','5','10','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1103','5','381','5','11','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1104','5','381','5','12','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1105','5','382','5','1','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1106','5','382','5','2','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1107','5','382','5','3','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1108','5','382','5','4','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1109','5','382','5','5','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1110','5','382','5','6','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1111','5','382','5','7','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1112','5','382','5','8','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1113','5','382','5','9','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1114','5','382','5','10','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1115','5','382','5','11','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1116','5','382','5','12','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1117','5','383','5','1','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1118','5','383','5','2','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1119','5','383','5','3','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1120','5','383','5','4','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1121','5','383','5','5','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1122','5','383','5','6','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1123','5','383','5','7','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1124','5','383','5','8','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1125','5','383','5','9','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1126','5','383','5','10','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1127','5','383','5','11','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1128','5','383','5','12','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1129','5','384','5','1','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1130','5','384','5','2','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1131','5','384','5','3','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1132','5','384','5','4','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1133','5','384','5','5','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1134','5','384','5','6','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1135','5','384','5','7','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1136','5','384','5','8','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1137','5','384','5','9','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1138','5','384','5','10','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1139','5','384','5','11','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1140','5','384','5','12','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1141','5','385','5','1','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1142','5','385','5','2','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1143','5','385','5','3','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1144','5','385','5','4','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1145','5','385','5','5','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1146','5','385','5','6','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1147','5','385','5','7','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1148','5','385','5','8','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1149','5','385','5','9','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1150','5','385','5','10','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1151','5','385','5','11','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1152','5','385','5','12','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1153','5','387','5','1','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1154','5','387','5','2','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1155','5','387','5','3','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1156','5','387','5','4','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1157','5','387','5','5','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1158','5','387','5','6','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1159','5','387','5','7','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1160','5','387','5','8','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1161','5','387','5','9','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1162','5','387','5','10','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1163','5','387','5','11','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1164','5','387','5','12','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1165','5','388','5','1','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1166','5','388','5','2','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1167','5','388','5','3','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1168','5','388','5','4','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1169','5','388','5','5','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1170','5','388','5','6','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1171','5','388','5','7','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1172','5','388','5','8','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1173','5','388','5','9','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1174','5','388','5','10','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1175','5','388','5','11','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1176','5','388','5','12','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1177','5','390','5','1','65000','2020-01-30 00:00:00','2020-01-30 13:17:46','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1178','5','390','5','2','65000','2020-01-30 00:00:00','2020-01-30 13:17:50','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1179','5','390','5','3','65000','2020-01-30 00:00:00','2020-01-30 13:17:54','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1180','5','390','5','4','65000','2020-01-30 00:00:00','2020-01-30 13:17:56','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1181','5','390','5','5','65000','2020-01-30 00:00:00','2020-01-30 13:18:00','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1182','5','390','5','6','65000','2020-01-30 00:00:00','2020-01-30 13:18:03','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1183','5','390','5','7','65000','2020-01-30 00:00:00','2020-01-30 13:17:30','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1184','5','390','5','8','65000','2020-01-30 00:00:00','2020-01-30 13:17:31','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1185','5','390','5','9','65000','2020-01-30 00:00:00','2020-01-30 13:17:33','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1186','5','390','5','10','65000','2020-01-30 00:00:00','2020-01-30 13:17:38','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1187','5','390','5','11','65000','2020-01-30 00:00:00','2020-01-30 13:17:41','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1188','5','390','5','12','65000','2020-01-30 00:00:00','2020-01-30 13:17:44','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1189','5','391','5','1','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1190','5','391','5','2','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1191','5','391','5','3','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1192','5','391','5','4','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1193','5','391','5','5','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1194','5','391','5','6','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1195','5','391','5','7','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1196','5','391','5','8','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1197','5','391','5','9','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1198','5','391','5','10','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1199','5','391','5','11','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1200','5','391','5','12','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1201','5','392','5','1','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1202','5','392','5','2','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1203','5','392','5','3','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1204','5','392','5','4','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1205','5','392','5','5','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1206','5','392','5','6','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1207','5','392','5','7','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1208','5','392','5','8','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1209','5','392','5','9','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1210','5','392','5','10','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1211','5','392','5','11','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1212','5','392','5','12','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1213','5','393','5','1','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1214','5','393','5','2','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1215','5','393','5','3','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1216','5','393','5','4','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1217','5','393','5','5','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1218','5','393','5','6','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1219','5','393','5','7','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1220','5','393','5','8','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1221','5','393','5','9','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1222','5','393','5','10','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1223','5','393','5','11','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1224','5','393','5','12','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1225','5','394','5','1','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1226','5','394','5','2','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1227','5','394','5','3','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1228','5','394','5','4','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1229','5','394','5','5','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1230','5','394','5','6','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1231','5','394','5','7','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1232','5','394','5','8','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1233','5','394','5','9','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1234','5','394','5','10','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1235','5','394','5','11','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1236','5','394','5','12','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1237','5','395','5','1','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1238','5','395','5','2','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1239','5','395','5','3','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1240','5','395','5','4','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1241','5','395','5','5','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1242','5','395','5','6','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1243','5','395','5','7','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1244','5','395','5','8','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1245','5','395','5','9','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1246','5','395','5','10','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1247','5','395','5','11','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1248','5','395','5','12','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1249','5','396','5','1','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1250','5','396','5','2','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1251','5','396','5','3','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1252','5','396','5','4','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1253','5','396','5','5','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1254','5','396','5','6','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1255','5','396','5','7','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1256','5','396','5','8','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1257','5','396','5','9','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1258','5','396','5','10','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1259','5','396','5','11','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1260','5','396','5','12','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1261','5','397','5','1','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1262','5','397','5','2','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1263','5','397','5','3','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1264','5','397','5','4','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1265','5','397','5','5','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1266','5','397','5','6','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1267','5','397','5','7','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1268','5','397','5','8','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1269','5','397','5','9','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1270','5','397','5','10','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1271','5','397','5','11','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1272','5','397','5','12','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1273','5','398','5','1','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1274','5','398','5','2','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1275','5','398','5','3','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1276','5','398','5','4','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1277','5','398','5','5','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1278','5','398','5','6','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1279','5','398','5','7','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1280','5','398','5','8','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1281','5','398','5','9','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1282','5','398','5','10','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1283','5','398','5','11','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1284','5','398','5','12','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1285','5','370','6','1','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1286','5','370','6','2','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1287','5','370','6','3','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1288','5','370','6','4','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1289','5','370','6','5','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1290','5','370','6','6','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1291','5','370','6','7','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1292','5','370','6','8','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1293','5','370','6','9','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1294','5','370','6','10','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1295','5','370','6','11','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1296','5','370','6','12','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1297','5','371','6','1','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1298','5','371','6','2','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1299','5','371','6','3','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1300','5','371','6','4','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1301','5','371','6','5','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1302','5','371','6','6','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1303','5','371','6','7','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1304','5','371','6','8','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1305','5','371','6','9','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1306','5','371','6','10','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1307','5','371','6','11','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1308','5','371','6','12','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1309','5','372','6','1','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1310','5','372','6','2','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1311','5','372','6','3','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1312','5','372','6','4','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1313','5','372','6','5','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1314','5','372','6','6','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1315','5','372','6','7','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1316','5','372','6','8','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1317','5','372','6','9','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1318','5','372','6','10','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1319','5','372','6','11','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1320','5','372','6','12','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1321','5','374','6','1','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1322','5','374','6','2','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1323','5','374','6','3','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1324','5','374','6','4','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1325','5','374','6','5','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1326','5','374','6','6','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1327','5','374','6','7','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1328','5','374','6','8','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1329','5','374','6','9','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1330','5','374','6','10','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1331','5','374','6','11','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1332','5','374','6','12','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1333','5','377','6','1','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1334','5','377','6','2','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1335','5','377','6','3','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1336','5','377','6','4','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1337','5','377','6','5','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1338','5','377','6','6','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1339','5','377','6','7','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1340','5','377','6','8','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1341','5','377','6','9','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1342','5','377','6','10','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1343','5','377','6','11','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1344','5','377','6','12','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1345','5','346','7','1','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1346','5','346','7','2','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1347','5','346','7','3','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1348','5','346','7','4','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1349','5','346','7','5','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1350','5','346','7','6','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1351','5','346','7','7','65000','2020-01-30 00:00:00','2020-01-30 13:11:39','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1352','5','346','7','8','65000','2020-01-30 00:00:00','2020-01-30 13:11:41','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1353','5','346','7','9','65000','2020-01-30 00:00:00','2020-01-30 13:11:43','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1354','5','346','7','10','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1355','5','346','7','11','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1356','5','346','7','12','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1357','5','347','7','1','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1358','5','347','7','2','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1359','5','347','7','3','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1360','5','347','7','4','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1361','5','347','7','5','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1362','5','347','7','6','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1363','5','347','7','7','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1364','5','347','7','8','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1365','5','347','7','9','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1366','5','347','7','10','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1367','5','347','7','11','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1368','5','347','7','12','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1369','5','348','7','1','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1370','5','348','7','2','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1371','5','348','7','3','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1372','5','348','7','4','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1373','5','348','7','5','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1374','5','348','7','6','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1375','5','348','7','7','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1376','5','348','7','8','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1377','5','348','7','9','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1378','5','348','7','10','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1379','5','348','7','11','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1380','5','348','7','12','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1381','5','349','7','1','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1382','5','349','7','2','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1383','5','349','7','3','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1384','5','349','7','4','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1385','5','349','7','5','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1386','5','349','7','6','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1387','5','349','7','7','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1388','5','349','7','8','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1389','5','349','7','9','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1390','5','349','7','10','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1391','5','349','7','11','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1392','5','349','7','12','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1393','5','350','7','1','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1394','5','350','7','2','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1395','5','350','7','3','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1396','5','350','7','4','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1397','5','350','7','5','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1398','5','350','7','6','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1399','5','350','7','7','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1400','5','350','7','8','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1401','5','350','7','9','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1402','5','350','7','10','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1403','5','350','7','11','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1404','5','350','7','12','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1405','5','351','7','1','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1406','5','351','7','2','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1407','5','351','7','3','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1408','5','351','7','4','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1409','5','351','7','5','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1410','5','351','7','6','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1411','5','351','7','7','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1412','5','351','7','8','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1413','5','351','7','9','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1414','5','351','7','10','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1415','5','351','7','11','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1416','5','351','7','12','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1417','5','352','7','1','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1418','5','352','7','2','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1419','5','352','7','3','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1420','5','352','7','4','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1421','5','352','7','5','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1422','5','352','7','6','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1423','5','352','7','7','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1424','5','352','7','8','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1425','5','352','7','9','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1426','5','352','7','10','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1427','5','352','7','11','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1428','5','352','7','12','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1429','5','353','7','1','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1430','5','353','7','2','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1431','5','353','7','3','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1432','5','353','7','4','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1433','5','353','7','5','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1434','5','353','7','6','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1435','5','353','7','7','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1436','5','353','7','8','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1437','5','353','7','9','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1438','5','353','7','10','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1439','5','353','7','11','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1440','5','353','7','12','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1441','5','354','7','1','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1442','5','354','7','2','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1443','5','354','7','3','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1444','5','354','7','4','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1445','5','354','7','5','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1446','5','354','7','6','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1447','5','354','7','7','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1448','5','354','7','8','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1449','5','354','7','9','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1450','5','354','7','10','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1451','5','354','7','11','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1452','5','354','7','12','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1453','5','355','7','1','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1454','5','355','7','2','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1455','5','355','7','3','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1456','5','355','7','4','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1457','5','355','7','5','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1458','5','355','7','6','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1459','5','355','7','7','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1460','5','355','7','8','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1461','5','355','7','9','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1462','5','355','7','10','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1463','5','355','7','11','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1464','5','355','7','12','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1465','5','358','7','1','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1466','5','358','7','2','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1467','5','358','7','3','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1468','5','358','7','4','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1469','5','358','7','5','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1470','5','358','7','6','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1471','5','358','7','7','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1472','5','358','7','8','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1473','5','358','7','9','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1474','5','358','7','10','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1475','5','358','7','11','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1476','5','358','7','12','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1477','5','359','7','1','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1478','5','359','7','2','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1479','5','359','7','3','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1480','5','359','7','4','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1481','5','359','7','5','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1482','5','359','7','6','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1483','5','359','7','7','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1484','5','359','7','8','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1485','5','359','7','9','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1486','5','359','7','10','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1487','5','359','7','11','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1488','5','359','7','12','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1489','5','362','7','1','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1490','5','362','7','2','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1491','5','362','7','3','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1492','5','362','7','4','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1493','5','362','7','5','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1494','5','362','7','6','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1495','5','362','7','7','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1496','5','362','7','8','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1497','5','362','7','9','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1498','5','362','7','10','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1499','5','362','7','11','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1500','5','362','7','12','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1501','5','363','7','1','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1502','5','363','7','2','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1503','5','363','7','3','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1504','5','363','7','4','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1505','5','363','7','5','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1506','5','363','7','6','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1507','5','363','7','7','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1508','5','363','7','8','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1509','5','363','7','9','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1510','5','363','7','10','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1511','5','363','7','11','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1512','5','363','7','12','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1513','5','364','7','1','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1514','5','364','7','2','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1515','5','364','7','3','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1516','5','364','7','4','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1517','5','364','7','5','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1518','5','364','7','6','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1519','5','364','7','7','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1520','5','364','7','8','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1521','5','364','7','9','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1522','5','364','7','10','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1523','5','364','7','11','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1524','5','364','7','12','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1525','5','365','7','1','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1526','5','365','7','2','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1527','5','365','7','3','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1528','5','365','7','4','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1529','5','365','7','5','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1530','5','365','7','6','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1531','5','365','7','7','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1532','5','365','7','8','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1533','5','365','7','9','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1534','5','365','7','10','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1535','5','365','7','11','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1536','5','365','7','12','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1537','5','366','7','1','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1538','5','366','7','2','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1539','5','366','7','3','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1540','5','366','7','4','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1541','5','366','7','5','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1542','5','366','7','6','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1543','5','366','7','7','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1544','5','366','7','8','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1545','5','366','7','9','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1546','5','366','7','10','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1547','5','366','7','11','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1548','5','366','7','12','65000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1573','53','303','1','1','50000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1574','53','303','1','2','50000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1575','53','303','1','3','50000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1576','53','303','1','4','50000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1577','53','303','1','5','50000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1578','53','303','1','6','50000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1579','53','303','1','7','50000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1580','53','303','1','8','50000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1581','53','303','1','9','50000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1582','53','303','1','10','50000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1583','53','303','1','11','50000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1584','53','303','1','12','50000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1585','53','409','1','1','50000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1586','53','409','1','2','50000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1587','53','409','1','3','50000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1588','53','409','1','4','50000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1589','53','409','1','5','50000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1590','53','409','1','6','50000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1591','53','409','1','7','50000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1592','53','409','1','8','50000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1593','53','409','1','9','50000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1594','53','409','1','10','50000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1595','53','409','1','11','50000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1596','53','409','1','12','50000',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1597','65','409','1','1','0',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1598','65','409','1','2','0',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1599','65','409','1','3','0',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1600','65','409','1','4','0',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1601','65','409','1','5','0',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1602','65','409','1','6','0',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1603','65','409','1','7','0',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1604','65','409','1','8','0',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1605','65','409','1','9','0',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1606','65','409','1','10','0',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1607','65','409','1','11','0',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1608','65','409','1','12','0',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1609','65','415','1','1','0',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1610','65','415','1','2','0',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1611','65','415','1','3','0',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1612','65','415','1','4','0',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1613','65','415','1','5','0',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1614','65','415','1','6','0',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1615','65','415','1','7','0',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1616','65','415','1','8','0',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1617','65','415','1','9','0',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1618','65','415','1','10','0',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1619','65','415','1','11','0',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('1620','65','415','1','12','0',NULL,NULL,'0','Tunai');

/*---------------------------------------------------------------
  TABLE: `tahun_ajaran`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `tahun_ajaran`;
CREATE TABLE `tahun_ajaran` (
  `idTahunAjaran` int(5) NOT NULL AUTO_INCREMENT,
  `nmTahunAjaran` varchar(9) DEFAULT NULL,
  `aktif` enum('Y','T') DEFAULT 'Y',
  PRIMARY KEY (`idTahunAjaran`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=latin1;
INSERT INTO `tahun_ajaran` VALUES   ('3','2018/2019','T');
INSERT INTO `tahun_ajaran` VALUES ('4','2019/2020','Y');
INSERT INTO `tahun_ajaran` VALUES ('5','2020/2021','T');
INSERT INTO `tahun_ajaran` VALUES ('8','2019/2020','T');
INSERT INTO `tahun_ajaran` VALUES ('10','2020/2021','T');

/*---------------------------------------------------------------
  TABLE: `transaksi`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `transaksi`;
CREATE TABLE `transaksi` (
  `id_transaksi` varchar(50) NOT NULL,
  `idSiswa` varchar(50) NOT NULL,
  `tanggal` date NOT NULL,
  `debit` int(10) NOT NULL,
  `kredit` int(10) NOT NULL,
  `keterangan` varchar(50) NOT NULL,
  PRIMARY KEY (`id_transaksi`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
INSERT INTO `transaksi` VALUES   ('T0002','409','2020-01-16','0','1000','mengambil');
INSERT INTO `transaksi` VALUES ('T0001','409','2020-01-16','1000','0','menabung');
INSERT INTO `transaksi` VALUES ('T0003','407','2020-01-16','50000','0','');
INSERT INTO `transaksi` VALUES ('T0004','407','2020-01-16','0','5000','');
INSERT INTO `transaksi` VALUES ('T0005','302','2020-01-25','450000','0','tabungan');
INSERT INTO `transaksi` VALUES ('T0006','409','2020-02-29','20000','0','');
INSERT INTO `transaksi` VALUES ('T0007','410','2020-03-11','10000','0','');
INSERT INTO `transaksi` VALUES ('T0008','410','2020-03-11','0','5000','beli permen');
INSERT INTO `transaksi` VALUES ('T0009','412','2020-04-28','500000','0','kontan');
INSERT INTO `transaksi` VALUES ('T0010','412','2020-04-28','1000','0','');
INSERT INTO `transaksi` VALUES ('T0011','411','2020-05-01','50000','0','');
INSERT INTO `transaksi` VALUES ('T0012','411','2020-05-01','50000','0','');
INSERT INTO `transaksi` VALUES ('T0013','412','2020-05-03','1000000','0','Tabungan mei 2020');
INSERT INTO `transaksi` VALUES ('T0014','412','2020-05-03','0','100000','Pembayaran SPP');
INSERT INTO `transaksi` VALUES ('T0015','299','2020-05-11','9000000','0','ghjgj');
INSERT INTO `transaksi` VALUES ('T0016','299','2020-05-11','0','9000000','nn');
INSERT INTO `transaksi` VALUES ('T0017','412','2020-06-07','10000','0','');
INSERT INTO `transaksi` VALUES ('T0018','412','2020-06-07','0','1411000','');
INSERT INTO `transaksi` VALUES ('T0019','412','2020-06-07','500000','0','');
INSERT INTO `transaksi` VALUES ('T0020','416','2020-06-13','20000','0','tABUNGAN');
INSERT INTO `transaksi` VALUES ('T0021','416','2020-06-13','0','10000','');

/*---------------------------------------------------------------
  TABLE: `users`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `username` varchar(50) COLLATE latin1_general_ci NOT NULL,
  `password` varchar(50) COLLATE latin1_general_ci NOT NULL,
  `nama_lengkap` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `email` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `no_telp` varchar(20) COLLATE latin1_general_ci NOT NULL,
  `level` varchar(20) COLLATE latin1_general_ci NOT NULL DEFAULT 'admin',
  `blokir` enum('Y','N') COLLATE latin1_general_ci NOT NULL DEFAULT 'N',
  `id_session` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `last_login` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`username`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;
INSERT INTO `users` VALUES   ('admin','0192023a7bbd73250516f069df18b500','Rivani Noer Maulidi','theivhan@gmail.com','085233072661','admin','N','vgjkducma2cld9dq2a7ahg5f04','2017-08-30 18:43:28');
INSERT INTO `users` VALUES ('adminjuraganpay','0192023a7bbd73250516f069df18b500','Riv','theivhan@gmail.com','68233072661','bendahara','N','',NULL);
INSERT INTO `users` VALUES ('koperasi','e2056765263365f9084fd44dad5e39ee','Koperasi','theivhan@gmail.com','68233072661','koperasi','N','',NULL);

/*---------------------------------------------------------------
  TABLE: `view_detil_jenis_bayar`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `view_detil_jenis_bayar`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `view_detil_jenis_bayar` AS select `jenis_bayar`.`idJenisBayar` AS `idJenisBayar`,`jenis_bayar`.`idPosBayar` AS `idPosBayar`,`jenis_bayar`.`idTahunAjaran` AS `idTahunAjaran`,`jenis_bayar`.`nmJenisBayar` AS `nmJenisBayar`,`jenis_bayar`.`tipeBayar` AS `tipeBayar`,`pos_bayar`.`nmPosBayar` AS `nmPosBayar`,`tahun_ajaran`.`nmTahunAjaran` AS `nmTahunAjaran`,`tahun_ajaran`.`aktif` AS `aktif` from ((`jenis_bayar` join `pos_bayar` on((`jenis_bayar`.`idPosBayar` = `pos_bayar`.`idPosBayar`))) join `tahun_ajaran` on((`jenis_bayar`.`idTahunAjaran` = `tahun_ajaran`.`idTahunAjaran`)));
INSERT INTO `view_detil_jenis_bayar` VALUES   ('2','1','3','Pembangunan 1819','bebas','SMK','2018/2019','T');
INSERT INTO `view_detil_jenis_bayar` VALUES ('4','1','3','spp','bulanan','SMK','2018/2019','T');
INSERT INTO `view_detil_jenis_bayar` VALUES ('5','1','4','DANA BULANAN','bulanan','SMK','2019/2020','Y');
INSERT INTO `view_detil_jenis_bayar` VALUES ('6','1','4','DAFTAR ULANG','bebas','SMK','2019/2020','Y');
INSERT INTO `view_detil_jenis_bayar` VALUES ('7','1','4','DANA KEG. (AGUSTUSAN)','bebas','SMK','2019/2020','Y');
INSERT INTO `view_detil_jenis_bayar` VALUES ('8','1','4','DANA KEG. (QURBAN)','bebas','SMK','2019/2020','Y');
INSERT INTO `view_detil_jenis_bayar` VALUES ('9','1','4','DANA KEG.(CLASSMEETING)','bebas','SMK','2019/2020','Y');
INSERT INTO `view_detil_jenis_bayar` VALUES ('10','1','4','DANA KEG.(PHBI)','bebas','SMK','2019/2020','Y');
INSERT INTO `view_detil_jenis_bayar` VALUES ('11','1','4','DANA KEG.(OSIS)','bebas','SMK','2019/2020','Y');
INSERT INTO `view_detil_jenis_bayar` VALUES ('12','1','4','EKSTRAKULIKULER','bebas','SMK','2019/2020','Y');
INSERT INTO `view_detil_jenis_bayar` VALUES ('13','1','4','KEPRAMUKAAN','bebas','SMK','2019/2020','Y');
INSERT INTO `view_detil_jenis_bayar` VALUES ('14','1','4','KARTU PELAJAR','bebas','SMK','2019/2020','Y');
INSERT INTO `view_detil_jenis_bayar` VALUES ('15','1','4','DANA PERPUS','bebas','SMK','2019/2020','Y');
INSERT INTO `view_detil_jenis_bayar` VALUES ('16','1','4','UTS (SMST1)','bebas','SMK','2019/2020','Y');
INSERT INTO `view_detil_jenis_bayar` VALUES ('17','1','4','UTS (SMST2)','bebas','SMK','2019/2020','Y');
INSERT INTO `view_detil_jenis_bayar` VALUES ('18','1','4','UAS(SMST1)','bebas','SMK','2019/2020','Y');
INSERT INTO `view_detil_jenis_bayar` VALUES ('19','1','4','UAS(SMST2)','bebas','SMK','2019/2020','Y');
INSERT INTO `view_detil_jenis_bayar` VALUES ('20','1','4','RAPORT','bebas','SMK','2019/2020','Y');
INSERT INTO `view_detil_jenis_bayar` VALUES ('21','1','4','PERKEMAHAN/PERJARI','bebas','SMK','2019/2020','Y');
INSERT INTO `view_detil_jenis_bayar` VALUES ('22','1','4','SERAGAM ALMAMATER','bebas','SMK','2019/2020','Y');
INSERT INTO `view_detil_jenis_bayar` VALUES ('23','1','4','DANA PRAKTIKUM','bebas','SMK','2019/2020','Y');
INSERT INTO `view_detil_jenis_bayar` VALUES ('24','1','4','DANA SARPARAS','bebas','SMK','2019/2020','Y');
INSERT INTO `view_detil_jenis_bayar` VALUES ('25','1','4','KALENDER SEKOLAH','bebas','SMK','2019/2020','Y');
INSERT INTO `view_detil_jenis_bayar` VALUES ('26','1','4','NOMINATIF','bebas','SMK','2019/2020','Y');
INSERT INTO `view_detil_jenis_bayar` VALUES ('27','1','4','PENDALAMAN MATERI','bebas','SMK','2019/2020','Y');
INSERT INTO `view_detil_jenis_bayar` VALUES ('28','1','4','PENGADAAN SARANA UNBK','bebas','SMK','2019/2020','Y');
INSERT INTO `view_detil_jenis_bayar` VALUES ('29','1','4','FOTO IJAZAH','bebas','SMK','2019/2020','Y');
INSERT INTO `view_detil_jenis_bayar` VALUES ('30','1','4','BUKU PENDAMPING UN & LKS','bebas','SMK','2019/2020','Y');
INSERT INTO `view_detil_jenis_bayar` VALUES ('31','1','4','SIMULASI (1&2)','bebas','SMK','2019/2020','Y');
INSERT INTO `view_detil_jenis_bayar` VALUES ('32','1','4','TRYOUT (1&2)','bebas','SMK','2019/2020','Y');
INSERT INTO `view_detil_jenis_bayar` VALUES ('33','1','4','USBN BK','bebas','SMK','2019/2020','Y');
INSERT INTO `view_detil_jenis_bayar` VALUES ('34','1','4','UNBK','bebas','SMK','2019/2020','Y');
INSERT INTO `view_detil_jenis_bayar` VALUES ('35','1','4','PRA UKK','bebas','SMK','2019/2020','Y');
INSERT INTO `view_detil_jenis_bayar` VALUES ('36','1','4','UKK','bebas','SMK','2019/2020','Y');
INSERT INTO `view_detil_jenis_bayar` VALUES ('37','1','4','BUKU KENANGAN','bebas','SMK','2019/2020','Y');
INSERT INTO `view_detil_jenis_bayar` VALUES ('38','1','4','IJASAH & SKHUN','bebas','SMK','2019/2020','Y');
INSERT INTO `view_detil_jenis_bayar` VALUES ('39','1','4','SAMPUL IJASAH','bebas','SMK','2019/2020','Y');
INSERT INTO `view_detil_jenis_bayar` VALUES ('40','1','4','FC.PENULISAN IJASAH','bebas','SMK','2019/2020','Y');
INSERT INTO `view_detil_jenis_bayar` VALUES ('41','1','4','CENDERAMATA SEKOLAH','bebas','SMK','2019/2020','Y');
INSERT INTO `view_detil_jenis_bayar` VALUES ('42','1','4','PERPISAHAN','bebas','SMK','2019/2020','Y');
INSERT INTO `view_detil_jenis_bayar` VALUES ('43','1','4','PRAKERIN/TABLE MANER','bebas','SMK','2019/2020','Y');
INSERT INTO `view_detil_jenis_bayar` VALUES ('44','2','4','UAS','bebas','SD AJA','2019/2020','Y');
INSERT INTO `view_detil_jenis_bayar` VALUES ('49','4','4','PSG','bebas','PSG','2019/2020','Y');
INSERT INTO `view_detil_jenis_bayar` VALUES ('50','1','4','','bebas','SMK','2019/2020','Y');
INSERT INTO `view_detil_jenis_bayar` VALUES ('51','1','4','SPP 01 20','bebas','SMK','2019/2020','Y');
INSERT INTO `view_detil_jenis_bayar` VALUES ('52','1','4','kaoskaki','bebas','SMK','2019/2020','Y');
INSERT INTO `view_detil_jenis_bayar` VALUES ('54','6','4','Uang Pangkal','bebas','MA','2019/2020','Y');
INSERT INTO `view_detil_jenis_bayar` VALUES ('55','1','4','Ikhtifalan','bebas','SMK','2019/2020','Y');
INSERT INTO `view_detil_jenis_bayar` VALUES ('57','1','4','bp','bebas','SMK','2019/2020','Y');
INSERT INTO `view_detil_jenis_bayar` VALUES ('45','1','5','PTS Susulan','bebas','SMK','2020/2021','T');
INSERT INTO `view_detil_jenis_bayar` VALUES ('46','1','5','PAS Susulan','bebas','SMK','2020/2021','T');
INSERT INTO `view_detil_jenis_bayar` VALUES ('53','1','5','SPP Bulanan','bulanan','SMK','2020/2021','T');
INSERT INTO `view_detil_jenis_bayar` VALUES ('56','1','5','bilungal','bebas','SMK','2020/2021','T');
INSERT INTO `view_detil_jenis_bayar` VALUES ('58','1','8','','bulanan','SMK','2019/2020','T');
INSERT INTO `view_detil_jenis_bayar` VALUES ('59','5','8','susulan','bulanan','SPP','2019/2020','T');
INSERT INTO `view_detil_jenis_bayar` VALUES ('60','1','8','susulan','bulanan','SMK','2019/2020','T');
INSERT INTO `view_detil_jenis_bayar` VALUES ('61','6','8','Uang Keamanan','bebas','MA','2019/2020','T');
INSERT INTO `view_detil_jenis_bayar` VALUES ('65','9','8','SPP BULAN JUNI','bulanan','SPP Bulan Juni','2019/2020','T');
INSERT INTO `view_detil_jenis_bayar` VALUES ('66','8','8','Uang Makan','bulanan','Syahriyah','2019/2020','T');
INSERT INTO `view_detil_jenis_bayar` VALUES ('62','1','10','SPP KJP','bulanan','SMK','2020/2021','T');
INSERT INTO `view_detil_jenis_bayar` VALUES ('63','4','10','','bulanan','PSG','2020/2021','T');
INSERT INTO `view_detil_jenis_bayar` VALUES ('64','4','10','psg','bulanan','PSG','2020/2021','T');

/*---------------------------------------------------------------
  TABLE: `view_detil_siswa`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `view_detil_siswa`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `view_detil_siswa` AS select `siswa`.`idSiswa` AS `idSiswa`,`siswa`.`nisSiswa` AS `nisSiswa`,`siswa`.`nisnSiswa` AS `nisnSiswa`,`siswa`.`nmSiswa` AS `nmSiswa`,`siswa`.`jkSiswa` AS `jkSiswa`,`siswa`.`agamaSiswa` AS `agamaSiswa`,`siswa`.`idKelas` AS `idKelas`,`siswa`.`statusSiswa` AS `statusSiswa`,`kelas_siswa`.`nmKelas` AS `nmKelas`,`kelas_siswa`.`ketKelas` AS `ketKelas`,`siswa`.`nmOrtu` AS `nmOrtu`,`siswa`.`alamatOrtu` AS `alamatOrtu`,`siswa`.`noHpOrtu` AS `noHpOrtu`,`siswa`.`saldo` AS `saldo` from (`siswa` join `kelas_siswa` on((`siswa`.`idKelas` = `kelas_siswa`.`idKelas`)));
INSERT INTO `view_detil_siswa` VALUES   ('299','373/046/110','0041807508','Amalia Ilmiah','P','Islam','1','Aktif','X OTKP','-','Hadiri','sampangan','085233072661','0');
INSERT INTO `view_detil_siswa` VALUES ('300','374/047/110','0044717785','Anisa Tri Wahyuni','P','Islam','1','Lulus','X OTKP','-','','Dsn. Pekiwen RT.03/RW.02 Ds. Kaligung','','0');
INSERT INTO `view_detil_siswa` VALUES ('304','378/051/110','0048336113','Dini Asmawati','P','Islam','1','Lulus','X OTKP','-','','Dsn. Krajan RT.02/RW.02 Ds. Blimbingsari','','0');
INSERT INTO `view_detil_siswa` VALUES ('305','379/052/110','0042201099','Dini Putri Hidayah','P','Islam','1','Lulus','X OTKP','-','','Rejosari','','15000');
INSERT INTO `view_detil_siswa` VALUES ('306','380/053/110','0047377251','Eka Agustina Rahayu','P','Islam','1','Lulus','X OTKP','-','','Sukodadi Sraten','','0');
INSERT INTO `view_detil_siswa` VALUES ('307','381/054/110','0036492699','Hedi Saputra','L','Islam','1','Lulus','X OTKP','-','','Dsn. Babakan RT.01/RW.04 Ds. Kedayunan','','0');
INSERT INTO `view_detil_siswa` VALUES ('308','382/055/110','0040573762','Indah Tri Wulandari','P','Islam','1','Lulus','X OTKP','-','Surip','Krajan','','0');
INSERT INTO `view_detil_siswa` VALUES ('309','383/056/110','0039182496','Istikomah','P','Islam','1','Lulus','X OTKP','-','','Dsn. Kedungsari RT.02/RW.01  Ds. Gintangan','','0');
INSERT INTO `view_detil_siswa` VALUES ('311','385/058/110','0036413579','Maulida Yuli Fitri','P','Islam','1','Lulus','X OTKP','-','','Dsn. Krajan Timur RT.03/RW.03 Ds. Segobang Licin','','0');
INSERT INTO `view_detil_siswa` VALUES ('313','396/060/110','0044324638','Nadifatul Insiyah','P','Islam','1','Lulus','X OTKP','-','','Ds. Sasakbomo RT.01/RW.02 Ds. Mangir','','0');
INSERT INTO `view_detil_siswa` VALUES ('314','397/061/110','0035764814','Nuris Soleha','P','Islam','1','Lulus','X OTKP','-','MAD RAJI','PALUREJO','','0');
INSERT INTO `view_detil_siswa` VALUES ('316','399/063/110','0036380287','Roekhatul Habibah','P','Islam','1','Lulus','X OTKP','-','','sampangan','085233072661','0');
INSERT INTO `view_detil_siswa` VALUES ('317','400/064/110','0035593330','Ulfa Hanin Khumairoh','P','Islam','1','Lulus','X OTKP','-','','Dsn. Rejosari RT.06/RW.01 Ds. Benculuk','','0');
INSERT INTO `view_detil_siswa` VALUES ('409','123','0031242229','rsad','L','Islam','1','Lulus','X OTKP','-','Hadiri','Jalan Raya Gedangan','999999999999','20000');
INSERT INTO `view_detil_siswa` VALUES ('411','12345678','123456789','kimin','L','Islam','1','Lulus','X OTKP','-','kiming','takes','321321123','100000');
INSERT INTO `view_detil_siswa` VALUES ('415','0001','414','abcd','L','Islam','1','Lulus','X OTKP','-','qqq','qqqqqqqqqq','999999999999','0');
INSERT INTO `view_detil_siswa` VALUES ('312','395/059/110','0031048961','Mira Agustin','P','Islam','3','Aktif','X APH','','Orang Tua','Dsn. Krajan Ds. Songgon','085233072661','0');
INSERT INTO `view_detil_siswa` VALUES ('413','1234','','wanda','P','Islam','3','Aktif','X APH','','suhdi','Yossudarso','08123456789','0');
INSERT INTO `view_detil_siswa` VALUES ('414','88','88','wanda','P','Islam','3','Aktif','X APH','','suhdi','Yossudarso','08123456789','0');
INSERT INTO `view_detil_siswa` VALUES ('318','401/087/66','0039250453','Abd. Rohim','L','Islam','4','Lulus','X TKJ','','','Giri','','0');
INSERT INTO `view_detil_siswa` VALUES ('303','377/050/110','0047992668','Dimas Viktor Risman','L','Islam','5','Aktif','XI TKJ','','','','','0');
INSERT INTO `view_detil_siswa` VALUES ('319','402/088/66','0039782572','Abdul Latip','L','Islam','5','Aktif','XI TKJ','','Sudirman','Desa Tanjung Mulya','','0');
INSERT INTO `view_detil_siswa` VALUES ('320','403/089/66','0014102305','Abdul Rohman','L','Islam','5','Aktif','XI TKJ','','','Dsn. Cengkokan RT.01/RW.01 Ds. Mangir','','0');
INSERT INTO `view_detil_siswa` VALUES ('321','404/090/66','0049747742','Ahmad Balya Irsyaduddin','L','Islam','5','Aktif','XI TKJ','','','Dsn. Sumbersari  RT.01/RW.02 Ds. Mangir','','0');
INSERT INTO `view_detil_siswa` VALUES ('322','405/091/66','0048101100','Ahmad Fathurrohman','L','Islam','5','Aktif','XI TKJ','','','Dsn. Kramatagung RT.03/RW.02 Ds. Kaligung','','0');
INSERT INTO `view_detil_siswa` VALUES ('323','406/092/66','0047902281','Ahmad Taufiqur Rohman','L','Islam','5','Aktif','XI TKJ','','','Dsn. Sumbersari  RT.02/RW.02 Ds. Mangir','','0');
INSERT INTO `view_detil_siswa` VALUES ('324','317/043/66','0037262310','Andri Kristina Putra','L','Islam','5','Aktif','XI TKJ','','','Dsn. Rejosari RT.01/RW.01 Ds. Karangrejo','','0');
INSERT INTO `view_detil_siswa` VALUES ('325','408/094/66','0042037288','Ayu Uut Wulandari','P','Islam','5','Aktif','XI TKJ','','','Dsn. Krajan RT.05/RW.02 Ds. Bomo','','0');
INSERT INTO `view_detil_siswa` VALUES ('326','428/113/66','0036431103','Dina Mukarromah','P','Islam','5','Aktif','XI TKJ','','','JAMBEARUM PUGER JEMBER','','0');
INSERT INTO `view_detil_siswa` VALUES ('327','429/114/66','0036431104','Dini Mukarromah','P','Islam','5','Aktif','XI TKJ','','','JAMBEARUM PUGER JEMBER','','0');
INSERT INTO `view_detil_siswa` VALUES ('328','409/095/66','0036057891','ERVINA GUSMIARNI','P','Islam','5','Aktif','XI TKJ','','KUSNEN','JL.GUMUK KANTONG','','0');
INSERT INTO `view_detil_siswa` VALUES ('330','411/097/66','0049516358','Hayatun Thoyyibah','P','Islam','5','Aktif','XI TKJ','','NASERI','Jl. Kramat','','0');
INSERT INTO `view_detil_siswa` VALUES ('331','412/098/66','0035657766','Imam Mustofa','L','Islam','5','Aktif','XI TKJ','','','Dsn. Rejosari RT.03/RW.01 Ds. Karangrejo','','0');
INSERT INTO `view_detil_siswa` VALUES ('332','413/099/66','0034686802','Ismia Umul Azam','P','Islam','5','Aktif','XI TKJ','','SUGIANTO','JL. KEDAYUNAN','','0');
INSERT INTO `view_detil_siswa` VALUES ('333','414/100/66','0031469023','Kartika Trisna Devi','P','Islam','5','Aktif','XI TKJ','','BASORI','Krajan','','0');
INSERT INTO `view_detil_siswa` VALUES ('334','415/101/66','0033680235','M. Azwar Anas','L','Islam','5','Aktif','XI TKJ','','Misnan','Dsn, Sumbersari','','0');
INSERT INTO `view_detil_siswa` VALUES ('335','416/102/66','0050455300','Mas Hilmi Mubarrok','L','Islam','5','Aktif','XI TKJ','','','Dsn. Babakan RT.01/RW.04 Ds.Kedayunan','','0');
INSERT INTO `view_detil_siswa` VALUES ('336','417/103/66','0037811820','Moh. Fikri Andriansyah','L','Islam','5','Aktif','XI TKJ','','AGUS MUJIB','JL. PRING SEJUTA','','0');
INSERT INTO `view_detil_siswa` VALUES ('337','419/105/66','0046777477','Nanang Bahroji','L','Islam','5','Aktif','XI TKJ','','','JL. WATUGONG','','0');
INSERT INTO `view_detil_siswa` VALUES ('338','420/106/66','0045631789','Nidia Rin Triana','P','Islam','5','Aktif','XI TKJ','','','Dsn. Kedunen RT.03/RW.02 Ds. Bomo','','0');
INSERT INTO `view_detil_siswa` VALUES ('339','421/107/66','0042520889','Nuril Islam','L','Islam','5','Aktif','XI TKJ','','','Dsn. Malar Ds. Macanputih','','0');
INSERT INTO `view_detil_siswa` VALUES ('341','423/109/66','0036452057','Sela Arista','P','Islam','5','Aktif','XI TKJ','','','Dsn. Pendarungan RT.01/RW.01 Ds. Karangrejo','','0');
INSERT INTO `view_detil_siswa` VALUES ('342','424/110/66','0045236290','Sinta Annuriyah','P','Islam','5','Aktif','XI TKJ','','Tuhaini','Jl. Kramat','','0');
INSERT INTO `view_detil_siswa` VALUES ('343','425/111/66','0042258489','Very Prasetiyo','L','Islam','5','Aktif','XI TKJ','','','Dsn. Pekiwen RT.01/RW.02 Ds. Kaligung','','0');
INSERT INTO `view_detil_siswa` VALUES ('345','427/046/66','0044255385','Wisnu Wardana','L','Islam','5','Aktif','XI TKJ','','MOH. SUPRIYANTO ROUTOMO','KRAJAN','','0');
INSERT INTO `view_detil_siswa` VALUES ('346','320/037/116','0022045685','AHMAD SULAIMI','L','Islam','5','Aktif','XI TKJ','','','Babagan RT01/RW01 Kedayunan Kabat','','0');
INSERT INTO `view_detil_siswa` VALUES ('347','335/051/116','0019297552','Arkanul Muslimin','L','Islam','5','Aktif','XI TKJ','','','Curahpacul RT03/RW04 Tambakrejo Muncar','','0');
INSERT INTO `view_detil_siswa` VALUES ('348','341/053/116','0016977296','DENI PURWANTO','L','Islam','5','Aktif','XI TKJ','','','Yosowinangun RT06/RW03 Jajag Gambiran','','0');
INSERT INTO `view_detil_siswa` VALUES ('349','321/038/116','0034332522','DHILA ARIESTYA','P','Islam','5','Aktif','XI TKJ','','','Muncar RT03/RW05 Kedungrejo Muncar','','0');
INSERT INTO `view_detil_siswa` VALUES ('350','324/040/116','0036495560','Muhamad Firli Abdika','L','Islam','5','Aktif','XI TKJ','','','Krajan RT04/RW02 Sraten Cluring','','0');
INSERT INTO `view_detil_siswa` VALUES ('351','326/042/116','0025512733','Nur Alfi Ansyah','P','Islam','5','Aktif','XI TKJ','','HADI SURYANTO','SRONO','','0');
INSERT INTO `view_detil_siswa` VALUES ('352','325/041/116','0039907311','Nuril Maulidiyah','P','Islam','5','Aktif','XI TKJ','','FATKHAL MUNIR','KRAJAN','','0');
INSERT INTO `view_detil_siswa` VALUES ('353','327/043/116','0031970784','Orlando Pilipus','L','Islam','5','Aktif','XI TKJ','','DIDIK HARIYADI','DUSUN BLANGKON','','0');
INSERT INTO `view_detil_siswa` VALUES ('354','328/044/116','0010062760','Putra Adi Prasetya','L','Islam','5','Aktif','XI TKJ','','','Plosorejo RT02/RW01 Kaliploso Cluring','','0');
INSERT INTO `view_detil_siswa` VALUES ('355','329/045/116','0039075959','Putri Amelia Larosa','P','Islam','5','Aktif','XI TKJ','','Khusnun','Suwaluh','','0');
INSERT INTO `view_detil_siswa` VALUES ('358','330/046/116','0056677245','S. Eka Nurul Hikmah','P','Islam','5','Aktif','XI TKJ','','Yusup','Pekiringan','','0');
INSERT INTO `view_detil_siswa` VALUES ('359','331/047/116','0013717789','Sayu Ulandari','P','Islam','5','Aktif','XI TKJ','','','Sukodadi RT04/RW01 Sraten Cluring','','0');
INSERT INTO `view_detil_siswa` VALUES ('362','332/048/116','0023393443','Siti Kholifah','P','Islam','5','Aktif','XI TKJ','','','Krajan RT03/RW02 Sraten Cluring','','0');
INSERT INTO `view_detil_siswa` VALUES ('363','416/055/116','0013563839','Siti Nur Lutfiyah','P','Islam','5','Aktif','XI TKJ','','AHMAD QUSOYI','Jl.segobang','','0');
INSERT INTO `view_detil_siswa` VALUES ('364','417/056/116','0002341623','Sri Dwi Wahyuni','P','Islam','5','Aktif','XI TKJ','','SUROSO','Jl.sukonatar','','10000');
INSERT INTO `view_detil_siswa` VALUES ('365','333/049/116','0030992539','Syekh Maulana Ishaq','L','Islam','5','Aktif','XI TKJ','','','Kramatagung RT03/RW01 Kaligung Blimbingsari','','0');
INSERT INTO `view_detil_siswa` VALUES ('366','334/050/116','0033770586','Umarudin','L','Islam','5','Aktif','XI TKJ','','','Krajan RT01/RW08 Sraten Cluring','','0');
INSERT INTO `view_detil_siswa` VALUES ('378','337/069/66','0036682272','Andre Gunawan','L','Islam','5','Aktif','XI TKJ','','','Biyan Tengah RT01/RW02 Kaduara Barat Larangan','','0');
INSERT INTO `view_detil_siswa` VALUES ('379','338/070/66','0034088266','ANGGI NOVITASARI','P','Islam','5','Aktif','XI TKJ','','','Patoman Barat RT02/RW02 Patoman Blimbingsari','','0');
INSERT INTO `view_detil_siswa` VALUES ('380','339/071/66','0027589635','ARIF SETIAWAN','L','Islam','5','Aktif','XI TKJ','','','Patoman Barat RT02/RW02 Patoman Blimbingsari','','0');
INSERT INTO `view_detil_siswa` VALUES ('381','340/072/66','0033009795','AYUK OKTAVIA','P','Islam','5','Aktif','XI TKJ','','','Babakan RT01/RW04 Kedayunan Kabat ','','0');
INSERT INTO `view_detil_siswa` VALUES ('382','342/073/66','0036921533','Diyana','P','Islam','5','Aktif','XI TKJ','','AGUS','JL. TAMBONG','','0');
INSERT INTO `view_detil_siswa` VALUES ('383','343/074/66','0036113469','Erviyadi Luqman Asmawi','L','Islam','5','Aktif','XI TKJ','','','Krajan RT02/RW04 Kaligung Rogojampi','','0');
INSERT INTO `view_detil_siswa` VALUES ('384','344/075/66','0036378894','Lilis Widya Astutik','P','Islam','5','Aktif','XI TKJ','','SAIKONI','PAKEL','','0');
INSERT INTO `view_detil_siswa` VALUES ('385','349/080/66','0037870073','M Ali Murtadlo','L','Islam','5','Aktif','XI TKJ','','','Temuguruh Sempu','','0');
INSERT INTO `view_detil_siswa` VALUES ('387','345/076/66','0036413345','Moch Nurul Fawaiz','L','Islam','5','Aktif','XI TKJ','','','Segobang','','0');
INSERT INTO `view_detil_siswa` VALUES ('388','351/082/66','0026203553','Mochammad Marzuqi','L','Islam','5','Aktif','XI TKJ','','','Tapansari RT03/RW01 Sraten Cluring','','0');
INSERT INTO `view_detil_siswa` VALUES ('390','346/077/66','0023173932','Moh. Gufron','L','Islam','5','Aktif','XI TKJ','','SUMITO','JL. PRING SEJUTA','','0');
INSERT INTO `view_detil_siswa` VALUES ('391','347/078/66','0038927770','Mohammad Nabil','L','Islam','5','Aktif','XI TKJ','','NUR KHOLIS','SRONO','','0');
INSERT INTO `view_detil_siswa` VALUES ('392','348/079/66','0020425650','Muhamad Ifroni','L','Islam','5','Aktif','XI TKJ','','BUKHORI','JL. PRING SEJUTA','','0');
INSERT INTO `view_detil_siswa` VALUES ('393','350/081/66','0035733377','Muhammad Azkanafsi','L','Islam','5','Aktif','XI TKJ','','','Seloagung RT04/RW03 Siliragung Siliragung','','0');
INSERT INTO `view_detil_siswa` VALUES ('394','352/083/66','0026362601','Nur Laila Hidayah','P','Islam','5','Aktif','XI TKJ','','','Krajan RT05/RW02 Barurejo Siliragung','','0');
INSERT INTO `view_detil_siswa` VALUES ('395','353/084/66','0038926644','Rizki Ari Saputra','L','Islam','5','Aktif','XI TKJ','','JONO SUPARNO','Tanah Hitam','','0');
INSERT INTO `view_detil_siswa` VALUES ('396','354/085/66','0029051204','Siti  Mudawamah','P','Islam','5','Aktif','XI TKJ','','','Kebonsari','','0');
INSERT INTO `view_detil_siswa` VALUES ('397','358/089/66','0009813878','Siti Nur Azizah','P','Islam','5','Aktif','XI TKJ','','FAHRUDIN','Jl.sraten','','0');
INSERT INTO `view_detil_siswa` VALUES ('398','355/086/66','0037604093','Syaiful Islam','L','Islam','5','Aktif','XI TKJ','','','Kedungsumur RT02/RW14 Jambearum Puger','','0');
INSERT INTO `view_detil_siswa` VALUES ('410','21787878','676687','Asep Keraton','L','Katolik','5','Aktif','XI TKJ','','usluk','','','5000');
INSERT INTO `view_detil_siswa` VALUES ('416','0002','12345678','Fauzan','L','Islam','5','Aktif','XI TKJ','','Setiyo','Sidoarjo','909090','10000');
INSERT INTO `view_detil_siswa` VALUES ('278','361/059/116','0031242223','Dewi Pitasari','P','Islam','6','Aktif','XI OTKP','','Jauhari','Dsn. Sukodadi RT.04/RW.01 Ds. Sraten ','6825233072661','100000');
INSERT INTO `view_detil_siswa` VALUES ('280','363/061/116','0047537539','Eka Dian Saputri','P','Islam','6','Lulus','XI OTKP','','','Dsn. Sukodadi RT.03/RW.02 Ds. Sraten ','','0');
INSERT INTO `view_detil_siswa` VALUES ('282','366/064/116','0036076018','Haliyatul Fitri','P','Islam','6','Lulus','XI OTKP','','HANIPAN','SRAMPON','','0');
INSERT INTO `view_detil_siswa` VALUES ('284','368/066/116','0036492698','Hillah Maulana','L','Islam','6','Lulus','XI OTKP','','','Dsn. Sukodadi RT.03/RW.02 Ds. Sraten ','','0');
INSERT INTO `view_detil_siswa` VALUES ('285','369/067/116','0045002559','Israhul Amalia','P','Islam','6','Lulus','XI OTKP','','','Dsn. Krajan RT.03/RW.03 Ds. Kedayunan','','0');
INSERT INTO `view_detil_siswa` VALUES ('286','370/068/116','0031890173','LISA NUR AYU GUNAWATI','P','Islam','6','Lulus','XI OTKP','','Sujarno','Sukodadi','','0');
INSERT INTO `view_detil_siswa` VALUES ('287','371/069/116','0023395015','Mirna Putri Uhrowi','P','Islam','6','Lulus','XI OTKP','','','Dsn. Sumberjeruk RT.03/RW.03 Ds. Tamanagung','','0');
INSERT INTO `view_detil_siswa` VALUES ('289','373/071/116','0043434098','Moh. Taqinaqi Khoirusima Yusuf','L','Islam','6','Lulus','XI OTKP','','','Dsn. Kejoyo RT.01/04 Ds. Tambong','','0');
INSERT INTO `view_detil_siswa` VALUES ('290','374/072/116','0039621557','Muhammad Hendrawan','L','Islam','6','Lulus','XI OTKP','','','Dsn. Krajan RT.04/RW.04 Ds. Sraten','','0');
INSERT INTO `view_detil_siswa` VALUES ('291','375/073/116','0036533502','Nafila Kurnia Alvianda','P','Islam','6','Lulus','XI OTKP','','','Dsn. Krajan RT.02/RW.01 Ds. Sukojati','','0');
INSERT INTO `view_detil_siswa` VALUES ('292','376/074/116','0037619590','Nining Arbailah','P','Islam','6','Lulus','XI OTKP','','','Dsn. Krajan RT.02/RW.07 Ds. Pakistaji','','0');
INSERT INTO `view_detil_siswa` VALUES ('293','377/075/116','3007000000','Nur Aini','P','Islam','6','Lulus','XI OTKP','','','Dsn. Gumukagung RT.03/RW.05 Ds. Gintangan','','0');
INSERT INTO `view_detil_siswa` VALUES ('294','378/076/116','0041817964','Puspa Rida Umma','P','Islam','6','Lulus','XI OTKP','','HUSNAN','JL. BANYU CINDIH','','0');
INSERT INTO `view_detil_siswa` VALUES ('295','380/078/116','0035612410','Seza Aprilia','P','Islam','6','Lulus','XI OTKP','','','Dsn. Krajan RT.02/RW.07 Ds. Gladag','','0');
INSERT INTO `view_detil_siswa` VALUES ('296','382/080/116','0044995733','Siti Wasilah','P','Islam','6','Lulus','XI OTKP','','','Dsn. Krajan RT.03/RW.02 Ds. Kaligung','','0');
INSERT INTO `view_detil_siswa` VALUES ('297','383/081/116','0035663108','Wahyudi Ismail','L','Islam','6','Lulus','XI OTKP','','','Dsn. Kedungsari RT.02/RW.01 Ds. Gintangan','','0');
INSERT INTO `view_detil_siswa` VALUES ('298','384/082/116','0043344704','Yeni Fitriani','P','Islam','6','Lulus','XI OTKP','','','Dsn Krajan RT.02/RW.01 Ds. Sraten','','0');
INSERT INTO `view_detil_siswa` VALUES ('370','313/039/110','0035134146','Arjun Rhamadani','L','Islam','6','Lulus','XI OTKP','','EKO SANTOSO','CEMPOKOSARI','','0');
INSERT INTO `view_detil_siswa` VALUES ('371','314/040/110','0036552923','Dewi Aisah','P','Islam','6','Lulus','XI OTKP','','','Krajan RT01/RW08 Dadapan Kabat','','0');
INSERT INTO `view_detil_siswa` VALUES ('372','315/041/110','0011769512','Fita Ratnaningtiyas','P','Islam','6','Lulus','XI OTKP','','MUHTADI','TUGUNG','','0');
INSERT INTO `view_detil_siswa` VALUES ('374','316/042/110','0022222882','Mita Agustin','P','Islam','6','Lulus','XI OTKP','','SURIYONO','SUMBERJOYO','','0');
INSERT INTO `view_detil_siswa` VALUES ('377','319/045/110','0025570684','Sintia Ayu Lestari','P','Islam','6','Lulus','XI OTKP','','','Sukosari','','0');
INSERT INTO `view_detil_siswa` VALUES ('302','376/049/110','0033302744','Diana Ulfa','P','Islam','8','Lulus','XII APH','','','','','450000');
INSERT INTO `view_detil_siswa` VALUES ('399','301/035/098','0014832615','Adelia P','P','Islam','8','Lulus','XII APH','','','Dsn.Sritanjung 001/006 Ds.Wirolegi Kec.sumbersari','','0');
INSERT INTO `view_detil_siswa` VALUES ('400','299/033/098','0019767038','Ahmad Syaifulloh','L','Islam','8','Lulus','XII APH','','PONIRAN','SUWALUH','','0');
INSERT INTO `view_detil_siswa` VALUES ('401','294/028/098','0012388010','Aprilia Prahesti Utami','L','Islam','8','Lulus','XII APH','','SUGIYONO','KRAJAN','','0');
INSERT INTO `view_detil_siswa` VALUES ('402','302/036/098','0034260832','Davit Agung Prayogo','L','Islam','8','Lulus','XII APH','','SUGIONO','SUWALUH','','0');
INSERT INTO `view_detil_siswa` VALUES ('403','295/029/098','0020824994','Eka Ulansari','P','Islam','8','Lulus','XII APH','','SAFRUDIN','rimpis','','0');
INSERT INTO `view_detil_siswa` VALUES ('404','296/030/098','0016430243','Faizatul Fitri','P','Islam','8','Lulus','XII APH','','MEIYANTO','Krajan','','0');
INSERT INTO `view_detil_siswa` VALUES ('405','311/033/098','0025558288','Faris Abid Muwaffaq','L','Islam','8','Lulus','XII APH','','ABDUL KARIM','BULUAGUNG SILIRAGUNG BANYUWANGI','','0');
INSERT INTO `view_detil_siswa` VALUES ('406','297/031/098','0009438458','Firman Bastomi','L','Islam','8','Lulus','XII APH','','BUSAINI','ABDUL BASAR','','0');
INSERT INTO `view_detil_siswa` VALUES ('407','300/034/098','0029658269','Medi Denes Saputra','L','Islam','8','Lulus','XII APH','','GATOT BAMBANG SUGIONO','BLANGKON','','45000');
INSERT INTO `view_detil_siswa` VALUES ('408','298/032/098','0028439399','Rika Supiyati','P','Islam','8','Lulus','XII APH','','Rohmad','Pendarungan','','0');
INSERT INTO `view_detil_siswa` VALUES ('412','7612641827','783585391','Ahmad Baihaqi','L','Islam','9','Lulus','X RPL','','Sudin Samsudin','Alamatnya','092507235','500000');

/*---------------------------------------------------------------
  TABLE: `view_laporan_bayar_bulanan`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `view_laporan_bayar_bulanan`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `view_laporan_bayar_bulanan` AS select `tagihan_bulanan`.`idTagihanBulanan` AS `idTagihanBulanan`,`tagihan_bulanan`.`idJenisBayar` AS `idJenisBayar`,`tagihan_bulanan`.`idSiswa` AS `idSiswa`,`tagihan_bulanan`.`idKelas` AS `idKelas`,`tagihan_bulanan`.`idBulan` AS `idBulan`,`tagihan_bulanan`.`jumlahBayar` AS `jumlahBayar`,`tagihan_bulanan`.`tglBayar` AS `tglBayar`,`tagihan_bulanan`.`tglUpdate` AS `tglUpdate`,`tagihan_bulanan`.`statusBayar` AS `statusBayar`,`jenis_bayar`.`idTahunAjaran` AS `idTahunAjaran`,`jenis_bayar`.`nmJenisBayar` AS `nmJenisBayar`,`tahun_ajaran`.`nmTahunAjaran` AS `nmTahunAjaran`,`siswa`.`nisSiswa` AS `nisSiswa`,`siswa`.`nmSiswa` AS `nmSiswa`,`kelas_siswa`.`nmKelas` AS `nmKelas`,`bulan`.`nmBulan` AS `nmBulan`,`bulan`.`urutan` AS `urutan`,`tagihan_bulanan`.`caraBayar` AS `caraBayar` from (((((`tagihan_bulanan` join `jenis_bayar` on((`tagihan_bulanan`.`idJenisBayar` = `jenis_bayar`.`idJenisBayar`))) join `tahun_ajaran` on((`jenis_bayar`.`idTahunAjaran` = `tahun_ajaran`.`idTahunAjaran`))) join `siswa` on((`tagihan_bulanan`.`idSiswa` = `siswa`.`idSiswa`))) join `kelas_siswa` on((`siswa`.`idKelas` = `kelas_siswa`.`idKelas`))) join `bulan` on((`tagihan_bulanan`.`idBulan` = `bulan`.`idBulan`)));
INSERT INTO `view_laporan_bayar_bulanan` VALUES   ('349','5','299','1','1','55000','2020-02-20 00:00:00','2020-02-20 12:12:12','1','4','DANA BULANAN','2019/2020','373/046/110','Amalia Ilmiah','X OTKP','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('350','5','299','1','2','55000','2020-02-20 00:00:00','2020-02-20 12:12:19','1','4','DANA BULANAN','2019/2020','373/046/110','Amalia Ilmiah','X OTKP','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('351','5','299','1','3','55000','2020-02-20 00:00:00','2020-02-20 12:13:03','1','4','DANA BULANAN','2019/2020','373/046/110','Amalia Ilmiah','X OTKP','Maret','9','Transfer');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('352','5','299','1','4','55000','2020-02-20 00:00:00','2020-02-20 15:15:50','1','4','DANA BULANAN','2019/2020','373/046/110','Amalia Ilmiah','X OTKP','April','10','Transfer');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('353','5','299','1','5','55000','2020-02-20 00:00:00','2020-02-20 15:15:53','1','4','DANA BULANAN','2019/2020','373/046/110','Amalia Ilmiah','X OTKP','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('354','5','299','1','6','55000','2020-02-20 00:00:00','2020-02-20 15:15:56','1','4','DANA BULANAN','2019/2020','373/046/110','Amalia Ilmiah','X OTKP','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('355','5','299','1','7','55000','2020-01-25 00:00:00','2020-01-25 22:02:41','1','4','DANA BULANAN','2019/2020','373/046/110','Amalia Ilmiah','X OTKP','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('356','5','299','1','8','55000','2020-01-30 00:00:00','2020-01-30 13:03:20','1','4','DANA BULANAN','2019/2020','373/046/110','Amalia Ilmiah','X OTKP','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('357','5','299','1','9','55000','2020-01-30 00:00:00','2020-01-30 13:03:23','1','4','DANA BULANAN','2019/2020','373/046/110','Amalia Ilmiah','X OTKP','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('358','5','299','1','10','55000','2020-02-18 00:00:00','2020-02-18 02:46:03','1','4','DANA BULANAN','2019/2020','373/046/110','Amalia Ilmiah','X OTKP','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('359','5','299','1','11','55000','2020-02-18 00:00:00','2020-02-18 02:46:06','1','4','DANA BULANAN','2019/2020','373/046/110','Amalia Ilmiah','X OTKP','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('360','5','299','1','12','55000','2020-02-20 00:00:00','2020-02-20 12:12:04','1','4','DANA BULANAN','2019/2020','373/046/110','Amalia Ilmiah','X OTKP','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('361','5','300','1','1','55000','2020-03-28 00:00:00','2020-03-28 23:09:21','1','4','DANA BULANAN','2019/2020','374/047/110','Anisa Tri Wahyuni','X OTKP','Januari','7','Transfer');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('362','5','300','1','2','55000','2020-05-11 00:00:00','2020-05-11 13:00:40','1','4','DANA BULANAN','2019/2020','374/047/110','Anisa Tri Wahyuni','X OTKP','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('363','5','300','1','3','55000','2020-05-12 00:00:00','2020-05-12 22:11:08','1','4','DANA BULANAN','2019/2020','374/047/110','Anisa Tri Wahyuni','X OTKP','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('364','5','300','1','4','55000','2020-05-12 00:00:00','2020-05-12 22:11:11','1','4','DANA BULANAN','2019/2020','374/047/110','Anisa Tri Wahyuni','X OTKP','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('365','5','300','1','5','55000','0000-00-00 00:00:00','2020-05-18 23:50:16','0','4','DANA BULANAN','2019/2020','374/047/110','Anisa Tri Wahyuni','X OTKP','Mei','11','');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('366','5','300','1','6','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','374/047/110','Anisa Tri Wahyuni','X OTKP','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('367','5','300','1','7','55000','2020-01-15 00:00:00','2020-01-15 20:37:08','1','4','DANA BULANAN','2019/2020','374/047/110','Anisa Tri Wahyuni','X OTKP','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('368','5','300','1','8','55000','2020-01-15 00:00:00','2020-01-15 20:37:21','1','4','DANA BULANAN','2019/2020','374/047/110','Anisa Tri Wahyuni','X OTKP','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('369','5','300','1','9','55000','2020-01-30 00:00:00','2020-01-30 14:33:52','1','4','DANA BULANAN','2019/2020','374/047/110','Anisa Tri Wahyuni','X OTKP','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('370','5','300','1','10','55000','2020-03-28 00:00:00','2020-03-28 23:09:02','1','4','DANA BULANAN','2019/2020','374/047/110','Anisa Tri Wahyuni','X OTKP','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('371','5','300','1','11','55000','2020-03-28 00:00:00','2020-03-28 23:09:06','1','4','DANA BULANAN','2019/2020','374/047/110','Anisa Tri Wahyuni','X OTKP','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('372','5','300','1','12','55000','2020-03-28 00:00:00','2020-03-28 23:09:12','1','4','DANA BULANAN','2019/2020','374/047/110','Anisa Tri Wahyuni','X OTKP','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('397','5','304','1','1','55000','2020-06-21 00:00:00','2020-06-21 09:40:10','1','4','DANA BULANAN','2019/2020','378/051/110','Dini Asmawati','X OTKP','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('398','5','304','1','2','55000','2020-05-03 00:00:00','2020-05-03 04:46:24','1','4','DANA BULANAN','2019/2020','378/051/110','Dini Asmawati','X OTKP','Februari','8','Transfer');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('399','5','304','1','3','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','378/051/110','Dini Asmawati','X OTKP','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('400','5','304','1','4','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','378/051/110','Dini Asmawati','X OTKP','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('401','5','304','1','5','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','378/051/110','Dini Asmawati','X OTKP','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('402','5','304','1','6','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','378/051/110','Dini Asmawati','X OTKP','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('403','5','304','1','7','55000','2020-03-04 00:00:00','2020-03-04 11:11:08','1','4','DANA BULANAN','2019/2020','378/051/110','Dini Asmawati','X OTKP','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('404','5','304','1','8','55000','2020-03-25 00:00:00','2020-03-25 22:24:58','1','4','DANA BULANAN','2019/2020','378/051/110','Dini Asmawati','X OTKP','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('405','5','304','1','9','55000','2020-03-25 00:00:00','2020-03-25 22:25:02','1','4','DANA BULANAN','2019/2020','378/051/110','Dini Asmawati','X OTKP','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('406','5','304','1','10','55000','2020-03-25 00:00:00','2020-03-25 22:25:05','1','4','DANA BULANAN','2019/2020','378/051/110','Dini Asmawati','X OTKP','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('407','5','304','1','11','55000','2020-03-25 00:00:00','2020-03-25 22:25:08','1','4','DANA BULANAN','2019/2020','378/051/110','Dini Asmawati','X OTKP','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('408','5','304','1','12','55000','2020-05-03 00:00:00','2020-05-03 04:45:57','1','4','DANA BULANAN','2019/2020','378/051/110','Dini Asmawati','X OTKP','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('409','5','305','1','1','55000','2020-04-08 00:00:00','2020-04-08 19:27:33','1','4','DANA BULANAN','2019/2020','379/052/110','Dini Putri Hidayah','X OTKP','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('410','5','305','1','2','55000','2020-04-08 00:00:00','2020-04-08 19:27:43','1','4','DANA BULANAN','2019/2020','379/052/110','Dini Putri Hidayah','X OTKP','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('411','5','305','1','3','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','379/052/110','Dini Putri Hidayah','X OTKP','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('412','5','305','1','4','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','379/052/110','Dini Putri Hidayah','X OTKP','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('413','5','305','1','5','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','379/052/110','Dini Putri Hidayah','X OTKP','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('414','5','305','1','6','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','379/052/110','Dini Putri Hidayah','X OTKP','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('415','5','305','1','7','55000','2020-02-11 00:00:00','2020-02-11 13:38:51','1','4','DANA BULANAN','2019/2020','379/052/110','Dini Putri Hidayah','X OTKP','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('416','5','305','1','8','55000','2020-03-11 00:00:00','2020-03-11 01:25:12','1','4','DANA BULANAN','2019/2020','379/052/110','Dini Putri Hidayah','X OTKP','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('417','5','305','1','9','55000','2020-03-15 00:00:00','2020-03-15 22:51:25','1','4','DANA BULANAN','2019/2020','379/052/110','Dini Putri Hidayah','X OTKP','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('418','5','305','1','10','55000','2020-03-15 00:00:00','2020-03-15 22:51:30','1','4','DANA BULANAN','2019/2020','379/052/110','Dini Putri Hidayah','X OTKP','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('419','5','305','1','11','55000','2020-04-01 00:00:00','2020-04-01 14:54:07','1','4','DANA BULANAN','2019/2020','379/052/110','Dini Putri Hidayah','X OTKP','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('420','5','305','1','12','55000','2020-03-24 00:00:00','2020-03-24 09:48:24','1','4','DANA BULANAN','2019/2020','379/052/110','Dini Putri Hidayah','X OTKP','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('421','5','306','1','1','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','380/053/110','Eka Agustina Rahayu','X OTKP','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('422','5','306','1','2','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','380/053/110','Eka Agustina Rahayu','X OTKP','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('423','5','306','1','3','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','380/053/110','Eka Agustina Rahayu','X OTKP','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('424','5','306','1','4','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','380/053/110','Eka Agustina Rahayu','X OTKP','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('425','5','306','1','5','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','380/053/110','Eka Agustina Rahayu','X OTKP','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('426','5','306','1','6','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','380/053/110','Eka Agustina Rahayu','X OTKP','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('427','5','306','1','7','55000','2020-03-25 00:00:00','2020-03-25 12:56:51','1','4','DANA BULANAN','2019/2020','380/053/110','Eka Agustina Rahayu','X OTKP','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('428','5','306','1','8','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','380/053/110','Eka Agustina Rahayu','X OTKP','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('429','5','306','1','9','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','380/053/110','Eka Agustina Rahayu','X OTKP','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('430','5','306','1','10','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','380/053/110','Eka Agustina Rahayu','X OTKP','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('431','5','306','1','11','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','380/053/110','Eka Agustina Rahayu','X OTKP','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('432','5','306','1','12','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','380/053/110','Eka Agustina Rahayu','X OTKP','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('433','5','307','1','1','55000','2020-04-13 00:00:00','2020-04-13 20:11:46','1','4','DANA BULANAN','2019/2020','381/054/110','Hedi Saputra','X OTKP','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('434','5','307','1','2','55000','2020-04-13 00:00:00','2020-04-13 20:12:35','1','4','DANA BULANAN','2019/2020','381/054/110','Hedi Saputra','X OTKP','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('435','5','307','1','3','55000','2020-04-13 00:00:00','2020-04-13 20:12:30','1','4','DANA BULANAN','2019/2020','381/054/110','Hedi Saputra','X OTKP','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('436','5','307','1','4','55000','2020-04-13 00:00:00','2020-04-13 20:12:24','1','4','DANA BULANAN','2019/2020','381/054/110','Hedi Saputra','X OTKP','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('437','5','307','1','5','55000','2020-04-13 00:00:00','2020-04-13 20:12:18','1','4','DANA BULANAN','2019/2020','381/054/110','Hedi Saputra','X OTKP','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('438','5','307','1','6','55000','2020-04-13 00:00:00','2020-04-13 20:12:12','1','4','DANA BULANAN','2019/2020','381/054/110','Hedi Saputra','X OTKP','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('439','5','307','1','7','55000','2020-02-12 00:00:00','2020-02-12 09:16:20','1','4','DANA BULANAN','2019/2020','381/054/110','Hedi Saputra','X OTKP','Juli','1','Transfer');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('440','5','307','1','8','55000','2020-02-12 00:00:00','2020-02-12 09:16:50','1','4','DANA BULANAN','2019/2020','381/054/110','Hedi Saputra','X OTKP','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('441','5','307','1','9','55000','2020-02-12 00:00:00','2020-02-12 09:17:03','1','4','DANA BULANAN','2019/2020','381/054/110','Hedi Saputra','X OTKP','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('442','5','307','1','10','55000','2020-02-04 00:00:00','2020-02-29 21:29:23','1','4','DANA BULANAN','2019/2020','381/054/110','Hedi Saputra','X OTKP','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('443','5','307','1','11','55000','2020-02-29 00:00:00','2020-02-29 21:29:30','1','4','DANA BULANAN','2019/2020','381/054/110','Hedi Saputra','X OTKP','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('444','5','307','1','12','55000','2020-02-29 00:00:00','2020-02-29 21:29:35','1','4','DANA BULANAN','2019/2020','381/054/110','Hedi Saputra','X OTKP','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('445','5','308','1','1','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','382/055/110','Indah Tri Wulandari','X OTKP','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('446','5','308','1','2','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','382/055/110','Indah Tri Wulandari','X OTKP','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('447','5','308','1','3','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','382/055/110','Indah Tri Wulandari','X OTKP','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('448','5','308','1','4','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','382/055/110','Indah Tri Wulandari','X OTKP','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('449','5','308','1','5','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','382/055/110','Indah Tri Wulandari','X OTKP','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('450','5','308','1','6','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','382/055/110','Indah Tri Wulandari','X OTKP','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('451','5','308','1','7','55000','2020-01-21 00:00:00','2020-01-21 04:04:07','1','4','DANA BULANAN','2019/2020','382/055/110','Indah Tri Wulandari','X OTKP','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('452','5','308','1','8','55000','2020-01-23 00:00:00','2020-01-23 21:21:42','1','4','DANA BULANAN','2019/2020','382/055/110','Indah Tri Wulandari','X OTKP','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('453','5','308','1','9','55000','2020-03-11 00:00:00','2020-03-11 13:47:03','1','4','DANA BULANAN','2019/2020','382/055/110','Indah Tri Wulandari','X OTKP','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('454','5','308','1','10','55000','2020-05-12 00:00:00','2020-05-12 22:38:21','1','4','DANA BULANAN','2019/2020','382/055/110','Indah Tri Wulandari','X OTKP','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('455','5','308','1','11','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','382/055/110','Indah Tri Wulandari','X OTKP','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('456','5','308','1','12','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','382/055/110','Indah Tri Wulandari','X OTKP','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('457','5','309','1','1','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','383/056/110','Istikomah','X OTKP','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('458','5','309','1','2','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','383/056/110','Istikomah','X OTKP','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('459','5','309','1','3','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','383/056/110','Istikomah','X OTKP','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('460','5','309','1','4','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','383/056/110','Istikomah','X OTKP','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('461','5','309','1','5','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','383/056/110','Istikomah','X OTKP','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('462','5','309','1','6','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','383/056/110','Istikomah','X OTKP','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('463','5','309','1','7','55000','2020-01-30 00:00:00','2020-01-30 12:13:30','1','4','DANA BULANAN','2019/2020','383/056/110','Istikomah','X OTKP','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('464','5','309','1','8','55000','2020-01-30 00:00:00','2020-01-30 12:13:32','1','4','DANA BULANAN','2019/2020','383/056/110','Istikomah','X OTKP','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('465','5','309','1','9','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','383/056/110','Istikomah','X OTKP','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('466','5','309','1','10','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','383/056/110','Istikomah','X OTKP','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('467','5','309','1','11','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','383/056/110','Istikomah','X OTKP','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('468','5','309','1','12','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','383/056/110','Istikomah','X OTKP','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('481','5','311','1','1','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','385/058/110','Maulida Yuli Fitri','X OTKP','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('482','5','311','1','2','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','385/058/110','Maulida Yuli Fitri','X OTKP','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('483','5','311','1','3','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','385/058/110','Maulida Yuli Fitri','X OTKP','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('484','5','311','1','4','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','385/058/110','Maulida Yuli Fitri','X OTKP','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('485','5','311','1','5','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','385/058/110','Maulida Yuli Fitri','X OTKP','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('486','5','311','1','6','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','385/058/110','Maulida Yuli Fitri','X OTKP','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('487','5','311','1','7','55000','2020-05-11 00:00:00','2020-05-11 12:37:17','1','4','DANA BULANAN','2019/2020','385/058/110','Maulida Yuli Fitri','X OTKP','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('488','5','311','1','8','55000','2020-06-10 00:00:00','2020-06-10 12:33:50','1','4','DANA BULANAN','2019/2020','385/058/110','Maulida Yuli Fitri','X OTKP','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('489','5','311','1','9','55000','2020-06-10 00:00:00','2020-06-10 12:34:01','1','4','DANA BULANAN','2019/2020','385/058/110','Maulida Yuli Fitri','X OTKP','September','3','Transfer');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('490','5','311','1','10','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','385/058/110','Maulida Yuli Fitri','X OTKP','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('491','5','311','1','11','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','385/058/110','Maulida Yuli Fitri','X OTKP','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('492','5','311','1','12','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','385/058/110','Maulida Yuli Fitri','X OTKP','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('505','5','313','1','1','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','396/060/110','Nadifatul Insiyah','X OTKP','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('506','5','313','1','2','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','396/060/110','Nadifatul Insiyah','X OTKP','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('507','5','313','1','3','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','396/060/110','Nadifatul Insiyah','X OTKP','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('508','5','313','1','4','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','396/060/110','Nadifatul Insiyah','X OTKP','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('509','5','313','1','5','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','396/060/110','Nadifatul Insiyah','X OTKP','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('510','5','313','1','6','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','396/060/110','Nadifatul Insiyah','X OTKP','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('511','5','313','1','7','55000','0000-00-00 00:00:00','2020-04-13 21:47:30','0','4','DANA BULANAN','2019/2020','396/060/110','Nadifatul Insiyah','X OTKP','Juli','1','');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('512','5','313','1','8','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','396/060/110','Nadifatul Insiyah','X OTKP','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('513','5','313','1','9','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','396/060/110','Nadifatul Insiyah','X OTKP','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('514','5','313','1','10','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','396/060/110','Nadifatul Insiyah','X OTKP','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('515','5','313','1','11','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','396/060/110','Nadifatul Insiyah','X OTKP','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('516','5','313','1','12','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','396/060/110','Nadifatul Insiyah','X OTKP','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('517','5','314','1','1','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','397/061/110','Nuris Soleha','X OTKP','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('518','5','314','1','2','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','397/061/110','Nuris Soleha','X OTKP','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('519','5','314','1','3','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','397/061/110','Nuris Soleha','X OTKP','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('520','5','314','1','4','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','397/061/110','Nuris Soleha','X OTKP','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('521','5','314','1','5','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','397/061/110','Nuris Soleha','X OTKP','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('522','5','314','1','6','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','397/061/110','Nuris Soleha','X OTKP','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('523','5','314','1','7','55000','2020-03-04 00:00:00','2020-03-04 13:51:50','1','4','DANA BULANAN','2019/2020','397/061/110','Nuris Soleha','X OTKP','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('524','5','314','1','8','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','397/061/110','Nuris Soleha','X OTKP','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('525','5','314','1','9','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','397/061/110','Nuris Soleha','X OTKP','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('526','5','314','1','10','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','397/061/110','Nuris Soleha','X OTKP','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('527','5','314','1','11','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','397/061/110','Nuris Soleha','X OTKP','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('528','5','314','1','12','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','397/061/110','Nuris Soleha','X OTKP','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('529','5','316','1','1','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','399/063/110','Roekhatul Habibah','X OTKP','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('530','5','316','1','2','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','399/063/110','Roekhatul Habibah','X OTKP','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('531','5','316','1','3','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','399/063/110','Roekhatul Habibah','X OTKP','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('532','5','316','1','4','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','399/063/110','Roekhatul Habibah','X OTKP','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('533','5','316','1','5','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','399/063/110','Roekhatul Habibah','X OTKP','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('534','5','316','1','6','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','399/063/110','Roekhatul Habibah','X OTKP','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('535','5','316','1','7','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','399/063/110','Roekhatul Habibah','X OTKP','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('536','5','316','1','8','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','399/063/110','Roekhatul Habibah','X OTKP','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('537','5','316','1','9','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','399/063/110','Roekhatul Habibah','X OTKP','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('538','5','316','1','10','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','399/063/110','Roekhatul Habibah','X OTKP','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('539','5','316','1','11','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','399/063/110','Roekhatul Habibah','X OTKP','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('540','5','316','1','12','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','399/063/110','Roekhatul Habibah','X OTKP','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('541','5','317','1','1','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','400/064/110','Ulfa Hanin Khumairoh','X OTKP','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('542','5','317','1','2','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','400/064/110','Ulfa Hanin Khumairoh','X OTKP','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('543','5','317','1','3','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','400/064/110','Ulfa Hanin Khumairoh','X OTKP','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('544','5','317','1','4','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','400/064/110','Ulfa Hanin Khumairoh','X OTKP','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('545','5','317','1','5','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','400/064/110','Ulfa Hanin Khumairoh','X OTKP','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('546','5','317','1','6','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','400/064/110','Ulfa Hanin Khumairoh','X OTKP','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('547','5','317','1','7','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','400/064/110','Ulfa Hanin Khumairoh','X OTKP','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('548','5','317','1','8','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','400/064/110','Ulfa Hanin Khumairoh','X OTKP','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('549','5','317','1','9','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','400/064/110','Ulfa Hanin Khumairoh','X OTKP','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('550','5','317','1','10','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','400/064/110','Ulfa Hanin Khumairoh','X OTKP','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('551','5','317','1','11','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','400/064/110','Ulfa Hanin Khumairoh','X OTKP','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('552','5','317','1','12','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','400/064/110','Ulfa Hanin Khumairoh','X OTKP','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('493','5','312','1','1','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','395/059/110','Mira Agustin','X APH','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('494','5','312','1','2','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','395/059/110','Mira Agustin','X APH','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('495','5','312','1','3','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','395/059/110','Mira Agustin','X APH','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('496','5','312','1','4','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','395/059/110','Mira Agustin','X APH','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('497','5','312','1','5','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','395/059/110','Mira Agustin','X APH','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('498','5','312','1','6','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','395/059/110','Mira Agustin','X APH','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('499','5','312','1','7','55000','2020-05-03 00:00:00','2020-05-03 13:34:35','1','4','DANA BULANAN','2019/2020','395/059/110','Mira Agustin','X APH','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('500','5','312','1','8','55000','2020-05-03 00:00:00','2020-05-03 13:34:54','1','4','DANA BULANAN','2019/2020','395/059/110','Mira Agustin','X APH','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('501','5','312','1','9','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','395/059/110','Mira Agustin','X APH','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('502','5','312','1','10','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','395/059/110','Mira Agustin','X APH','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('503','5','312','1','11','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','395/059/110','Mira Agustin','X APH','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('504','5','312','1','12','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','395/059/110','Mira Agustin','X APH','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('757','5','318','4','1','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','401/087/66','Abd. Rohim','X TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('758','5','318','4','2','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','401/087/66','Abd. Rohim','X TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('759','5','318','4','3','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','401/087/66','Abd. Rohim','X TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('760','5','318','4','4','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','401/087/66','Abd. Rohim','X TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('761','5','318','4','5','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','401/087/66','Abd. Rohim','X TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('762','5','318','4','6','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','401/087/66','Abd. Rohim','X TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('763','5','318','4','7','55000','2020-06-07 00:00:00','2020-06-07 15:47:34','1','4','DANA BULANAN','2019/2020','401/087/66','Abd. Rohim','X TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('764','5','318','4','8','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','401/087/66','Abd. Rohim','X TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('765','5','318','4','9','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','401/087/66','Abd. Rohim','X TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('766','5','318','4','10','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','401/087/66','Abd. Rohim','X TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('767','5','318','4','11','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','401/087/66','Abd. Rohim','X TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('768','5','318','4','12','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','401/087/66','Abd. Rohim','X TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('385','5','303','1','1','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','377/050/110','Dimas Viktor Risman','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('386','5','303','1','2','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','377/050/110','Dimas Viktor Risman','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('387','5','303','1','3','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','377/050/110','Dimas Viktor Risman','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('388','5','303','1','4','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','377/050/110','Dimas Viktor Risman','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('389','5','303','1','5','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','377/050/110','Dimas Viktor Risman','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('390','5','303','1','6','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','377/050/110','Dimas Viktor Risman','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('391','5','303','1','7','55000','0000-00-00 00:00:00','2020-01-22 23:49:21','0','4','DANA BULANAN','2019/2020','377/050/110','Dimas Viktor Risman','XI TKJ','Juli','1','');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('392','5','303','1','8','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','377/050/110','Dimas Viktor Risman','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('393','5','303','1','9','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','377/050/110','Dimas Viktor Risman','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('394','5','303','1','10','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','377/050/110','Dimas Viktor Risman','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('395','5','303','1','11','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','377/050/110','Dimas Viktor Risman','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('396','5','303','1','12','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','377/050/110','Dimas Viktor Risman','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('769','5','319','4','1','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','402/088/66','Abdul Latip','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('770','5','319','4','2','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','402/088/66','Abdul Latip','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('771','5','319','4','3','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','402/088/66','Abdul Latip','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('772','5','319','4','4','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','402/088/66','Abdul Latip','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('773','5','319','4','5','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','402/088/66','Abdul Latip','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('774','5','319','4','6','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','402/088/66','Abdul Latip','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('775','5','319','4','7','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','402/088/66','Abdul Latip','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('776','5','319','4','8','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','402/088/66','Abdul Latip','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('777','5','319','4','9','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','402/088/66','Abdul Latip','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('778','5','319','4','10','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','402/088/66','Abdul Latip','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('779','5','319','4','11','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','402/088/66','Abdul Latip','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('780','5','319','4','12','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','402/088/66','Abdul Latip','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('781','5','320','4','1','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','403/089/66','Abdul Rohman','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('782','5','320','4','2','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','403/089/66','Abdul Rohman','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('783','5','320','4','3','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','403/089/66','Abdul Rohman','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('784','5','320','4','4','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','403/089/66','Abdul Rohman','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('785','5','320','4','5','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','403/089/66','Abdul Rohman','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('786','5','320','4','6','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','403/089/66','Abdul Rohman','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('787','5','320','4','7','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','403/089/66','Abdul Rohman','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('788','5','320','4','8','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','403/089/66','Abdul Rohman','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('789','5','320','4','9','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','403/089/66','Abdul Rohman','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('790','5','320','4','10','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','403/089/66','Abdul Rohman','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('791','5','320','4','11','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','403/089/66','Abdul Rohman','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('792','5','320','4','12','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','403/089/66','Abdul Rohman','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('793','5','321','4','1','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','404/090/66','Ahmad Balya Irsyaduddin','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('794','5','321','4','2','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','404/090/66','Ahmad Balya Irsyaduddin','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('795','5','321','4','3','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','404/090/66','Ahmad Balya Irsyaduddin','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('796','5','321','4','4','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','404/090/66','Ahmad Balya Irsyaduddin','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('797','5','321','4','5','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','404/090/66','Ahmad Balya Irsyaduddin','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('798','5','321','4','6','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','404/090/66','Ahmad Balya Irsyaduddin','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('799','5','321','4','7','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','404/090/66','Ahmad Balya Irsyaduddin','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('800','5','321','4','8','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','404/090/66','Ahmad Balya Irsyaduddin','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('801','5','321','4','9','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','404/090/66','Ahmad Balya Irsyaduddin','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('802','5','321','4','10','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','404/090/66','Ahmad Balya Irsyaduddin','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('803','5','321','4','11','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','404/090/66','Ahmad Balya Irsyaduddin','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('804','5','321','4','12','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','404/090/66','Ahmad Balya Irsyaduddin','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('805','5','322','4','1','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','405/091/66','Ahmad Fathurrohman','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('806','5','322','4','2','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','405/091/66','Ahmad Fathurrohman','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('807','5','322','4','3','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','405/091/66','Ahmad Fathurrohman','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('808','5','322','4','4','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','405/091/66','Ahmad Fathurrohman','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('809','5','322','4','5','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','405/091/66','Ahmad Fathurrohman','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('810','5','322','4','6','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','405/091/66','Ahmad Fathurrohman','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('811','5','322','4','7','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','405/091/66','Ahmad Fathurrohman','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('812','5','322','4','8','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','405/091/66','Ahmad Fathurrohman','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('813','5','322','4','9','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','405/091/66','Ahmad Fathurrohman','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('814','5','322','4','10','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','405/091/66','Ahmad Fathurrohman','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('815','5','322','4','11','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','405/091/66','Ahmad Fathurrohman','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('816','5','322','4','12','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','405/091/66','Ahmad Fathurrohman','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('817','5','323','4','1','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','406/092/66','Ahmad Taufiqur Rohman','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('818','5','323','4','2','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','406/092/66','Ahmad Taufiqur Rohman','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('819','5','323','4','3','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','406/092/66','Ahmad Taufiqur Rohman','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('820','5','323','4','4','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','406/092/66','Ahmad Taufiqur Rohman','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('821','5','323','4','5','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','406/092/66','Ahmad Taufiqur Rohman','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('822','5','323','4','6','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','406/092/66','Ahmad Taufiqur Rohman','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('823','5','323','4','7','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','406/092/66','Ahmad Taufiqur Rohman','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('824','5','323','4','8','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','406/092/66','Ahmad Taufiqur Rohman','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('825','5','323','4','9','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','406/092/66','Ahmad Taufiqur Rohman','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('826','5','323','4','10','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','406/092/66','Ahmad Taufiqur Rohman','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('827','5','323','4','11','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','406/092/66','Ahmad Taufiqur Rohman','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('828','5','323','4','12','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','406/092/66','Ahmad Taufiqur Rohman','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('829','5','324','4','1','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','317/043/66','Andri Kristina Putra','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('830','5','324','4','2','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','317/043/66','Andri Kristina Putra','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('831','5','324','4','3','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','317/043/66','Andri Kristina Putra','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('832','5','324','4','4','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','317/043/66','Andri Kristina Putra','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('833','5','324','4','5','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','317/043/66','Andri Kristina Putra','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('834','5','324','4','6','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','317/043/66','Andri Kristina Putra','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('835','5','324','4','7','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','317/043/66','Andri Kristina Putra','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('836','5','324','4','8','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','317/043/66','Andri Kristina Putra','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('837','5','324','4','9','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','317/043/66','Andri Kristina Putra','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('838','5','324','4','10','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','317/043/66','Andri Kristina Putra','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('839','5','324','4','11','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','317/043/66','Andri Kristina Putra','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('840','5','324','4','12','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','317/043/66','Andri Kristina Putra','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('841','5','325','4','1','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','408/094/66','Ayu Uut Wulandari','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('842','5','325','4','2','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','408/094/66','Ayu Uut Wulandari','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('843','5','325','4','3','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','408/094/66','Ayu Uut Wulandari','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('844','5','325','4','4','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','408/094/66','Ayu Uut Wulandari','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('845','5','325','4','5','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','408/094/66','Ayu Uut Wulandari','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('846','5','325','4','6','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','408/094/66','Ayu Uut Wulandari','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('847','5','325','4','7','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','408/094/66','Ayu Uut Wulandari','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('848','5','325','4','8','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','408/094/66','Ayu Uut Wulandari','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('849','5','325','4','9','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','408/094/66','Ayu Uut Wulandari','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('850','5','325','4','10','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','408/094/66','Ayu Uut Wulandari','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('851','5','325','4','11','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','408/094/66','Ayu Uut Wulandari','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('852','5','325','4','12','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','408/094/66','Ayu Uut Wulandari','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('853','5','326','4','1','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','428/113/66','Dina Mukarromah','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('854','5','326','4','2','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','428/113/66','Dina Mukarromah','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('855','5','326','4','3','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','428/113/66','Dina Mukarromah','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('856','5','326','4','4','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','428/113/66','Dina Mukarromah','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('857','5','326','4','5','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','428/113/66','Dina Mukarromah','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('858','5','326','4','6','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','428/113/66','Dina Mukarromah','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('859','5','326','4','7','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','428/113/66','Dina Mukarromah','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('860','5','326','4','8','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','428/113/66','Dina Mukarromah','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('861','5','326','4','9','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','428/113/66','Dina Mukarromah','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('862','5','326','4','10','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','428/113/66','Dina Mukarromah','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('863','5','326','4','11','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','428/113/66','Dina Mukarromah','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('864','5','326','4','12','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','428/113/66','Dina Mukarromah','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('865','5','327','4','1','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','429/114/66','Dini Mukarromah','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('866','5','327','4','2','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','429/114/66','Dini Mukarromah','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('867','5','327','4','3','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','429/114/66','Dini Mukarromah','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('868','5','327','4','4','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','429/114/66','Dini Mukarromah','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('869','5','327','4','5','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','429/114/66','Dini Mukarromah','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('870','5','327','4','6','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','429/114/66','Dini Mukarromah','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('871','5','327','4','7','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','429/114/66','Dini Mukarromah','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('872','5','327','4','8','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','429/114/66','Dini Mukarromah','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('873','5','327','4','9','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','429/114/66','Dini Mukarromah','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('874','5','327','4','10','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','429/114/66','Dini Mukarromah','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('875','5','327','4','11','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','429/114/66','Dini Mukarromah','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('876','5','327','4','12','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','429/114/66','Dini Mukarromah','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('877','5','328','4','1','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','409/095/66','ERVINA GUSMIARNI','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('878','5','328','4','2','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','409/095/66','ERVINA GUSMIARNI','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('879','5','328','4','3','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','409/095/66','ERVINA GUSMIARNI','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('880','5','328','4','4','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','409/095/66','ERVINA GUSMIARNI','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('881','5','328','4','5','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','409/095/66','ERVINA GUSMIARNI','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('882','5','328','4','6','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','409/095/66','ERVINA GUSMIARNI','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('883','5','328','4','7','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','409/095/66','ERVINA GUSMIARNI','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('884','5','328','4','8','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','409/095/66','ERVINA GUSMIARNI','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('885','5','328','4','9','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','409/095/66','ERVINA GUSMIARNI','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('886','5','328','4','10','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','409/095/66','ERVINA GUSMIARNI','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('887','5','328','4','11','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','409/095/66','ERVINA GUSMIARNI','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('888','5','328','4','12','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','409/095/66','ERVINA GUSMIARNI','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('889','5','330','4','1','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','411/097/66','Hayatun Thoyyibah','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('890','5','330','4','2','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','411/097/66','Hayatun Thoyyibah','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('891','5','330','4','3','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','411/097/66','Hayatun Thoyyibah','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('892','5','330','4','4','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','411/097/66','Hayatun Thoyyibah','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('893','5','330','4','5','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','411/097/66','Hayatun Thoyyibah','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('894','5','330','4','6','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','411/097/66','Hayatun Thoyyibah','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('895','5','330','4','7','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','411/097/66','Hayatun Thoyyibah','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('896','5','330','4','8','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','411/097/66','Hayatun Thoyyibah','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('897','5','330','4','9','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','411/097/66','Hayatun Thoyyibah','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('898','5','330','4','10','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','411/097/66','Hayatun Thoyyibah','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('899','5','330','4','11','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','411/097/66','Hayatun Thoyyibah','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('900','5','330','4','12','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','411/097/66','Hayatun Thoyyibah','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('901','5','331','4','1','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','412/098/66','Imam Mustofa','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('902','5','331','4','2','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','412/098/66','Imam Mustofa','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('903','5','331','4','3','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','412/098/66','Imam Mustofa','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('904','5','331','4','4','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','412/098/66','Imam Mustofa','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('905','5','331','4','5','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','412/098/66','Imam Mustofa','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('906','5','331','4','6','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','412/098/66','Imam Mustofa','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('907','5','331','4','7','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','412/098/66','Imam Mustofa','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('908','5','331','4','8','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','412/098/66','Imam Mustofa','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('909','5','331','4','9','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','412/098/66','Imam Mustofa','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('910','5','331','4','10','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','412/098/66','Imam Mustofa','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('911','5','331','4','11','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','412/098/66','Imam Mustofa','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('912','5','331','4','12','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','412/098/66','Imam Mustofa','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('913','5','332','4','1','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','413/099/66','Ismia Umul Azam','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('914','5','332','4','2','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','413/099/66','Ismia Umul Azam','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('915','5','332','4','3','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','413/099/66','Ismia Umul Azam','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('916','5','332','4','4','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','413/099/66','Ismia Umul Azam','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('917','5','332','4','5','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','413/099/66','Ismia Umul Azam','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('918','5','332','4','6','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','413/099/66','Ismia Umul Azam','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('919','5','332','4','7','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','413/099/66','Ismia Umul Azam','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('920','5','332','4','8','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','413/099/66','Ismia Umul Azam','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('921','5','332','4','9','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','413/099/66','Ismia Umul Azam','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('922','5','332','4','10','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','413/099/66','Ismia Umul Azam','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('923','5','332','4','11','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','413/099/66','Ismia Umul Azam','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('924','5','332','4','12','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','413/099/66','Ismia Umul Azam','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('925','5','333','4','1','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','414/100/66','Kartika Trisna Devi','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('926','5','333','4','2','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','414/100/66','Kartika Trisna Devi','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('927','5','333','4','3','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','414/100/66','Kartika Trisna Devi','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('928','5','333','4','4','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','414/100/66','Kartika Trisna Devi','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('929','5','333','4','5','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','414/100/66','Kartika Trisna Devi','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('930','5','333','4','6','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','414/100/66','Kartika Trisna Devi','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('931','5','333','4','7','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','414/100/66','Kartika Trisna Devi','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('932','5','333','4','8','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','414/100/66','Kartika Trisna Devi','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('933','5','333','4','9','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','414/100/66','Kartika Trisna Devi','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('934','5','333','4','10','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','414/100/66','Kartika Trisna Devi','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('935','5','333','4','11','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','414/100/66','Kartika Trisna Devi','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('936','5','333','4','12','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','414/100/66','Kartika Trisna Devi','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('937','5','334','4','1','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','415/101/66','M. Azwar Anas','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('938','5','334','4','2','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','415/101/66','M. Azwar Anas','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('939','5','334','4','3','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','415/101/66','M. Azwar Anas','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('940','5','334','4','4','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','415/101/66','M. Azwar Anas','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('941','5','334','4','5','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','415/101/66','M. Azwar Anas','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('942','5','334','4','6','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','415/101/66','M. Azwar Anas','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('943','5','334','4','7','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','415/101/66','M. Azwar Anas','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('944','5','334','4','8','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','415/101/66','M. Azwar Anas','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('945','5','334','4','9','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','415/101/66','M. Azwar Anas','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('946','5','334','4','10','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','415/101/66','M. Azwar Anas','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('947','5','334','4','11','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','415/101/66','M. Azwar Anas','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('948','5','334','4','12','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','415/101/66','M. Azwar Anas','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('949','5','335','4','1','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','416/102/66','Mas Hilmi Mubarrok','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('950','5','335','4','2','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','416/102/66','Mas Hilmi Mubarrok','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('951','5','335','4','3','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','416/102/66','Mas Hilmi Mubarrok','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('952','5','335','4','4','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','416/102/66','Mas Hilmi Mubarrok','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('953','5','335','4','5','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','416/102/66','Mas Hilmi Mubarrok','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('954','5','335','4','6','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','416/102/66','Mas Hilmi Mubarrok','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('955','5','335','4','7','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','416/102/66','Mas Hilmi Mubarrok','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('956','5','335','4','8','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','416/102/66','Mas Hilmi Mubarrok','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('957','5','335','4','9','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','416/102/66','Mas Hilmi Mubarrok','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('958','5','335','4','10','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','416/102/66','Mas Hilmi Mubarrok','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('959','5','335','4','11','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','416/102/66','Mas Hilmi Mubarrok','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('960','5','335','4','12','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','416/102/66','Mas Hilmi Mubarrok','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('961','5','336','4','1','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','417/103/66','Moh. Fikri Andriansyah','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('962','5','336','4','2','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','417/103/66','Moh. Fikri Andriansyah','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('963','5','336','4','3','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','417/103/66','Moh. Fikri Andriansyah','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('964','5','336','4','4','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','417/103/66','Moh. Fikri Andriansyah','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('965','5','336','4','5','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','417/103/66','Moh. Fikri Andriansyah','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('966','5','336','4','6','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','417/103/66','Moh. Fikri Andriansyah','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('967','5','336','4','7','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','417/103/66','Moh. Fikri Andriansyah','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('968','5','336','4','8','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','417/103/66','Moh. Fikri Andriansyah','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('969','5','336','4','9','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','417/103/66','Moh. Fikri Andriansyah','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('970','5','336','4','10','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','417/103/66','Moh. Fikri Andriansyah','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('971','5','336','4','11','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','417/103/66','Moh. Fikri Andriansyah','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('972','5','336','4','12','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','417/103/66','Moh. Fikri Andriansyah','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('973','5','337','4','1','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','419/105/66','Nanang Bahroji','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('974','5','337','4','2','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','419/105/66','Nanang Bahroji','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('975','5','337','4','3','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','419/105/66','Nanang Bahroji','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('976','5','337','4','4','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','419/105/66','Nanang Bahroji','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('977','5','337','4','5','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','419/105/66','Nanang Bahroji','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('978','5','337','4','6','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','419/105/66','Nanang Bahroji','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('979','5','337','4','7','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','419/105/66','Nanang Bahroji','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('980','5','337','4','8','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','419/105/66','Nanang Bahroji','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('981','5','337','4','9','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','419/105/66','Nanang Bahroji','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('982','5','337','4','10','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','419/105/66','Nanang Bahroji','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('983','5','337','4','11','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','419/105/66','Nanang Bahroji','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('984','5','337','4','12','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','419/105/66','Nanang Bahroji','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('985','5','338','4','1','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','420/106/66','Nidia Rin Triana','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('986','5','338','4','2','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','420/106/66','Nidia Rin Triana','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('987','5','338','4','3','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','420/106/66','Nidia Rin Triana','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('988','5','338','4','4','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','420/106/66','Nidia Rin Triana','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('989','5','338','4','5','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','420/106/66','Nidia Rin Triana','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('990','5','338','4','6','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','420/106/66','Nidia Rin Triana','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('991','5','338','4','7','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','420/106/66','Nidia Rin Triana','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('992','5','338','4','8','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','420/106/66','Nidia Rin Triana','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('993','5','338','4','9','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','420/106/66','Nidia Rin Triana','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('994','5','338','4','10','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','420/106/66','Nidia Rin Triana','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('995','5','338','4','11','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','420/106/66','Nidia Rin Triana','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('996','5','338','4','12','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','420/106/66','Nidia Rin Triana','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('997','5','339','4','1','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','421/107/66','Nuril Islam','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('998','5','339','4','2','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','421/107/66','Nuril Islam','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('999','5','339','4','3','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','421/107/66','Nuril Islam','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1000','5','339','4','4','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','421/107/66','Nuril Islam','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1001','5','339','4','5','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','421/107/66','Nuril Islam','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1002','5','339','4','6','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','421/107/66','Nuril Islam','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1003','5','339','4','7','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','421/107/66','Nuril Islam','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1004','5','339','4','8','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','421/107/66','Nuril Islam','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1005','5','339','4','9','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','421/107/66','Nuril Islam','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1006','5','339','4','10','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','421/107/66','Nuril Islam','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1007','5','339','4','11','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','421/107/66','Nuril Islam','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1008','5','339','4','12','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','421/107/66','Nuril Islam','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1009','5','341','4','1','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','423/109/66','Sela Arista','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1010','5','341','4','2','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','423/109/66','Sela Arista','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1011','5','341','4','3','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','423/109/66','Sela Arista','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1012','5','341','4','4','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','423/109/66','Sela Arista','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1013','5','341','4','5','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','423/109/66','Sela Arista','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1014','5','341','4','6','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','423/109/66','Sela Arista','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1015','5','341','4','7','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','423/109/66','Sela Arista','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1016','5','341','4','8','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','423/109/66','Sela Arista','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1017','5','341','4','9','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','423/109/66','Sela Arista','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1018','5','341','4','10','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','423/109/66','Sela Arista','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1019','5','341','4','11','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','423/109/66','Sela Arista','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1020','5','341','4','12','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','423/109/66','Sela Arista','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1021','5','342','4','1','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','424/110/66','Sinta Annuriyah','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1022','5','342','4','2','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','424/110/66','Sinta Annuriyah','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1023','5','342','4','3','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','424/110/66','Sinta Annuriyah','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1024','5','342','4','4','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','424/110/66','Sinta Annuriyah','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1025','5','342','4','5','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','424/110/66','Sinta Annuriyah','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1026','5','342','4','6','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','424/110/66','Sinta Annuriyah','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1027','5','342','4','7','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','424/110/66','Sinta Annuriyah','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1028','5','342','4','8','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','424/110/66','Sinta Annuriyah','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1029','5','342','4','9','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','424/110/66','Sinta Annuriyah','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1030','5','342','4','10','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','424/110/66','Sinta Annuriyah','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1031','5','342','4','11','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','424/110/66','Sinta Annuriyah','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1032','5','342','4','12','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','424/110/66','Sinta Annuriyah','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1033','5','343','4','1','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','425/111/66','Very Prasetiyo','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1034','5','343','4','2','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','425/111/66','Very Prasetiyo','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1035','5','343','4','3','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','425/111/66','Very Prasetiyo','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1036','5','343','4','4','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','425/111/66','Very Prasetiyo','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1037','5','343','4','5','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','425/111/66','Very Prasetiyo','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1038','5','343','4','6','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','425/111/66','Very Prasetiyo','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1039','5','343','4','7','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','425/111/66','Very Prasetiyo','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1040','5','343','4','8','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','425/111/66','Very Prasetiyo','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1041','5','343','4','9','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','425/111/66','Very Prasetiyo','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1042','5','343','4','10','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','425/111/66','Very Prasetiyo','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1043','5','343','4','11','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','425/111/66','Very Prasetiyo','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1044','5','343','4','12','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','425/111/66','Very Prasetiyo','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1045','5','345','4','1','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','427/046/66','Wisnu Wardana','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1046','5','345','4','2','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','427/046/66','Wisnu Wardana','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1047','5','345','4','3','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','427/046/66','Wisnu Wardana','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1048','5','345','4','4','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','427/046/66','Wisnu Wardana','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1049','5','345','4','5','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','427/046/66','Wisnu Wardana','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1050','5','345','4','6','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','427/046/66','Wisnu Wardana','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1051','5','345','4','7','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','427/046/66','Wisnu Wardana','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1052','5','345','4','8','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','427/046/66','Wisnu Wardana','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1053','5','345','4','9','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','427/046/66','Wisnu Wardana','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1054','5','345','4','10','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','427/046/66','Wisnu Wardana','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1055','5','345','4','11','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','427/046/66','Wisnu Wardana','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1056','5','345','4','12','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','427/046/66','Wisnu Wardana','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1345','5','346','7','1','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','320/037/116','AHMAD SULAIMI','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1346','5','346','7','2','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','320/037/116','AHMAD SULAIMI','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1347','5','346','7','3','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','320/037/116','AHMAD SULAIMI','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1348','5','346','7','4','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','320/037/116','AHMAD SULAIMI','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1349','5','346','7','5','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','320/037/116','AHMAD SULAIMI','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1350','5','346','7','6','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','320/037/116','AHMAD SULAIMI','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1351','5','346','7','7','65000','2020-01-30 00:00:00','2020-01-30 13:11:39','1','4','DANA BULANAN','2019/2020','320/037/116','AHMAD SULAIMI','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1352','5','346','7','8','65000','2020-01-30 00:00:00','2020-01-30 13:11:41','1','4','DANA BULANAN','2019/2020','320/037/116','AHMAD SULAIMI','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1353','5','346','7','9','65000','2020-01-30 00:00:00','2020-01-30 13:11:43','1','4','DANA BULANAN','2019/2020','320/037/116','AHMAD SULAIMI','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1354','5','346','7','10','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','320/037/116','AHMAD SULAIMI','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1355','5','346','7','11','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','320/037/116','AHMAD SULAIMI','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1356','5','346','7','12','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','320/037/116','AHMAD SULAIMI','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1357','5','347','7','1','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','335/051/116','Arkanul Muslimin','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1358','5','347','7','2','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','335/051/116','Arkanul Muslimin','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1359','5','347','7','3','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','335/051/116','Arkanul Muslimin','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1360','5','347','7','4','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','335/051/116','Arkanul Muslimin','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1361','5','347','7','5','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','335/051/116','Arkanul Muslimin','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1362','5','347','7','6','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','335/051/116','Arkanul Muslimin','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1363','5','347','7','7','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','335/051/116','Arkanul Muslimin','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1364','5','347','7','8','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','335/051/116','Arkanul Muslimin','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1365','5','347','7','9','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','335/051/116','Arkanul Muslimin','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1366','5','347','7','10','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','335/051/116','Arkanul Muslimin','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1367','5','347','7','11','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','335/051/116','Arkanul Muslimin','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1368','5','347','7','12','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','335/051/116','Arkanul Muslimin','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1369','5','348','7','1','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','341/053/116','DENI PURWANTO','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1370','5','348','7','2','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','341/053/116','DENI PURWANTO','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1371','5','348','7','3','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','341/053/116','DENI PURWANTO','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1372','5','348','7','4','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','341/053/116','DENI PURWANTO','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1373','5','348','7','5','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','341/053/116','DENI PURWANTO','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1374','5','348','7','6','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','341/053/116','DENI PURWANTO','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1375','5','348','7','7','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','341/053/116','DENI PURWANTO','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1376','5','348','7','8','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','341/053/116','DENI PURWANTO','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1377','5','348','7','9','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','341/053/116','DENI PURWANTO','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1378','5','348','7','10','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','341/053/116','DENI PURWANTO','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1379','5','348','7','11','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','341/053/116','DENI PURWANTO','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1380','5','348','7','12','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','341/053/116','DENI PURWANTO','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1381','5','349','7','1','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','321/038/116','DHILA ARIESTYA','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1382','5','349','7','2','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','321/038/116','DHILA ARIESTYA','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1383','5','349','7','3','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','321/038/116','DHILA ARIESTYA','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1384','5','349','7','4','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','321/038/116','DHILA ARIESTYA','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1385','5','349','7','5','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','321/038/116','DHILA ARIESTYA','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1386','5','349','7','6','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','321/038/116','DHILA ARIESTYA','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1387','5','349','7','7','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','321/038/116','DHILA ARIESTYA','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1388','5','349','7','8','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','321/038/116','DHILA ARIESTYA','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1389','5','349','7','9','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','321/038/116','DHILA ARIESTYA','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1390','5','349','7','10','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','321/038/116','DHILA ARIESTYA','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1391','5','349','7','11','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','321/038/116','DHILA ARIESTYA','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1392','5','349','7','12','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','321/038/116','DHILA ARIESTYA','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1393','5','350','7','1','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','324/040/116','Muhamad Firli Abdika','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1394','5','350','7','2','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','324/040/116','Muhamad Firli Abdika','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1395','5','350','7','3','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','324/040/116','Muhamad Firli Abdika','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1396','5','350','7','4','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','324/040/116','Muhamad Firli Abdika','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1397','5','350','7','5','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','324/040/116','Muhamad Firli Abdika','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1398','5','350','7','6','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','324/040/116','Muhamad Firli Abdika','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1399','5','350','7','7','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','324/040/116','Muhamad Firli Abdika','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1400','5','350','7','8','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','324/040/116','Muhamad Firli Abdika','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1401','5','350','7','9','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','324/040/116','Muhamad Firli Abdika','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1402','5','350','7','10','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','324/040/116','Muhamad Firli Abdika','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1403','5','350','7','11','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','324/040/116','Muhamad Firli Abdika','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1404','5','350','7','12','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','324/040/116','Muhamad Firli Abdika','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1405','5','351','7','1','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','326/042/116','Nur Alfi Ansyah','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1406','5','351','7','2','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','326/042/116','Nur Alfi Ansyah','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1407','5','351','7','3','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','326/042/116','Nur Alfi Ansyah','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1408','5','351','7','4','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','326/042/116','Nur Alfi Ansyah','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1409','5','351','7','5','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','326/042/116','Nur Alfi Ansyah','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1410','5','351','7','6','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','326/042/116','Nur Alfi Ansyah','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1411','5','351','7','7','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','326/042/116','Nur Alfi Ansyah','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1412','5','351','7','8','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','326/042/116','Nur Alfi Ansyah','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1413','5','351','7','9','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','326/042/116','Nur Alfi Ansyah','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1414','5','351','7','10','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','326/042/116','Nur Alfi Ansyah','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1415','5','351','7','11','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','326/042/116','Nur Alfi Ansyah','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1416','5','351','7','12','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','326/042/116','Nur Alfi Ansyah','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1417','5','352','7','1','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','325/041/116','Nuril Maulidiyah','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1418','5','352','7','2','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','325/041/116','Nuril Maulidiyah','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1419','5','352','7','3','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','325/041/116','Nuril Maulidiyah','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1420','5','352','7','4','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','325/041/116','Nuril Maulidiyah','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1421','5','352','7','5','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','325/041/116','Nuril Maulidiyah','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1422','5','352','7','6','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','325/041/116','Nuril Maulidiyah','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1423','5','352','7','7','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','325/041/116','Nuril Maulidiyah','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1424','5','352','7','8','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','325/041/116','Nuril Maulidiyah','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1425','5','352','7','9','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','325/041/116','Nuril Maulidiyah','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1426','5','352','7','10','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','325/041/116','Nuril Maulidiyah','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1427','5','352','7','11','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','325/041/116','Nuril Maulidiyah','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1428','5','352','7','12','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','325/041/116','Nuril Maulidiyah','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1429','5','353','7','1','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','327/043/116','Orlando Pilipus','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1430','5','353','7','2','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','327/043/116','Orlando Pilipus','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1431','5','353','7','3','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','327/043/116','Orlando Pilipus','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1432','5','353','7','4','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','327/043/116','Orlando Pilipus','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1433','5','353','7','5','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','327/043/116','Orlando Pilipus','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1434','5','353','7','6','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','327/043/116','Orlando Pilipus','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1435','5','353','7','7','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','327/043/116','Orlando Pilipus','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1436','5','353','7','8','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','327/043/116','Orlando Pilipus','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1437','5','353','7','9','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','327/043/116','Orlando Pilipus','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1438','5','353','7','10','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','327/043/116','Orlando Pilipus','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1439','5','353','7','11','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','327/043/116','Orlando Pilipus','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1440','5','353','7','12','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','327/043/116','Orlando Pilipus','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1441','5','354','7','1','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','328/044/116','Putra Adi Prasetya','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1442','5','354','7','2','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','328/044/116','Putra Adi Prasetya','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1443','5','354','7','3','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','328/044/116','Putra Adi Prasetya','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1444','5','354','7','4','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','328/044/116','Putra Adi Prasetya','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1445','5','354','7','5','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','328/044/116','Putra Adi Prasetya','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1446','5','354','7','6','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','328/044/116','Putra Adi Prasetya','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1447','5','354','7','7','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','328/044/116','Putra Adi Prasetya','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1448','5','354','7','8','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','328/044/116','Putra Adi Prasetya','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1449','5','354','7','9','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','328/044/116','Putra Adi Prasetya','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1450','5','354','7','10','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','328/044/116','Putra Adi Prasetya','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1451','5','354','7','11','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','328/044/116','Putra Adi Prasetya','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1452','5','354','7','12','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','328/044/116','Putra Adi Prasetya','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1453','5','355','7','1','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','329/045/116','Putri Amelia Larosa','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1454','5','355','7','2','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','329/045/116','Putri Amelia Larosa','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1455','5','355','7','3','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','329/045/116','Putri Amelia Larosa','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1456','5','355','7','4','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','329/045/116','Putri Amelia Larosa','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1457','5','355','7','5','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','329/045/116','Putri Amelia Larosa','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1458','5','355','7','6','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','329/045/116','Putri Amelia Larosa','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1459','5','355','7','7','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','329/045/116','Putri Amelia Larosa','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1460','5','355','7','8','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','329/045/116','Putri Amelia Larosa','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1461','5','355','7','9','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','329/045/116','Putri Amelia Larosa','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1462','5','355','7','10','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','329/045/116','Putri Amelia Larosa','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1463','5','355','7','11','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','329/045/116','Putri Amelia Larosa','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1464','5','355','7','12','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','329/045/116','Putri Amelia Larosa','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1465','5','358','7','1','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','330/046/116','S. Eka Nurul Hikmah','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1466','5','358','7','2','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','330/046/116','S. Eka Nurul Hikmah','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1467','5','358','7','3','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','330/046/116','S. Eka Nurul Hikmah','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1468','5','358','7','4','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','330/046/116','S. Eka Nurul Hikmah','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1469','5','358','7','5','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','330/046/116','S. Eka Nurul Hikmah','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1470','5','358','7','6','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','330/046/116','S. Eka Nurul Hikmah','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1471','5','358','7','7','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','330/046/116','S. Eka Nurul Hikmah','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1472','5','358','7','8','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','330/046/116','S. Eka Nurul Hikmah','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1473','5','358','7','9','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','330/046/116','S. Eka Nurul Hikmah','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1474','5','358','7','10','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','330/046/116','S. Eka Nurul Hikmah','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1475','5','358','7','11','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','330/046/116','S. Eka Nurul Hikmah','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1476','5','358','7','12','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','330/046/116','S. Eka Nurul Hikmah','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1477','5','359','7','1','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','331/047/116','Sayu Ulandari','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1478','5','359','7','2','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','331/047/116','Sayu Ulandari','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1479','5','359','7','3','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','331/047/116','Sayu Ulandari','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1480','5','359','7','4','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','331/047/116','Sayu Ulandari','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1481','5','359','7','5','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','331/047/116','Sayu Ulandari','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1482','5','359','7','6','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','331/047/116','Sayu Ulandari','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1483','5','359','7','7','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','331/047/116','Sayu Ulandari','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1484','5','359','7','8','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','331/047/116','Sayu Ulandari','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1485','5','359','7','9','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','331/047/116','Sayu Ulandari','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1486','5','359','7','10','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','331/047/116','Sayu Ulandari','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1487','5','359','7','11','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','331/047/116','Sayu Ulandari','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1488','5','359','7','12','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','331/047/116','Sayu Ulandari','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1489','5','362','7','1','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','332/048/116','Siti Kholifah','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1490','5','362','7','2','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','332/048/116','Siti Kholifah','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1491','5','362','7','3','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','332/048/116','Siti Kholifah','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1492','5','362','7','4','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','332/048/116','Siti Kholifah','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1493','5','362','7','5','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','332/048/116','Siti Kholifah','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1494','5','362','7','6','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','332/048/116','Siti Kholifah','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1495','5','362','7','7','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','332/048/116','Siti Kholifah','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1496','5','362','7','8','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','332/048/116','Siti Kholifah','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1497','5','362','7','9','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','332/048/116','Siti Kholifah','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1498','5','362','7','10','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','332/048/116','Siti Kholifah','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1499','5','362','7','11','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','332/048/116','Siti Kholifah','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1500','5','362','7','12','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','332/048/116','Siti Kholifah','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1501','5','363','7','1','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','416/055/116','Siti Nur Lutfiyah','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1502','5','363','7','2','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','416/055/116','Siti Nur Lutfiyah','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1503','5','363','7','3','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','416/055/116','Siti Nur Lutfiyah','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1504','5','363','7','4','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','416/055/116','Siti Nur Lutfiyah','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1505','5','363','7','5','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','416/055/116','Siti Nur Lutfiyah','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1506','5','363','7','6','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','416/055/116','Siti Nur Lutfiyah','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1507','5','363','7','7','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','416/055/116','Siti Nur Lutfiyah','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1508','5','363','7','8','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','416/055/116','Siti Nur Lutfiyah','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1509','5','363','7','9','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','416/055/116','Siti Nur Lutfiyah','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1510','5','363','7','10','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','416/055/116','Siti Nur Lutfiyah','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1511','5','363','7','11','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','416/055/116','Siti Nur Lutfiyah','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1512','5','363','7','12','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','416/055/116','Siti Nur Lutfiyah','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1513','5','364','7','1','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','417/056/116','Sri Dwi Wahyuni','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1514','5','364','7','2','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','417/056/116','Sri Dwi Wahyuni','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1515','5','364','7','3','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','417/056/116','Sri Dwi Wahyuni','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1516','5','364','7','4','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','417/056/116','Sri Dwi Wahyuni','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1517','5','364','7','5','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','417/056/116','Sri Dwi Wahyuni','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1518','5','364','7','6','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','417/056/116','Sri Dwi Wahyuni','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1519','5','364','7','7','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','417/056/116','Sri Dwi Wahyuni','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1520','5','364','7','8','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','417/056/116','Sri Dwi Wahyuni','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1521','5','364','7','9','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','417/056/116','Sri Dwi Wahyuni','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1522','5','364','7','10','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','417/056/116','Sri Dwi Wahyuni','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1523','5','364','7','11','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','417/056/116','Sri Dwi Wahyuni','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1524','5','364','7','12','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','417/056/116','Sri Dwi Wahyuni','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1525','5','365','7','1','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','333/049/116','Syekh Maulana Ishaq','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1526','5','365','7','2','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','333/049/116','Syekh Maulana Ishaq','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1527','5','365','7','3','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','333/049/116','Syekh Maulana Ishaq','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1528','5','365','7','4','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','333/049/116','Syekh Maulana Ishaq','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1529','5','365','7','5','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','333/049/116','Syekh Maulana Ishaq','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1530','5','365','7','6','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','333/049/116','Syekh Maulana Ishaq','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1531','5','365','7','7','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','333/049/116','Syekh Maulana Ishaq','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1532','5','365','7','8','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','333/049/116','Syekh Maulana Ishaq','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1533','5','365','7','9','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','333/049/116','Syekh Maulana Ishaq','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1534','5','365','7','10','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','333/049/116','Syekh Maulana Ishaq','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1535','5','365','7','11','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','333/049/116','Syekh Maulana Ishaq','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1536','5','365','7','12','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','333/049/116','Syekh Maulana Ishaq','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1537','5','366','7','1','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','334/050/116','Umarudin','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1538','5','366','7','2','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','334/050/116','Umarudin','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1539','5','366','7','3','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','334/050/116','Umarudin','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1540','5','366','7','4','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','334/050/116','Umarudin','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1541','5','366','7','5','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','334/050/116','Umarudin','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1542','5','366','7','6','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','334/050/116','Umarudin','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1543','5','366','7','7','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','334/050/116','Umarudin','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1544','5','366','7','8','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','334/050/116','Umarudin','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1545','5','366','7','9','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','334/050/116','Umarudin','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1546','5','366','7','10','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','334/050/116','Umarudin','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1547','5','366','7','11','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','334/050/116','Umarudin','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1548','5','366','7','12','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','334/050/116','Umarudin','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1057','5','378','5','1','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','337/069/66','Andre Gunawan','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1058','5','378','5','2','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','337/069/66','Andre Gunawan','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1059','5','378','5','3','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','337/069/66','Andre Gunawan','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1060','5','378','5','4','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','337/069/66','Andre Gunawan','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1061','5','378','5','5','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','337/069/66','Andre Gunawan','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1062','5','378','5','6','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','337/069/66','Andre Gunawan','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1063','5','378','5','7','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','337/069/66','Andre Gunawan','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1064','5','378','5','8','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','337/069/66','Andre Gunawan','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1065','5','378','5','9','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','337/069/66','Andre Gunawan','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1066','5','378','5','10','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','337/069/66','Andre Gunawan','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1067','5','378','5','11','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','337/069/66','Andre Gunawan','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1068','5','378','5','12','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','337/069/66','Andre Gunawan','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1069','5','379','5','1','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','338/070/66','ANGGI NOVITASARI','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1070','5','379','5','2','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','338/070/66','ANGGI NOVITASARI','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1071','5','379','5','3','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','338/070/66','ANGGI NOVITASARI','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1072','5','379','5','4','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','338/070/66','ANGGI NOVITASARI','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1073','5','379','5','5','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','338/070/66','ANGGI NOVITASARI','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1074','5','379','5','6','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','338/070/66','ANGGI NOVITASARI','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1075','5','379','5','7','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','338/070/66','ANGGI NOVITASARI','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1076','5','379','5','8','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','338/070/66','ANGGI NOVITASARI','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1077','5','379','5','9','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','338/070/66','ANGGI NOVITASARI','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1078','5','379','5','10','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','338/070/66','ANGGI NOVITASARI','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1079','5','379','5','11','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','338/070/66','ANGGI NOVITASARI','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1080','5','379','5','12','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','338/070/66','ANGGI NOVITASARI','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1081','5','380','5','1','65000','2020-01-30 00:00:00','2020-01-30 13:15:37','1','4','DANA BULANAN','2019/2020','339/071/66','ARIF SETIAWAN','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1082','5','380','5','2','65000','2020-01-30 00:00:00','2020-01-30 13:15:40','1','4','DANA BULANAN','2019/2020','339/071/66','ARIF SETIAWAN','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1083','5','380','5','3','65000','2020-01-30 00:00:00','2020-01-30 13:15:42','1','4','DANA BULANAN','2019/2020','339/071/66','ARIF SETIAWAN','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1084','5','380','5','4','65000','2020-01-30 00:00:00','2020-01-30 13:15:44','1','4','DANA BULANAN','2019/2020','339/071/66','ARIF SETIAWAN','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1085','5','380','5','5','65000','2020-01-30 00:00:00','2020-01-30 13:15:46','1','4','DANA BULANAN','2019/2020','339/071/66','ARIF SETIAWAN','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1086','5','380','5','6','65000','2020-01-30 00:00:00','2020-01-30 13:15:49','1','4','DANA BULANAN','2019/2020','339/071/66','ARIF SETIAWAN','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1087','5','380','5','7','65000','2020-01-30 00:00:00','2020-01-30 13:12:36','1','4','DANA BULANAN','2019/2020','339/071/66','ARIF SETIAWAN','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1088','5','380','5','8','65000','2020-01-30 00:00:00','2020-01-30 13:12:38','1','4','DANA BULANAN','2019/2020','339/071/66','ARIF SETIAWAN','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1089','5','380','5','9','65000','2020-01-30 00:00:00','2020-01-30 13:12:44','1','4','DANA BULANAN','2019/2020','339/071/66','ARIF SETIAWAN','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1090','5','380','5','10','65000','2020-01-30 00:00:00','2020-01-30 13:12:48','1','4','DANA BULANAN','2019/2020','339/071/66','ARIF SETIAWAN','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1091','5','380','5','11','65000','2020-01-30 00:00:00','2020-01-30 13:15:32','1','4','DANA BULANAN','2019/2020','339/071/66','ARIF SETIAWAN','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1092','5','380','5','12','65000','2020-01-30 00:00:00','2020-01-30 13:15:35','1','4','DANA BULANAN','2019/2020','339/071/66','ARIF SETIAWAN','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1093','5','381','5','1','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','340/072/66','AYUK OKTAVIA','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1094','5','381','5','2','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','340/072/66','AYUK OKTAVIA','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1095','5','381','5','3','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','340/072/66','AYUK OKTAVIA','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1096','5','381','5','4','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','340/072/66','AYUK OKTAVIA','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1097','5','381','5','5','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','340/072/66','AYUK OKTAVIA','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1098','5','381','5','6','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','340/072/66','AYUK OKTAVIA','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1099','5','381','5','7','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','340/072/66','AYUK OKTAVIA','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1100','5','381','5','8','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','340/072/66','AYUK OKTAVIA','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1101','5','381','5','9','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','340/072/66','AYUK OKTAVIA','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1102','5','381','5','10','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','340/072/66','AYUK OKTAVIA','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1103','5','381','5','11','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','340/072/66','AYUK OKTAVIA','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1104','5','381','5','12','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','340/072/66','AYUK OKTAVIA','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1105','5','382','5','1','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','342/073/66','Diyana','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1106','5','382','5','2','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','342/073/66','Diyana','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1107','5','382','5','3','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','342/073/66','Diyana','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1108','5','382','5','4','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','342/073/66','Diyana','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1109','5','382','5','5','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','342/073/66','Diyana','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1110','5','382','5','6','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','342/073/66','Diyana','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1111','5','382','5','7','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','342/073/66','Diyana','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1112','5','382','5','8','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','342/073/66','Diyana','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1113','5','382','5','9','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','342/073/66','Diyana','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1114','5','382','5','10','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','342/073/66','Diyana','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1115','5','382','5','11','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','342/073/66','Diyana','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1116','5','382','5','12','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','342/073/66','Diyana','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1117','5','383','5','1','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','343/074/66','Erviyadi Luqman Asmawi','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1118','5','383','5','2','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','343/074/66','Erviyadi Luqman Asmawi','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1119','5','383','5','3','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','343/074/66','Erviyadi Luqman Asmawi','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1120','5','383','5','4','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','343/074/66','Erviyadi Luqman Asmawi','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1121','5','383','5','5','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','343/074/66','Erviyadi Luqman Asmawi','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1122','5','383','5','6','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','343/074/66','Erviyadi Luqman Asmawi','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1123','5','383','5','7','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','343/074/66','Erviyadi Luqman Asmawi','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1124','5','383','5','8','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','343/074/66','Erviyadi Luqman Asmawi','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1125','5','383','5','9','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','343/074/66','Erviyadi Luqman Asmawi','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1126','5','383','5','10','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','343/074/66','Erviyadi Luqman Asmawi','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1127','5','383','5','11','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','343/074/66','Erviyadi Luqman Asmawi','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1128','5','383','5','12','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','343/074/66','Erviyadi Luqman Asmawi','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1129','5','384','5','1','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','344/075/66','Lilis Widya Astutik','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1130','5','384','5','2','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','344/075/66','Lilis Widya Astutik','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1131','5','384','5','3','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','344/075/66','Lilis Widya Astutik','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1132','5','384','5','4','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','344/075/66','Lilis Widya Astutik','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1133','5','384','5','5','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','344/075/66','Lilis Widya Astutik','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1134','5','384','5','6','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','344/075/66','Lilis Widya Astutik','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1135','5','384','5','7','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','344/075/66','Lilis Widya Astutik','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1136','5','384','5','8','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','344/075/66','Lilis Widya Astutik','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1137','5','384','5','9','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','344/075/66','Lilis Widya Astutik','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1138','5','384','5','10','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','344/075/66','Lilis Widya Astutik','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1139','5','384','5','11','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','344/075/66','Lilis Widya Astutik','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1140','5','384','5','12','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','344/075/66','Lilis Widya Astutik','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1141','5','385','5','1','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','349/080/66','M Ali Murtadlo','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1142','5','385','5','2','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','349/080/66','M Ali Murtadlo','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1143','5','385','5','3','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','349/080/66','M Ali Murtadlo','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1144','5','385','5','4','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','349/080/66','M Ali Murtadlo','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1145','5','385','5','5','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','349/080/66','M Ali Murtadlo','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1146','5','385','5','6','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','349/080/66','M Ali Murtadlo','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1147','5','385','5','7','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','349/080/66','M Ali Murtadlo','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1148','5','385','5','8','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','349/080/66','M Ali Murtadlo','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1149','5','385','5','9','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','349/080/66','M Ali Murtadlo','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1150','5','385','5','10','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','349/080/66','M Ali Murtadlo','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1151','5','385','5','11','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','349/080/66','M Ali Murtadlo','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1152','5','385','5','12','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','349/080/66','M Ali Murtadlo','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1153','5','387','5','1','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','345/076/66','Moch Nurul Fawaiz','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1154','5','387','5','2','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','345/076/66','Moch Nurul Fawaiz','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1155','5','387','5','3','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','345/076/66','Moch Nurul Fawaiz','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1156','5','387','5','4','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','345/076/66','Moch Nurul Fawaiz','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1157','5','387','5','5','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','345/076/66','Moch Nurul Fawaiz','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1158','5','387','5','6','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','345/076/66','Moch Nurul Fawaiz','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1159','5','387','5','7','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','345/076/66','Moch Nurul Fawaiz','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1160','5','387','5','8','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','345/076/66','Moch Nurul Fawaiz','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1161','5','387','5','9','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','345/076/66','Moch Nurul Fawaiz','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1162','5','387','5','10','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','345/076/66','Moch Nurul Fawaiz','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1163','5','387','5','11','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','345/076/66','Moch Nurul Fawaiz','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1164','5','387','5','12','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','345/076/66','Moch Nurul Fawaiz','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1165','5','388','5','1','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','351/082/66','Mochammad Marzuqi','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1166','5','388','5','2','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','351/082/66','Mochammad Marzuqi','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1167','5','388','5','3','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','351/082/66','Mochammad Marzuqi','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1168','5','388','5','4','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','351/082/66','Mochammad Marzuqi','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1169','5','388','5','5','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','351/082/66','Mochammad Marzuqi','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1170','5','388','5','6','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','351/082/66','Mochammad Marzuqi','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1171','5','388','5','7','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','351/082/66','Mochammad Marzuqi','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1172','5','388','5','8','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','351/082/66','Mochammad Marzuqi','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1173','5','388','5','9','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','351/082/66','Mochammad Marzuqi','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1174','5','388','5','10','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','351/082/66','Mochammad Marzuqi','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1175','5','388','5','11','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','351/082/66','Mochammad Marzuqi','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1176','5','388','5','12','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','351/082/66','Mochammad Marzuqi','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1177','5','390','5','1','65000','2020-01-30 00:00:00','2020-01-30 13:17:46','1','4','DANA BULANAN','2019/2020','346/077/66','Moh. Gufron','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1178','5','390','5','2','65000','2020-01-30 00:00:00','2020-01-30 13:17:50','1','4','DANA BULANAN','2019/2020','346/077/66','Moh. Gufron','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1179','5','390','5','3','65000','2020-01-30 00:00:00','2020-01-30 13:17:54','1','4','DANA BULANAN','2019/2020','346/077/66','Moh. Gufron','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1180','5','390','5','4','65000','2020-01-30 00:00:00','2020-01-30 13:17:56','1','4','DANA BULANAN','2019/2020','346/077/66','Moh. Gufron','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1181','5','390','5','5','65000','2020-01-30 00:00:00','2020-01-30 13:18:00','1','4','DANA BULANAN','2019/2020','346/077/66','Moh. Gufron','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1182','5','390','5','6','65000','2020-01-30 00:00:00','2020-01-30 13:18:03','1','4','DANA BULANAN','2019/2020','346/077/66','Moh. Gufron','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1183','5','390','5','7','65000','2020-01-30 00:00:00','2020-01-30 13:17:30','1','4','DANA BULANAN','2019/2020','346/077/66','Moh. Gufron','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1184','5','390','5','8','65000','2020-01-30 00:00:00','2020-01-30 13:17:31','1','4','DANA BULANAN','2019/2020','346/077/66','Moh. Gufron','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1185','5','390','5','9','65000','2020-01-30 00:00:00','2020-01-30 13:17:33','1','4','DANA BULANAN','2019/2020','346/077/66','Moh. Gufron','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1186','5','390','5','10','65000','2020-01-30 00:00:00','2020-01-30 13:17:38','1','4','DANA BULANAN','2019/2020','346/077/66','Moh. Gufron','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1187','5','390','5','11','65000','2020-01-30 00:00:00','2020-01-30 13:17:41','1','4','DANA BULANAN','2019/2020','346/077/66','Moh. Gufron','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1188','5','390','5','12','65000','2020-01-30 00:00:00','2020-01-30 13:17:44','1','4','DANA BULANAN','2019/2020','346/077/66','Moh. Gufron','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1189','5','391','5','1','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','347/078/66','Mohammad Nabil','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1190','5','391','5','2','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','347/078/66','Mohammad Nabil','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1191','5','391','5','3','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','347/078/66','Mohammad Nabil','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1192','5','391','5','4','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','347/078/66','Mohammad Nabil','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1193','5','391','5','5','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','347/078/66','Mohammad Nabil','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1194','5','391','5','6','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','347/078/66','Mohammad Nabil','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1195','5','391','5','7','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','347/078/66','Mohammad Nabil','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1196','5','391','5','8','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','347/078/66','Mohammad Nabil','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1197','5','391','5','9','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','347/078/66','Mohammad Nabil','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1198','5','391','5','10','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','347/078/66','Mohammad Nabil','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1199','5','391','5','11','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','347/078/66','Mohammad Nabil','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1200','5','391','5','12','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','347/078/66','Mohammad Nabil','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1201','5','392','5','1','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','348/079/66','Muhamad Ifroni','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1202','5','392','5','2','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','348/079/66','Muhamad Ifroni','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1203','5','392','5','3','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','348/079/66','Muhamad Ifroni','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1204','5','392','5','4','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','348/079/66','Muhamad Ifroni','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1205','5','392','5','5','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','348/079/66','Muhamad Ifroni','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1206','5','392','5','6','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','348/079/66','Muhamad Ifroni','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1207','5','392','5','7','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','348/079/66','Muhamad Ifroni','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1208','5','392','5','8','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','348/079/66','Muhamad Ifroni','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1209','5','392','5','9','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','348/079/66','Muhamad Ifroni','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1210','5','392','5','10','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','348/079/66','Muhamad Ifroni','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1211','5','392','5','11','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','348/079/66','Muhamad Ifroni','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1212','5','392','5','12','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','348/079/66','Muhamad Ifroni','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1213','5','393','5','1','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','350/081/66','Muhammad Azkanafsi','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1214','5','393','5','2','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','350/081/66','Muhammad Azkanafsi','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1215','5','393','5','3','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','350/081/66','Muhammad Azkanafsi','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1216','5','393','5','4','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','350/081/66','Muhammad Azkanafsi','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1217','5','393','5','5','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','350/081/66','Muhammad Azkanafsi','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1218','5','393','5','6','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','350/081/66','Muhammad Azkanafsi','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1219','5','393','5','7','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','350/081/66','Muhammad Azkanafsi','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1220','5','393','5','8','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','350/081/66','Muhammad Azkanafsi','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1221','5','393','5','9','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','350/081/66','Muhammad Azkanafsi','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1222','5','393','5','10','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','350/081/66','Muhammad Azkanafsi','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1223','5','393','5','11','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','350/081/66','Muhammad Azkanafsi','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1224','5','393','5','12','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','350/081/66','Muhammad Azkanafsi','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1225','5','394','5','1','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','352/083/66','Nur Laila Hidayah','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1226','5','394','5','2','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','352/083/66','Nur Laila Hidayah','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1227','5','394','5','3','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','352/083/66','Nur Laila Hidayah','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1228','5','394','5','4','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','352/083/66','Nur Laila Hidayah','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1229','5','394','5','5','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','352/083/66','Nur Laila Hidayah','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1230','5','394','5','6','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','352/083/66','Nur Laila Hidayah','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1231','5','394','5','7','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','352/083/66','Nur Laila Hidayah','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1232','5','394','5','8','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','352/083/66','Nur Laila Hidayah','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1233','5','394','5','9','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','352/083/66','Nur Laila Hidayah','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1234','5','394','5','10','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','352/083/66','Nur Laila Hidayah','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1235','5','394','5','11','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','352/083/66','Nur Laila Hidayah','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1236','5','394','5','12','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','352/083/66','Nur Laila Hidayah','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1237','5','395','5','1','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','353/084/66','Rizki Ari Saputra','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1238','5','395','5','2','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','353/084/66','Rizki Ari Saputra','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1239','5','395','5','3','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','353/084/66','Rizki Ari Saputra','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1240','5','395','5','4','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','353/084/66','Rizki Ari Saputra','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1241','5','395','5','5','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','353/084/66','Rizki Ari Saputra','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1242','5','395','5','6','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','353/084/66','Rizki Ari Saputra','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1243','5','395','5','7','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','353/084/66','Rizki Ari Saputra','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1244','5','395','5','8','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','353/084/66','Rizki Ari Saputra','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1245','5','395','5','9','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','353/084/66','Rizki Ari Saputra','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1246','5','395','5','10','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','353/084/66','Rizki Ari Saputra','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1247','5','395','5','11','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','353/084/66','Rizki Ari Saputra','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1248','5','395','5','12','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','353/084/66','Rizki Ari Saputra','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1249','5','396','5','1','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','354/085/66','Siti  Mudawamah','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1250','5','396','5','2','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','354/085/66','Siti  Mudawamah','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1251','5','396','5','3','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','354/085/66','Siti  Mudawamah','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1252','5','396','5','4','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','354/085/66','Siti  Mudawamah','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1253','5','396','5','5','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','354/085/66','Siti  Mudawamah','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1254','5','396','5','6','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','354/085/66','Siti  Mudawamah','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1255','5','396','5','7','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','354/085/66','Siti  Mudawamah','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1256','5','396','5','8','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','354/085/66','Siti  Mudawamah','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1257','5','396','5','9','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','354/085/66','Siti  Mudawamah','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1258','5','396','5','10','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','354/085/66','Siti  Mudawamah','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1259','5','396','5','11','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','354/085/66','Siti  Mudawamah','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1260','5','396','5','12','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','354/085/66','Siti  Mudawamah','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1261','5','397','5','1','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','358/089/66','Siti Nur Azizah','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1262','5','397','5','2','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','358/089/66','Siti Nur Azizah','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1263','5','397','5','3','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','358/089/66','Siti Nur Azizah','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1264','5','397','5','4','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','358/089/66','Siti Nur Azizah','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1265','5','397','5','5','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','358/089/66','Siti Nur Azizah','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1266','5','397','5','6','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','358/089/66','Siti Nur Azizah','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1267','5','397','5','7','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','358/089/66','Siti Nur Azizah','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1268','5','397','5','8','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','358/089/66','Siti Nur Azizah','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1269','5','397','5','9','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','358/089/66','Siti Nur Azizah','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1270','5','397','5','10','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','358/089/66','Siti Nur Azizah','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1271','5','397','5','11','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','358/089/66','Siti Nur Azizah','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1272','5','397','5','12','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','358/089/66','Siti Nur Azizah','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1273','5','398','5','1','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','355/086/66','Syaiful Islam','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1274','5','398','5','2','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','355/086/66','Syaiful Islam','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1275','5','398','5','3','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','355/086/66','Syaiful Islam','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1276','5','398','5','4','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','355/086/66','Syaiful Islam','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1277','5','398','5','5','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','355/086/66','Syaiful Islam','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1278','5','398','5','6','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','355/086/66','Syaiful Islam','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1279','5','398','5','7','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','355/086/66','Syaiful Islam','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1280','5','398','5','8','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','355/086/66','Syaiful Islam','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1281','5','398','5','9','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','355/086/66','Syaiful Islam','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1282','5','398','5','10','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','355/086/66','Syaiful Islam','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1283','5','398','5','11','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','355/086/66','Syaiful Islam','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1284','5','398','5','12','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','355/086/66','Syaiful Islam','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('553','5','278','3','1','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','361/059/116','Dewi Pitasari','XI OTKP','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('554','5','278','3','2','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','361/059/116','Dewi Pitasari','XI OTKP','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('555','5','278','3','3','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','361/059/116','Dewi Pitasari','XI OTKP','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('556','5','278','3','4','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','361/059/116','Dewi Pitasari','XI OTKP','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('557','5','278','3','5','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','361/059/116','Dewi Pitasari','XI OTKP','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('558','5','278','3','6','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','361/059/116','Dewi Pitasari','XI OTKP','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('559','5','278','3','7','55000','2020-01-30 00:00:00','2020-01-30 13:05:33','1','4','DANA BULANAN','2019/2020','361/059/116','Dewi Pitasari','XI OTKP','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('560','5','278','3','8','55000','2020-01-30 00:00:00','2020-01-30 13:05:36','1','4','DANA BULANAN','2019/2020','361/059/116','Dewi Pitasari','XI OTKP','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('561','5','278','3','9','55000','2020-01-30 00:00:00','2020-01-30 13:05:38','1','4','DANA BULANAN','2019/2020','361/059/116','Dewi Pitasari','XI OTKP','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('562','5','278','3','10','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','361/059/116','Dewi Pitasari','XI OTKP','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('563','5','278','3','11','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','361/059/116','Dewi Pitasari','XI OTKP','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('564','5','278','3','12','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','361/059/116','Dewi Pitasari','XI OTKP','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('565','5','280','3','1','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','363/061/116','Eka Dian Saputri','XI OTKP','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('566','5','280','3','2','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','363/061/116','Eka Dian Saputri','XI OTKP','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('567','5','280','3','3','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','363/061/116','Eka Dian Saputri','XI OTKP','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('568','5','280','3','4','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','363/061/116','Eka Dian Saputri','XI OTKP','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('569','5','280','3','5','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','363/061/116','Eka Dian Saputri','XI OTKP','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('570','5','280','3','6','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','363/061/116','Eka Dian Saputri','XI OTKP','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('571','5','280','3','7','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','363/061/116','Eka Dian Saputri','XI OTKP','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('572','5','280','3','8','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','363/061/116','Eka Dian Saputri','XI OTKP','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('573','5','280','3','9','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','363/061/116','Eka Dian Saputri','XI OTKP','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('574','5','280','3','10','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','363/061/116','Eka Dian Saputri','XI OTKP','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('575','5','280','3','11','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','363/061/116','Eka Dian Saputri','XI OTKP','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('576','5','280','3','12','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','363/061/116','Eka Dian Saputri','XI OTKP','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('577','5','282','3','1','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','366/064/116','Haliyatul Fitri','XI OTKP','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('578','5','282','3','2','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','366/064/116','Haliyatul Fitri','XI OTKP','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('579','5','282','3','3','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','366/064/116','Haliyatul Fitri','XI OTKP','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('580','5','282','3','4','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','366/064/116','Haliyatul Fitri','XI OTKP','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('581','5','282','3','5','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','366/064/116','Haliyatul Fitri','XI OTKP','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('582','5','282','3','6','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','366/064/116','Haliyatul Fitri','XI OTKP','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('583','5','282','3','7','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','366/064/116','Haliyatul Fitri','XI OTKP','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('584','5','282','3','8','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','366/064/116','Haliyatul Fitri','XI OTKP','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('585','5','282','3','9','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','366/064/116','Haliyatul Fitri','XI OTKP','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('586','5','282','3','10','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','366/064/116','Haliyatul Fitri','XI OTKP','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('587','5','282','3','11','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','366/064/116','Haliyatul Fitri','XI OTKP','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('588','5','282','3','12','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','366/064/116','Haliyatul Fitri','XI OTKP','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('589','5','284','3','1','55000','2020-02-10 00:00:00','2020-02-10 13:50:05','1','4','DANA BULANAN','2019/2020','368/066/116','Hillah Maulana','XI OTKP','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('590','5','284','3','2','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','368/066/116','Hillah Maulana','XI OTKP','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('591','5','284','3','3','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','368/066/116','Hillah Maulana','XI OTKP','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('592','5','284','3','4','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','368/066/116','Hillah Maulana','XI OTKP','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('593','5','284','3','5','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','368/066/116','Hillah Maulana','XI OTKP','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('594','5','284','3','6','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','368/066/116','Hillah Maulana','XI OTKP','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('595','5','284','3','7','55000','2020-02-10 00:00:00','2020-02-10 13:49:42','1','4','DANA BULANAN','2019/2020','368/066/116','Hillah Maulana','XI OTKP','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('596','5','284','3','8','55000','2020-02-10 00:00:00','2020-02-10 13:49:48','1','4','DANA BULANAN','2019/2020','368/066/116','Hillah Maulana','XI OTKP','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('597','5','284','3','9','55000','2020-02-10 00:00:00','2020-02-10 13:49:51','1','4','DANA BULANAN','2019/2020','368/066/116','Hillah Maulana','XI OTKP','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('598','5','284','3','10','55000','2020-02-10 00:00:00','2020-02-10 13:49:56','1','4','DANA BULANAN','2019/2020','368/066/116','Hillah Maulana','XI OTKP','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('599','5','284','3','11','55000','2020-02-10 00:00:00','2020-02-10 13:49:59','1','4','DANA BULANAN','2019/2020','368/066/116','Hillah Maulana','XI OTKP','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('600','5','284','3','12','55000','2020-02-10 00:00:00','2020-02-10 13:50:02','1','4','DANA BULANAN','2019/2020','368/066/116','Hillah Maulana','XI OTKP','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('601','5','285','3','1','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','369/067/116','Israhul Amalia','XI OTKP','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('602','5','285','3','2','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','369/067/116','Israhul Amalia','XI OTKP','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('603','5','285','3','3','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','369/067/116','Israhul Amalia','XI OTKP','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('604','5','285','3','4','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','369/067/116','Israhul Amalia','XI OTKP','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('605','5','285','3','5','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','369/067/116','Israhul Amalia','XI OTKP','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('606','5','285','3','6','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','369/067/116','Israhul Amalia','XI OTKP','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('607','5','285','3','7','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','369/067/116','Israhul Amalia','XI OTKP','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('608','5','285','3','8','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','369/067/116','Israhul Amalia','XI OTKP','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('609','5','285','3','9','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','369/067/116','Israhul Amalia','XI OTKP','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('610','5','285','3','10','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','369/067/116','Israhul Amalia','XI OTKP','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('611','5','285','3','11','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','369/067/116','Israhul Amalia','XI OTKP','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('612','5','285','3','12','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','369/067/116','Israhul Amalia','XI OTKP','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('613','5','286','3','1','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','370/068/116','LISA NUR AYU GUNAWATI','XI OTKP','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('614','5','286','3','2','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','370/068/116','LISA NUR AYU GUNAWATI','XI OTKP','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('615','5','286','3','3','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','370/068/116','LISA NUR AYU GUNAWATI','XI OTKP','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('616','5','286','3','4','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','370/068/116','LISA NUR AYU GUNAWATI','XI OTKP','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('617','5','286','3','5','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','370/068/116','LISA NUR AYU GUNAWATI','XI OTKP','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('618','5','286','3','6','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','370/068/116','LISA NUR AYU GUNAWATI','XI OTKP','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('619','5','286','3','7','55000','2020-03-13 00:00:00','2020-03-13 16:57:35','1','4','DANA BULANAN','2019/2020','370/068/116','LISA NUR AYU GUNAWATI','XI OTKP','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('620','5','286','3','8','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','370/068/116','LISA NUR AYU GUNAWATI','XI OTKP','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('621','5','286','3','9','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','370/068/116','LISA NUR AYU GUNAWATI','XI OTKP','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('622','5','286','3','10','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','370/068/116','LISA NUR AYU GUNAWATI','XI OTKP','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('623','5','286','3','11','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','370/068/116','LISA NUR AYU GUNAWATI','XI OTKP','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('624','5','286','3','12','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','370/068/116','LISA NUR AYU GUNAWATI','XI OTKP','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('625','5','287','3','1','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','371/069/116','Mirna Putri Uhrowi','XI OTKP','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('626','5','287','3','2','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','371/069/116','Mirna Putri Uhrowi','XI OTKP','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('627','5','287','3','3','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','371/069/116','Mirna Putri Uhrowi','XI OTKP','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('628','5','287','3','4','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','371/069/116','Mirna Putri Uhrowi','XI OTKP','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('629','5','287','3','5','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','371/069/116','Mirna Putri Uhrowi','XI OTKP','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('630','5','287','3','6','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','371/069/116','Mirna Putri Uhrowi','XI OTKP','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('631','5','287','3','7','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','371/069/116','Mirna Putri Uhrowi','XI OTKP','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('632','5','287','3','8','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','371/069/116','Mirna Putri Uhrowi','XI OTKP','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('633','5','287','3','9','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','371/069/116','Mirna Putri Uhrowi','XI OTKP','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('634','5','287','3','10','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','371/069/116','Mirna Putri Uhrowi','XI OTKP','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('635','5','287','3','11','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','371/069/116','Mirna Putri Uhrowi','XI OTKP','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('636','5','287','3','12','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','371/069/116','Mirna Putri Uhrowi','XI OTKP','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('637','5','289','3','1','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','373/071/116','Moh. Taqinaqi Khoirusima Yusuf','XI OTKP','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('638','5','289','3','2','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','373/071/116','Moh. Taqinaqi Khoirusima Yusuf','XI OTKP','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('639','5','289','3','3','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','373/071/116','Moh. Taqinaqi Khoirusima Yusuf','XI OTKP','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('640','5','289','3','4','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','373/071/116','Moh. Taqinaqi Khoirusima Yusuf','XI OTKP','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('641','5','289','3','5','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','373/071/116','Moh. Taqinaqi Khoirusima Yusuf','XI OTKP','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('642','5','289','3','6','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','373/071/116','Moh. Taqinaqi Khoirusima Yusuf','XI OTKP','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('643','5','289','3','7','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','373/071/116','Moh. Taqinaqi Khoirusima Yusuf','XI OTKP','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('644','5','289','3','8','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','373/071/116','Moh. Taqinaqi Khoirusima Yusuf','XI OTKP','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('645','5','289','3','9','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','373/071/116','Moh. Taqinaqi Khoirusima Yusuf','XI OTKP','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('646','5','289','3','10','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','373/071/116','Moh. Taqinaqi Khoirusima Yusuf','XI OTKP','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('647','5','289','3','11','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','373/071/116','Moh. Taqinaqi Khoirusima Yusuf','XI OTKP','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('648','5','289','3','12','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','373/071/116','Moh. Taqinaqi Khoirusima Yusuf','XI OTKP','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('649','5','290','3','1','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','374/072/116','Muhammad Hendrawan','XI OTKP','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('650','5','290','3','2','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','374/072/116','Muhammad Hendrawan','XI OTKP','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('651','5','290','3','3','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','374/072/116','Muhammad Hendrawan','XI OTKP','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('652','5','290','3','4','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','374/072/116','Muhammad Hendrawan','XI OTKP','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('653','5','290','3','5','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','374/072/116','Muhammad Hendrawan','XI OTKP','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('654','5','290','3','6','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','374/072/116','Muhammad Hendrawan','XI OTKP','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('655','5','290','3','7','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','374/072/116','Muhammad Hendrawan','XI OTKP','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('656','5','290','3','8','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','374/072/116','Muhammad Hendrawan','XI OTKP','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('657','5','290','3','9','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','374/072/116','Muhammad Hendrawan','XI OTKP','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('658','5','290','3','10','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','374/072/116','Muhammad Hendrawan','XI OTKP','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('659','5','290','3','11','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','374/072/116','Muhammad Hendrawan','XI OTKP','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('660','5','290','3','12','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','374/072/116','Muhammad Hendrawan','XI OTKP','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('661','5','291','3','1','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','375/073/116','Nafila Kurnia Alvianda','XI OTKP','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('662','5','291','3','2','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','375/073/116','Nafila Kurnia Alvianda','XI OTKP','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('663','5','291','3','3','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','375/073/116','Nafila Kurnia Alvianda','XI OTKP','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('664','5','291','3','4','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','375/073/116','Nafila Kurnia Alvianda','XI OTKP','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('665','5','291','3','5','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','375/073/116','Nafila Kurnia Alvianda','XI OTKP','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('666','5','291','3','6','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','375/073/116','Nafila Kurnia Alvianda','XI OTKP','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('667','5','291','3','7','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','375/073/116','Nafila Kurnia Alvianda','XI OTKP','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('668','5','291','3','8','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','375/073/116','Nafila Kurnia Alvianda','XI OTKP','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('669','5','291','3','9','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','375/073/116','Nafila Kurnia Alvianda','XI OTKP','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('670','5','291','3','10','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','375/073/116','Nafila Kurnia Alvianda','XI OTKP','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('671','5','291','3','11','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','375/073/116','Nafila Kurnia Alvianda','XI OTKP','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('672','5','291','3','12','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','375/073/116','Nafila Kurnia Alvianda','XI OTKP','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('673','5','292','3','1','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','376/074/116','Nining Arbailah','XI OTKP','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('674','5','292','3','2','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','376/074/116','Nining Arbailah','XI OTKP','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('675','5','292','3','3','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','376/074/116','Nining Arbailah','XI OTKP','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('676','5','292','3','4','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','376/074/116','Nining Arbailah','XI OTKP','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('677','5','292','3','5','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','376/074/116','Nining Arbailah','XI OTKP','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('678','5','292','3','6','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','376/074/116','Nining Arbailah','XI OTKP','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('679','5','292','3','7','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','376/074/116','Nining Arbailah','XI OTKP','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('680','5','292','3','8','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','376/074/116','Nining Arbailah','XI OTKP','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('681','5','292','3','9','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','376/074/116','Nining Arbailah','XI OTKP','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('682','5','292','3','10','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','376/074/116','Nining Arbailah','XI OTKP','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('683','5','292','3','11','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','376/074/116','Nining Arbailah','XI OTKP','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('684','5','292','3','12','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','376/074/116','Nining Arbailah','XI OTKP','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('685','5','293','3','1','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','377/075/116','Nur Aini','XI OTKP','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('686','5','293','3','2','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','377/075/116','Nur Aini','XI OTKP','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('687','5','293','3','3','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','377/075/116','Nur Aini','XI OTKP','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('688','5','293','3','4','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','377/075/116','Nur Aini','XI OTKP','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('689','5','293','3','5','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','377/075/116','Nur Aini','XI OTKP','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('690','5','293','3','6','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','377/075/116','Nur Aini','XI OTKP','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('691','5','293','3','7','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','377/075/116','Nur Aini','XI OTKP','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('692','5','293','3','8','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','377/075/116','Nur Aini','XI OTKP','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('693','5','293','3','9','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','377/075/116','Nur Aini','XI OTKP','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('694','5','293','3','10','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','377/075/116','Nur Aini','XI OTKP','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('695','5','293','3','11','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','377/075/116','Nur Aini','XI OTKP','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('696','5','293','3','12','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','377/075/116','Nur Aini','XI OTKP','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('697','5','294','3','1','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','378/076/116','Puspa Rida Umma','XI OTKP','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('698','5','294','3','2','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','378/076/116','Puspa Rida Umma','XI OTKP','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('699','5','294','3','3','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','378/076/116','Puspa Rida Umma','XI OTKP','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('700','5','294','3','4','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','378/076/116','Puspa Rida Umma','XI OTKP','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('701','5','294','3','5','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','378/076/116','Puspa Rida Umma','XI OTKP','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('702','5','294','3','6','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','378/076/116','Puspa Rida Umma','XI OTKP','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('703','5','294','3','7','55000','2020-01-30 00:00:00','2020-01-30 13:06:07','1','4','DANA BULANAN','2019/2020','378/076/116','Puspa Rida Umma','XI OTKP','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('704','5','294','3','8','55000','2020-01-30 00:00:00','2020-01-30 13:06:10','1','4','DANA BULANAN','2019/2020','378/076/116','Puspa Rida Umma','XI OTKP','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('705','5','294','3','9','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','378/076/116','Puspa Rida Umma','XI OTKP','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('706','5','294','3','10','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','378/076/116','Puspa Rida Umma','XI OTKP','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('707','5','294','3','11','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','378/076/116','Puspa Rida Umma','XI OTKP','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('708','5','294','3','12','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','378/076/116','Puspa Rida Umma','XI OTKP','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('709','5','295','3','1','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','380/078/116','Seza Aprilia','XI OTKP','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('710','5','295','3','2','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','380/078/116','Seza Aprilia','XI OTKP','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('711','5','295','3','3','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','380/078/116','Seza Aprilia','XI OTKP','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('712','5','295','3','4','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','380/078/116','Seza Aprilia','XI OTKP','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('713','5','295','3','5','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','380/078/116','Seza Aprilia','XI OTKP','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('714','5','295','3','6','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','380/078/116','Seza Aprilia','XI OTKP','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('715','5','295','3','7','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','380/078/116','Seza Aprilia','XI OTKP','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('716','5','295','3','8','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','380/078/116','Seza Aprilia','XI OTKP','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('717','5','295','3','9','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','380/078/116','Seza Aprilia','XI OTKP','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('718','5','295','3','10','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','380/078/116','Seza Aprilia','XI OTKP','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('719','5','295','3','11','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','380/078/116','Seza Aprilia','XI OTKP','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('720','5','295','3','12','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','380/078/116','Seza Aprilia','XI OTKP','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('721','5','296','3','1','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','382/080/116','Siti Wasilah','XI OTKP','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('722','5','296','3','2','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','382/080/116','Siti Wasilah','XI OTKP','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('723','5','296','3','3','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','382/080/116','Siti Wasilah','XI OTKP','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('724','5','296','3','4','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','382/080/116','Siti Wasilah','XI OTKP','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('725','5','296','3','5','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','382/080/116','Siti Wasilah','XI OTKP','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('726','5','296','3','6','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','382/080/116','Siti Wasilah','XI OTKP','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('727','5','296','3','7','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','382/080/116','Siti Wasilah','XI OTKP','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('728','5','296','3','8','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','382/080/116','Siti Wasilah','XI OTKP','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('729','5','296','3','9','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','382/080/116','Siti Wasilah','XI OTKP','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('730','5','296','3','10','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','382/080/116','Siti Wasilah','XI OTKP','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('731','5','296','3','11','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','382/080/116','Siti Wasilah','XI OTKP','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('732','5','296','3','12','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','382/080/116','Siti Wasilah','XI OTKP','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('733','5','297','3','1','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','383/081/116','Wahyudi Ismail','XI OTKP','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('734','5','297','3','2','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','383/081/116','Wahyudi Ismail','XI OTKP','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('735','5','297','3','3','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','383/081/116','Wahyudi Ismail','XI OTKP','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('736','5','297','3','4','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','383/081/116','Wahyudi Ismail','XI OTKP','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('737','5','297','3','5','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','383/081/116','Wahyudi Ismail','XI OTKP','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('738','5','297','3','6','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','383/081/116','Wahyudi Ismail','XI OTKP','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('739','5','297','3','7','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','383/081/116','Wahyudi Ismail','XI OTKP','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('740','5','297','3','8','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','383/081/116','Wahyudi Ismail','XI OTKP','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('741','5','297','3','9','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','383/081/116','Wahyudi Ismail','XI OTKP','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('742','5','297','3','10','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','383/081/116','Wahyudi Ismail','XI OTKP','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('743','5','297','3','11','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','383/081/116','Wahyudi Ismail','XI OTKP','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('744','5','297','3','12','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','383/081/116','Wahyudi Ismail','XI OTKP','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('745','5','298','3','1','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','384/082/116','Yeni Fitriani','XI OTKP','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('746','5','298','3','2','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','384/082/116','Yeni Fitriani','XI OTKP','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('747','5','298','3','3','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','384/082/116','Yeni Fitriani','XI OTKP','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('748','5','298','3','4','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','384/082/116','Yeni Fitriani','XI OTKP','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('749','5','298','3','5','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','384/082/116','Yeni Fitriani','XI OTKP','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('750','5','298','3','6','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','384/082/116','Yeni Fitriani','XI OTKP','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('751','5','298','3','7','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','384/082/116','Yeni Fitriani','XI OTKP','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('752','5','298','3','8','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','384/082/116','Yeni Fitriani','XI OTKP','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('753','5','298','3','9','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','384/082/116','Yeni Fitriani','XI OTKP','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('754','5','298','3','10','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','384/082/116','Yeni Fitriani','XI OTKP','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('755','5','298','3','11','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','384/082/116','Yeni Fitriani','XI OTKP','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('756','5','298','3','12','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','384/082/116','Yeni Fitriani','XI OTKP','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1285','5','370','6','1','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','313/039/110','Arjun Rhamadani','XI OTKP','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1286','5','370','6','2','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','313/039/110','Arjun Rhamadani','XI OTKP','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1287','5','370','6','3','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','313/039/110','Arjun Rhamadani','XI OTKP','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1288','5','370','6','4','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','313/039/110','Arjun Rhamadani','XI OTKP','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1289','5','370','6','5','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','313/039/110','Arjun Rhamadani','XI OTKP','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1290','5','370','6','6','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','313/039/110','Arjun Rhamadani','XI OTKP','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1291','5','370','6','7','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','313/039/110','Arjun Rhamadani','XI OTKP','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1292','5','370','6','8','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','313/039/110','Arjun Rhamadani','XI OTKP','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1293','5','370','6','9','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','313/039/110','Arjun Rhamadani','XI OTKP','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1294','5','370','6','10','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','313/039/110','Arjun Rhamadani','XI OTKP','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1295','5','370','6','11','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','313/039/110','Arjun Rhamadani','XI OTKP','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1296','5','370','6','12','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','313/039/110','Arjun Rhamadani','XI OTKP','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1297','5','371','6','1','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','314/040/110','Dewi Aisah','XI OTKP','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1298','5','371','6','2','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','314/040/110','Dewi Aisah','XI OTKP','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1299','5','371','6','3','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','314/040/110','Dewi Aisah','XI OTKP','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1300','5','371','6','4','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','314/040/110','Dewi Aisah','XI OTKP','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1301','5','371','6','5','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','314/040/110','Dewi Aisah','XI OTKP','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1302','5','371','6','6','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','314/040/110','Dewi Aisah','XI OTKP','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1303','5','371','6','7','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','314/040/110','Dewi Aisah','XI OTKP','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1304','5','371','6','8','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','314/040/110','Dewi Aisah','XI OTKP','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1305','5','371','6','9','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','314/040/110','Dewi Aisah','XI OTKP','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1306','5','371','6','10','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','314/040/110','Dewi Aisah','XI OTKP','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1307','5','371','6','11','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','314/040/110','Dewi Aisah','XI OTKP','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1308','5','371','6','12','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','314/040/110','Dewi Aisah','XI OTKP','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1309','5','372','6','1','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','315/041/110','Fita Ratnaningtiyas','XI OTKP','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1310','5','372','6','2','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','315/041/110','Fita Ratnaningtiyas','XI OTKP','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1311','5','372','6','3','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','315/041/110','Fita Ratnaningtiyas','XI OTKP','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1312','5','372','6','4','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','315/041/110','Fita Ratnaningtiyas','XI OTKP','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1313','5','372','6','5','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','315/041/110','Fita Ratnaningtiyas','XI OTKP','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1314','5','372','6','6','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','315/041/110','Fita Ratnaningtiyas','XI OTKP','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1315','5','372','6','7','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','315/041/110','Fita Ratnaningtiyas','XI OTKP','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1316','5','372','6','8','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','315/041/110','Fita Ratnaningtiyas','XI OTKP','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1317','5','372','6','9','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','315/041/110','Fita Ratnaningtiyas','XI OTKP','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1318','5','372','6','10','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','315/041/110','Fita Ratnaningtiyas','XI OTKP','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1319','5','372','6','11','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','315/041/110','Fita Ratnaningtiyas','XI OTKP','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1320','5','372','6','12','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','315/041/110','Fita Ratnaningtiyas','XI OTKP','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1321','5','374','6','1','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','316/042/110','Mita Agustin','XI OTKP','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1322','5','374','6','2','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','316/042/110','Mita Agustin','XI OTKP','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1323','5','374','6','3','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','316/042/110','Mita Agustin','XI OTKP','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1324','5','374','6','4','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','316/042/110','Mita Agustin','XI OTKP','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1325','5','374','6','5','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','316/042/110','Mita Agustin','XI OTKP','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1326','5','374','6','6','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','316/042/110','Mita Agustin','XI OTKP','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1327','5','374','6','7','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','316/042/110','Mita Agustin','XI OTKP','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1328','5','374','6','8','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','316/042/110','Mita Agustin','XI OTKP','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1329','5','374','6','9','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','316/042/110','Mita Agustin','XI OTKP','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1330','5','374','6','10','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','316/042/110','Mita Agustin','XI OTKP','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1331','5','374','6','11','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','316/042/110','Mita Agustin','XI OTKP','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1332','5','374','6','12','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','316/042/110','Mita Agustin','XI OTKP','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1333','5','377','6','1','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','319/045/110','Sintia Ayu Lestari','XI OTKP','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1334','5','377','6','2','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','319/045/110','Sintia Ayu Lestari','XI OTKP','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1335','5','377','6','3','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','319/045/110','Sintia Ayu Lestari','XI OTKP','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1336','5','377','6','4','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','319/045/110','Sintia Ayu Lestari','XI OTKP','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1337','5','377','6','5','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','319/045/110','Sintia Ayu Lestari','XI OTKP','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1338','5','377','6','6','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','319/045/110','Sintia Ayu Lestari','XI OTKP','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1339','5','377','6','7','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','319/045/110','Sintia Ayu Lestari','XI OTKP','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1340','5','377','6','8','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','319/045/110','Sintia Ayu Lestari','XI OTKP','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1341','5','377','6','9','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','319/045/110','Sintia Ayu Lestari','XI OTKP','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1342','5','377','6','10','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','319/045/110','Sintia Ayu Lestari','XI OTKP','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1343','5','377','6','11','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','319/045/110','Sintia Ayu Lestari','XI OTKP','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1344','5','377','6','12','65000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','319/045/110','Sintia Ayu Lestari','XI OTKP','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('373','5','302','1','1','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','376/049/110','Diana Ulfa','XII APH','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('374','5','302','1','2','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','376/049/110','Diana Ulfa','XII APH','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('375','5','302','1','3','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','376/049/110','Diana Ulfa','XII APH','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('376','5','302','1','4','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','376/049/110','Diana Ulfa','XII APH','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('377','5','302','1','5','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','376/049/110','Diana Ulfa','XII APH','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('378','5','302','1','6','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','376/049/110','Diana Ulfa','XII APH','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('379','5','302','1','7','55000','2020-01-25 00:00:00','2020-01-25 21:10:07','1','4','DANA BULANAN','2019/2020','376/049/110','Diana Ulfa','XII APH','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('380','5','302','1','8','55000','2020-02-10 00:00:00','2020-02-10 13:51:03','1','4','DANA BULANAN','2019/2020','376/049/110','Diana Ulfa','XII APH','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('381','5','302','1','9','55000','2020-02-10 00:00:00','2020-02-10 13:51:05','1','4','DANA BULANAN','2019/2020','376/049/110','Diana Ulfa','XII APH','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('382','5','302','1','10','55000','2020-02-10 00:00:00','2020-02-10 13:51:08','1','4','DANA BULANAN','2019/2020','376/049/110','Diana Ulfa','XII APH','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('383','5','302','1','11','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','376/049/110','Diana Ulfa','XII APH','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('384','5','302','1','12','55000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','376/049/110','Diana Ulfa','XII APH','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('229','5','399','8','1','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','301/035/098','Adelia P','XII APH','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('230','5','399','8','2','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','301/035/098','Adelia P','XII APH','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('231','5','399','8','3','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','301/035/098','Adelia P','XII APH','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('232','5','399','8','4','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','301/035/098','Adelia P','XII APH','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('233','5','399','8','5','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','301/035/098','Adelia P','XII APH','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('234','5','399','8','6','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','301/035/098','Adelia P','XII APH','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('235','5','399','8','7','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','301/035/098','Adelia P','XII APH','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('236','5','399','8','8','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','301/035/098','Adelia P','XII APH','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('237','5','399','8','9','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','301/035/098','Adelia P','XII APH','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('238','5','399','8','10','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','301/035/098','Adelia P','XII APH','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('239','5','399','8','11','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','301/035/098','Adelia P','XII APH','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('240','5','399','8','12','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','301/035/098','Adelia P','XII APH','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('241','5','400','8','1','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','299/033/098','Ahmad Syaifulloh','XII APH','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('242','5','400','8','2','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','299/033/098','Ahmad Syaifulloh','XII APH','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('243','5','400','8','3','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','299/033/098','Ahmad Syaifulloh','XII APH','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('244','5','400','8','4','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','299/033/098','Ahmad Syaifulloh','XII APH','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('245','5','400','8','5','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','299/033/098','Ahmad Syaifulloh','XII APH','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('246','5','400','8','6','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','299/033/098','Ahmad Syaifulloh','XII APH','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('247','5','400','8','7','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','299/033/098','Ahmad Syaifulloh','XII APH','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('248','5','400','8','8','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','299/033/098','Ahmad Syaifulloh','XII APH','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('249','5','400','8','9','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','299/033/098','Ahmad Syaifulloh','XII APH','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('250','5','400','8','10','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','299/033/098','Ahmad Syaifulloh','XII APH','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('251','5','400','8','11','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','299/033/098','Ahmad Syaifulloh','XII APH','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('252','5','400','8','12','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','299/033/098','Ahmad Syaifulloh','XII APH','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('253','5','401','8','1','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','294/028/098','Aprilia Prahesti Utami','XII APH','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('254','5','401','8','2','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','294/028/098','Aprilia Prahesti Utami','XII APH','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('255','5','401','8','3','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','294/028/098','Aprilia Prahesti Utami','XII APH','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('256','5','401','8','4','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','294/028/098','Aprilia Prahesti Utami','XII APH','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('257','5','401','8','5','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','294/028/098','Aprilia Prahesti Utami','XII APH','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('258','5','401','8','6','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','294/028/098','Aprilia Prahesti Utami','XII APH','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('259','5','401','8','7','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','294/028/098','Aprilia Prahesti Utami','XII APH','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('260','5','401','8','8','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','294/028/098','Aprilia Prahesti Utami','XII APH','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('261','5','401','8','9','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','294/028/098','Aprilia Prahesti Utami','XII APH','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('262','5','401','8','10','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','294/028/098','Aprilia Prahesti Utami','XII APH','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('263','5','401','8','11','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','294/028/098','Aprilia Prahesti Utami','XII APH','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('264','5','401','8','12','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','294/028/098','Aprilia Prahesti Utami','XII APH','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('265','5','402','8','1','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','302/036/098','Davit Agung Prayogo','XII APH','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('266','5','402','8','2','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','302/036/098','Davit Agung Prayogo','XII APH','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('267','5','402','8','3','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','302/036/098','Davit Agung Prayogo','XII APH','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('268','5','402','8','4','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','302/036/098','Davit Agung Prayogo','XII APH','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('269','5','402','8','5','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','302/036/098','Davit Agung Prayogo','XII APH','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('270','5','402','8','6','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','302/036/098','Davit Agung Prayogo','XII APH','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('271','5','402','8','7','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','302/036/098','Davit Agung Prayogo','XII APH','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('272','5','402','8','8','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','302/036/098','Davit Agung Prayogo','XII APH','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('273','5','402','8','9','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','302/036/098','Davit Agung Prayogo','XII APH','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('274','5','402','8','10','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','302/036/098','Davit Agung Prayogo','XII APH','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('275','5','402','8','11','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','302/036/098','Davit Agung Prayogo','XII APH','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('276','5','402','8','12','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','302/036/098','Davit Agung Prayogo','XII APH','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('277','5','403','8','1','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','295/029/098','Eka Ulansari','XII APH','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('278','5','403','8','2','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','295/029/098','Eka Ulansari','XII APH','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('279','5','403','8','3','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','295/029/098','Eka Ulansari','XII APH','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('280','5','403','8','4','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','295/029/098','Eka Ulansari','XII APH','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('281','5','403','8','5','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','295/029/098','Eka Ulansari','XII APH','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('282','5','403','8','6','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','295/029/098','Eka Ulansari','XII APH','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('283','5','403','8','7','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','295/029/098','Eka Ulansari','XII APH','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('284','5','403','8','8','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','295/029/098','Eka Ulansari','XII APH','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('285','5','403','8','9','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','295/029/098','Eka Ulansari','XII APH','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('286','5','403','8','10','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','295/029/098','Eka Ulansari','XII APH','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('287','5','403','8','11','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','295/029/098','Eka Ulansari','XII APH','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('288','5','403','8','12','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','295/029/098','Eka Ulansari','XII APH','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('289','5','404','8','1','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','296/030/098','Faizatul Fitri','XII APH','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('290','5','404','8','2','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','296/030/098','Faizatul Fitri','XII APH','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('291','5','404','8','3','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','296/030/098','Faizatul Fitri','XII APH','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('292','5','404','8','4','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','296/030/098','Faizatul Fitri','XII APH','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('293','5','404','8','5','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','296/030/098','Faizatul Fitri','XII APH','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('294','5','404','8','6','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','296/030/098','Faizatul Fitri','XII APH','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('295','5','404','8','7','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','296/030/098','Faizatul Fitri','XII APH','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('296','5','404','8','8','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','296/030/098','Faizatul Fitri','XII APH','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('297','5','404','8','9','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','296/030/098','Faizatul Fitri','XII APH','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('298','5','404','8','10','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','296/030/098','Faizatul Fitri','XII APH','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('299','5','404','8','11','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','296/030/098','Faizatul Fitri','XII APH','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('300','5','404','8','12','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','296/030/098','Faizatul Fitri','XII APH','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('301','5','405','8','1','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','311/033/098','Faris Abid Muwaffaq','XII APH','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('302','5','405','8','2','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','311/033/098','Faris Abid Muwaffaq','XII APH','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('303','5','405','8','3','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','311/033/098','Faris Abid Muwaffaq','XII APH','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('304','5','405','8','4','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','311/033/098','Faris Abid Muwaffaq','XII APH','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('305','5','405','8','5','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','311/033/098','Faris Abid Muwaffaq','XII APH','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('306','5','405','8','6','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','311/033/098','Faris Abid Muwaffaq','XII APH','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('307','5','405','8','7','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','311/033/098','Faris Abid Muwaffaq','XII APH','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('308','5','405','8','8','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','311/033/098','Faris Abid Muwaffaq','XII APH','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('309','5','405','8','9','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','311/033/098','Faris Abid Muwaffaq','XII APH','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('310','5','405','8','10','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','311/033/098','Faris Abid Muwaffaq','XII APH','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('311','5','405','8','11','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','311/033/098','Faris Abid Muwaffaq','XII APH','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('312','5','405','8','12','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','311/033/098','Faris Abid Muwaffaq','XII APH','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('313','5','406','8','1','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','297/031/098','Firman Bastomi','XII APH','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('314','5','406','8','2','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','297/031/098','Firman Bastomi','XII APH','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('315','5','406','8','3','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','297/031/098','Firman Bastomi','XII APH','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('316','5','406','8','4','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','297/031/098','Firman Bastomi','XII APH','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('317','5','406','8','5','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','297/031/098','Firman Bastomi','XII APH','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('318','5','406','8','6','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','297/031/098','Firman Bastomi','XII APH','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('319','5','406','8','7','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','297/031/098','Firman Bastomi','XII APH','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('320','5','406','8','8','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','297/031/098','Firman Bastomi','XII APH','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('321','5','406','8','9','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','297/031/098','Firman Bastomi','XII APH','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('322','5','406','8','10','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','297/031/098','Firman Bastomi','XII APH','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('323','5','406','8','11','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','297/031/098','Firman Bastomi','XII APH','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('324','5','406','8','12','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','297/031/098','Firman Bastomi','XII APH','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('325','5','407','8','1','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','300/034/098','Medi Denes Saputra','XII APH','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('326','5','407','8','2','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','300/034/098','Medi Denes Saputra','XII APH','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('327','5','407','8','3','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','300/034/098','Medi Denes Saputra','XII APH','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('328','5','407','8','4','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','300/034/098','Medi Denes Saputra','XII APH','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('329','5','407','8','5','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','300/034/098','Medi Denes Saputra','XII APH','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('330','5','407','8','6','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','300/034/098','Medi Denes Saputra','XII APH','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('331','5','407','8','7','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','300/034/098','Medi Denes Saputra','XII APH','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('332','5','407','8','8','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','300/034/098','Medi Denes Saputra','XII APH','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('333','5','407','8','9','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','300/034/098','Medi Denes Saputra','XII APH','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('334','5','407','8','10','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','300/034/098','Medi Denes Saputra','XII APH','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('335','5','407','8','11','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','300/034/098','Medi Denes Saputra','XII APH','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('336','5','407','8','12','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','300/034/098','Medi Denes Saputra','XII APH','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('337','5','408','8','1','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','298/032/098','Rika Supiyati','XII APH','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('338','5','408','8','2','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','298/032/098','Rika Supiyati','XII APH','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('339','5','408','8','3','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','298/032/098','Rika Supiyati','XII APH','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('340','5','408','8','4','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','298/032/098','Rika Supiyati','XII APH','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('341','5','408','8','5','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','298/032/098','Rika Supiyati','XII APH','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('342','5','408','8','6','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','298/032/098','Rika Supiyati','XII APH','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('343','5','408','8','7','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','298/032/098','Rika Supiyati','XII APH','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('344','5','408','8','8','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','298/032/098','Rika Supiyati','XII APH','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('345','5','408','8','9','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','298/032/098','Rika Supiyati','XII APH','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('346','5','408','8','10','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','298/032/098','Rika Supiyati','XII APH','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('347','5','408','8','11','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','298/032/098','Rika Supiyati','XII APH','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('348','5','408','8','12','75000',NULL,NULL,'0','4','DANA BULANAN','2019/2020','298/032/098','Rika Supiyati','XII APH','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1585','53','409','1','1','50000',NULL,NULL,'0','5','SPP Bulanan','2020/2021','123','rsad','X OTKP','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1586','53','409','1','2','50000',NULL,NULL,'0','5','SPP Bulanan','2020/2021','123','rsad','X OTKP','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1587','53','409','1','3','50000',NULL,NULL,'0','5','SPP Bulanan','2020/2021','123','rsad','X OTKP','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1588','53','409','1','4','50000',NULL,NULL,'0','5','SPP Bulanan','2020/2021','123','rsad','X OTKP','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1589','53','409','1','5','50000',NULL,NULL,'0','5','SPP Bulanan','2020/2021','123','rsad','X OTKP','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1590','53','409','1','6','50000',NULL,NULL,'0','5','SPP Bulanan','2020/2021','123','rsad','X OTKP','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1591','53','409','1','7','50000',NULL,NULL,'0','5','SPP Bulanan','2020/2021','123','rsad','X OTKP','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1592','53','409','1','8','50000',NULL,NULL,'0','5','SPP Bulanan','2020/2021','123','rsad','X OTKP','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1593','53','409','1','9','50000',NULL,NULL,'0','5','SPP Bulanan','2020/2021','123','rsad','X OTKP','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1594','53','409','1','10','50000',NULL,NULL,'0','5','SPP Bulanan','2020/2021','123','rsad','X OTKP','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1595','53','409','1','11','50000',NULL,NULL,'0','5','SPP Bulanan','2020/2021','123','rsad','X OTKP','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1596','53','409','1','12','50000',NULL,NULL,'0','5','SPP Bulanan','2020/2021','123','rsad','X OTKP','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1573','53','303','1','1','50000',NULL,NULL,'0','5','SPP Bulanan','2020/2021','377/050/110','Dimas Viktor Risman','XI TKJ','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1574','53','303','1','2','50000',NULL,NULL,'0','5','SPP Bulanan','2020/2021','377/050/110','Dimas Viktor Risman','XI TKJ','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1575','53','303','1','3','50000',NULL,NULL,'0','5','SPP Bulanan','2020/2021','377/050/110','Dimas Viktor Risman','XI TKJ','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1576','53','303','1','4','50000',NULL,NULL,'0','5','SPP Bulanan','2020/2021','377/050/110','Dimas Viktor Risman','XI TKJ','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1577','53','303','1','5','50000',NULL,NULL,'0','5','SPP Bulanan','2020/2021','377/050/110','Dimas Viktor Risman','XI TKJ','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1578','53','303','1','6','50000',NULL,NULL,'0','5','SPP Bulanan','2020/2021','377/050/110','Dimas Viktor Risman','XI TKJ','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1579','53','303','1','7','50000',NULL,NULL,'0','5','SPP Bulanan','2020/2021','377/050/110','Dimas Viktor Risman','XI TKJ','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1580','53','303','1','8','50000',NULL,NULL,'0','5','SPP Bulanan','2020/2021','377/050/110','Dimas Viktor Risman','XI TKJ','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1581','53','303','1','9','50000',NULL,NULL,'0','5','SPP Bulanan','2020/2021','377/050/110','Dimas Viktor Risman','XI TKJ','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1582','53','303','1','10','50000',NULL,NULL,'0','5','SPP Bulanan','2020/2021','377/050/110','Dimas Viktor Risman','XI TKJ','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1583','53','303','1','11','50000',NULL,NULL,'0','5','SPP Bulanan','2020/2021','377/050/110','Dimas Viktor Risman','XI TKJ','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1584','53','303','1','12','50000',NULL,NULL,'0','5','SPP Bulanan','2020/2021','377/050/110','Dimas Viktor Risman','XI TKJ','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1597','65','409','1','1','0',NULL,NULL,'0','8','SPP BULAN JUNI','2019/2020','123','rsad','X OTKP','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1598','65','409','1','2','0',NULL,NULL,'0','8','SPP BULAN JUNI','2019/2020','123','rsad','X OTKP','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1599','65','409','1','3','0',NULL,NULL,'0','8','SPP BULAN JUNI','2019/2020','123','rsad','X OTKP','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1600','65','409','1','4','0',NULL,NULL,'0','8','SPP BULAN JUNI','2019/2020','123','rsad','X OTKP','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1601','65','409','1','5','0',NULL,NULL,'0','8','SPP BULAN JUNI','2019/2020','123','rsad','X OTKP','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1602','65','409','1','6','0',NULL,NULL,'0','8','SPP BULAN JUNI','2019/2020','123','rsad','X OTKP','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1603','65','409','1','7','0',NULL,NULL,'0','8','SPP BULAN JUNI','2019/2020','123','rsad','X OTKP','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1604','65','409','1','8','0',NULL,NULL,'0','8','SPP BULAN JUNI','2019/2020','123','rsad','X OTKP','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1605','65','409','1','9','0',NULL,NULL,'0','8','SPP BULAN JUNI','2019/2020','123','rsad','X OTKP','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1606','65','409','1','10','0',NULL,NULL,'0','8','SPP BULAN JUNI','2019/2020','123','rsad','X OTKP','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1607','65','409','1','11','0',NULL,NULL,'0','8','SPP BULAN JUNI','2019/2020','123','rsad','X OTKP','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1608','65','409','1','12','0',NULL,NULL,'0','8','SPP BULAN JUNI','2019/2020','123','rsad','X OTKP','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1609','65','415','1','1','0',NULL,NULL,'0','8','SPP BULAN JUNI','2019/2020','0001','abcd','X OTKP','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1610','65','415','1','2','0',NULL,NULL,'0','8','SPP BULAN JUNI','2019/2020','0001','abcd','X OTKP','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1611','65','415','1','3','0',NULL,NULL,'0','8','SPP BULAN JUNI','2019/2020','0001','abcd','X OTKP','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1612','65','415','1','4','0',NULL,NULL,'0','8','SPP BULAN JUNI','2019/2020','0001','abcd','X OTKP','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1613','65','415','1','5','0',NULL,NULL,'0','8','SPP BULAN JUNI','2019/2020','0001','abcd','X OTKP','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1614','65','415','1','6','0',NULL,NULL,'0','8','SPP BULAN JUNI','2019/2020','0001','abcd','X OTKP','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1615','65','415','1','7','0',NULL,NULL,'0','8','SPP BULAN JUNI','2019/2020','0001','abcd','X OTKP','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1616','65','415','1','8','0',NULL,NULL,'0','8','SPP BULAN JUNI','2019/2020','0001','abcd','X OTKP','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1617','65','415','1','9','0',NULL,NULL,'0','8','SPP BULAN JUNI','2019/2020','0001','abcd','X OTKP','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1618','65','415','1','10','0',NULL,NULL,'0','8','SPP BULAN JUNI','2019/2020','0001','abcd','X OTKP','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1619','65','415','1','11','0',NULL,NULL,'0','8','SPP BULAN JUNI','2019/2020','0001','abcd','X OTKP','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('1620','65','415','1','12','0',NULL,NULL,'0','8','SPP BULAN JUNI','2019/2020','0001','abcd','X OTKP','Desember','6','Tunai');
