
/*---------------------------------------------------------------
  SQL DB BACKUP 06.07.2021 17:24 
  HOST: localhost
  DATABASE: spp_live
  TABLES: *
  ---------------------------------------------------------------*/

/*---------------------------------------------------------------
  TABLE: `angsurantoko`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `angsurantoko`;
CREATE TABLE `angsurantoko` (
  `id_angsurantoko` varchar(10) NOT NULL,
  `id_hutangtoko` varchar(10) NOT NULL,
  `tanggal` date NOT NULL,
  `angsuran` int(11) NOT NULL,
  PRIMARY KEY (`id_angsurantoko`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*---------------------------------------------------------------
  TABLE: `bulan`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `bulan`;
CREATE TABLE `bulan` (
  `idBulan` varchar(15) NOT NULL DEFAULT '0',
  `nmBulan` varchar(25) DEFAULT NULL,
  `urutan` int(2) DEFAULT NULL,
  PRIMARY KEY (`idBulan`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
INSERT INTO `bulan` VALUES   ('1','Januari','7');
INSERT INTO `bulan` VALUES ('10','Oktober','4');
INSERT INTO `bulan` VALUES ('11','November','5');
INSERT INTO `bulan` VALUES ('12','Desember','6');
INSERT INTO `bulan` VALUES ('2','Februari','8');
INSERT INTO `bulan` VALUES ('3','Maret','9');
INSERT INTO `bulan` VALUES ('4','April','10');
INSERT INTO `bulan` VALUES ('5','Mei','11');
INSERT INTO `bulan` VALUES ('6','Juni','12');
INSERT INTO `bulan` VALUES ('7','Juli','1');
INSERT INTO `bulan` VALUES ('8','Agustus','2');
INSERT INTO `bulan` VALUES ('9','September','3');

/*---------------------------------------------------------------
  TABLE: `hutangtoko`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `hutangtoko`;
CREATE TABLE `hutangtoko` (
  `id_hutangtoko` varchar(10) NOT NULL,
  `hutangke` varchar(50) NOT NULL,
  `tanggal` date NOT NULL,
  `ket` varchar(100) NOT NULL,
  `nominal` int(11) NOT NULL,
  `sisa` int(11) NOT NULL,
  PRIMARY KEY (`id_hutangtoko`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

/*---------------------------------------------------------------
  TABLE: `identitas`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `identitas`;
CREATE TABLE `identitas` (
  `npsn` varchar(8) NOT NULL,
  `nmSekolah` varchar(100) DEFAULT NULL,
  `alamat` varchar(255) DEFAULT NULL,
  `kabupaten` varchar(100) NOT NULL,
  `propinsi` varchar(100) NOT NULL,
  `nipKepsek` varchar(20) DEFAULT NULL,
  `nmKepsek` varchar(100) DEFAULT NULL,
  `nipKaTU` varchar(20) DEFAULT NULL,
  `nmKaTU` varchar(100) DEFAULT NULL,
  `nipBendahara` varchar(20) DEFAULT NULL,
  `nmBendahara` varchar(100) DEFAULT NULL,
  `logo_kiri` varchar(255) DEFAULT NULL,
  `logo_kanan` varchar(100) NOT NULL,
  PRIMARY KEY (`npsn`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
INSERT INTO `identitas` VALUES   ('10700295','SMK TARUNA HARAPAN 1 CIPATAT','Jl. Angker No.111','Cipatat','Jawa Barat','-','Jojon.Spd.','-','ANISA ANJARSARI ','','SHOLIHATUL FAHMI','APA AJA.png','Barokah Channel.png');

/*---------------------------------------------------------------
  TABLE: `jenis_bayar`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `jenis_bayar`;
CREATE TABLE `jenis_bayar` (
  `idJenisBayar` int(10) NOT NULL AUTO_INCREMENT,
  `idPosBayar` int(5) DEFAULT NULL,
  `idTahunAjaran` int(5) DEFAULT NULL,
  `nmJenisBayar` varchar(100) DEFAULT NULL,
  `tipeBayar` enum('bulanan','bebas') DEFAULT 'bulanan',
  PRIMARY KEY (`idJenisBayar`),
  KEY `fk_pos` (`idPosBayar`),
  KEY `fk_tahun` (`idTahunAjaran`),
  CONSTRAINT `fk_pos` FOREIGN KEY (`idPosBayar`) REFERENCES `pos_bayar` (`idPosBayar`) ON UPDATE CASCADE,
  CONSTRAINT `fk_tahun` FOREIGN KEY (`idTahunAjaran`) REFERENCES `tahun_ajaran` (`idTahunAjaran`) ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=latin1;
INSERT INTO `jenis_bayar` VALUES   ('15','6','9','SPP Bulanan Kelas X','bulanan');
INSERT INTO `jenis_bayar` VALUES ('18','7','9','SPP Bulanan Kelas XI','bulanan');

/*---------------------------------------------------------------
  TABLE: `jurnal_umum`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `jurnal_umum`;
CREATE TABLE `jurnal_umum` (
  `id` int(50) NOT NULL AUTO_INCREMENT,
  `tgl` date DEFAULT NULL,
  `ket` varchar(100) DEFAULT NULL,
  `penerimaan` int(10) DEFAULT '0',
  `pengeluaran` int(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=latin1;

/*---------------------------------------------------------------
  TABLE: `kas`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `kas`;
CREATE TABLE `kas` (
  `kode` int(11) NOT NULL AUTO_INCREMENT,
  `keterangan` varchar(300) NOT NULL,
  `idKelas` int(50) NOT NULL,
  `tgl` date NOT NULL,
  `jumlah` int(10) NOT NULL,
  `jenis` varchar(20) NOT NULL,
  `keluar` int(20) NOT NULL,
  PRIMARY KEY (`kode`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

/*---------------------------------------------------------------
  TABLE: `kelas_siswa`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `kelas_siswa`;
CREATE TABLE `kelas_siswa` (
  `idKelas` int(5) NOT NULL AUTO_INCREMENT,
  `nmKelas` varchar(20) DEFAULT NULL,
  `ketKelas` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`idKelas`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=latin1;
INSERT INTO `kelas_siswa` VALUES   ('11','X RPL 1','');
INSERT INTO `kelas_siswa` VALUES ('12','XI RPL 2','');
INSERT INTO `kelas_siswa` VALUES ('13','XI RPL 3','');
INSERT INTO `kelas_siswa` VALUES ('14','XII RPL 1','');
INSERT INTO `kelas_siswa` VALUES ('15','X RPL 2','');

/*---------------------------------------------------------------
  TABLE: `kwitansi`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `kwitansi`;
CREATE TABLE `kwitansi` (
  `id_kwitansi` varchar(30) NOT NULL,
  `id_siswa` int(11) NOT NULL,
  `tgl_cetak` datetime NOT NULL,
  PRIMARY KEY (`id_kwitansi`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
INSERT INTO `kwitansi` VALUES   ('KWT00000001','420','2021-07-06 03:04:59');

/*---------------------------------------------------------------
  TABLE: `memodb`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `memodb`;
CREATE TABLE `memodb` (
  `kwnum` varchar(20) NOT NULL,
  `nominal` int(11) NOT NULL,
  `payee` varchar(25) NOT NULL,
  `pic` varchar(25) NOT NULL,
  `tglkw` varchar(20) NOT NULL,
  `ktrg` text NOT NULL,
  PRIMARY KEY (`kwnum`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*---------------------------------------------------------------
  TABLE: `pos_bayar`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `pos_bayar`;
CREATE TABLE `pos_bayar` (
  `idPosBayar` int(5) NOT NULL AUTO_INCREMENT,
  `nmPosBayar` varchar(100) DEFAULT NULL,
  `ketPosBayar` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`idPosBayar`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=latin1;
INSERT INTO `pos_bayar` VALUES   ('6','SMK TARUNA HARAPAN 1 CIPATAT',NULL);
INSERT INTO `pos_bayar` VALUES ('7','SPP Bulanan Kelas XI','');

/*---------------------------------------------------------------
  TABLE: `siswa`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `siswa`;
CREATE TABLE `siswa` (
  `idSiswa` int(10) NOT NULL AUTO_INCREMENT,
  `nisSiswa` varchar(25) DEFAULT NULL,
  `nisnSiswa` varchar(25) DEFAULT NULL,
  `nmSiswa` varchar(100) DEFAULT NULL,
  `jkSiswa` varchar(15) DEFAULT NULL,
  `unitSiswa` varchar(100) NOT NULL,
  `agamaSiswa` varchar(15) DEFAULT NULL,
  `idKelas` int(5) DEFAULT NULL,
  `statusSiswa` enum('Aktif','Non Aktif','Pindah','Drop Out','Lulus') DEFAULT 'Aktif',
  `username` varchar(20) NOT NULL,
  `password` varchar(200) DEFAULT NULL,
  `level` varchar(10) NOT NULL,
  `nmOrtu` varchar(40) DEFAULT NULL,
  `alamatOrtu` varchar(100) DEFAULT NULL,
  `noHpOrtu` varchar(30) DEFAULT NULL,
  `saldo` double NOT NULL,
  PRIMARY KEY (`idSiswa`),
  KEY `fk_kelas` (`idKelas`),
  KEY `fk_status` (`statusSiswa`),
  CONSTRAINT `fk_kelas` FOREIGN KEY (`idKelas`) REFERENCES `kelas_siswa` (`idKelas`) ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=422 DEFAULT CHARSET=latin1;
INSERT INTO `siswa` VALUES   ('420','1','1','fahmi','L','6','Islam','11','Aktif','-','-','siswa','rehan','Jl. Ters. Nilem Barat No. 49, B No.Kel, Pasirluyu, Kec. Regol, Kota Bandung, Jawa Barat 40254','+10225208735','0');
INSERT INTO `siswa` VALUES ('421','2','2','restu','L','7','Islam','12','Aktif','--','--','siswa','rehan','Jl. Terusan Nilem Barat No. 49B, Selatan Kec. Regol, Pasirluyu, Regol, Kota Bandung, Jawa Barat 4025','0225208735','0');

/*---------------------------------------------------------------
  TABLE: `tagihan_bebas`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `tagihan_bebas`;
CREATE TABLE `tagihan_bebas` (
  `idTagihanBebas` int(50) NOT NULL AUTO_INCREMENT,
  `idJenisBayar` int(5) DEFAULT NULL,
  `idSiswa` int(10) DEFAULT NULL,
  `idKelas` int(5) DEFAULT NULL,
  `totalTagihan` int(10) DEFAULT NULL,
  `statusBayar` enum('0','1','2') DEFAULT '0',
  `TglTagihan` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idTagihanBebas`),
  KEY `fk_t_jenis` (`idJenisBayar`),
  KEY `fk_t_siswa` (`idSiswa`),
  KEY `fk_t_kelas` (`idKelas`),
  CONSTRAINT `tagihan_bebas_ibfk_2` FOREIGN KEY (`idJenisBayar`) REFERENCES `jenis_bayar` (`idJenisBayar`) ON UPDATE CASCADE,
  CONSTRAINT `tagihan_bebas_ibfk_3` FOREIGN KEY (`idKelas`) REFERENCES `kelas_siswa` (`idKelas`) ON UPDATE CASCADE,
  CONSTRAINT `tagihan_bebas_ibfk_4` FOREIGN KEY (`idSiswa`) REFERENCES `siswa` (`idSiswa`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=latin1;

/*---------------------------------------------------------------
  TABLE: `tagihan_bebas_bayar`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `tagihan_bebas_bayar`;
CREATE TABLE `tagihan_bebas_bayar` (
  `idTagihanBebasBayar` int(50) NOT NULL AUTO_INCREMENT,
  `idTagihanBebas` int(50) DEFAULT NULL,
  `tglBayar` date DEFAULT NULL,
  `jumlahBayar` int(10) DEFAULT NULL,
  `ketBayar` varchar(100) DEFAULT NULL,
  `caraBayar` enum('Tunai','Transfer') DEFAULT 'Tunai',
  PRIMARY KEY (`idTagihanBebasBayar`),
  KEY `fkbayarbebas` (`idTagihanBebas`),
  CONSTRAINT `fkbayarbebas` FOREIGN KEY (`idTagihanBebas`) REFERENCES `tagihan_bebas` (`idTagihanBebas`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

/*---------------------------------------------------------------
  TABLE: `tagihan_bulanan`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `tagihan_bulanan`;
CREATE TABLE `tagihan_bulanan` (
  `idTagihanBulanan` int(50) NOT NULL AUTO_INCREMENT,
  `idJenisBayar` int(5) DEFAULT NULL,
  `idSiswa` int(10) DEFAULT NULL,
  `idKelas` int(5) DEFAULT NULL,
  `idBulan` varchar(15) DEFAULT NULL,
  `jumlahBayar` int(10) DEFAULT NULL,
  `TglTagihan` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `tglBayar` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `tglUpdate` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `statusBayar` enum('0','1') DEFAULT '0',
  `caraBayar` enum('Tunai','Transfer') DEFAULT 'Tunai',
  PRIMARY KEY (`idTagihanBulanan`),
  KEY `fk_t_jenis` (`idJenisBayar`),
  KEY `fk_t_siswa` (`idSiswa`),
  KEY `fk_t_kelas` (`idKelas`),
  KEY `fk_t_bulan` (`idBulan`),
  CONSTRAINT `fk_t_bulan` FOREIGN KEY (`idBulan`) REFERENCES `bulan` (`idBulan`) ON UPDATE CASCADE,
  CONSTRAINT `fk_t_jenis` FOREIGN KEY (`idJenisBayar`) REFERENCES `jenis_bayar` (`idJenisBayar`) ON UPDATE CASCADE,
  CONSTRAINT `fk_t_kelas` FOREIGN KEY (`idKelas`) REFERENCES `kelas_siswa` (`idKelas`) ON UPDATE CASCADE,
  CONSTRAINT `fk_t_siswa` FOREIGN KEY (`idSiswa`) REFERENCES `siswa` (`idSiswa`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=469 DEFAULT CHARSET=latin1;
INSERT INTO `tagihan_bulanan` VALUES   ('445','15','420','11','1','100000','2021-07-06 16:39:24','2021-07-06 00:00:00','2021-07-06 16:39:24','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('446','15','420','11','2','100000','2021-07-06 16:03:37',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('447','15','420','11','3','100000','2021-07-06 16:03:37',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('448','15','420','11','4','100000','2021-07-06 16:03:38',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('449','15','420','11','5','100000','2021-07-06 16:03:38',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('450','15','420','11','6','100000','2021-07-06 16:03:38',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('451','15','420','11','7','100000','2021-07-06 16:05:24','2021-07-06 00:00:00','2021-07-06 16:05:24','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('452','15','420','11','8','100000','2021-07-06 16:05:24','2021-07-06 00:00:00','2021-07-06 16:05:24','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('453','15','420','11','9','100000','2021-07-06 16:39:15','2021-07-06 00:00:00','2021-07-06 16:39:15','1','Transfer');
INSERT INTO `tagihan_bulanan` VALUES ('454','15','420','11','10','100000','2021-07-06 16:39:21','2021-07-06 00:00:00','2021-07-06 16:39:21','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('455','15','420','11','11','100000','2021-07-06 16:39:22','2021-07-06 00:00:00','2021-07-06 16:39:22','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('456','15','420','11','12','100000','2021-07-06 16:39:23','2021-07-06 00:00:00','2021-07-06 16:39:23','1','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('457','18','421','12','1','120000','2021-07-06 16:14:56',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('458','18','421','12','2','120000','2021-07-06 16:14:56',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('459','18','421','12','3','120000','2021-07-06 16:14:56',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('460','18','421','12','4','120000','2021-07-06 16:14:57',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('461','18','421','12','5','120000','2021-07-06 16:14:57',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('462','18','421','12','6','120000','2021-07-06 16:14:57',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('463','18','421','12','7','120000','2021-07-06 16:14:57',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('464','18','421','12','8','120000','2021-07-06 16:14:57',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('465','18','421','12','9','120000','2021-07-06 16:14:57',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('466','18','421','12','10','120000','2021-07-06 16:14:57',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('467','18','421','12','11','120000','2021-07-06 16:14:57',NULL,NULL,'0','Tunai');
INSERT INTO `tagihan_bulanan` VALUES ('468','18','421','12','12','120000','2021-07-06 16:14:57',NULL,NULL,'0','Tunai');

/*---------------------------------------------------------------
  TABLE: `tahun_ajaran`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `tahun_ajaran`;
CREATE TABLE `tahun_ajaran` (
  `idTahunAjaran` int(5) NOT NULL AUTO_INCREMENT,
  `nmTahunAjaran` varchar(9) DEFAULT NULL,
  `aktif` enum('Y','T') DEFAULT 'Y',
  PRIMARY KEY (`idTahunAjaran`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;
INSERT INTO `tahun_ajaran` VALUES   ('9','2020/2021','Y');

/*---------------------------------------------------------------
  TABLE: `transaksi`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `transaksi`;
CREATE TABLE `transaksi` (
  `id_transaksi` varchar(50) NOT NULL,
  `idSiswa` varchar(50) NOT NULL,
  `tanggal` date NOT NULL,
  `debit` int(10) NOT NULL,
  `kredit` int(10) NOT NULL,
  `keterangan` varchar(50) NOT NULL,
  PRIMARY KEY (`id_transaksi`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

/*---------------------------------------------------------------
  TABLE: `users`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `username` varchar(50) COLLATE latin1_general_ci NOT NULL,
  `password` varchar(50) COLLATE latin1_general_ci NOT NULL,
  `nama_lengkap` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `email` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `no_telp` varchar(20) COLLATE latin1_general_ci NOT NULL,
  `level` varchar(20) COLLATE latin1_general_ci NOT NULL DEFAULT 'admin',
  `unit` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `blokir` enum('Y','N') COLLATE latin1_general_ci NOT NULL DEFAULT 'N',
  `idKelas` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `id_session` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `last_login` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`username`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;
INSERT INTO `users` VALUES   ('dodidarmawan@smktarpan1.sch.id','de28f8f7998f23ab4194b51a6029416f','dodidarmawan','dodidarmawan@smktarpan1.sch.id','082218327154','kasir','6','N','','',NULL);
INSERT INTO `users` VALUES ('mrizkyandram@smktarpan1.sch.id','8f49a731effe19ecc5cb67179a21a949','Muhammad Rizky Andra Muchlis','muhammadrizkyandra@smktarpan1.sch.id','082218327154','admin','','N','','',NULL);
INSERT INTO `users` VALUES ('rizal@smktarpan1.sch.id','f80ef4b61dd49d31cbfc38759341a13d','rizal','rizal@smktarpan1.sch.id','082218327154','adminunit','6','N','','',NULL);
INSERT INTO `users` VALUES ('robisanusi@smktarpan1.sch.id','c9ccd7f3c1145515a9d3f7415d5bcbea','robisanusi','robisanusi@smktarpan1.sch.id','082218327154','bendahara','6','N','','',NULL);

/*---------------------------------------------------------------
  TABLE: `view_detil_jenis_bayar`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `view_detil_jenis_bayar`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `view_detil_jenis_bayar` AS select `jenis_bayar`.`idJenisBayar` AS `idJenisBayar`,`jenis_bayar`.`idPosBayar` AS `idPosBayar`,`jenis_bayar`.`idTahunAjaran` AS `idTahunAjaran`,`jenis_bayar`.`nmJenisBayar` AS `nmJenisBayar`,`jenis_bayar`.`tipeBayar` AS `tipeBayar`,`pos_bayar`.`nmPosBayar` AS `nmPosBayar`,`tahun_ajaran`.`nmTahunAjaran` AS `nmTahunAjaran`,`tahun_ajaran`.`aktif` AS `aktif` from ((`jenis_bayar` join `pos_bayar` on((`jenis_bayar`.`idPosBayar` = `pos_bayar`.`idPosBayar`))) join `tahun_ajaran` on((`jenis_bayar`.`idTahunAjaran` = `tahun_ajaran`.`idTahunAjaran`)));
INSERT INTO `view_detil_jenis_bayar` VALUES   ('15','6','9','SPP Bulanan Kelas X','bulanan','SMK TARUNA HARAPAN 1 CIPATAT','2020/2021','Y');
INSERT INTO `view_detil_jenis_bayar` VALUES ('18','7','9','SPP Bulanan Kelas XI','bulanan','SPP Bulanan Kelas XI','2020/2021','Y');

/*---------------------------------------------------------------
  TABLE: `view_detil_siswa`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `view_detil_siswa`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `view_detil_siswa` AS select `siswa`.`idSiswa` AS `idSiswa`,`siswa`.`nisSiswa` AS `nisSiswa`,`siswa`.`nisnSiswa` AS `nisnSiswa`,`siswa`.`nmSiswa` AS `nmSiswa`,`siswa`.`jkSiswa` AS `jkSiswa`,`siswa`.`unitSiswa` AS `unitSiswa`,`siswa`.`agamaSiswa` AS `agamaSiswa`,`siswa`.`idKelas` AS `idKelas`,`siswa`.`statusSiswa` AS `statusSiswa`,`siswa`.`username` AS `username`,`siswa`.`password` AS `password`,`kelas_siswa`.`nmKelas` AS `nmKelas`,`kelas_siswa`.`ketKelas` AS `ketKelas`,`siswa`.`nmOrtu` AS `nmOrtu`,`siswa`.`alamatOrtu` AS `alamatOrtu`,`siswa`.`noHpOrtu` AS `noHpOrtu`,`siswa`.`saldo` AS `saldo` from (`siswa` join `kelas_siswa` on((`siswa`.`idKelas` = `kelas_siswa`.`idKelas`)));
INSERT INTO `view_detil_siswa` VALUES   ('420','1','1','fahmi','L','6','Islam','11','Aktif','-','-','X RPL 1','','rehan','Jl. Ters. Nilem Barat No. 49, B No.Kel, Pasirluyu, Kec. Regol, Kota Bandung, Jawa Barat 40254','+10225208735','0');
INSERT INTO `view_detil_siswa` VALUES ('421','2','2','restu','L','7','Islam','12','Aktif','--','--','XI RPL 2','','rehan','Jl. Terusan Nilem Barat No. 49B, Selatan Kec. Regol, Pasirluyu, Regol, Kota Bandung, Jawa Barat 4025','0225208735','0');

/*---------------------------------------------------------------
  TABLE: `view_laporan_bayar_bulanan`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `view_laporan_bayar_bulanan`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `view_laporan_bayar_bulanan` AS select `tagihan_bulanan`.`idTagihanBulanan` AS `idTagihanBulanan`,`tagihan_bulanan`.`idJenisBayar` AS `idJenisBayar`,`tagihan_bulanan`.`idSiswa` AS `idSiswa`,`tagihan_bulanan`.`idKelas` AS `idKelas`,`tagihan_bulanan`.`idBulan` AS `idBulan`,`tagihan_bulanan`.`jumlahBayar` AS `jumlahBayar`,`tagihan_bulanan`.`tglBayar` AS `tglBayar`,`tagihan_bulanan`.`tglUpdate` AS `tglUpdate`,`tagihan_bulanan`.`statusBayar` AS `statusBayar`,`jenis_bayar`.`idTahunAjaran` AS `idTahunAjaran`,`jenis_bayar`.`nmJenisBayar` AS `nmJenisBayar`,`tahun_ajaran`.`nmTahunAjaran` AS `nmTahunAjaran`,`siswa`.`nisSiswa` AS `nisSiswa`,`siswa`.`nmSiswa` AS `nmSiswa`,`kelas_siswa`.`nmKelas` AS `nmKelas`,`bulan`.`nmBulan` AS `nmBulan`,`bulan`.`urutan` AS `urutan`,`tagihan_bulanan`.`caraBayar` AS `caraBayar` from (((((`tagihan_bulanan` join `jenis_bayar` on((`tagihan_bulanan`.`idJenisBayar` = `jenis_bayar`.`idJenisBayar`))) join `tahun_ajaran` on((`jenis_bayar`.`idTahunAjaran` = `tahun_ajaran`.`idTahunAjaran`))) join `siswa` on((`tagihan_bulanan`.`idSiswa` = `siswa`.`idSiswa`))) join `kelas_siswa` on((`siswa`.`idKelas` = `kelas_siswa`.`idKelas`))) join `bulan` on((`tagihan_bulanan`.`idBulan` = `bulan`.`idBulan`)));
INSERT INTO `view_laporan_bayar_bulanan` VALUES   ('445','15','420','11','1','100000','2021-07-06 00:00:00','2021-07-06 16:39:24','1','9','SPP Bulanan Kelas X','2020/2021','1','fahmi','X RPL 1','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('446','15','420','11','2','100000',NULL,NULL,'0','9','SPP Bulanan Kelas X','2020/2021','1','fahmi','X RPL 1','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('447','15','420','11','3','100000',NULL,NULL,'0','9','SPP Bulanan Kelas X','2020/2021','1','fahmi','X RPL 1','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('448','15','420','11','4','100000',NULL,NULL,'0','9','SPP Bulanan Kelas X','2020/2021','1','fahmi','X RPL 1','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('449','15','420','11','5','100000',NULL,NULL,'0','9','SPP Bulanan Kelas X','2020/2021','1','fahmi','X RPL 1','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('450','15','420','11','6','100000',NULL,NULL,'0','9','SPP Bulanan Kelas X','2020/2021','1','fahmi','X RPL 1','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('451','15','420','11','7','100000','2021-07-06 00:00:00','2021-07-06 16:05:24','1','9','SPP Bulanan Kelas X','2020/2021','1','fahmi','X RPL 1','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('452','15','420','11','8','100000','2021-07-06 00:00:00','2021-07-06 16:05:24','1','9','SPP Bulanan Kelas X','2020/2021','1','fahmi','X RPL 1','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('453','15','420','11','9','100000','2021-07-06 00:00:00','2021-07-06 16:39:15','1','9','SPP Bulanan Kelas X','2020/2021','1','fahmi','X RPL 1','September','3','Transfer');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('454','15','420','11','10','100000','2021-07-06 00:00:00','2021-07-06 16:39:21','1','9','SPP Bulanan Kelas X','2020/2021','1','fahmi','X RPL 1','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('455','15','420','11','11','100000','2021-07-06 00:00:00','2021-07-06 16:39:22','1','9','SPP Bulanan Kelas X','2020/2021','1','fahmi','X RPL 1','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('456','15','420','11','12','100000','2021-07-06 00:00:00','2021-07-06 16:39:23','1','9','SPP Bulanan Kelas X','2020/2021','1','fahmi','X RPL 1','Desember','6','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('457','18','421','12','1','120000',NULL,NULL,'0','9','SPP Bulanan Kelas XI','2020/2021','2','restu','XI RPL 2','Januari','7','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('458','18','421','12','2','120000',NULL,NULL,'0','9','SPP Bulanan Kelas XI','2020/2021','2','restu','XI RPL 2','Februari','8','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('459','18','421','12','3','120000',NULL,NULL,'0','9','SPP Bulanan Kelas XI','2020/2021','2','restu','XI RPL 2','Maret','9','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('460','18','421','12','4','120000',NULL,NULL,'0','9','SPP Bulanan Kelas XI','2020/2021','2','restu','XI RPL 2','April','10','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('461','18','421','12','5','120000',NULL,NULL,'0','9','SPP Bulanan Kelas XI','2020/2021','2','restu','XI RPL 2','Mei','11','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('462','18','421','12','6','120000',NULL,NULL,'0','9','SPP Bulanan Kelas XI','2020/2021','2','restu','XI RPL 2','Juni','12','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('463','18','421','12','7','120000',NULL,NULL,'0','9','SPP Bulanan Kelas XI','2020/2021','2','restu','XI RPL 2','Juli','1','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('464','18','421','12','8','120000',NULL,NULL,'0','9','SPP Bulanan Kelas XI','2020/2021','2','restu','XI RPL 2','Agustus','2','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('465','18','421','12','9','120000',NULL,NULL,'0','9','SPP Bulanan Kelas XI','2020/2021','2','restu','XI RPL 2','September','3','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('466','18','421','12','10','120000',NULL,NULL,'0','9','SPP Bulanan Kelas XI','2020/2021','2','restu','XI RPL 2','Oktober','4','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('467','18','421','12','11','120000',NULL,NULL,'0','9','SPP Bulanan Kelas XI','2020/2021','2','restu','XI RPL 2','November','5','Tunai');
INSERT INTO `view_laporan_bayar_bulanan` VALUES ('468','18','421','12','12','120000',NULL,NULL,'0','9','SPP Bulanan Kelas XI','2020/2021','2','restu','XI RPL 2','Desember','6','Tunai');
