<?php

use App\Http\Controllers\AbsenController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\CatatanController;
use App\Http\Controllers\CetakRangkingController;
use App\Http\Controllers\CetakSampulRaport;
use App\Http\Controllers\LeggerController;
use App\Http\Controllers\ListKdController;
use App\Http\Controllers\MapelDiampuController;
use App\Http\Controllers\MasterKdController;
use App\Http\Controllers\NilaiKeterampilanController;
use App\Http\Controllers\NilaiPasController;
use App\Http\Controllers\NilaiPengetahuanController;
use App\Http\Controllers\NilaiPtsController;
use App\Http\Controllers\RekapNilaiController;
use App\Http\Controllers\SettingRateNilaiController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\ListSiswaController;
use App\Http\Controllers\MasterEkskulController;
use App\Http\Controllers\MasterNilaiSikapController;
use App\Http\Controllers\NilaiEkstrakulikulerController;
use App\Http\Controllers\NilaiPrakerinController;
use App\Http\Controllers\NilaiPrestasiController;
use App\Http\Controllers\NilaiSikapSosialController;
use App\Http\Controllers\NilaiSikapSpiritualController;
use Illuminate\Support\Facades\Route;

Route::get('/legger', [CetakSampulRaport::class, 'test_legger']);
Route::view('/', 'index' )->name('index')->middleware('auth');
Route::prefix('login')->group(function (){
    Route::get('/',[AuthController::class,'index'])->name('login.index');
    Route::post('/store',[AuthController::class,'store'])->name('login.store');
    Route::get('/forgot-password',[AuthController::class,'forgot_password'])->name('forgot_password.index');
    Route::post('/forgot-password_store',[AuthController::class,'forgot_password_store'])->name('forgot_password.store');
    Route::get('/reset-password/{token}',[AuthController::class,'reset_password'])->name('password.reset');
    Route::post('/reset-password_store',[AuthController::class,'reset_password_store'])->name('reset_password.store');
    Route::post('/logout',[AuthController::class,'logout'])->name('logout');
})->middleware('guest');

Route::prefix('guru')->middleware([\App\Http\Middleware\AuthCheck::class])->group(function(){
    Route::prefix('rekap-nilai')->group(function(){
        Route::get('/', [RekapNilaiController::class, 'index'])->name('rekap-nilai.index');
    });
    Route::prefix('master-kd')->group(function (){
        Route::get('/',[MasterKdController::class,'index'])->name('master-kd.index');
        Route::get('/create',[MasterKdController::class,'create'])->name('master-kd.create');
        Route::post('/store',[MasterKdController::class,'store'])->name('master-kd.store');
        Route::get('/show/{id}',[MasterKdController::class,'show'])->name('master-kd.show');
        Route::get('/edit/{id}',[MasterKdController::class,'edit'])->name('master-kd.edit');
        Route::post('/update/{id}',[MasterKdController::class,'update'])->name('master-kd.update');
        Route::get('/destroy/{id}',[MasterKdController::class,'destroy'])->name('master-kd.destroy');
    })->middleware('auth');

    Route::prefix('nilai-pengetahuan')->group(function (){
        Route::get('/',[NilaiPengetahuanController::class,'index'])->name('nilai-pengetahuan.index');
        Route::post('/store',[NilaiPengetahuanController::class,'store'])->name('nilai-pengetahuan.store');
        Route::get('/show',[NilaiPengetahuanController::class,'show'])->name('nilai-pengetahuan.show');
        Route::post('/import', [NilaiPengetahuanController::class, 'import'])->name('nilai-pengetahuan.import');
        Route::get('/template', [NilaiPengetahuanController::class, 'downloadTemplate'])->name('nilai-pengetahuan.downloadTemplate');
    })->middleware('auth');

    Route::prefix('nilai-keterampilan')->group(function (){
        Route::get('/',[NilaiKeterampilanController::class,'index'])->name('nilai-keterampilan.index');
        Route::post('/store',[NilaiKeterampilanController::class,'store'])->name('nilai-keterampilan.store');
        Route::get('/show',[NilaiKeterampilanController::class,'show'])->name('nilai-keterampilan.show');
        Route::post('/import', [NilaiKeterampilanController::class, 'import'])->name('nilai-keterampilan.import');
    })->middleware('auth');

    Route::prefix('nilai-pts')->group(function (){
        Route::get('/',[NilaiPtsController::class,'index'])->name('nilai-pts.index');
        Route::post('/store',[NilaiPtsController::class,'store'])->name('nilai-pts.store');
        Route::post('/import', [NilaiPtsController::class, 'import'])->name('nilai-pts.import');
    })->middleware('auth');

    Route::prefix('nilai-pas')->group(function (){
        Route::get('/',[NilaiPasController::class,'index'])->name('nilai-pas.index');
        Route::post('/store',[NilaiPasController::class,'store'])->name('nilai-pas.store');
        Route::post('/import', [NilaiPasController::class, 'import'])->name('nilai-pas.import');
    })->middleware('auth');

    Route::prefix('absen')->group(function (){
        Route::get('/',[AbsenController::class,'index'])->name('absen.index');
        Route::post('/store',[AbsenController::class,'store'])->name('absen.store');
    })->middleware('auth');

    Route::prefix('nilai-sikap-sosial')->group(function (){
        Route::get('/',[NilaiSikapSosialController::class,'index'])->name('nilai-sikap-sosial.index');
        Route::post('/store',[NilaiSikapSosialController::class,'store'])->name('nilai-sikap-sosial.store');
    })->middleware('auth');

    Route::prefix('nilai-sikap-spiritual')->group(function (){
        Route::get('/',[NilaiSikapSpiritualController::class,'index'])->name('nilai-sikap-spiritual.index');
        Route::post('/store',[NilaiSikapSpiritualController::class,'store'])->name('nilai-sikap-spiritual.store');
    })->middleware('auth');

    Route::prefix('mapel-diampu')->group(function (){
        Route::get('/',[MapelDiampuController::class,'index'])->name('mapel-diampu.index');
        Route::get('/show/{id}',[MapelDiampuController::class,'show'])->name('mapel-diampu.show');
    })->middleware('auth');

    Route::prefix('list-kd')->group(function (){
        Route::get('/',[ListKdController::class,'index'])->name('list-kd.index');
        Route::post('/store',[ListKdController::class,'store'])->name('list-kd.store');
        Route::get('/destroy/{id}',[ListKdController::class,'destroy'])->name('list-kd.destroy');
    })->middleware('auth');

    Route::prefix('master-ekskul')->group(function (){
        Route::get('/',[MasterEkskulController::class,'index'])->name('master-ekskul.index');
        Route::get('/create',[MasterEkskulController::class,'create'])->name('master-ekskul.create');
        Route::post('/store',[MasterEkskulController::class,'store'])->name('master-ekskul.store');
        Route::get('/edit/{id}',[MasterEkskulController::class,'edit'])->name('master-ekskul.edit');
        Route::post('/update/{id}',[MasterEkskulController::class,'update'])->name('master-ekskul.update');
        Route::get('/destroy/{id}',[MasterEkskulController::class,'destroy'])->name('master-ekskul.destroy');
    })->middleware('auth');

    Route::prefix('master-nilai-sikap')->group(function (){
        Route::get('/',[MasterNilaiSikapController::class,'index'])->name('master-nilai-sikap.index');
        Route::get('/create',[MasterNilaiSikapController::class,'create'])->name('master-nilai-sikap.create');
        Route::post('/store',[MasterNilaiSikapController::class,'store'])->name('master-nilai-sikap.store');
        Route::get('/edit/{id}',[MasterNilaiSikapController::class,'edit'])->name('master-nilai-sikap.edit');
        Route::post('/update/{id}',[MasterNilaiSikapController::class,'update'])->name('master-nilai-sikap.update');
        Route::get('/destroy/{id}',[MasterNilaiSikapController::class,'destroy'])->name('master-nilai-sikap.destroy');
    })->middleware('auth');


    Route::prefix('prestasi')->group(function (){
        Route::get('/',[NilaiPrestasiController::class,'index'])->name('prestasi.index');
        Route::get('/create',[NilaiPrestasiController::class,'create'])->name('prestasi.create');
        Route::post('/store',[NilaiPrestasiController::class,'store'])->name('prestasi.store');
        Route::get('/edit/{id}',[NilaiPrestasiController::class,'edit'])->name('prestasi.edit');
        Route::post('/update/{id}',[NilaiPrestasiController::class,'update'])->name('prestasi.update');
        Route::get('/destroy/{id}',[NilaiPrestasiController::class,'destroy'])->name('prestasi.destroy');
    })->middleware('auth');

    Route::prefix('nilai-ekskul')->group(function (){
        Route::get('/',[NilaiEkstrakulikulerController::class,'index'])->name('nilai-ekskul.index');
        Route::post('/store',[NilaiEkstrakulikulerController::class,'store'])->name('nilai-ekskul.store');
    })->middleware('auth');
    Route::prefix('prakerin')->group(function (){
        Route::get('/',[NilaiPrakerinController::class,'index'])->name('prakerin.index');
        Route::post('/store',[NilaiPrakerinController::class,'store'])->name('prakerin.store');
    })->middleware('auth');

    Route::prefix('catatan')->group(function (){
        Route::get('/',[CatatanController::class,'index'])->name('catatan.index');
        Route::post('/store',[CatatanController::class,'store'])->name('catatan.store');
    })->middleware('auth');
});

// Walikelas
Route::prefix('walikelas')->group(function(){
    Route::prefix('list-siswa')->group(function(){
        Route::get('/', [ListSiswaController::class, 'index'])->name('list-siswa.index');
        Route::get('/show/{id}', [ListSiswaController::class, 'show'])->name('list-siswa.show');
        Route::get('/legger/{id}',[LeggerController::class,'index'])->name('cetak-legger-wali.index');
        Route::get('/sampul-1/{id}',[CetakSampulRaport::class,'sampul1'])->name('wali-kelas-cetak-sampul-raport.sampul-1');
        Route::get('/sampul-2/{id}',[CetakSampulRaport::class,'sampul2'])->name('wali-kelas-cetak-sampul-raport.sampul-2');
        Route::get('/sampul-3/{id}',[CetakSampulRaport::class,'sampul3'])->name('wali-kelas-cetak-sampul-raport.sampul-3');
        Route::get('/showCetakPasMerdeka/{id}',[CetakSampulRaport::class,'showCetakPasMerdeka'])->name('wali-kelas-cetak-sampul-raport.showCetakPasMerdeka');
        Route::get('/showCetakPasK13/{id}',[CetakSampulRaport::class,'showCetakPasK13'])->name('wali-kelas-cetak-sampul-raport.showCetakPasK13');
    });
});

// Admin
Route::prefix('admin')->group(function(){
    Route::prefix('setting-rate-nilai')->group(function(){
        Route::get('/', [SettingRateNilaiController::class, 'index'])->name('setting-rate-nilai.index');
    });
    Route::prefix('cetak-legger')->group(function(){
        Route::get('/',[LeggerController::class,'index'])->name('cetak-legger.index');
        Route::get('/export',[LeggerController::class,'export'])->name('cetak-legger.export');
    });

    Route::prefix('cetak-sampul-raport')->group(function (){
        Route::get('/',[CetakSampulRaport::class,'index'])->name('cetak-sampul-raport.index');
        Route::get('/sampul-1/{id}',[CetakSampulRaport::class,'sampul1'])->name('cetak-sampul-raport.sampul-1');
        Route::get('/sampul-2/{id}',[CetakSampulRaport::class,'sampul2'])->name('cetak-sampul-raport.sampul-2');
        Route::get('/sampul-3/{id}',[CetakSampulRaport::class,'sampul3'])->name('cetak-sampul-raport.sampul-3');
        Route::get('/absensi-raport',[CetakSampulRaport::class,'absensiRaport'])->name('absensi-raport.absensi');
        Route::post('/cetak-absensi-raport',[CetakSampulRaport::class,'cetakAbsensiRaport'])->name('cetak-absensi-raport.absensi');
        Route::get('/show/{id}',[CetakSampulRaport::class,'show'])->name('cetak-sampul-raport.show');
        Route::get('/showCetakPasMerdeka/{id}',[CetakSampulRaport::class,'showCetakPasMerdeka'])->name('cetak-sampul-raport.showCetakPasMerdeka');
        Route::get('/showCetakPasK13/{id}',[CetakSampulRaport::class,'showCetakPasK13'])->name('cetak-sampul-raport.showCetakPasK13');
    })->middleware('auth');

    Route::prefix('cetak-rangking')->group(function (){
        Route::get('/',[CetakRangkingController::class,'index'])->name('cetak-rangking.index');
        Route::get('/show',[CetakRangkingController::class,'show'])->name('cetak-rangking.show');
    })->middleware('auth');

    Route::prefix('user')->group(function (){
        Route::get('/',[UserController::class,'index'])->name('user.index');
        Route::get('/login-as/{id}',[UserController::class,'impersonate'])->name('user.impersonate');
        Route::post('/logout-as',[UserController::class,'leaveImpersonate'])->name('user.leaveImpersonate');
    })->middleware('auth');

});
