<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\Api\DashboardController;
use App\Http\Controllers\Api\NilaiController;
use App\Http\Controllers\Api\MasterDataController;

/*
|--------------------------------------------------------------------------
| API Routes - Revamp Eraport
|--------------------------------------------------------------------------
*/

Route::get('/ping', function () {
    return response()->json([
        'status' => 'ok',
        'app' => 'revamp-eraport'
    ]);
});


// ==================== AUTH ====================
Route::prefix('auth')->group(function () {
    Route::post('/login', [AuthController::class, 'login']);
    Route::post('/logout', [AuthController::class, 'logout'])
        ->middleware('auth:sanctum');
});


// ==================== AUTHENTICATED USER ====================
Route::middleware('auth:sanctum')->group(function () {

    Route::get('/me', function (Request $request) {
        return $request->user();
    });

    // ==================== DASHBOARD ====================
    Route::get('/dashboard', [DashboardController::class, 'index']);

    // ==================== NILAI ====================
    Route::prefix('nilai')->group(function () {
        Route::get('/', [NilaiController::class, 'index']);
        Route::post('/store', [NilaiController::class, 'store']);
        Route::get('/{siswa_id}', [NilaiController::class, 'show']);
    });

    // ==================== MASTER DATA (PROXY) ====================
    Route::prefix('masterdata')->group(function () {
        Route::get('/sekolah', [MasterDataController::class, 'sekolah']);
        Route::get('/kelas', [MasterDataController::class, 'kelas']);
        Route::get('/mapel', [MasterDataController::class, 'mapel']);
        Route::get('/siswa', [MasterDataController::class, 'siswa']);
        Route::get('/guru', [MasterDataController::class, 'guru']);
    });

});
