<x-layout.default>

    <ul class="flex space-x-2 rtl:space-x-reverse">
        <li>
            <a href="{{ route('master-ekskul.index') }}" class="text-primary hover:underline">Nilai Prestasi Siswa</a>
        </li>
        <li class="before:content-['/'] ltr:before:mr-1 rtl:before:ml-1">
            <span>Edit Prestasi Siswa</span>
        </li>
    </ul>

    <!-- card 1 -->
    <div class="w-full rounded border border-[#e0e6ed] dark:border-[#1b2e4b] dark:bg-[#191e3a] dark:shadow-none">
        <div class="py-7 px-6">
            <h5 class="text-[#3b3f5c] text-xl mt-5 font-semibold mb-4 dark:text-white-light">Edit Data</h5>
            <form class="space-y-5 mt-5 mb-5" action="{{ route('prestasi.update',$prestasi->id) }}" method="POST">
                @csrf
                <div>
                    <input type="hidden" name="kelas_id" value="{{ $wali->kelas_id }}">
                    <label for="groupFname">Nama Siswa</label>
                    <select name="siswa_id" class="form-input">
                        <option value="-">Pilih Siswa</option>
                        @foreach ($siswa as $data)
                            <option value="{{ $data->siswa_id }}" @if ($prestasi->siswa_id == $data->siswa_id)
                                {{ 'selected' }}
                            @endif>{{ $data->siswa->nama_siswa }}</option>
                        @endforeach
                    </select>
                    @error('siswa_id')
                        <p class="text-danger">{{ $message }}</p>
                    @enderror
                </div>
                <div>
                    <label for="groupFname">Jenis Prestasi</label>
                    <input type="text" name="jenis" class="form-input" value="{{ $prestasi->jenis }}">
                    @error('jenis')
                        <p class="text-danger">{{ $message }}</p>
                    @enderror
                </div>
                <div>
                    <label for="groupFname">Keterangan</label>
                    <textarea name="keterangan" class="form-input" cols="30" rows="10">{{ $prestasi->keterangan }}</textarea>
                    @error('keterangan')
                        <p class="text-danger">{{ $message }}</p>
                    @enderror
                </div>
                <button type="submit" class="btn btn-primary !mt-6 ml-auto">Edit</button>
            </form>
        </div>
    </div>

</x-layout.default>
