<x-layout.default>

    <ul class="flex space-x-2 rtl:space-x-reverse">
        <li>
            <a href="{{ route('mapel-diampu.index') }}" class="text-primary hover:underline">Mapel Diampu</a>
        </li>
        <li class="before:content-['/'] ltr:before:mr-1 rtl:before:ml-1">
            <a href="{{ route('mapel-diampu.show',
            [
                'id' => request()->mapel_id,
                'tahun_ajaran_id' => request()->tahun_ajaran_id,
            ]
            ) }}" class="text-primary hover:underline">{{ \App\Models\Mapel::find($mapel)->nama_mapel }}</a>
        </li>
        <li class="before:content-['/'] ltr:before:mr-1 rtl:before:ml-1">
            <span>Input Nilai Pengetahuan</span>
        </li>
    </ul>

    <div x-data="{ open: true }">
        @if ($sukses = Session::get('sukses'))
            <div x-show="open" x-transition class="block text-sm mt-5 text-left border flex justify-between px-4 py-3 rounded-sm text-green-600 bg-green-200 border-green-400" role="alert">
                <div >
                    <p>{{ $sukses }}</p>
                </div>
                <button type="button" aria-label="Close" x-on:click="open = ! open">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24px" height="24px" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" class="w-5 h-5">
                        <line x1="18" y1="6" x2="6" y2="18"></line>
                        <line x1="6" y1="6" x2="18" y2="18"></line>
                    </svg>
                </button>
            </div>
        @endif
    </div>

    <div x-data="{ open: true }">
        @if ($fail = Session::get('fail'))
            <div x-show="open" x-transition class="block text-sm mt-5 text-left border flex justify-between px-4 py-3 rounded-sm text-red-600 bg-red-200 border-red-400" role="alert">
                <div >
                    <p>{{ $fail }}</p>
                </div>
                <button type="button" aria-label="Close" x-on:click="open = ! open">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24px" height="24px" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" class="w-5 h-5">
                        <line x1="18" y1="6" x2="6" y2="18"></line>
                        <line x1="6" y1="6" x2="18" y2="18"></line>
                    </svg>
                </button>
            </div>
        @endif
    </div>

    <div class="mt-5 mb-5 grid grid-cols-1 sm:grid-cols-1">
        <div class="bg-primary p-4 rounded-lg shadow-lg text-white font-bold">
            <ul>
                <li>Untuk menambahkan KD yang akan diinput, klik tombol panah bawah berwarna biru pada menu Daftar KD</li>
            </ul>
          </div>
    </div>

    <div class="panel xl:col-span-2">
        <div class="flex items-center dark:text-white-light mb-5">
            <h5 class="font-semibold text-lg">NILAI PENGETAHUAN</h5>
            <a href="{{ route('nilai-pengetahuan.show',[
                            'tahun_ajaran_id' => $tahun_ajaran,
                            'mapel_id' => $mapel,
                            'kelas_id' => $kelas,
                            'mapping_guru_id' => $mapping_guru,
                            'tingkat' => $getGuruId->kelas->tingkatan->kode_tingkatan
            ]) }}" class="btn btn-success ms-auto">Lihat Rekap</a>
        </div>
    </div>

        <div class="flex justify-between">
            <div class="grid grid-cols-1 sm:grid-cols-1 md:grid-cols-2 lg:grid-cols-2 xl:grid-cols-2">
                <div class="panel mt-6 me-5">
                    <div class="flex">
                        <h5 class="font-semibold text-lg dark:text-white-light">Daftar KD</h5>

                        <!-- basic -->
                        <div x-data="modal" class="mb-5 ms-auto">
                            <!-- button -->
                            <div class="flex items-center justify-center">
                                <button type="button" x-tooltip="Import KD" class="p-1 text-teal-600 hover:bg-teal-600 hover:text-white rounded" @click="toggle">
                                    <svg  xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                                        <path d="M12 8L12 16M12 16L15 13M12 16L9 13" stroke="blue" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                        <path d="M22 12C22 16.714 22 19.0711 20.5355 20.5355C19.0711 22 16.714 22 12 22C7.28595 22 4.92893 22 3.46447 20.5355C2 19.0711 2 16.714 2 12C2 7.28595 2 4.92893 3.46447 3.46447C4.92893 2 7.28595 2 12 2C16.714 2 19.0711 2 20.5355 3.46447C21.5093 4.43821 21.8356 5.80655 21.9449 8" stroke="blue" stroke-width="1.5" stroke-linecap="round"/>
                                    </svg>
                                </button>
                            </div>

                            <!-- modal -->
                            <div class="fixed inset-0 bg-[black]/60 z-[999] hidden overflow-y-auto" :class="open && '!block'">
                                <div class="flex items-start justify-center min-h-screen px-4" @click.self="open = false">
                                    <div x-show="open" x-transition x-transition.duration.300 class="panel border-0 p-0 rounded-lg overflow-hidden my-8 w-full max-w-lg">
                                        <div class="flex bg-[#fbfbfb] dark:bg-[#121c2c] items-center justify-between px-5 py-3">
                                            <div class="font-bold text-lg">Tambah KD</div>
                                        </div>
                                        <div class="p-5">
                                            <div class="dark:text-white-dark/70 text-base font-medium text-[#1f2937]">
                                                <form action="{{ route('list-kd.store',[
                                                    'mapel_id' => $mapel,
                                                    'tingkat' => $getGuruId->kelas->tingkatan->kode_tingkatan
                                                ]) }}" method="post">
                                                    @csrf
                                                    <label for="">Nama Kd</label>
                                                    <select name="kode_kd" id="" class="form-input">
                                                        <option value="" class="form-input" disabled>Select KD</option>
                                                        @foreach ($masterkd as $data)
                                                        @php
                                                            $kdExists = DB::table('list_kd')
                                                            ->where('mapel_id',$mapel)
                                                            ->where('kode_kd',$data->kode_kd)
                                                            ->where('guru_id',Auth::user()->model_id)
                                                            ->where('tingkat',$getGuruId->kelas->tingkatan->kode_tingkatan)
                                                            ->where('tahun_ajaran_id',$getGuruId->tahunAjaran->id)
                                                            ->exists();
                                                        @endphp
                                                            @if (!$kdExists)
                                                                <option value="{{ $data->kode_kd }}" class="form-input">{{ $data->kode_kd.' '.$data->nama_kd }}</option>
                                                            @endif
                                                        @endforeach
                                                    </select>
                                            </div>
                                            <div class="flex justify-end items-center mt-8">
                                                <button type="button" class="btn btn-outline-danger" @click="toggle">Batal</button>
                                                <button type="submit" class="btn btn-primary ltr:ml-4 rtl:mr-4" >Simpan</button>
                                            </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="table-responsive">
                        <span>SEMESTER 1</span>
                        <table>
                            @foreach ($kd->where('semester', 1) as $k)
                            <tr>
                                <td @if($kd_req == $k->id) class="text-blue-500 font-bold" @endif>{{ $k->kode_kd }}</td>
                                @if ($kd_req == $k->id)
                                <td><a href="{{ route('nilai-pengetahuan.index',[
                                    'tahun_ajaran_id' => $k->tahun_ajaran_id,
                                    'mapel_id' => $k->mapel_id,
                                    'kelas_id' => $kelas,
                                    'kd_id' => $k->id,
                                    'mapping_guru_id' => $mapping_guru,
                                ]) }}" class="text-blue-500 font-bold">{{ $k->nama_kd }}</a></td>
                                @else
                                <td><a href="{{ route('nilai-pengetahuan.index',[
                                    'tahun_ajaran_id' => $k->tahun_ajaran_id,
                                    'mapel_id' => $k->mapel_id,
                                    'kelas_id' => $kelas,
                                    'kd_id' => $k->id,
                                    'mapping_guru_id' => $mapping_guru,
                                ]) }}">{{ $k->nama_kd }}</a></td>
                                @endif
                                <td>@include('list-kd.table_action')</td>
                            </tr>
                            @endforeach
                        </table>
                        <hr>
                        <div class="mt-4">
                            <span>SEMESTER 2</span>
                        </div>
                        <table>
                            @foreach ($kd->where('semester', 2) as $k)
                                <tr>
                                    <td @if($kd_req == $k->id) class="text-blue-500 font-bold" @endif>{{ $k->kode_kd }}</td>
                                    @if ($kd_req == $k->id)
                                        <td><a href="{{ route('nilai-pengetahuan.index',[
                                    'tahun_ajaran_id' => $k->tahun_ajaran_id,
                                    'mapel_id' => $k->mapel_id,
                                    'kelas_id' => $kelas,
                                    'kd_id' => $k->id,
                                    'mapping_guru_id' => $mapping_guru,
                                ]) }}" class="text-blue-500 font-bold">{{ $k->nama_kd }}</a></td>
                                    @else
                                        <td><a href="{{ route('nilai-pengetahuan.index',[
                                    'tahun_ajaran_id' => $k->tahun_ajaran_id,
                                    'mapel_id' => $k->mapel_id,
                                    'kelas_id' => $kelas,
                                    'kd_id' => $k->id,
                                    'mapping_guru_id' => $mapping_guru,
                                ]) }}">{{ $k->nama_kd }}</a></td>
                                    @endif
                                    <td>@include('list-kd.table_action')</td>
                                </tr>
                            @endforeach
                        </table>
                        <hr>
                    </div>
                </div>
            @if (isset($kd_req))
                <div class="panel mt-6">
                    <div class="flex">
                        <h5 class="font-semibold text-lg dark:text-white-light mb-4">Nilai Pengetahuan</h5>
                        <!-- basic -->
                        <div x-data="modal" class="mb-5 ms-auto">
                            <!-- button -->
                            <div class="flex items-center justify-center">
                                <button type="button" class="btn btn-info btn-sm" @click="toggle">
                                    Import Nilai per KD
                                </button>
                            </div>

                            <!-- modal -->
                            <div class="fixed inset-0 bg-[black]/60 z-[999] hidden overflow-y-auto" :class="open && '!block'">
                                <div class="flex items-start justify-center min-h-screen px-4" @click.self="open = false">
                                    <div x-show="open" x-transition x-transition.duration.300 class="panel border-0 p-0 rounded-lg overflow-hidden my-8 w-full max-w-lg">
                                        <div class="flex bg-[#fbfbfb] dark:bg-[#121c2c] items-center justify-between px-5 py-3">
                                            <div class="font-bold text-lg">Form Upload Nilai Pengetahuan</div>
                                        </div>
                                        <div class="p-5">
                                            <div class="dark:text-white-dark/70 text-base font-medium text-[#1f2937]">
                                                <div class="mb-4 inline-block">
                                                    <a class="btn btn-warning btn-sm btn-" href="{{ route('nilai-pengetahuan.downloadTemplate', ['kelas_id' => request()->kelas_id, 'tahun_ajaran_id' => request()->tahun_ajaran_id ]) }}">Download Template Import - {{ \App\Models\Kelas::find(request()->kelas_id)->nama_kelas }}</a>
                                                </div>
                                                <form action="{{ route('nilai-pengetahuan.import',[
                                                    'mapel_id' => $mapel,
                                                    'kd_id' => request()->kd_id,
                                                    'kelas_id' => request()->kelas_id,
                                                    'tahun_ajaran_id' => request()->tahun_ajaran_id,
                                                    'mapping_guru_id' => request()->mapping_guru_id
                                                ]) }}" method="post" enctype="multipart/form-data">
                                                    @csrf
                                                    <label for="">File</label>
                                                    <input type="file" name="file" class="form-input">
                                            </div>
                                            <div class="flex justify-end items-center mt-8">
                                                <button type="button" class="btn btn-outline-danger" @click="toggle">Batal</button>
                                                <button type="submit" class="btn btn-primary ltr:ml-4 rtl:mr-4" >Simpan</button>
                                            </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <form action="{{ route('nilai-pengetahuan.store') }}" method="POST">
                        @csrf
                        <div class="table-responsive">
                            <table>
                                <thead>
                                    <tr>
                                        <th>No</th>
                                        <th>Nama</th>
                                        <th>Nilai</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php
                                        $i = 1;
                                    @endphp
                                    @foreach ($mapping_siswa as $datasiswa)
                                        @php
                                            $datanilai = $nilai_pengetahuan->where('siswa_id', $datasiswa->siswa_id)->first();
                                        @endphp
                                        <tr>
                                            <td>{{ $i++ }}</td>
                                            <td>{{ $datasiswa->siswa->nama_siswa }}</td>
                                            @if ($datanilai)
                                                <td><input type="number" class="form-input" name="siswa[{{ $datasiswa->siswa_id }}][nilai]" value="{{ $datanilai->nilai }}" required /></td>
                                            @else
                                                <td><input type="number" class="form-input" name="siswa[{{ $datasiswa->siswa_id }}][nilai]" value="0" required /></td>
                                            @endif
                                        </tr>
                                        <input type="hidden" name="kd_id" value="{{ $kd_req }}" required />
                                        <input type="hidden" name="tahun_ajaran_id" value="{{ $tahun_ajaran }}" required />
                                        <input type="hidden" name="mapping_guru_id" value="{{ $mapping_guru }}" required />
                                        <input type="hidden" name="kelas_id" value="{{ $kelas }}" required />
                                    @endforeach
                                </tbody>
                            </table>

                        <button type="submit" class="btn btn-primary mt-5">SIMPAN</button>

                        </div>
                    </form>
                </div>
                @endif
            </div>
        </div>

    <script>
        document.addEventListener("alpine:init", () => {
            Alpine.data("dropdown", (initialOpenState = false) => ({
                open: initialOpenState,

                toggle() {
                    this.open = !this.open;
                },
            }));
        });
    </script>


</x-layout.default>
