<x-layout.default>

    <ul class="flex space-x-2 rtl:space-x-reverse">
        <li>
            <a href="{{ route('mapel-diampu.index') }}" class="text-primary hover:underline">Mapel Diampu</a>
        </li>
        <li class="before:content-['/'] ltr:before:mr-1 rtl:before:ml-1">
            <span>Edit Master KD</span>
        </li>
    </ul>

    <!-- card 1 -->
    <div class="w-full rounded border border-[#e0e6ed] dark:border-[#1b2e4b] dark:bg-[#191e3a] dark:shadow-none">
        <div class="py-7 px-6">
            <h5 class="text-[#3b3f5c] text-xl mt-5 font-semibold mb-4 dark:text-white-light">Edit Data</h5>
            <form class="space-y-5 mt-5 mb-5" action="{{ route('master-kd.update',$master_kd->id) }}" method="POST">
                @csrf
                <div>
                    <label for="groupFname">Mapel</label>
                    <select class="selectize form-input" name="mapel_id">
                        <option selected value="orange">-- Select Mapel --</option>
                        @foreach ($mapel as $data)
                            <option value="{{ $data->mapel->id }}" @if ($master_kd->mapel_id == $data->mapel->id)
                                {{ "selected" }}
                            @endif >{{ $data->mapel->nama_mapel }}</option>
                        @endforeach
                    </select>
                    @error('mapel_id')
                        <p class="text-danger">{{ $message }}</p>
                    @enderror
                </div>
                <div>
                    <label for="groupFname">Jenis Kd</label>
                    <select class="selectize form-input" name="jenis_kd">
                        <option selected value="orange" disabled>-- Select Jenis KD --</option>
                        @if ($master_kd->jenis_kd == 'pengetahuan')
                            <option value="pengetahuan" selected>Pengetahuan</option>
                            <option value="keterampilan">Keterampilan</option>
                        @endif
                        @if ($master_kd->jenis_kd == 'keterampilan')
                            <option value="pengetahuan">Pengetahuan</option>
                            <option value="keterampilan" selected>Keterampilan</option>
                        @endif

                    </select>
                    @error('tahun_ajaran_id')
                        <p class="text-danger">{{ $message }}</p>
                    @enderror
                </div>
                <div>
                    <label for="groupFname">Tahun Ajaran</label>
                    <select class="selectize form-input" name="tahun_ajaran_id">
                        <option selected value="orange" disabled>-- Select Tahun Ajaran --</option>
                        @foreach ($tahun_ajaran as $data)
                            <option value="{{ $data->id }}" @if ($master_kd->tahun_ajaran_id == $data->id)
                                {{ "selected" }}
                            @endif >{{ $data->nama_tahun_ajaran }}</option>
                        @endforeach
                    </select>
                    @error('tahun_ajaran_id')
                        <p class="text-danger">{{ $message }}</p>
                    @enderror
                </div>
                <div>
                    <label for="groupFname">Kode KD</label>
                    <input id="groupFname" type="text" placeholder="Enter Kode KD" name="kode_kd" class="form-input" value="{{ $master_kd->kode_kd }}"/>
                    @error('kode_kd')
                        <p class="text-danger">{{ $message }}</p>
                    @enderror
                </div>
                <div>
                    <label for="groupLname">Nama KD</label>
                    <input id="groupLname" type="text" placeholder="Enter Nama KD" name="nama_kd" class="form-input" value="{{ $master_kd->nama_kd }}"/>
                    @error('nama_kd')
                        <p class="text-danger">{{ $message }}</p>
                    @enderror
                </div>
                <div>
                    <label for="groupLname">Keterangan</label>
                    <input id="groupLname" type="text" placeholder="Enter keterangan" name="keterangan" class="form-input" value="{{ $master_kd->keterangan }}"/>
                    @error('keterangan')
                        <p class="text-danger">{{ $message }}</p>
                    @enderror
                </div>
                <button type="submit" class="btn btn-primary !mt-6 ml-auto">Edit</button>
            </form>
        </div>
    </div>

</x-layout.default>
