<x-layout.default>

    <ul class="flex space-x-2 rtl:space-x-reverse">
        <li>
            <a href="{{ route('mapel-diampu.index') }}" class="text-primary hover:underline">Mapel Diampu</a>
        </li>
        <li class="before:content-['/'] ltr:before:mr-1 rtl:before:ml-1">
            <span>Tambah Master KD</span>
        </li>
    </ul>

    <!-- card 1 -->
    <div class="w-full rounded border border-[#e0e6ed] dark:border-[#1b2e4b] dark:bg-[#191e3a] dark:shadow-none">
        <div class="py-7 px-6">
            <h5 class="text-[#3b3f5c] text-xl mt-5 font-semibold mb-4 dark:text-white-light">Tambah Data</h5>
            <form class="space-y-5 mt-5 mb-5" action="{{ route('master-kd.store') }}" method="POST">
                @csrf
                <div>
                    <label for="groupFname">Mata Pelajaran</label>
                    <select class="selectize form-input" name="mapel_id">
                        <option selected value="orange" selected>-- Select Mata Pelajaran --</option>
                        @foreach ($mapel as $data)
                            <option value="{{ $data->mapel->id }}" @if ($data->mapel->id == $mapel_id)
                                {{ "selected" }}
                            @endif>{{ $data->mapel->nama_mapel }}</option>
                        @endforeach
                    </select>
                    @error('tahun_ajaran_id')
                        <p class="text-danger">{{ $message }}</p>
                    @enderror
                </div>
                <div>
                    <label for="groupFname">Jenis Kd</label>
                    <select class="selectize form-input" name="jenis_kd">
                        <option selected value="orange" disabled>-- Select Jenis KD --</option>
                        <option value="pengetahuan">Pengetahuan</option>
                        <option value="keterampilan">Keterampilan</option>
                    </select>
                    @error('tahun_ajaran_id')
                        <p class="text-danger">{{ $message }}</p>
                    @enderror
                </div>
                <div>
                    <label for="groupFname">Tahun Ajaran</label>
                    <select class="selectize form-input" name="tahun_ajaran_id">
                        <option selected value="orange" disabled>-- Select Tahun Ajaran</option>
                        @foreach ($tahun_ajaran as $data)
                            <option value="{{ $data->id }}" @if ($data->is_active == 1)
                                {{ 'selected' }}
                            @endif>{{ $data->nama_tahun_ajaran }}</option>
                        @endforeach
                    </select>
                    @error('tahun_ajaran_id')
                        <p class="text-danger">{{ $message }}</p>
                    @enderror
                </div>
                <div>
                    <label for="groupFname">Kode KD</label>
                    <input id="groupFname" type="text" placeholder="Enter Kode KD" name="kode_kd" class="form-input" />
                    @error('kode_kd')
                        <p class="text-danger">{{ $message }}</p>
                    @enderror
                </div>
                <div>
                    <label for="groupLname">Nama KD</label>
                    <input id="groupLname" type="text" placeholder="Enter Nama KD" name="nama_kd" class="form-input" />
                    @error('nama_kd')
                        <p class="text-danger">{{ $message }}</p>
                    @enderror
                </div>
                <div>
                    <label for="groupLname">Keterangan</label>
                    <input id="groupLname" type="text" placeholder="Enter keterangan" name="keterangan" class="form-input" />
                    @error('keterangan')
                        <p class="text-danger">{{ $message }}</p>
                    @enderror
                </div>
                <button type="submit" class="btn btn-primary !mt-6 ml-auto">Tambah</button>
            </form>
        </div>
    </div>

</x-layout.default>
