<x-layout.default>

    <div>
        <ul class="flex space-x-2 rtl:space-x-reverse">
            <li>
                <a href="{{ route('master-ekskul.index') }}" class="text-primary hover:underline">Master Eksktrakulikuler</a>
            </li>
        </ul>
        <div class="pt-5">
            <div class="grid gap-5 mb-5">

                <div x-data="{ open: true }">
                    @if ($sukses = Session::get('sukses'))
                        <div x-show="open" x-transition class="block text-sm mt-5 text-left border flex justify-between px-4 py-3 rounded-sm text-green-600 bg-green-200 border-green-400" role="alert">
                            <div >
                                <p>{{ $sukses }}</p>
                            </div>
                            <button type="button" aria-label="Close" x-on:click="open = ! open">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24px" height="24px" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" class="w-5 h-5">
                                    <line x1="18" y1="6" x2="6" y2="18"></line>
                                    <line x1="6" y1="6" x2="18" y2="18"></line>
                                </svg>
                            </button>
                        </div>
                    @endif
                </div>

                <div class="panel">
                    <div class="flex items-center justify-between mb-5">
                        <h5 class="font-semibold text-lg dark:text-white-light">Master Ekstrakulikuler</h5>
                        <a href="{{ route('master-ekskul.create') }}"
                            class="ltr:ml-auto rtl:mr-auto btn btn-primary p-2 rounded-full">
                            Tambah
                        </a>
                    </div>

                    <livewire:ekskul-table/>

                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener("alpine:init", () => {
            Alpine.data("dropdown", (initialOpenState = false) => ({
                open: initialOpenState,

                toggle() {
                    this.open = !this.open;
                },
            }));
        });
    </script>

</x-layout.default>
