<x-layout.default>

    <ul class="flex space-x-2 rtl:space-x-reverse">
        <li>
            <a href="{{ route('mapel-diampu.index') }}" class="text-primary hover:underline">Mapel Diampu</a>
        </li>
        <li class="before:content-['/'] ltr:before:mr-1 rtl:before:ml-1">
            <span>{{ $mapel->nama_mapel }}</span>
        </li>
    </ul>

    <div x-data="{ open: true }">
        @if ($sukses = Session::get('sukses'))
            <div x-show="open" x-transition class="block text-sm mt-5 text-left border flex justify-between px-4 py-3 rounded-sm text-green-600 bg-green-200 border-green-400" role="alert">
                <div >
                    <p>{{ $sukses }}</p>
                </div>
                <button type="button" aria-label="Close" x-on:click="open = ! open">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24px" height="24px" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" class="w-5 h-5">
                        <line x1="18" y1="6" x2="6" y2="18"></line>
                        <line x1="6" y1="6" x2="18" y2="18"></line>
                    </svg>
                </button>
            </div>
        @endif
    </div>

    <div class="panel mt-6 mb-6">
        <h5 class="font-semibold text-lg dark:text-white-light">Master KD - {{ $mapel->nama_mapel }} </h5>
        <div class="flex mt-5">
            <a href="{{ route('master-kd.create',[
                'mapel_id' => $mapel_id
            ]) }}" class="btn btn-outline-primary rounded-full mb-4">Tambah</a>
            <div class="ml-auto mb-5">
                <form action="{{ route('mapel-diampu.show',$mapel->id) }}" method="get">
                    <div class="flex">
                        <input type="hidden" name="tahun_ajaran_id" value="{{ request()->tahun_ajaran_id }}">
                        <select name="sort_jenis_kd" class="form-input px-7">
                            <option value="pengetahuan">Pengetahuan</option>
                            <option value="keterampilan">Keterampilan</option>
                        </select>
                        <button type="submit" class="ms-5 btn btn-primary">Pilih</button>
                    </div>
                </form>
            </div>
        </div>

        <div class="table-responsive">
            <table>
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Kode KD</th>
                        <th>Nama KD</th>
                        <th>Jenis KD</th>
                        <th>Tahun Ajaran</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    @php
                        $i = 1;
                    @endphp
                    @foreach ($masterkd as $data)
                        <tr>
                            <td>{{ $i++ }}</td>
                            <td>{{ $data->kode_kd }}</td>
                            <td>{{ $data->nama_kd }}</td>
                            <td>{{ $data->jenis_kd }}</td>
                            <td>{{ $data->tahunAjaran->nama_tahun_ajaran }}</td>
                            <td>@include('master_kd.table_action')</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
            <div class="m-2">
                {{ $masterkd->links() }}
            </div>
        </div>

    </div>

    <!-- basic -->
    <div class="panel mt-6">
    <div class="mb-5" x-data="{ active: 1 }">
        <div class="space-y-2 font-bold">
            <div class="border border-[#d3d3d3] rounded dark:border-[#1b2e4b]">
                <button type="button" class="p-4 text-lg w-full flex items-center text-white-dark dark:bg-[#1b2e4b]" :class="{'!text-primary' : active === 1}" x-on:click="active === 1 ? active = null : active = 1">
                    <h3 class="text-black">Input Nilai - {{ $mapel->nama_mapel }}</h3>
                    <div class="ltr:ml-auto rtl:mr-auto" :class="{'rotate-180' : active === 1}">
                        <svg xmlns="http://www.w3.org/2000/svg" width="19" height="13" viewBox="0 0 19 13" fill="none">
                            <path fill-rule="evenodd" clip-rule="evenodd" stroke="blue" d="M0.25 1C0.25 0.585786 0.585786 0.25 1 0.25H18C18.4142 0.25 18.75 0.585786 18.75 1C18.75 1.41421 18.4142 1.75 18 1.75H1C0.585786 1.75 0.25 1.41421 0.25 1ZM15.5 3.25C15.9142 3.25 16.25 3.58579 16.25 4V10.1893L17.4697 8.96967C17.7626 8.67678 18.2374 8.67678 18.5303 8.96967C18.8232 9.26256 18.8232 9.73744 18.5303 10.0303L16.0303 12.5303C15.7374 12.8232 15.2626 12.8232 14.9697 12.5303L12.4697 10.0303C12.1768 9.73744 12.1768 9.26256 12.4697 8.96967C12.7626 8.67678 13.2374 8.67678 13.5303 8.96967L14.75 10.1893V4C14.75 3.58579 15.0858 3.25 15.5 3.25ZM0.25 6C0.25 5.58579 0.585786 5.25 1 5.25H10C10.4142 5.25 10.75 5.58579 10.75 6C10.75 6.41421 10.4142 6.75 10 6.75H1C0.585786 6.75 0.25 6.41421 0.25 6ZM0.25 11C0.25 10.5858 0.585786 10.25 1 10.25H9C9.41421 10.25 9.75 10.5858 9.75 11C9.75 11.4142 9.41421 11.75 9 11.75H1C0.585786 11.75 0.25 11.4142 0.25 11Z" fill="#1C274C"/>
                        </svg>
                    </div>
                </button>
                <div x-cloak x-show="active === 1" x-collapse>
                    <div class="space-y-2 p-4 text-white-dark text-[13px] border-t border-[#d3d3d3] dark:border-[#1b2e4b]">
                        <!-- card 1 -->
                        <div class="grid sm:grid-cols-1 md:grid-cols-3 lg:grid-cols-4 justify-center">
                            @foreach ($mapping_guru as $data)
                                        <div class="bg-white me-4 mb-4 shadow-[4px_6px_10px_-3px_#bfc9d4] rounded border border-[#e0e6ed] dark:border-[#1b2e4b] dark:bg-[#191e3a] dark:shadow-none">
                                            <h5 class="text-[#3b3f5c] text-center mt-3 text-lg font-bold dark:text-white-light">{{ $data->mapel->kode_mapel }} {{ $data->kelas->nama_kelas }}</h5>
                                            <div class="py-7 px-6">
                                                <a href="{{ route('nilai-pengetahuan.index',[
                                                    'tahun_ajaran_id' => $data->tahun_ajaran_id,
                                                    'mapel_id' => $data->mapel_id,
                                                    'kelas_id' => $data->kelas_id,
                                                    'mapping_guru_id' => $data->id,
                                                ]) }}" class="btn mb-3 text-white bg-blue-950">Nilai Pengetahuan</a>
                                                <a href="{{ route('nilai-keterampilan.index',[
                                                    'tahun_ajaran_id' => $data->tahun_ajaran_id,
                                                    'mapel_id' => $data->mapel_id,
                                                    'kelas_id' => $data->kelas_id,
                                                    'mapping_guru_id' => $data->id,
                                                ]) }}" class="btn mb-3 text-white bg-blue-950">Nilai Keterampilan</a>
                                                <a href="{{ route('nilai-pts.index',[
                                                    'tahun_ajaran_id' => $data->tahun_ajaran_id,
                                                    'mapel_id' => $data->mapel_id,
                                                    'kelas_id' => $data->kelas_id,
                                                    'mapping_guru_id' => $data->id,
                                                ]) }}" class="btn mb-3 text-white bg-blue-950">Nilai STS/PTS</a>
                                                <a href="{{ route('nilai-pas.index',[
                                                    'tahun_ajaran_id' => $data->tahun_ajaran_id,
                                                    'mapel_id' => $data->mapel_id,
                                                    'kelas_id' => $data->kelas_id,
                                                    'mapping_guru_id' => $data->id,
                                                ]) }}" class="btn mb-3 text-white bg-blue-950">Nilai SAS/PAS</a>
                                            </div>
                                        </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

</x-layout.default>
