<x-layout.default>

    <ul class="flex space-x-2 rtl:space-x-reverse">
        <li>
            <a href="{{ route('mapel-diampu.index') }}" class="text-primary hover:underline">Mapel Diampu</a>
        </li>
        <li class="before:content-['/'] ltr:before:mr-1 rtl:before:ml-1">
            <span>Daftar Mapel</span>
        </li>
    </ul>

    <div>
        <div class="panel mt-6">

            <div class="flex">
                <h5 class="font-semibold text-lg dark:text-white-light">Daftar Mapel</h5>
            </div>


            <div class="table-responsive">
                <table>
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Nama Mapel</th>
                            <th>Tahun Ajaran</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        @php
                            $i = 1;
                        @endphp
                        @foreach ($mapel as $data)
                        <tr>
                            <td>{{ $i++ }}</td>
                            <td>{{ $data->mapel->nama_mapel }}</td>
                            <td>{{ $data->tahunAjaran->nama_tahun_ajaran }}</td>
                            <td>@include('mapel-diampu.table_action')</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

        </div>
    </div>

    <script>
        document.addEventListener("alpine:init", () => {
            Alpine.data("dropdown", (initialOpenState = false) => ({
                open: initialOpenState,

                toggle() {
                    this.open = !this.open;
                },
            }));
        });
    </script>

</x-layout.default>
