<html>

<head>
    <title>Cetak Raport</title>
    <style type="text/css">
        body {
            font-family: arial;
            font-size: 8pt; /* Mengurangi ukuran font */
            width: 8.5in;
        }

        .table {
            border-collapse: collapse;
            border: solid 1px #999;
            width: 100%;
            font-size: 8pt; /* Mengurangi ukuran font */
        }

        .table tr td, .table tr th {
            border: solid 1px #000;
            padding: 2px;  /* Mengurangi padding */
            font-size: 16px; /* Mengurangi ukuran font */
        }

        .table tr th {
            font-weight: bold;
            text-align: center;
            font-size: 8pt; /* Mengurangi ukuran font */
        }

    /* Atur ukuran font keseluruhan tabel */
    table, table th, table td, p {
        font-size: 16px;
    }

    /* Atur font tebal untuk poin-poin B, C, D, E, dan F */
    h3, p b {
        font-weight: bold;
    }

    /* Atur margin untuk elemen h3 agar rapi */
    h3 {
        margin-top: 1em;
        margin-bottom: 0.5em;
    }

    /* Style khusus untuk div yang memiliki border */
    div {
        font-size: 16px;
    }


        .rgt {text-align: right;}
        .ctr {text-align: center;}
        .tbl {font-weight: bold}

        table tr td {vertical-align: top}
        .font_kecil {font-size: 10px}
    </style>
    <script type="text/javascript">
        function PrintWindow() {
            window.print();
            CheckWindowState();
        }

        function CheckWindowState() {
            if (document.readyState == "complete") {
                window.close();
            } else {
                setTimeout("CheckWindowState()", 1000)
            }
        }
    </script>
</head>

<body>
    <table>
        <tbody>
            <tr>
                <td colspan="6" style="text-align: center; font-weight: bold">
                    <p></p>
                    <h3>HASIL BELAJAR (RAPOR) PESERTA DIDIK SEMESTER {{ $semester }} {{ $mappingSiswa->tahunAjaran->kode_tahun_ajaran }}</h3>
                    <p></p>
                </td>
            </tr>
            <tr>

                <td>Nama Siswa</td>
                <td>:</td>
                <td class="tbl">{{ $mappingSiswa->siswa->nama_siswa }}</td>
                <td width="20%">Kelas</td>
                <td width="1%">:</td>
                <td width="19%" class="tbl">{{ $mappingSiswa->kelas->nama_kelas }}</td>
            </tr>
            <tr>
                <td>NISN</td>
                <td>:</td>
                <td class="tbl">{{ $mappingSiswa->siswa->nis ?? '-' }} / {{ $mappingSiswa->siswa->nisn ?? '-' }}</td>
                @if ($mappingSiswa->kelas->tingkatan->kode_tingkatan == 'XI' || $mappingSiswa->kelas->tingkatan->kode_tingkatan == 'XII')
                <td>Fase</td>
                <td>:</td>
                <td class="tbl">F</td>
                @else
                <td>Fase</td>
                <td>:</td>
                <td class="tbl">E</td>
                @endif

            </tr>
            <tr>
                <td width="20%">Nama Sekolah</td>
                <td width="1%">:</td>
                <td width="39%" class="tbl">SMK TARUNA HARAPAN 1 CIPATAT</td>
                <td>Semester</td>
                <td>:</td>
                <td class="tbl">{{ $semester }}</td>
            </tr>
            <tr>
                <td>Alamat Sekolah</td>
                <td>:</td>
                <td class="tbl">Jalan Raya Cipatat No.28, Ciptaharja, Kec. Cipatat, Kabupaten Bandung Barat, Jawa Barat 40554</td>
                <td>Tahun Pelajaran</td>
                <td>:</td>
                <td class="tbl">{{ $mappingSiswa->tahunAjaran->kode_tahun_ajaran }}</td>

            </tr>
        </tbody>
    </table>
    <h3>A. Pengetahuan dan Keterampilan</h3>
    <table border="1" cellpadding="5" cellspacing="0">
        <thead>
            <tr>
                <th>No</th>
                <th>Mata Pelajaran</th>
                <th>Nilai Akhir</th>
                <th>Capaian Kompetensi</th>
            </tr>
        </thead>
        <tbody>
            @php
            $i =1;
            @endphp
            @if ($mappingSiswa->kelas->tingkatan->kode_tingkatan == 'X' || $mappingSiswa->kelas->tingkatan->kode_tingkatan == 'XI')
                @foreach ($nilaiA as $key => $value)
                    <tr>
                        <td style="text-align: center">{{ $i++}}</td>
                        <td>{{ $key }}</td>
                        <td @if ($value['rataRata'] < 75) style="color: red;text-align: center;" @endif style="text-align: center">{{ $value['rataRata'] }}</td>
                        <td>
                            @if (nilaiPredikat($value['rataRata']) == 'A')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Sangat Baik pada :
                                @elseif(nilaiPredikat($value['rataRata']) == 'B')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Baik pada :
                                @elseif(nilaiPredikat($value['rataRata']) == 'C')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Cukup pada :
                                @else
                            <p>Capaian kompetensi belum tuntas dengan predikat Kurang pada :
                                @endif
                                @if (isset($value['kd_pengetahuan']))
                                {{ $value['kd_pengetahuan'] }}
                            </p>
                            @endif
                        </td>
                    </tr>
                @endforeach
            @elseif ($mappingSiswa->kelas->tingkatan->kode_tingkatan == 'XII')
                @php
                    $convertArray = $nilaiA->toArray();
                    $arrayKey = array_keys($convertArray);
                    $lastIndex = array_pop($arrayKey);
                    unset($convertArray[$lastIndex]);
                @endphp
                @foreach ($convertArray as $key => $value)
                    <tr>
                        <td style="text-align: center">{{ $i++}}</td>
                        <td>{{ $key }}</td>
                        <td @if ($value['rataRata'] < 75) style="color: red;text-align: center;" @endif style="text-align: center">{{ $value['rataRata'] }}</td>
                        <td>
                            @if (nilaiPredikat($value['rataRata']) == 'A')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Sangat Baik pada :
                                @elseif(nilaiPredikat($value['rataRata']) == 'B')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Baik pada :
                                @elseif(nilaiPredikat($value['rataRata']) == 'C')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Cukup pada :
                                @else
                            <p>Capaian kompetensi belum tuntas dengan predikat Kurang pada :
                                @endif
                                @if (isset($value['kd_pengetahuan']))
                                {{ $value['kd_pengetahuan'] }}
                            </p>
                            @endif
                        </td>
                    </tr>
                @endforeach
            @endif

            @if ($mappingSiswa->kelas->tingkatan->kode_tingkatan == 'XI')
                @foreach ($nilaiB as $key => $value)
                    <tr>
                        <td style="text-align: center">{{ $i++}}</td>
                        <td>{{ $key }}</td>
                        <td @if ($value['rataRata'] < 75) style="color: red;text-align: center;" @endif style="text-align: center">{{ $value['rataRata'] }}</td>
                        <td>
                            @if (nilaiPredikat($value['rataRata']) == 'A')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Sangat Baik pada :
                                @elseif(nilaiPredikat($value['rataRata']) == 'B')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Baik pada :
                                @elseif(nilaiPredikat($value['rataRata']) == 'C')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Cukup pada :
                                @else
                            <p>Capaian kompetensi belum tuntas dengan predikat Kurang pada :
                                @endif
                                @if (isset($value['kd_pengetahuan']))
                                {{ $value['kd_pengetahuan'] }}
                            </p>
                            @endif
                        </td>
                    </tr>
                @endforeach
            @elseif($mappingSiswa->kelas->tingkatan->kode_tingkatan == 'X')
                @foreach ($nilaiB as $key => $value)
                    <tr>
                        <td style="text-align: center">{{ $i++}}</td>
                        <td>{{ $key }}</td>
                        <td @if ($value['rataRata'] < 75) style="color: red;text-align: center;" @endif style="text-align: center">{{ $value['rataRata'] }}</td>
                        <td>
                            @if (nilaiPredikat($value['rataRata']) == 'A')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Sangat Baik pada :
                                @elseif(nilaiPredikat($value['rataRata']) == 'B')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Baik pada :
                                @elseif(nilaiPredikat($value['rataRata']) == 'C')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Cukup pada :
                                @else
                            <p>Capaian kompetensi belum tuntas dengan predikat Kurang pada :
                                @endif
                                @if (isset($value['kd_pengetahuan']))
                                {{ $value['kd_pengetahuan'] }}
                            </p>
                            @endif
                        </td>
                    </tr>
                @endforeach
                @foreach ($nilaiB10 as $key => $value)
                    <tr>
                        <td style="text-align: center">{{ $i++}}</td>
                        <td>{{ $key }}</td>
                        <td @if ($value['rataRata'] < 75) style="color: red;text-align: center;" @endif style="text-align: center">{{ $value['rataRata'] }}</td>
                        <td>
                            @if (nilaiPredikat($value['rataRata']) == 'A')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Sangat Baik pada :
                                @elseif(nilaiPredikat($value['rataRata']) == 'B')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Baik pada :
                                @elseif(nilaiPredikat($value['rataRata']) == 'C')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Cukup pada :
                                @else
                            <p>Capaian kompetensi belum tuntas dengan predikat Kurang pada :
                                @endif
                                @if (isset($value['kd_pengetahuan']))
                                {{ $value['kd_pengetahuan'] }}
                            </p>
                            @endif
                        </td>
                    </tr>
                @endforeach
            @endif

            @if ($mappingSiswa->kelas->tingkatan->kode_tingkatan == 'X')
                @foreach ($nilaiC1 as $key => $value)
                    <tr>
                        <td style="text-align: center">{{ $i++}}</td>
                        <td>{{ $key }}</td>
                        <td @if ($value['rataRata'] < 75) style="color: red;text-align: center;" @endif style="text-align: center">{{ $value['rataRata'] }}</td>
                        <td>
                            @if (nilaiPredikat($value['rataRata']) == 'A')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Sangat Baik pada :
                                @elseif(nilaiPredikat($value['rataRata']) == 'B')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Baik pada :
                                @elseif(nilaiPredikat($value['rataRata']) == 'C')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Cukup pada :
                                @else
                            <p>Capaian kompetensi belum tuntas dengan predikat Kurang pada :
                                @endif
                                @if (isset($value['kd_pengetahuan']))
                                {{ $value['kd_pengetahuan'] }}
                            </p>
                            @endif
                        </td>
                    </tr>
                @endforeach
            @endif

            @if ($mappingSiswa->kelas->jurusan->kode_jurusan == 'AK' && $mappingSiswa->kelas->tingkatan->kode_tingkatan == 'X')
                @foreach ($nilaiC2AK as $key => $value)
                    <tr>
                        <td style="text-align: center">{{ $i++}}</td>
                        <td>{{ $key }}</td>
                        <td @if ($value['rataRata'] < 75) style="color: red;text-align: center;" @endif style="text-align: center">{{ $value['rataRata'] }}</td>
                        <td>
                            @if (nilaiPredikat($value['rataRata']) == 'A')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Sangat Baik pada :
                                @elseif(nilaiPredikat($value['rataRata']) == 'B')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Baik pada :
                                @elseif(nilaiPredikat($value['rataRata']) == 'C')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Cukup pada :
                                @else
                            <p>Capaian kompetensi belum tuntas dengan predikat Kurang pada :
                                @endif
                                @if (isset($value['kd_pengetahuan']))
                                {{ $value['kd_pengetahuan'] }}
                            </p>
                            @endif
                        </td>
                    </tr>
                @endforeach
            @endif

            @if ($mappingSiswa->kelas->jurusan->kode_jurusan == 'BDP' && $mappingSiswa->kelas->tingkatan->kode_tingkatan == 'X')
                @foreach ($nilaiC2BDP as $key => $value)
                    <tr>
                        <td style="text-align: center">{{ $i++}}</td>
                        <td>{{ $key }}</td>
                        <td @if ($value['rataRata'] < 75) style="color: red;text-align: center;" @endif style="text-align: center">{{ $value['rataRata'] }}</td>
                        <td>
                            @if (nilaiPredikat($value['rataRata']) == 'A')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Sangat Baik pada :
                                @elseif(nilaiPredikat($value['rataRata']) == 'B')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Baik pada :
                                @elseif(nilaiPredikat($value['rataRata']) == 'C')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Cukup pada :
                                @else
                            <p>Capaian kompetensi belum tuntas dengan predikat Kurang pada :
                                @endif
                                @if (isset($value['kd_pengetahuan']))
                                {{ $value['kd_pengetahuan'] }}
                            </p>
                            @endif
                        </td>
                    </tr>
                @endforeach
            @endif

            @if ($mappingSiswa->kelas->jurusan->kode_jurusan == 'RPL' && $mappingSiswa->kelas->tingkatan->kode_tingkatan == 'X')
                @foreach ($nilaiC2RPL as $key => $value)
                    <tr>
                        <td style="text-align: center">{{ $i++}}</td>
                        <td>{{ $key }}</td>
                        <td @if ($value['rataRata'] < 75) style="color: red;text-align: center;" @endif style="text-align: center">{{ $value['rataRata'] }}</td>
                        <td>
                            @if (nilaiPredikat($value['rataRata']) == 'A')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Sangat Baik pada :
                                @elseif(nilaiPredikat($value['rataRata']) == 'B')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Baik pada :
                                @elseif(nilaiPredikat($value['rataRata']) == 'C')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Cukup pada :
                                @else
                            <p>Capaian kompetensi belum tuntas dengan predikat Kurang pada :
                                @endif
                                @if (isset($value['kd_pengetahuan']))
                                {{ $value['kd_pengetahuan'] }}
                            </p>
                            @endif
                        </td>
                    </tr>
                @endforeach
            @endif

            @if ($mappingSiswa->kelas->jurusan->kode_jurusan == 'TBSM' && $mappingSiswa->kelas->tingkatan->kode_tingkatan == 'X' || $mappingSiswa->kelas->jurusan->kode_jurusan == 'TKRO' && $mappingSiswa->kelas->tingkatan->kode_tingkatan == 'X')
                @foreach ($nilaiC2OTO as $key => $value)
                    <tr>
                        <td style="text-align: center">{{ $i++}}</td>
                        <td>{{ $key }}</td>
                        <td @if ($value['rataRata'] < 75) style="color: red;text-align: center;" @endif style="text-align: center">{{ $value['rataRata'] }}</td>
                        <td>
                            @if (nilaiPredikat($value['rataRata']) == 'A')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Sangat Baik pada :
                                @elseif(nilaiPredikat($value['rataRata']) == 'B')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Baik pada :
                                @elseif(nilaiPredikat($value['rataRata']) == 'C')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Cukup pada :
                                @else
                            <p>Capaian kompetensi belum tuntas dengan predikat Kurang pada :
                                @endif
                                @if (isset($value['kd_pengetahuan']))
                                {{ $value['kd_pengetahuan'] }}
                            </p>
                            @endif
                        </td>
                    </tr>
                @endforeach
            @endif

            @if ($mappingSiswa->kelas->tingkatan->kode_tingkatan == 'XI' && $mappingSiswa->kelas->jurusan->kode_jurusan == 'AK')
                @foreach ($nilaiC3AK as $key => $value)
                    <tr>
                        <td style="text-align: center">{{ $i++}}</td>
                        <td>{{ $key }}</td>
                        <td @if ($value['rataRata'] < 75) style="color: red; text-align: center;" @endif style="text-align: center">{{ $value['rataRata'] }}</td>
                        <td>
                            @if (nilaiPredikat($value['rataRata']) == 'A')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Sangat Baik pada :
                                @elseif(nilaiPredikat($value['rataRata']) == 'B')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Baik pada :
                                @elseif(nilaiPredikat($value['rataRata']) == 'C')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Cukup pada :
                                @else
                            <p>Capaian kompetensi belum tuntas dengan predikat Kurang pada :
                                @endif
                                @if (isset($value['kd_pengetahuan']))
                                {{ $value['kd_pengetahuan'] }}
                            </p>
                            @endif
                        </td>
                    </tr>
                @endforeach
            @endif

            @if ($mappingSiswa->kelas->tingkatan->kode_tingkatan == 'XI' && $mappingSiswa->kelas->jurusan->kode_jurusan == 'BDP')
                @foreach ($nilaiC3BDP as $key => $value)
                    <tr>
                        <td style="text-align: center">{{ $i++}}</td>
                        <td>{{ $key }}</td>
                        <td @if ($value['rataRata'] < 75) style="color: red;text-align: center;" @endif style="text-align: center">{{ $value['rataRata'] }}</td>
                        <td>
                            @if (nilaiPredikat($value['rataRata']) == 'A')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Sangat Baik pada :
                                @elseif(nilaiPredikat($value['rataRata']) == 'B')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Baik pada :
                                @elseif(nilaiPredikat($value['rataRata']) == 'C')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Cukup pada :
                                @else
                            <p>Capaian kompetensi belum tuntas dengan predikat Kurang pada :
                                @endif
                                @if (isset($value['kd_pengetahuan']))
                                {{ $value['kd_pengetahuan'] }}
                            </p>
                            @endif
                        </td>
                    </tr>
                @endforeach
            @endif

            @if ($mappingSiswa->kelas->tingkatan->kode_tingkatan == 'XI' && $mappingSiswa->kelas->jurusan->kode_jurusan == 'RPL')
                @php
                    $convertArray = $nilaiC3RPL->toArray();
                    $arrayKey = array_keys($convertArray);
                    $lastIndex = array_pop($arrayKey);
                    unset($convertArray[$lastIndex]);
                @endphp
                @foreach ($convertArray as $key => $value)
                    <tr>
                        <td style="text-align: center">{{ $i++}}</td>
                        <td>{{ $key }}</td>
                        <td @if ($value['rataRata'] < 75) style="color: red;text-align: center;" @endif style="text-align: center">{{ $value['rataRata'] }}</td>
                        <td>
                            @if (nilaiPredikat($value['rataRata']) == 'A')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Sangat Baik pada :
                                @elseif(nilaiPredikat($value['rataRata']) == 'B')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Baik pada :
                                @elseif(nilaiPredikat($value['rataRata']) == 'C')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Cukup pada :
                                @else
                            <p>Capaian kompetensi belum tuntas dengan predikat Kurang pada :
                                @endif
                                @if (isset($value['kd_pengetahuan']))
                                {{ $value['kd_pengetahuan'] }}
                            </p>
                            @endif
                        </td>
                    </tr>
                @endforeach
            @endif

            @if ($mappingSiswa->kelas->tingkatan->kode_tingkatan == 'XI' && $mappingSiswa->kelas->jurusan->kode_jurusan == 'TBSM')
                @foreach ($nilaiC3TBSM as $key => $value)
                    <tr>
                        <td style="text-align: center">{{ $i++}}</td>
                        <td>{{ $key }}</td>
                        <td @if ($value['rataRata'] < 75) style="color: red;text-align: center;" @endif style="text-align: center">{{ $value['rataRata'] }}</td>
                        <td>
                            @if (nilaiPredikat($value['rataRata']) == 'A')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Sangat Baik pada :
                                @elseif(nilaiPredikat($value['rataRata']) == 'B')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Baik pada :
                                @elseif(nilaiPredikat($value['rataRata']) == 'C')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Cukup pada :
                                @else
                            <p>Capaian kompetensi belum tuntas dengan predikat Kurang pada :
                                @endif
                                @if (isset($value['kd_pengetahuan']))
                                {{ $value['kd_pengetahuan'] }}
                            </p>
                            @endif
                        </td>
                    </tr>
                @endforeach
            @endif

            @if ($mappingSiswa->kelas->tingkatan->kode_tingkatan == 'XI' && $mappingSiswa->kelas->jurusan->kode_jurusan == 'TKRO')
                @foreach ($nilaiC3TKRO as $key => $value)
                    <tr>
                        <td style="text-align: center">{{ $i++}}</td>
                        <td>{{ $key }}</td>
                        <td @if ($value['rataRata'] < 75) style="color: red;text-align: center;" @endif style="text-align: center">{{ $value['rataRata'] }}</td>
                        <td>
                            @if (nilaiPredikat($value['rataRata']) == 'A')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Sangat Baik pada :
                                @elseif(nilaiPredikat($value['rataRata']) == 'B')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Baik pada :
                                @elseif(nilaiPredikat($value['rataRata']) == 'C')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Cukup pada :
                                @else
                            <p>Capaian kompetensi belum tuntas dengan predikat Kurang pada :
                                @endif
                                @if (isset($value['kd_pengetahuan']))
                                {{ $value['kd_pengetahuan'] }}
                            </p>
                            @endif
                        </td>
                    </tr>
                @endforeach
            @endif

            @if ($mappingSiswa->kelas->tingkatan->kode_tingkatan == 'XII' && $mappingSiswa->kelas->jurusan->kode_jurusan == 'AK')
                @foreach ($nilaiC3AK12 as $key => $value)
                    <tr>
                        <td style="text-align: center">{{ $i++}}</td>
                        <td>{{ $key }}</td>
                        <td @if ($value['rataRata'] < 75) style="color: red; text-align: center;" @endif style="text-align: center">{{ $value['rataRata'] }}</td>
                        <td>
                            @if (nilaiPredikat($value['rataRata']) == 'A')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Sangat Baik pada :
                                @elseif(nilaiPredikat($value['rataRata']) == 'B')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Baik pada :
                                @elseif(nilaiPredikat($value['rataRata']) == 'C')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Cukup pada :
                                @else
                            <p>Capaian kompetensi belum tuntas dengan predikat Kurang pada :
                                @endif
                                @if (isset($value['kd_pengetahuan']))
                                {{ $value['kd_pengetahuan'] }}
                            </p>
                            @endif
                        </td>
                    </tr>
                @endforeach
            @endif

            @if ($mappingSiswa->kelas->tingkatan->kode_tingkatan == 'XII' && $mappingSiswa->kelas->jurusan->kode_jurusan == 'BDP')
                @foreach ($nilaiC3BDP12 as $key => $value)
                    <tr>
                        <td style="text-align: center">{{ $i++}}</td>
                        <td>{{ $key }}</td>
                        <td @if ($value['rataRata'] < 75) style="color: red;text-align: center;" @endif style="text-align: center">{{ $value['rataRata'] }}</td>
                        <td>
                            @if (nilaiPredikat($value['rataRata']) == 'A')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Sangat Baik pada :
                                @elseif(nilaiPredikat($value['rataRata']) == 'B')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Baik pada :
                                @elseif(nilaiPredikat($value['rataRata']) == 'C')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Cukup pada :
                                @else
                            <p>Capaian kompetensi belum tuntas dengan predikat Kurang pada :
                                @endif
                                @if (isset($value['kd_pengetahuan']))
                                {{ $value['kd_pengetahuan'] }}
                            </p>
                            @endif
                        </td>
                    </tr>
                @endforeach
            @endif

            @if ($mappingSiswa->kelas->tingkatan->kode_tingkatan == 'XII' && $mappingSiswa->kelas->jurusan->kode_jurusan == 'RPL')
                @foreach ($nilaiC3RPL12 as $key => $value)
                    <tr>
                        <td style="text-align: center">{{ $i++}}</td>
                        <td>{{ $key }}</td>
                        <td @if ($value['rataRata'] < 75) style="color: red;text-align: center;" @endif style="text-align: center">{{ $value['rataRata'] }}</td>
                        <td>
                            @if (nilaiPredikat($value['rataRata']) == 'A')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Sangat Baik pada :
                                @elseif(nilaiPredikat($value['rataRata']) == 'B')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Baik pada :
                                @elseif(nilaiPredikat($value['rataRata']) == 'C')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Cukup pada :
                                @else
                            <p>Capaian kompetensi belum tuntas dengan predikat Kurang pada :
                                @endif
                                @if (isset($value['kd_pengetahuan']))
                                {{ $value['kd_pengetahuan'] }}
                            </p>
                            @endif
                        </td>
                    </tr>
                @endforeach
            @endif

            @if ($mappingSiswa->kelas->tingkatan->kode_tingkatan == 'XII' && $mappingSiswa->kelas->jurusan->kode_jurusan == 'TBSM')
                @foreach ($nilaiC3TBSM12 as $key => $value)
                    <tr>
                        <td style="text-align: center">{{ $i++}}</td>
                        <td>{{ $key }}</td>
                        <td @if ($value['rataRata'] < 75) style="color: red;text-align: center;" @endif style="text-align: center">{{ $value['rataRata'] }}</td>
                        <td>
                            @if (nilaiPredikat($value['rataRata']) == 'A')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Sangat Baik pada :
                                @elseif(nilaiPredikat($value['rataRata']) == 'B')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Baik pada :
                                @elseif(nilaiPredikat($value['rataRata']) == 'C')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Cukup pada :
                                @else
                            <p>Capaian kompetensi belum tuntas dengan predikat Kurang pada :
                                @endif
                                @if (isset($value['kd_pengetahuan']))
                                {{ $value['kd_pengetahuan'] }}
                            </p>
                            @endif
                        </td>
                    </tr>
                @endforeach
            @endif

            @if ($mappingSiswa->kelas->tingkatan->kode_tingkatan == 'XII' && $mappingSiswa->kelas->jurusan->kode_jurusan == 'TKRO')
                @foreach ($nilaiC3TKRO12 as $key => $value)
                    <tr>
                        <td style="text-align: center">{{ $i++}}</td>
                        <td>{{ $key }}</td>
                        <td @if ($value['rataRata'] < 75) style="color: red;text-align: center;" @endif style="text-align: center">{{ $value['rataRata'] }}</td>
                        <td>
                            @if (nilaiPredikat($value['rataRata']) == 'A')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Sangat Baik pada :
                                @elseif(nilaiPredikat($value['rataRata']) == 'B')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Baik pada :
                                @elseif(nilaiPredikat($value['rataRata']) == 'C')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Cukup pada :
                                @else
                            <p>Capaian kompetensi belum tuntas dengan predikat Kurang pada :
                                @endif
                                @if (isset($value['kd_pengetahuan']))
                                {{ $value['kd_pengetahuan'] }}
                            </p>
                            @endif
                        </td>
                    </tr>
                @endforeach
            @endif

            @if ($mappingSiswa->kelas->tingkatan->kode_tingkatan == 'XI' || $mappingSiswa->kelas->tingkatan->kode_tingkatan == 'XII')
                @foreach ($nilaiC3ALL as $key => $value)
                    <tr>
                        <td style="text-align: center">{{ $i++}}</td>
                        <td>{{ $key }}</td>
                        <td @if ($value['rataRata'] < 75) style="color: red;text-align: center;" @endif style="text-align: center">{{ $value['rataRata'] }}</td>
                        <td>
                            @if (nilaiPredikat($value['rataRata']) == 'A')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Sangat Baik pada :
                                @elseif(nilaiPredikat($value['rataRata']) == 'B')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Baik pada :
                                @elseif(nilaiPredikat($value['rataRata']) == 'C')
                            <p>Capaian kompetensi sudah tuntas dengan predikat Cukup pada :
                                @else
                            <p>Capaian kompetensi belum tuntas dengan predikat Kurang pada :
                                @endif
                                @if (isset($value['kd_pengetahuan']))
                                {{ $value['kd_pengetahuan'] }}
                            </p>
                            @endif
                        </td>
                    </tr>
                @endforeach
            @endif


            @php
                $convertArray = $nilaiD->toArray();
                $arrayKey = array_keys($convertArray);
                $lastIndex = array_pop($arrayKey);
                unset($convertArray[$lastIndex]);
            @endphp
            @foreach ($convertArray as $key => $value)
                <tr>
                    <td style="text-align: center">{{ $i++}}</td>
                    <td>{{ $key }}</td>
                    <td @if ($value['rataRata'] < 75) style="color: red;text-align: center;" @endif style="text-align: center">{{ $value['rataRata'] }}</td>
                    <td>
                        @if (nilaiPredikat($value['rataRata']) == 'A')
                        <p>Capaian kompetensi sudah tuntas dengan predikat Sangat Baik pada :
                            @elseif(nilaiPredikat($value['rataRata']) == 'B')
                        <p>Capaian kompetensi sudah tuntas dengan predikat Baik pada :
                            @elseif(nilaiPredikat($value['rataRata']) == 'C')
                        <p>Capaian kompetensi sudah tuntas dengan predikat Cukup pada :
                            @else
                        <p>Capaian kompetensi belum tuntas dengan predikat Kurang pada :
                            @endif
                            @if (isset($value['kd_pengetahuan']))
                            {{ $value['kd_pengetahuan'] }}
                        </p>
                        @endif
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>


    @if ($mappingSiswa->kelas->tingkatan->kode_tingkatan == 'XII')
    <h3>B. Ekstrakurikuler & Nilai Sikap Ramah Lingkungan</h3>
    <table class="table" style="font-size: 16px">
        <thead>
            <tr>
                <th>No</th>
                <th>Nama Kegiatan</th>
                <th>Nilai</th>
                <th>Keterangan</th>
            </tr>
        </thead>
        <tbody>
            @if (isset($nilaiEkskul))
                @php
                $indexEkskul = 1;
                @endphp
                @foreach ($nilaiEkskul as $data)
                    @if ($data->nilai == 'A' || $data->nilai == 'B' || $data->nilai == 'C')
                        <tr>
                            <td style="text-align: center">{{ $indexEkskul++ }}</td>
                            <td>{{ $data->master_ekskul->nama_ekskul }}</td>
                            <td class="ctr">{{ $data->nilai }}</td>
                            <td>{{ $data->keterangan_walikelas }}</td>
                        </tr>
                    @endif
                @endforeach
            @else
            <tr>
                <td>1</td>
                <td>Ekskul A</td>
                <td>A</td>
                <td>Sangat Baik</td>
            </tr>
            @endif
        </tbody>
    </table>
@else
    <h3>B. Ekstrakurikuler</h3>
    <table class="table" style="font-size: 16px">
        <thead>
            <tr>
                <th>No</th>
                <th>Nama Kegiatan</th>
                <th>Nilai</th>
                <th>Keterangan</th>
            </tr>
        </thead>
        <tbody>
            @if (isset($nilaiEkskul))
                @php
                $indexEkskul = 1;
                @endphp
                @foreach ($nilaiEkskul as $data)
                    @if ($data->nilai == 'A' || $data->nilai == 'B' || $data->nilai == 'C')
                        <tr>
                            <td style="text-align: center">{{ $indexEkskul++ }}</td>
                            <td>{{ $data->master_ekskul->nama_ekskul }}</td>
                            <td class="ctr">{{ $data->nilai }}</td>
                            <td>{{ $data->keterangan_walikelas }}</td>
                        </tr>
                    @endif
                @endforeach
            @else
            <tr>
                <td>-</td>
                <td>-</td>
                <td>-</td>
                <td>-</td>
            </tr>
            @endif
        </tbody>
    </table>
@endif

<h3>C. Ketidakhadiran</h3>
<table class="table" style="width:50%; font-size: 16px">
    <tbody>
        <tr>
            <td width="40%">Sakit</td>
            @if (isset($nilaiAbsensi->sakit))
                <td width="40%" class="ctr">{{ $nilaiAbsensi->sakit }} - hari</td>
            @else
                <td width="40%" class="ctr">0 - hari</td>
            @endif
        </tr>
        <tr>
            <td>Izin</td>
            @if (isset($nilaiAbsensi->izin))
                <td width="40%" class="ctr">{{ $nilaiAbsensi->izin }} - hari</td>
            @else
                <td width="40%" class="ctr">0 - hari</td>
            @endif
        </tr>
        <tr>
            <td>Tanpa Keterangan</td>
            @if (isset($nilaiAbsensi->tanpa_keterangan))
                <td width="40%" class="ctr">{{ $nilaiAbsensi->tanpa_keterangan }} - hari</td>
            @else
                <td width="40%" class="ctr">0 - hari</td>
            @endif
        </tr>
    </tbody>
</table>

<h3>D. Prakerin</h3>
@if ($mappingSiswa->kelas->tingkatan->kode_tingkatan == 'XII' && $nilaiPrakerin != null)
    <table class="table" style="font-size: 16px">
        <thead>
            <tr>
                <th width="35%">Nama Perusahaan</th>
                <th width="30%">Nilai</th>
                <th width="30%">Predikat</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td style="text-align: center;">{{ $nilaiPrakerin->nama_perusahaan }}</td>
                <td style="text-align: center;">{{ $nilaiPrakerin->nilai }}</td>
                <td style="text-align: center;">{{ $nilaiPrakerin->predikat }}</td>
            </tr>
        </tbody>
    </table>
@endif

<h3>E. Catatan Wali Kelas</h3>
@if (isset($catatan))
    <div style="border: solid 1px #000; padding: 20px 10px;">
        <p>{{ $catatan->catatan_walikelas }}</p>
    </div>
@else
    <div style="border: solid 1px #000; padding: 20px 10px;">
        <p>-</p>
    </div>
@endif

<h3>F. Tanggapan Orang Tua / Wali</h3>
<div style="border: solid 1px #000; padding: 20px 10px;"></div>
            <table width="100%">
                <tbody>
                    <tr></tr>
                </tbody>
            </table>
        </td>
    </tr>
    @if ($semester == '2')
        <div style="border: solid 1px; padding: 10px; margin-top: 20px">
            <b>Keputusan : </b>

            <p>Berdasarkan pencapaian kompetensi pada semester ke-1 dan ke-2, <b>{{ $mappingSiswa->siswa->nama_siswa }}</b> ditetapkan *) </p><br>

            @php
                $currentTingkat = $mappingSiswa->kelas->tingkatan->kode_tingkatan;

                $tingkatanMap = [
                    'X' => ['current' => 'Sepuluh', 'next' => 'Sebelas'],
                    'XI' => ['current' => 'Sebelas', 'next' => 'Duabelas'],
                ];

                $currentLabel = $tingkatanMap[$currentTingkat]['current'] ?? 'Tidak Diketahui';
                $nextLabel = $tingkatanMap[$currentTingkat]['next'] ?? 'Tidak Diketahui';

                $currentAngka = array_search($currentLabel, ['Sepuluh' => 10, 'Sebelas' => 11, 'Duabelas' => 12]);
                $nextAngka = array_search($nextLabel, ['Sepuluh' => 10, 'Sebelas' => 11, 'Duabelas' => 12]);
            @endphp

            <table border="0" width="100%">
                <tr>
                    <td width="25%">naik ke kelas</td>
                    <td><b>{{ $nextAngka }} ({{ $nextLabel }})</b></td>
                    <td></td>
                    <td></td>
                </tr>
                <tr>
                    <td width="25%">tinggal di kelas</td>
                    <td><b>{{ $currentAngka }} ({{ $currentLabel }})</b></td>
                    <td></td>
                    <td></td>
                </tr>
            </table>

            <p>*) Coret yang tidak perlu</p>

        </div>
    @endif

    <table width="100%" style="margin-top: 1em;">
        <tr>
            <td width="8%"></td>
            <td width="25%">
                Mengetahui : <br>
                Orang Tua/Wali, <br>
                <br><br><br><br><br><br><br>
                <u>..........................</u>
            </td>
            <td width="8%"></td>
            <td width="25%">
                <br>
                Wali Kelas <br>
                <br><br><br><br><br><br><br>
                <u><b>{{ $mappingWaliKelas->guru->nama_lengkap }}</b></u><br>
                NIP.
            </td>
            <td width="50%">
                Bandung Barat, 24 Desember 2025
                <br>
                Kepala <br> SMK Taruna Harapan 1 Cipatat <br>
                <img src="{{asset('assets/images/ttd_pa_eki.png')}}" alt="" width="200px"><br><br>
                <u style="position: relative;bottom:40px"><b>Eki Jarul Alam, S.Kom</b></u><br>
                <p style="position: relative;bottom:50px">NIP.</p>
            </td>
        </tr>
    </table>

</body>

</html>
<script>
    function autoPrint() {
        window.print();
    }

    window.onload = autoPrint;
</script>
