<x-layout.default>

    <ul class="flex space-x-2 rtl:space-x-reverse">
        <li>
            <a href="{{ route('cetak-rangking.index') }}" class="text-primary hover:underline">Cetak Rangking</a>
        </li>
        <li class="before:content-['/'] ltr:before:mr-1 rtl:before:ml-1">
            <span>Cetak Rangking</span>
        </li>
    </ul>

    <div>
        <div class="panel mt-6">
            <div class="flex">
                <div class="grid grid-cols-3 gap-3">
                    <h5 class="font-semibold text-lg dark:text-white-light">Cetak Rangking</h5>
                </div>
                <a href="{{ route('cetak-rangking.show',[
                    'kelas' => $kelas_id
                ]) }}" target="_blank" class="btn btn-sm text-white btn-success ms-auto">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none">
                    <path d="M6 17.9827C4.44655 17.9359 3.51998 17.7626 2.87868 17.1213C2 16.2426 2 14.8284 2 12C2 9.17157 2 7.75736 2.87868 6.87868C3.75736 6 5.17157 6 8 6H16C18.8284 6 20.2426 6 21.1213 6.87868C22 7.75736 22 9.17157 22 12C22 14.8284 22 16.2426 21.1213 17.1213C20.48 17.7626 19.5535 17.9359 18 17.9827" stroke="white" stroke-width="1.5"/>
                    <path opacity="0.5" d="M9 10H6" stroke="white" stroke-width="1.5" stroke-linecap="round"/>
                    <path d="M19 15L5 15" stroke="white" stroke-width="1.5" stroke-linecap="round"/>
                    <path d="M18 15V16C18 18.8284 18 20.2426 17.1213 21.1213C16.2426 22 14.8284 22 12 22C9.17157 22 7.75736 22 6.87868 21.1213C6 20.2426 6 18.8284 6 16V15" stroke="white" stroke-width="1.5" stroke-linecap="round"/>
                    <path opacity="0.5" d="M17.9827 6C17.9359 4.44655 17.7626 3.51998 17.1213 2.87868C16.2427 2 14.8284 2 12 2C9.17158 2 7.75737 2 6.87869 2.87868C6.23739 3.51998 6.06414 4.44655 6.01733 6" stroke="white" stroke-width="1.5"/>
                    <circle opacity="0.5" cx="17" cy="10" r="1" fill="white"/>
                    </svg>Cetak
                </a>
            </div>


            <label for="kelas" class="mt-5">
                Pilih Kelas
            </label>

            <div class="grid grid-cols-2 ">
                <form action="{{route('cetak-rangking.index')}}" method="GET">
                    @if(auth()->user()->hasRole('walikelas'))
                    <select name="kelas" class="form-input">
                            <option disabled selected>Pilih Kelas</option>
                            @foreach($kelas as $data)
                                <option value="{{$data->id}}" @if ($mappingWalikelas->kelas_id == $data->id)
                                    {{ "selected" }}
                                @else {{ "disabled" }} @endif>{{$data->nama_kelas}}</option>
                            @endforeach
                    </select>
                    @else
                    <select name="kelas" class="form-input">
                        <option selected>Pilih Kelas</option>
                        @foreach($kelas as $data)
                            <option @if($data->id == request()->kelas) selected @endif value="{{$data->id}}">{{$data->nama_kelas}}</option>
                        @endforeach
                    </select>
                    @endif

                    @php
                        $reqKelas = request()->get('kelas');
                    @endphp
                    @if(isset($reqKelas))
                        <div class="mt-2">
                            <p class="text-md">Kelas yang dipilih: <span class="font-bold">{{ \App\Models\Kelas::find($reqKelas)->nama_kelas }}</span></p>
                        </div>
                    @endif

                    <button type="submit" class="btn btn-primary mt-5">Pilih Kelas</button>
                </form>
            </div>

            <div class="py-11">
            <table class="table-auto">
                @php
                    $i = 1;
                    $peringkat = 1;
                @endphp
                <thead>
                    <th>No</th>
                    <th>Nama</th>
                    <th>Jumlah</th>
                    <th>Rangking</th>
                </thead>
                <tbody>
                    @foreach ($summary as $nilai)
                    <tr>
                        <td>{{ $i++ }}</td>
                        <td>{{ $nilai['siswa']->nama_siswa }}</td>
                        <td>{{ $nilai['total_nilai'] }}</td>
                        <td>{{ $peringkat++ }}</td>
                    @endforeach
                    </tr>
                </tbody>
            </table>
            </div>

        </div>
    </div>

    <script>
        document.addEventListener("alpine:init", () => {
            Alpine.data("dropdown", (initialOpenState = false) => ({
                open: initialOpenState,

                toggle() {
                    this.open = !this.open;
                },
            }));
        });
    </script>

</x-layout.default>
