<x-layout.auth>

    <div class="flex justify-center items-center min-h-screen bg-[url('/assets/images/map.svg')] dark:bg-[url('/assets/images/map-dark.svg')] bg-cover bg-center">
        <div class="panel sm:w-[480px] m-6 max-w-lg w-full">
            <h2 class="font-bold text-2xl mb-3">Password Reset</h2>
            <p class="mb-7">Enter your new password</p>
            <form class="space-y-5" action="{{ route('reset_password.store') }}" method="post">
                @csrf
                <div>
                    <label for="token">Token</label>
                    <input id="token" type="hidden" name="token" class="form-input" placeholder="Enter token" value="{{ $token }}"/>
                </div>
                <div>
                    <label for="email">Email</label>
                    <input id="email" type="text" name="email" class="form-input" placeholder="Enter email" value="{{ $_GET['email'] }}" readonly/>
                </div>
                <div>
                    <label for="password">Password</label>
                    <input id="password" type="password" name="password" class="form-input" placeholder="Enter password" />
                    @error('password')
                        <p class="text-danger">{{ $message }}</p>
                    @enderror
                    @if($message = Session::get('email'))
                        <p class="text-danger">{{ $message }}</p>
                    @endif
                    @if($message = Session::get('status'))
                        <p class="text-danger">{{ $message }}</p>
                    @endif
                </div>
                <div>
                    <label for="password">Password Confirmation</label>
                    <input id="password" type="password" name="password_confirmation" class="form-input" placeholder="Enter password confirmation" />
                    @error('password')
                        <p class="text-danger">{{ $message }}</p>
                    @enderror
                    @if($message = Session::get('email'))
                        <p class="text-danger">{{ $message }}</p>
                    @endif
                    @if($message = Session::get('status'))
                        <p class="text-danger">{{ $message }}</p>
                    @endif
                </div>
                <button type="submit" class="btn btn-primary w-full">RECOVER</button>
            </form>
        </div>
    </div>

</x-layout.auth>
