<x-layout.auth>

    <div class="flex justify-center items-center min-h-screen bg-[url('/assets/images/map.svg')] dark:bg-[url('/assets/images/map-dark.svg')] bg-cover bg-center">
        <div class="panel sm:w-[480px] m-6 max-w-lg w-full">
            <div class="text-center">
                <div class="flex justify-center items-center">
                    <img class="w-16 mb-2 ml-[5px]" src="/android-chrome-512x512.png"
                         alt="image" />
                </div>
                <h2 class="font-bold text-2xl mb-3">ERaport v2</h2>
                <p class="mb-7">Masuk dengan akun SSO Tarpan One yang anda miliki</p>
            </div>
            <form class="space-y-5" action="{{ route('login.store') }}" method="post">
                @csrf
                <div>
                    <label for="email">Email</label>
                    <input id="email" type="email" class="form-input" name="email" placeholder="Masukkan Email" />
                    @error('email')
                        <p class="text-danger">{{ $message }}</p>
                    @enderror

                    @if($message = Session::get('gagal'))
                        <p class="text-danger">{{ $message }}</p>
                    @endif
                </div>
                <div>
                    <label for="password">Password</label>
                    <input id="password" type="password" class="form-input" name="password" placeholder="Masukkan Kata Sandi" />
                    @error('password')
                        <p class="text-danger">{{ $message }}</p>
                    @enderror
                </div>
                <button type="submit" class="btn btn-primary w-full">Masuk</button>
            </form>
            <p class="text-center mt-3"><a href="{{ route('forgot_password.index') }}"
                    class="text-primary font-bold hover:underline">Lupa Password</a></p>
        </div>
    </div>

</x-layout.auth>
