<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('nilai_prestasi', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('siswa_id')->unsigned();
            $table->bigInteger('kelas_id')->unsigned();
            $table->foreign('siswa_id')->references('id')->on('siswa')->onUpdate('CASCADE')->onDelete('CASCADE');
            $table->foreign('kelas_id')->references('id')->on('kelas')->onUpdate('CASCADE')->onDelete('CASCADE');
            $table->string('jenis');
            $table->text('keterangan');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('nilai_prestasis');
    }
};
