<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('list_kd', function (Blueprint $table) {
            $table->increments('id');
            $table->bigInteger('mapel_id')->unsigned();
            $table->bigInteger('tahun_ajaran_id')->unsigned();
            $table->bigInteger('guru_id')->unsigned();
            $table->foreign('guru_id')->references('id')->on('guru')->onUpdate('CASCADE')->onDelete('CASCADE');
            $table->foreign('mapel_id')->references('id')->on('mapels')->onUpdate('CASCADE')->onDelete('CASCADE');
            $table->foreign('tahun_ajaran_id')->references('id')->on('tahun_ajarans')->onUpdate('CASCADE')->onDelete('CASCADE');
            $table->string('kode_kd');
            $table->string('nama_kd');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('list_kd');
    }
};
