<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class TahunAjaran extends Model
{
    use HasFactory;

    protected $guarded = [];

    protected $fillable = ['nama_tahun_ajaran', 'kode_tahun_ajaran', 'deskripsi', 'is_active'];

    public function master_kd()
    {
        return $this->hasMany(MasterKd::class);
    }

    public function list_kd()
    {
        return $this->hasMany(ListKd::class);
    }

    public function nilai_pengetahuan()
    {
        return $this->hasMany(NilaiPengetahuan::class);
    }

    public function nilai_keterampilan()
    {
        return $this->hasMany(NilaiPengetahuan::class);
    }

    public function nilai_pts()
    {
        return $this->hasMany(NilaiPts::class);
    }

    public function nilai_pas()
    {
        return $this->hasMany(NilaiPas::class);
    }
    public function absen()
    {
        return $this->hasMany(Absen::class);
    }
    public function nilai_ekskul()
    {
        return $this->hasMany(NilaiEkstrakulikuler::class);
    }
    public function catatan()
    {
        return $this->hasMany(Catatan::class);
    }
    public function prakerin()
    {
        return $this->hasMany(NilaiPrakerin::class);
    }
    public function nilaisikapsosial()
    {
        return $this->hasMany(NilaiSikapSosial::class);
    }
    public function nilaisikapspiritual()
    {
        return $this->hasMany(NilaiSikapSpiritual::class);
    }

    // Model
    protected static function booted(): void
    {
        static::creating(function (TahunAjaran $model) {
            $model->uuid = Str::uuid()->toString();
        });
    }
}
