<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\MorphOne;
use Illuminate\Support\Str;

class Siswa extends Model implements Userable
{
    use HasFactory;

    protected $table = 'siswa';
    protected $fillable = [
        'id_siswa',
        'nama_siswa',
        'jenis_kelamin',
        'nis',
        'nisn',
        'nik',
        'no_kk',
        'tempat_lahir',
        'tanggal_lahir' ,
        'no_registrasi_akta',
        'agama',
        'berkebutuhan_khusus',
        'alamat_jalan',
        'rt',
        'rw',
        'desa',
        'kecamatan',
        'kode_pos',
        'tempat_tinggal',
        'moda_transportasi',
        'no_kks',
        'anak_ke',
        'penerima_kps',
        'no_kps',
        'penerima_kip',
        'no_kip',
        'nama_tertera_di_kip',
        'mempunyai_sktm',
//            Data Ayah
        'nama_ayah',
        'nik_ayah',
        'tahun_lahir_ayah',
        'pendidikan_ayah',
        'pekerjaan_ayah',
        'penghasilan_bulanan_ayah',
//            Data Ibu
        'nama_ibu',
        'nik_ibu',
        'tahun_lahir_ibu',
        'pendidikan_ibu',
        'pekerjaan_ibu',
        'penghasilan_bulanan_ibu',
//            Data Wali
        'nama_wali',
        'nik_wali',
        'tahun_lahir_wali',
        'pendidikan_wali',
        'pekerjaan_wali',
        'penghasilan_bulanan_wali' ,
//            Kontak
        'no_telp_rumah',
        'no_hp',
        'email',
//            Data Periodik
        'tinggi_badan',
        'berat_badan',
        'lingkar_kepala' ,
        'jarak_tempat_tinggal_ke_sekolah',
        'kilometer',
        'waktu_tempuh_ke_sekolah_jam',
        'waktu_tempuh_ke_sekolah_menit',
        'jumlah_saudara_kandung',
//            Data Prestasi
        'jenis_prestasi',
        'tingkat',
        'nama_prestasi',
        'tahun',
        'penyelenggara',
//            Registrasi Peserta Didik
        'asal_sekolah',
        'asal_sekolah_sd',
        'no_peserta_ujian',
        'no_seri_ijazah',
        'no_seri_skhus',
        'status',
        'foto_siswa',
        'jurusan_id',
        'cohort_id',
        'gelombang',
        'created_by',
        'status_input'
    ];

    public function jurusan(){
        return $this->belongsTo(Jurusan::class);
    }

    public function mappingSiswa()
    {
        return $this->hasMany(MappingSiswa::class);
    }

    public function homevisit()
    {
        return $this->hasMany(HomeVisit::class);
    }

    public function nilai_pengetahuan()
    {
        return $this->hasMany(NilaiPengetahuan::class);
    }

    public function nilai_keterampilan()
    {
        return $this->hasMany(NilaiPengetahuan::class);
    }

    public function nilai_pts()
    {
        return $this->hasMany(NilaiPts::class);
    }

    public function nilai_pas()
    {
        return $this->hasMany(NilaiPas::class);
    }
    public function absen()
    {
        return $this->hasMany(Absen::class);
    }
    public function nilai_ekskul()
    {
        return $this->hasMany(NilaiEkstrakulikuler::class);
    }
    public function catatan()
    {
        return $this->hasMany(Catatan::class);
    }
    public function prestasi()
    {
        return $this->hasMany(NilaiPrestasi::class);
    }
    public function prakerin()
    {
        return $this->hasMany(NilaiPrakerin::class);
    }

    public function nilaisikapsosial()
    {
        return $this->hasMany(NilaiSikapSosial::class);
    }
    public function nilaisikapspiritual()
    {
        return $this->hasMany(NilaiSikapSpiritual::class);
    }

    // Model
    protected static function booted(): void
    {
        static::creating(function (Siswa $model) {
            $model->uuid = Str::uuid()->toString();
            $model->created_by = auth()->user()->id ?? 'System';
        });
    }

    public function user(): MorphOne
    {
        return $this->morphOne(User::class, 'model');
    }

    public function syncedAttributes(): array
    {
        return [
            'email' => 'email',
            'name' => 'nama_siswa'
        ];
    }

    public function cohort(): BelongsTo
    {
        return $this->belongsTo(Cohort::class);
    }

    public function document()
    {
        return $this->morphMany(Document::class, 'owner');
    }

    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

}
