<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class NilaiPts extends Model
{
    use HasFactory;
    protected $table = 'nilai_pts';
    protected $fillable = ['tahun_ajaran_id','mapping_guru_id', 'siswa_id','nilai','jenis'];
    protected const jenis_kd = ['PTS1','PTS2'];

    public function tahunAjaran()
    {
        return $this->belongsTo(TahunAjaran::class);
    }
    public function mapping_guru()
    {
        return $this->belongsTo(MappingGuru::class);
    }
    public function siswa()
    {
        return $this->belongsTo(Siswa::class);
    }
}
