<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class NilaiPrakerin extends Model
{
    use HasFactory;
    protected $table = 'nilai_prakerin';
    protected $fillable = ['tahun_ajaran_id','mapping_walikelas_id','kelas_id','siswa_id','nama_perusahaan','nilai','predikat','semester'];

    public function tahunAjaran()
    {
        return $this->belongsTo(TahunAjaran::class);
    }
    public function mapping_walikelas()
    {
        return $this->belongsTo(MappingWaliKelas::class);
    }
    public function siswa()
    {
        return $this->belongsTo(Siswa::class);
    }
    public function kelas()
    {
        return $this->belongsTo(Kelas::class);
    }
}
