<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class NilaiPengetahuan extends Model
{
    use HasFactory;
    protected $table = 'nilai_pengetahuan';
    protected $fillable = ['kd_id','tahun_ajaran_id','mapping_guru_id', 'siswa_id','nilai'];

    public function tahunAjaran()
    {
        return $this->belongsTo(TahunAjaran::class);
    }
    public function kd()
    {
        return $this->belongsTo(ListKd::class);
    }
    public function mapping_guru()
    {
        return $this->belongsTo(MappingGuru::class);
    }
    public function siswa()
    {
        return $this->belongsTo(Siswa::class);
    }
}
