<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MasterKd extends Model
{
    use HasFactory;
    protected $table = 'master_kd';
    protected $fillable = ['tahun_ajaran_id','mapel_id','kode_kd','nama_kd','keterangan','jenis_kd'];
    protected const jenis_kd = ['pengetahuan','keterampilan'];

    public function tahunAjaran()
    {
        return $this->belongsTo(TahunAjaran::class);
    }
    public function mapel()
    {
        return $this->belongsTo(Mapel::class);
    }
}
