<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class MappingSiswa extends Model
{
    use HasFactory;

    protected $table = 'mapping_siswa';

    protected $fillable = ['siswa_id','kelas_id','tahun_ajaran_id'];

    public function siswa()
    {
        return $this->belongsTo(Siswa::class);
    }
    public function kelas()
    {
        return $this->belongsTo(Kelas::class);
    }
    public function tahunAjaran()
    {
        return $this->belongsTo(TahunAjaran::class);
    }

    // Model
    protected static function booted(): void
    {
        static::creating(function (MappingSiswa $model) {
            $model->uuid = Str::uuid()->toString();
        });
    }

}
