<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;


class Mapel extends Model
{
    use HasFactory;

    protected $fillable = ['kelompok', 'jurusan', 'tingkat', 'kode_mapel', 'nama_mapel'];

    public function master_kd()
    {
        return $this->hasMany(MasterKd::class);
    }

    // Model
    protected static function booted(): void
    {
        static::creating(function (Mapel $model) {
            $model->uuid = Str::uuid()->toString();
        });
    }
}
