<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ListKd extends Model
{
    use HasFactory;
    protected $table = 'list_kd';
    protected $fillable = ['guru_id','tahun_ajaran_id','mapel_id','kode_kd','nama_kd','jenis_kd', 'semester'];
    protected const jenis_kd = ['pengetahuan','keterampilan'];

    public function tahunAjaran()
    {
        return $this->belongsTo(TahunAjaran::class);
    }
    public function mapel()
    {
        return $this->belongsTo(Mapel::class);
    }
    public function guru()
    {
        return $this->belongsTo(Guru::class);
    }

    public function nilai_pengetahuan()
    {
        return $this->hasMany(NilaiPengetahuan::class);
    }
    public function nilai_keterampilan()
    {
        return $this->hasMany(NilaiPengetahuan::class);
    }
}
