<?php

namespace App\Models;

use Filament\Notifications\Notification;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class Jurusan extends Model
{
    use HasFactory;
    protected $table = 'jurusan';
    protected $fillable = ['nama_jurusan','kode_jurusan','deskripsi'];

    public function siswa()
    {
        return $this->hasMany(Siswa::class);
    }

    protected static function booted(): void
    {
        static::creating(function (Jurusan $model) {
            $model->uuid = Str::uuid()->toString();
        });

        static::created(function (Jurusan $model) {
            Notification::make()
                ->title('Jurusan '. $model->nama_jurusan.' telah ditambahkan oleh '.@auth()->user()->name)
                ->sendToDatabase(User::role(['superadmin', 'admin'])->get());
        });

        static::updated(function (Jurusan $model) {
            Notification::make()
                ->title('Jurusan '. $model->nama_jurusan.' telah diubah oleh '.@auth()->user()->name)
                ->sendToDatabase(User::role(['superadmin', 'admin'])->get());
        });

        static::deleted(function (Jurusan $model) {
            Notification::make()
                ->title('Jurusan '. $model->nama_jurusan.' telah dihapus oleh '.@auth()->user()->name)
                ->sendToDatabase(User::role(['superadmin', 'admin'])->get());
        });
    }
}
