<?php

namespace App\Http\Livewire;

use App\Models\User;
use Mediconesystems\LivewireDatatables\Column;
use Mediconesystems\LivewireDatatables\DateColumn;
use Mediconesystems\LivewireDatatables\NumberColumn;
use Mediconesystems\LivewireDatatables\Http\Livewire\LivewireDatatable;

class UsersTable extends LivewireDatatable
{
    public $model = User::class;

    public function columns()
    {
        return [
            Column::index($this),
            Column::name('name')->searchable(),
            Column::name('email')->searchable(),
            Column::callback(['id', 'name'], function ($id, $name) {
                return view('user.table-actions', ['id' => $id, 'name' => $name]);
            })->unsortable()
        ];
    }
}
