<?php

namespace App\Http\Livewire;

use App\Models\RateNilai;
use App\Models\User;
use Mediconesystems\LivewireDatatables\Column;
use Mediconesystems\LivewireDatatables\NumberColumn;
use Mediconesystems\LivewireDatatables\Http\Livewire\LivewireDatatable;

class RateNilaiTable extends LivewireDatatable
{
    public $model = RateNilai::class;

    public function columns()
    {
        return [
            Column::index($this),
            Column::name('name')
                ->searchable(),
            Column::name('kode')
                ->searchable(),
            NumberColumn::name('rate_nilai_harian')
                ->editable()
                ->alignCenter()
                ->label('Rate Nilai Harian (%)')
                ->searchable(),
            NumberColumn::name('rate_pts')
                ->editable()
                ->alignCenter()
                ->label('Rate STS/PTS (%)')
                ->searchable(),
            NumberColumn::name('rate_pas')
                ->editable()
                ->alignCenter()
                ->label('Rate PAS/PAT (%)')
                ->searchable(),
            NumberColumn::name('total')
                ->editable()
                ->alignCenter()
                ->label('Total Rasio (%)')
                ->searchable(),
        ];
    }
}
