<?php

namespace App\Http\Livewire;

use App\Models\MappingWaliKelas;
use App\Models\NilaiPrestasi;
use Illuminate\Support\Facades\Auth;
use Mediconesystems\LivewireDatatables\Column;
use Mediconesystems\LivewireDatatables\Http\Livewire\LivewireDatatable;

class PrestasiTable extends LivewireDatatable
{
    public $model = NilaiPrestasi::class;
    public function builder()
    {
        $kelas = MappingWaliKelas::where('guru_id',Auth::user()->model_id)->first();
        return NilaiPrestasi::where('kelas_id',$kelas->kelas_id);
    }

    public function columns()
    {
        return [
            Column::index($this),
            Column::name('siswa.nama_siswa')
                ->searchable()
                ->defaultSort('asc'),
            Column::name('jenis')
                ->searchable(),
            Column::name('keterangan')
                ->searchable(),
            Column::callback(['id'], function ($id) {
                return view('prestasi.table-actions', ['id' => $id]);
            })->unsortable()
        ];
    }
}
