<?php

namespace App\Http\Livewire;

use App\Models\MasterNilaiSikap;
use Mediconesystems\LivewireDatatables\Column;
use Mediconesystems\LivewireDatatables\Http\Livewire\LivewireDatatable;

class MasterNilaiTable extends LivewireDatatable
{
    public $model = MasterNilaiSikap::class;

    public function columns()
    {
        return [
            Column::index($this),
            Column::name('kode')
                ->searchable()
                ->defaultSort('asc'),
            Column::name('nama')
                ->searchable(),
            Column::name('jenis')
                ->searchable(),
            Column::callback(['id'], function ($id) {
                return view('master-nilai-sikap.table-actions', ['id' => $id]);
            })->unsortable()
        ];
    }
}
