<?php

namespace App\Http\Livewire;

use App\Models\MappingSiswa;
use App\Models\MappingWaliKelas;
use App\Models\TahunAjaran;
use Mediconesystems\LivewireDatatables\Column;
use Mediconesystems\LivewireDatatables\Http\Livewire\LivewireDatatable;

class ListSiswaTable extends LivewireDatatable
{
    public $model = MappingSiswa::class;

    public function builder()
    {
        $activeTahunAjaran = TahunAjaran::where('is_active', true)->first();
        $currentWaliKelas = MappingWaliKelas::where('tahun_ajaran_id', $activeTahunAjaran->id)
            ->where('guru_id', auth()->user()->model_id)
            ->first();
        return MappingSiswa::where('kelas_id', $currentWaliKelas->kelas_id)
            ->where('tahun_ajaran_id', $activeTahunAjaran->id);
    }

    public function columns()
    {
        return [
            Column::index($this),
            Column::name('siswa.nama_siswa')
                ->searchable()
                ->defaultSort('asc'),
            Column::name('kelas.nama_kelas')
                ->searchable(),
            Column::callback(['id'], function ($id) {
                return view('list-siswa.table-actions', ['id' => $id]);
            })->unsortable()
        ];
    }
}
