<?php

namespace App\Http\Livewire;

use App\Models\MasterEkskul;
use Mediconesystems\LivewireDatatables\Column;
use Mediconesystems\LivewireDatatables\Http\Livewire\LivewireDatatable;

class EkskulTable extends LivewireDatatable
{
    public $model = MasterEkskul::class;

    public function columns()
    {
        return [
            Column::index($this),
            Column::name('nama_ekskul')
                ->searchable()
                ->defaultSort('asc'),
            Column::name('deskripsi')
                ->searchable(),
            Column::callback(['id'], function ($id) {
                return view('master-ekskul.table-actions', ['id' => $id]);
            })->unsortable()
        ];
    }
}
