<?php

namespace App\Http\Controllers;

use App\DataTables\UsersDataTable;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class UserController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $user = User::all();
        return view('user.index', compact('user'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('user.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string',
            'email' => 'required|email|unique:users,email',
            'password' => 'required|min:8'
        ]);

        $data = new User;
        $data->name = $request->name;
        $data->email = $request->email;
        $data->password = Hash::make($request->password);
        $data->save();

        return redirect()->route('user.index')->with('sukses', 'Berhasil Menambahkan Data');

    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        $user = User::find($id);
        return view('user.show', compact('user'));
    }

    public function impersonate(string $id)
    {
        $targetUser = User::find($id);
        $impersonate = Auth::user()->impersonate($targetUser);
        clock($impersonate);
        return redirect()->route('index')->with('impersonate', "Anda telah login sebagai $targetUser->name");
    }

    public function leaveImpersonate()
    {
        $impersonate = Auth::user();
        $leaveImpersonate = Auth::user()->leaveImpersonation();
        clock($leaveImpersonate);
        return redirect()->route('user.index')->with('impersonate', "Anda telah keluar dari akun $impersonate->name");
    }
}
