<?php

namespace App\Http\Controllers;

use App\Models\Kelas;
use App\Models\ListKd;
use App\Models\MappingGuru;
use App\Models\MappingSiswa;
use App\Models\NilaiKeterampilan;
use App\Models\NilaiPas;
use App\Models\NilaiPengetahuan;
use App\Models\NilaiPts;
use App\Models\RateNilai;
use App\Models\Semester;
use App\Models\TahunAjaran;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class RekapNilaiController extends Controller
{
    public function index(Request $request)
    {
        $reqmapel = $request->mapel;
        $reqkelas = $request->kelas;
        $tahun_ajaran = TahunAjaran::where('is_active',1)->first();
        $mapel = MappingGuru::select('mapel_id','tahun_ajaran_id')->distinct('mapel_id','tahun_ajaran_id')->where('guru_id',Auth::user()->model_id)->where('tahun_ajaran_id', $tahun_ajaran->id)->get();
        $kelas = MappingGuru::where('guru_id',Auth::user()->model_id)->where('mapel_id',$reqmapel)->where('tahun_ajaran_id', $tahun_ajaran->id)->get();
        $reqmappingguru = MappingGuru::where('guru_id',Auth::user()->model_id)->where('mapel_id',$reqmapel)->where('kelas_id',$reqkelas)->where('tahun_ajaran_id', $tahun_ajaran->id)->first();
        $activeSemester = Semester::where('is_active', true)->first();

        $kdp = ListKd::where('mapel_id',$reqmapel)
            ->where('guru_id',Auth::user()->model_id)
            ->where('jenis_kd','pengetahuan')
            ->where('tingkat',@$reqmappingguru->kelas->tingkatan->kode_tingkatan)
            ->where('tahun_ajaran_id', $tahun_ajaran->id)
            ->where('semester', $activeSemester->kode)
            ->get();

        $kdk = ListKd::where('mapel_id',$reqmapel)
            ->where('guru_id',Auth::user()->model_id)
            ->where('jenis_kd','keterampilan')
            ->where('tingkat',@$reqmappingguru->kelas->tingkatan->kode_tingkatan)
            ->where('tahun_ajaran_id', $tahun_ajaran->id)
            ->where('semester', $activeSemester->kode)
            ->get();

        $mapping_siswa = MappingSiswa::where('kelas_id',$reqkelas)->where('tahun_ajaran_id', $tahun_ajaran->id)->get();

        $rasio = RateNilai::where('is_active', 1)
                ->first();

        $data = [];
        if (isset($reqkelas)) {
            $getNilaiP = NilaiPengetahuan::whereIn('kd_id', $kdp->pluck('id')->toArray())
            ->where('mapping_guru_id', $reqmappingguru->id)
            ->where('tahun_ajaran_id', $tahun_ajaran->id)
            ->where('kelas_id', $reqkelas)
            ->get();

            $getNilaiK = NilaiKeterampilan::whereIn('kd_id', $kdk->pluck('id')->toArray())
            ->where('mapping_guru_id', $reqmappingguru->id)
            ->where('tahun_ajaran_id', $tahun_ajaran->id)
            ->where('kelas_id', $reqkelas)
            ->get();

            $getNilaiPts = NilaiPts::where('mapping_guru_id', $reqmappingguru->id)
                ->where('tahun_ajaran_id', $tahun_ajaran->id)
                ->where('kelas_id', $reqkelas)
                ->where('semester', $activeSemester->kode)
                ->get();

            $getNilaiPas = NilaiPas::where('mapping_guru_id', $reqmappingguru->id)
                ->where('tahun_ajaran_id', $tahun_ajaran->id)
                ->where('kelas_id', $reqkelas)
                ->where('semester', $activeSemester->kode)
                ->get();


                foreach($getNilaiPts as $key => $value){
                    $siswaId = $value->siswa_id;
                    $data[$value->siswa_id]['nilai']['pts'] = $value->nilai;
                }

                foreach($getNilaiPas as $key => $value){
                    $siswaId = $value->siswa_id;
                    $data[$value->siswa_id]['nilai']['pas'] = $value->nilai;
                }

                foreach($getNilaiP as $key => $value){
                    $siswaId = $value->siswa_id;
                    $data[$value->siswa_id] = [
                        'nama_siswa' => $value->siswa->nama_siswa,
                        'nilai' => []
                    ];

                    $test = collect($getNilaiP)->groupBy('kd_id');
                    $arrayAllKd = [];
                    foreach($kdp->pluck('id')->toArray() as $kdId){
                        $arrayAllKd[$kdId][] = '';
                    }

                    foreach ($arrayAllKd as $key => &$v1) {
                        if (!isset($test[$key])) {
                            $test->put($key, '');
                        }
                    }

                    foreach($test as $k => $val){
                        $data[$siswaId]['nama_siswa'] = $value->siswa->nama_siswa;
                        $namaKd = ListKd::find($k)->kode_kd;
                        if(is_iterable($val)){
                            foreach($val as $n => $nv){
                                if((int)$siswaId === (int)$nv->siswa_id){
                                    $data[$siswaId]['nilai']['pengetahuan'][$namaKd] = $nv->nilai;
                                }
                            }
                        } else {
                            $data[$siswaId]['nilai']['pengetahuan'][$namaKd] = null;
                        }
                    }

                    // Set nilai PTS
                    foreach($getNilaiPts as $k1 => $v1){
                        if((int)$siswaId === (int)$v1->siswa_id){
                            $data[$siswaId]['nilai']['pts'] = $v1->nilai;
                        }
                    }

                    foreach($getNilaiPas as $k1 => $v1){
                        if((int)$siswaId === (int)$v1->siswa_id){
                            $data[$siswaId]['nilai']['pas'] = $v1->nilai;
                        }
                    }

                    $total = 0;
                    $avg = 0;
                    foreach($data[$siswaId]['nilai']['pengetahuan'] as $n){
                        $total += $n;
                        $avg = number_format($total / count($kdp), 0);
                    }

                     // Set rata-rata pengetahuan & count with ratio
                    $countedNilaiPengetahuan = ($avg * $rasio->rate_nilai_harian) / 100;
                    $countedNilaiPts = isset($data[$siswaId]['nilai']['pts']) ? ($data[$siswaId]['nilai']['pts'] * $rasio->rate_pts ) / 100 : 0;
                    $countedNilaiPas = isset($data[$siswaId]['nilai']['pas']) ? ($data[$siswaId]['nilai']['pas'] * $rasio->rate_pas ) / 100 : 0;
                    $data[$siswaId]['nilai']['rataRataPengetahuan'] = number_format($countedNilaiPengetahuan + $countedNilaiPts + $countedNilaiPas, 0);
                }

                foreach($getNilaiK as $key => $value){
                    $siswaId = $value->siswa_id;

                    $test = collect($getNilaiK)->groupBy('kd_id');
                    $arrayAllKd = [];
                    foreach($kdk->pluck('id')->toArray() as $kdId){
                        $arrayAllKd[$kdId][] = '';
                    }

                    foreach ($arrayAllKd as $key => &$v1) {
                        if (!isset($test[$key])) {
                            $test->put($key, '');
                        }
                    }

                    foreach($test as $k => $val){
                        $data[$siswaId]['nama_siswa'] = $value->siswa->nama_siswa;
                        $namaKd = ListKd::find($k)->kode_kd;
                        if(is_iterable($val)){
                            foreach($val as $n => $nv){
                                if((int)$siswaId === (int)$nv->siswa_id){
                                    $data[$siswaId]['nilai']['keterampilan'][$namaKd] = $nv->nilai;
                                }
                            }
                        } else {
                            $data[$siswaId]['nilai']['keterampilan'][$namaKd] = null;
                        }
                    }

                    // Set nilai PTS
                    foreach($getNilaiPts as $k1 => $v1){
                        if((int)$siswaId === (int)$v1->siswa_id){
                            $data[$siswaId]['nilai']['pts'] = $v1->nilai;
                        }
                    }
                    foreach($getNilaiPas as $k1 => $v1){
                        if((int)$siswaId === (int)$v1->siswa_id){
                            $data[$siswaId]['nilai']['pas'] = $v1->nilai;
                        }
                    }

                    $total = 0;
                    $avg = 0;
                    foreach($data[$siswaId]['nilai']['keterampilan'] as $n){
                        $total += $n;
                        $avg = number_format($total / count($kdk), 0);
                    }

                     // Set rata-rata pengetahuan & count with ratio
                    $countedNilaiKeterampilan = ($avg * $rasio->rate_nilai_harian) / 100;
                    $countedNilaiPts = isset($data[$siswaId]['nilai']['pts']) ? ($data[$siswaId]['nilai']['pts'] * $rasio->rate_pts ) / 100 : 0;
                    $countedNilaiPas = isset($data[$siswaId]['nilai']['pas']) ? ($data[$siswaId]['nilai']['pas'] * $rasio->rate_pas ) / 100 : 0;
                    $data[$siswaId]['nilai']['rataRataKeterampilan'] = number_format($countedNilaiKeterampilan + $countedNilaiPts + $countedNilaiPas, 0);
                    $rataRata = ($data[$siswaId]['nilai']['rataRataKeterampilan'] + $data[$siswaId]['nilai']['rataRataPengetahuan']) / 2;
                    $data[$siswaId]['nilai']['rataRata'] = number_format($rataRata, 0);
                    
                }

            }

        return view('rekap-nilai.index', compact('reqkelas','mapel','reqmapel','kelas','kdp','kdk','mapping_siswa','rasio','data','reqmappingguru'));
    }
}
