<?php

namespace App\Http\Controllers;

use App\Models\MappingSiswa;
use App\Models\MappingWaliKelas;
use App\Models\MasterNilaiSikap;
use App\Models\NilaiSikapSosial;
use App\Models\NilaiSikapSpiritual;
use App\Models\TahunAjaran;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class NilaiSikapSpiritualController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $mapping_walikelas = MappingWaliKelas::where('guru_id',Auth::user()->model_id)->first();
        $tahun_ajaran = TahunAjaran::where('is_active',1)->first();
        $masterNilai = MasterNilaiSikap::where('jenis','Spiritual')->get();
        $mapping_siswa = MappingSiswa::where('kelas_id',$mapping_walikelas->kelas_id)->get();
        $nilaiSikapSpiritual = NilaiSikapSpiritual::where('kelas_id',$mapping_walikelas->kelas_id)->get();
        $nilaiSikapSpiritualSelalu = NilaiSikapSpiritual::where('kelas_id',$mapping_walikelas->kelas_id)->where('type','selalu')->get();
        $selalu1 = $nilaiSikapSpiritualSelalu->get(0);
        $selalu2 = $nilaiSikapSpiritualSelalu->get(1);
        return view('nilai-sikap-spiritual.index',compact('nilaiSikapSpiritual','mapping_siswa','mapping_walikelas','tahun_ajaran','masterNilai','selalu1','selalu2'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $tahun_ajaran = $request->tahun_ajaran_id;
        $mapping_walikelas = $request->mapping_walikelas_id;
        $kelas = $request->kelas_id;

        foreach ($request->siswa as $siswa_id => $siswaData) {
            $dataSelalu1 = $siswaData['selalu1'] ?? null;
            $dataSelalu2 = $siswaData['selalu2'] ?? null;
            $dataMulaiMeningkat = $siswaData['mulai_meningkat'] ?? null;

            if (isset($dataSelalu1) && isset($dataSelalu2) && isset($dataMulaiMeningkat)) {
                if ($dataSelalu1 == $dataSelalu2) {
                    // Ada data yang duplikat
                    return redirect()->back()->with('fail', 'Terdapat data duplikat');
                }
                if ($dataMulaiMeningkat == $dataSelalu1) {
                    // Ada data yang duplikat
                    return redirect()->back()->with('fail', 'Terdapat data duplikat');
                }
                if ($dataMulaiMeningkat == $dataSelalu2) {
                    // Ada data yang duplikat
                    return redirect()->back()->with('fail', 'Terdapat data duplikat');
                }
            }
        }

        NilaiSikapSpiritual::where('kelas_id',$kelas)->delete();
        foreach ($request->siswa as $siswa_id => $siswaData) {
            $dataSelalu1 = $siswaData['selalu1'] ?? null;
            $dataSelalu2 = $siswaData['selalu2'] ?? null;
            $dataMulaiMeningkat = $siswaData['mulai_meningkat'] ?? null;
            if ($dataSelalu1) {
                    $master_nilai_sikap_id = MasterNilaiSikap::where('kode', $dataSelalu1)->first();
                    if ($master_nilai_sikap_id) {
                        NilaiSikapSpiritual::updateOrCreate(
                            [
                                'siswa_id' => $siswa_id,
                                'tahun_ajaran_id' => $tahun_ajaran,
                                'mapping_walikelas_id' => $mapping_walikelas,
                                'kelas_id' => $kelas,
                                'semester' => \App\Models\Semester::where('is_active', true)->first()->kode,
                                'master_nilai_sikap_id' => $master_nilai_sikap_id->id,
                            ],
                            [
                                'type' => 'selalu',
                                'status' => true, // Ubah ke nilai yang ingin Anda atur untuk update
                            ]
                        );
                    }
                }

            if ($dataSelalu2) {
                    $master_nilai_sikap_id = MasterNilaiSikap::where('kode', $dataSelalu2)->first();
                    if ($master_nilai_sikap_id) {
                        NilaiSikapSpiritual::updateOrCreate(
                            [
                                'siswa_id' => $siswa_id,
                                'tahun_ajaran_id' => $tahun_ajaran,
                                'mapping_walikelas_id' => $mapping_walikelas,
                                'kelas_id' => $kelas,
                                'semester' => \App\Models\Semester::where('is_active', true)->first()->kode,
                                'master_nilai_sikap_id' => $master_nilai_sikap_id->id,
                            ],
                            [
                                'type' => 'selalu',
                                'status' => true, // Ubah ke nilai yang ingin Anda atur untuk update
                            ]
                        );
                    }
                }


            if ($dataMulaiMeningkat) {
                $master_nilai_sikap_id = MasterNilaiSikap::where('kode', $dataMulaiMeningkat)->first();
                if ($master_nilai_sikap_id) {
                    NilaiSikapSpiritual::updateOrCreate(
                        [
                            'siswa_id' => $siswa_id,
                            'tahun_ajaran_id' => $tahun_ajaran,
                            'mapping_walikelas_id' => $mapping_walikelas,
                            'kelas_id' => $kelas,
                            'semester' => \App\Models\Semester::where('is_active', true)->first()->kode,
                            'master_nilai_sikap_id' => $master_nilai_sikap_id->id,
                        ],
                        [
                            'type' => 'mulai_meningkat',
                            'status' => true, // Ubah ke nilai yang ingin Anda atur untuk update
                        ]
                    );
                }
            }
        }

        return redirect()->back()->with('sukses', 'Nilai berhasil disimpan');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
