<?php

namespace App\Http\Controllers;

use App\Exports\TemplateExport;
use App\Imports\NilaiImport;
use App\Models\Kelas;
use App\Models\ListKd;
use App\Models\MappingGuru;
use App\Models\MappingSiswa;
use App\Models\MasterKd;
use App\Models\NilaiKeterampilan;
use App\Models\NilaiPas;
use App\Models\NilaiPengetahuan;
use App\Models\NilaiPts;
use App\Models\RateNilai;
use App\Models\Semester;
use App\Models\Siswa;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Facades\Excel;

class NilaiPengetahuanController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $kelas = $request->kelas_id;
        $mapping_guru = $request->mapping_guru_id;
        $tahun_ajaran = $request->tahun_ajaran_id;
        $mapel = $request->mapel_id;
        $getGuruId = MappingGuru::find($mapping_guru);
        $kd_req = $request->kd_id;
        $kd = ListKd::where('mapel_id',$mapel)
            ->where('guru_id', $getGuruId->guru_id)
            ->where('jenis_kd','pengetahuan')
            ->where('tingkat',$getGuruId->kelas->tingkatan->kode_tingkatan)
            ->where('tahun_ajaran_id',$tahun_ajaran)
            ->get();
        $masterkd = MasterKd::where('mapel_id',$mapel)->where('jenis_kd','pengetahuan')->get();

        $mapping_siswa = MappingSiswa::join('siswa', 'mapping_siswa.siswa_id', '=', 'siswa.id')
        ->where('mapping_siswa.kelas_id', $kelas)
        ->where('mapping_siswa.tahun_ajaran_id', $getGuruId->tahunAjaran->id)
        ->select('mapping_siswa.*', 'siswa.nama_siswa')
        ->orderBy('siswa.nama_siswa', 'ASC')
        ->get();

        $nilai_pengetahuan = NilaiPengetahuan::where('kelas_id',$kelas)->where('kd_id',$kd_req)->get();
        return view('nilai-pengetahuan.index',compact('masterkd','mapel','nilai_pengetahuan','kd','kd_req','mapping_siswa','kelas','mapping_guru','tahun_ajaran','getGuruId'));
    }


    public function store(Request $request)
    {
        $request->validate([
            'tahun_ajaran_id' => 'required|integer',
            'mapping_guru_id' => 'required|integer',
            'kelas_id' => 'required|integer',
            'kd_id' => 'required|integer',
        ]);

        $kd = $request->kd_id;
        $tahun_ajaran = $request->tahun_ajaran_id;
        $mapping_guru = $request->mapping_guru_id;
        $kelas = $request->kelas_id;

        foreach ($request->siswa as $key => $value) {
            $nilaisiswa = implode(',', $value);

            $siswa = $key;
            $nilai = $nilaisiswa;

            NilaiPengetahuan::updateOrInsert(
                [
                    'siswa_id' => $siswa,
                    'kd_id' => $kd,
                    'tahun_ajaran_id' => $tahun_ajaran,
                    'mapping_guru_id' => $mapping_guru,
                    'kelas_id' => $kelas,
                    'semester' => \App\Models\Semester::where('is_active', true)->first()->kode,
                ],
                [
                    'nilai' => $nilai,
                ]
            );
        }


        return redirect()->back()->with('sukses','Nilai berhasil disimpan');
    }

    /**
     * Display the specified resource.
     */
    public function show(Request $request)
    {
        // Params
        $kelas = $request->kelas_id;
        $mapping_guru = $request->mapping_guru_id;
        $tahun_ajaran = $request->tahun_ajaran_id;
        $mapel = $request->mapel_id;
        $tingkat = $request->tingkat;
        $activeSemester = Semester::where('is_active', true)->first();

        $kd = ListKd::where('mapel_id',$mapel)
            ->where('guru_id',Auth::user()->model_id)
            ->where('jenis_kd','pengetahuan')
            ->where('tingkat',$tingkat)
            ->where('tahun_ajaran_id', $tahun_ajaran)
            ->where('semester', $activeSemester->kode)
            ->get();

        $mapping_siswa = MappingSiswa::join('siswa', 'mapping_siswa.siswa_id', '=', 'siswa.id')
            ->where('mapping_siswa.kelas_id', $kelas)
            ->where('mapping_siswa.tahun_ajaran_id', $tahun_ajaran)
            ->select('mapping_siswa.*', 'siswa.nama_siswa')
            ->orderBy('siswa.nama_siswa', 'ASC')
            ->get();

        $data = [];
        $getNilai = NilaiPengetahuan::join('siswa', 'nilai_pengetahuan.siswa_id', '=', 'siswa.id')
            ->whereIn('kd_id', $kd->pluck('id')->toArray())
            ->where('mapping_guru_id', $mapping_guru)
            ->where('tahun_ajaran_id', $tahun_ajaran)
            ->where('semester', $activeSemester->kode)
            ->orderBy('siswa.nama_siswa', 'ASC')
            ->get();

        $getNilaiPts = NilaiPts::join('siswa', 'nilai_pts.siswa_id', '=', 'siswa.id')
            ->where('mapping_guru_id', $mapping_guru)
            ->where('tahun_ajaran_id', $tahun_ajaran)
            ->where('semester', $activeSemester->kode)
            ->orderBy('siswa.nama_siswa', 'ASC')
            ->get();

        $getNilaiPas = NilaiPas::join('siswa', 'nilai_pas.siswa_id', '=', 'siswa.id')
            ->where('mapping_guru_id', $mapping_guru)
            ->where('tahun_ajaran_id', $tahun_ajaran)
            ->where('semester', $activeSemester->kode)
            ->orderBy('siswa.nama_siswa', 'ASC')
            ->get();

        $rasio = RateNilai::where('is_active', 1)
            ->first();

        foreach($getNilaiPts as $key => $value){
            $siswaId = $value->siswa_id;
            $data[$value->siswa_id]['nilai']['pts'] = $value->nilai;
        }

        foreach($getNilaiPas as $key => $value){
            $siswaId = $value->siswa_id;
            $data[$value->siswa_id]['nilai']['pas'] = $value->nilai;
        }

        foreach($getNilai as $key => $value){
            $siswaId = $value->siswa_id;
            $data[$value->siswa_id] = [
                'nama_siswa' => $value->siswa->nama_siswa,
                'nilai' => []
            ];

            $test = collect($getNilai)->groupBy('kd_id');
            $arrayAllKd = [];
            foreach($kd->pluck('id')->toArray() as $kdId){
                $arrayAllKd[$kdId][] = '';
            }

            foreach ($arrayAllKd as $key => &$v1) {
                if (!isset($test[$key])) {
                    $test->put($key, '');
                }
            }

            foreach($test as $k => $val){
                $data[$siswaId]['nama_siswa'] = $value->siswa->nama_siswa;
                $namaKd = ListKd::find($k)->kode_kd;
                if(is_iterable($val)){
                    foreach($val as $n => $nv){
                        if((int)$siswaId === (int)$nv->siswa_id){
                            $data[$siswaId]['nilai']['pengetahuan'][$namaKd] = $nv->nilai;
                        }
                    }
                } else {
                    $data[$siswaId]['nilai']['pengetahuan'][$namaKd] = null;
                }
            }

            // Set nilai PTS
            foreach($getNilaiPts as $k1 => $v1){
                if((int)$siswaId === (int)$v1->siswa_id){
                    $data[$siswaId]['nilai']['pts'] = $v1->nilai;
                }
            }

            foreach($getNilaiPas as $k1 => $v1){
                if((int)$siswaId === (int)$v1->siswa_id){
                    $data[$siswaId]['nilai']['pas'] = $v1->nilai;
                }
            }

            $total = 0;
            $avg = 0;
            foreach($data[$siswaId]['nilai']['pengetahuan'] as $n){
                $total += $n;
                $avg = number_format($total / count($kd), 0);
            }

            // Set rata-rata pengetahuan & count with ratio
            $countedNilaiPengetahuan = ($avg * $rasio->rate_nilai_harian) / 100;
            $countedNilaiPts = isset($data[$siswaId]['nilai']['pts'])? ($data[$siswaId]['nilai']['pts'] * $rasio->rate_pts ) / 100 : 0;
            $countedNilaiPas = isset($data[$siswaId]['nilai']['pas'])? ($data[$siswaId]['nilai']['pas'] * $rasio->rate_pas ) / 100 : 0;
            $data[$siswaId]['nilai']['rataRata'] = number_format($countedNilaiPengetahuan + $countedNilaiPts + $countedNilaiPas, 0);
        }

        return view('nilai-pengetahuan.show',compact('mapping_siswa','mapel','kd','kelas','mapping_guru','tahun_ajaran', 'data', 'rasio'));
    }

    public function import(Request $request)
    {
        $data = Excel::toCollection(new NilaiImport, $request->file('file'));
        try {
            DB::beginTransaction();
            foreach($data[0] as $key => $value){
                // Skip header
                if(!is_string($value[0])){
                    $siswa = Siswa::where('nama_siswa', $value[1])
                        ->whereHas('mappingSiswa', function($query) use ($request){
                            return $query->where('kelas_id', $request->kelas_id)
                            ->where('tahun_ajaran_id', $request->tahun_ajaran_id);
                        })
                        ->first();

                    if($siswa == null){
                        throw new \Exception('Terdapat siswa yang tidak sesuai dengan kelas yang dipilih!');
                    }

                    $nilai = (int) number_format($value[2], 0);

                    if($nilai < 0 || $nilai > 100){
                        throw new \Exception('Nilai harus diantara rentang 0 sampai dengan 100');
                    }

                    if($siswa !== null){
                        NilaiPengetahuan::updateOrInsert(
                            [
                                'siswa_id' => $siswa->id,
                                'kd_id' => $request->kd_id,
                                'tahun_ajaran_id' => $request->tahun_ajaran_id,
                                'mapping_guru_id' => $request->mapping_guru_id,
                                'kelas_id' => $request->kelas_id,
                                'semester' => \App\Models\Semester::where('is_active', true)->first()->kode,
                            ],
                            [
                                'nilai' => $nilai,
                            ]
                        );
                    }
                }
            }
            DB::commit();

        } catch(\Exception $e){
            DB::rollBack();
            return redirect()->back()->with('fail', 'Terdapat kesalahan! '.$e->getMessage());
        }
        return redirect()->back()->with('sukses','Nilai berhasil diimport!');
    }

    public function downloadTemplate(Request $request)
    {
        $kelas = Kelas::find($request->kelas_id);
        $filename = "template_import_nilai_$kelas->kode_kelas.xlsx";

        return Excel::download(new TemplateExport, $filename);
    }
}
