<?php

namespace App\Http\Controllers;

use App\Models\Kelas;
use App\Models\MappingSiswa;
use App\Models\MappingWaliKelas;
use App\Models\Siswa;
use App\Models\TahunAjaran;
use App\Models\Tingkatan;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ListSiswaController extends Controller
{
    public function index()
    {
        $tahun_ajaran = TahunAjaran::where('is_active',1)->first();
        $mappingWaliKelas = MappingWaliKelas::where('guru_id',Auth::user()->model_id)->where('tahun_ajaran_id',$tahun_ajaran->id)->first();
        $mappingSiswa = MappingSiswa::join('siswa', 'mapping_siswa.siswa_id', '=', 'siswa.id')
            ->where('mapping_siswa.kelas_id', $mappingWaliKelas->kelas->id)
            ->where('mapping_siswa.tahun_ajaran_id', $mappingWaliKelas->tahunAjaran->id)
            ->select('mapping_siswa.*', 'siswa.nama_siswa')
            ->orderBy('siswa.nama_siswa', 'ASC')
            ->get();
        $kelas= Kelas::where('id',$mappingWaliKelas->kelas_id)->first();

        return view('list-siswa.index',compact('mappingSiswa','mappingWaliKelas','kelas'));
    }
}

