<?php

namespace App\Http\Controllers;

use App\Exports\LeggerExport;
use App\Http\Services\LeggerService;
use App\Models\Kelas;
use App\Models\RateNilai;
use App\Models\Semester;
use App\Models\TahunAjaran;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;

class LeggerController extends Controller
{
    /**
     * Display a listing of the resource.
     */


    public function index(Request $request)
    {
        $kelas = Kelas::orderBy('nama_kelas','ASC')->get();
        $tahun_ajaran = TahunAjaran::all();
        $semester = Semester::all();
        $hasil = null;
        if(isset($request->kelas)){
            $req_tahunAjaran = TahunAjaran::where('id', $request->tahun_ajaran)->first();
            $req_semester = Semester::where('id', $request->semester)->first();
            $req_kelas = Kelas::where('id', $request->kelas)->first();
            $rateNilai = RateNilai::where('is_active', 1)->first();

            $legger = new LeggerService($req_tahunAjaran, $req_kelas, $req_semester, $rateNilai);
            $hasil = $legger->generate();
        }
        return view("legger.index",compact("kelas","tahun_ajaran","semester","hasil"));
    }

    public function export(Request $request)
    {

        $req_tahunAjaran = TahunAjaran::find($request->reqtahunAjaran);
        $req_semester = Semester::find($request->reqsemester);
        $req_kelas = Kelas::find($request->reqkelas);
        $rateNilai = RateNilai::where('is_active', 1)->first();


        $leggerService = new LeggerService($req_tahunAjaran, $req_kelas, $req_semester, $rateNilai);
        $hasil = $leggerService->generate();

        return Excel::download(new LeggerExport($hasil), 'legger.xlsx');
    }

}
