<?php

namespace App\Http\Controllers;

use App\Http\Services\LeggerService;
use App\Http\Services\NilaiService;
use App\Models\Kelas;
use App\Models\ListKd;
use App\Models\Mapel;
use App\Models\NilaiPas;
use App\Models\Absen;
use App\Models\Catatan;
use App\Models\MappingGuru;
use App\Models\MappingSiswa;
use App\Models\MappingWaliKelas;
use App\Models\NilaiEkstrakulikuler;
use App\Models\NilaiSikapSosial;
use App\Models\NilaiSikapSpiritual;
use App\Models\NilaiKeterampilan;
use App\Models\NilaiPengetahuan;
use App\Models\NilaiPrakerin;
use App\Models\NilaiPts;
use App\Models\RateNilai;
use App\Models\Semester;
use App\Models\TahunAjaran;
use App\Models\Tingkatan;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class CetakSampulRaport extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $tahun_ajaran = TahunAjaran::where('is_active',1)->first();
        $kelas = Kelas::orderBy('nama_kelas','ASC')->get();
        $mappingSiswa = MappingSiswa::join('siswa', 'mapping_siswa.siswa_id', '=', 'siswa.id')
        ->where('mapping_siswa.kelas_id', $request->kelas)
        ->where('mapping_siswa.tahun_ajaran_id', $tahun_ajaran->id)
        ->select('mapping_siswa.*', 'siswa.nama_siswa')
        ->orderBy('siswa.nama_siswa','ASC')
        ->get();

        $kelasterpilih = Kelas::where('id',$request->kelas)->first();
        return view('cetak-sampul-raport.index',compact('kelas','mappingSiswa','kelasterpilih'));
    }

    /**
     * Show the form for creating a new resource.\
     */
    public function sampul1($id)
    {
        $mappingSiswa = MappingSiswa::find($id);
        return view('cetak-sampul-raport.sampul1',compact('mappingSiswa'));
    }

    public function cetak1($id)
    {
        $mappingSiswa = MappingSiswa::find($id);
        return view('cetak-sampul-raport.sampul1',compact('mappingSiswa'));
    }

    public function showCetakPasMerdeka($id)
    {
        $a = "A. Muatan Nasional";
        $b = "B. Muatan Kewilayahan";
        $c1 = "C1. Bidang Dasar Keahlian";
        $c2ak = "C2. Dasar Program Keahlian AK";
        $c2bdp = "C2. Dasar Program Keahlian BDP";
        $c2rpl = "C2. Dasar Program Keahlian RPL";
        $c2oto = "C2. Dasar Program Keahlian Otomotif";
        $c3ak = "C3. Kompetensi Keahlian AK";
        $c3bdp = "C3. Kompetensi Keahlian BDP";
        $c3rpl = "C3. Kompetensi Keahlian RPL";
        $c3tbsm = "C3. Kompetensi Keahlian TBSM";
        $c3tkro = "C3. Kompetensi Keahlian TKRO";
        $c3all = "C3. KOMPETENSI KEAHLIAN SEMUA JURUSAN";
        $d = "D. Muatan Lokal";

        $mappingSiswa = MappingSiswa::find($id);
        $semester = Semester::where('is_active', true)->first()->kode;

        // KELOMPOK A. MUATAN NASIONAL
        $nilaiService = new NilaiService($mappingSiswa);
        $calculateNilaiA = $nilaiService->calculate($a, 'Semua');
        $nilaiA = $calculateNilaiA['calculatedNilai'];
        $mapelNilaiPA = $calculateNilaiA['listOfMapel'];

        // KELOMPOK A. MUATAN NASIONAL TINGKAT SEPULUH
        $calculateNilaiA10 = $nilaiService->calculate($a, 'Sepuluh');
        $nilaiA10 = $calculateNilaiA10['calculatedNilai'];
        $mapelNilaiPA10 = $calculateNilaiA10['listOfMapel'];

        // KELOMPOK B. MUATAN KEWILAYAHAN SEMUA TINGKAT
        $calculateNilaiB = $nilaiService->calculate($b, 'Semua');
        $nilaiB = $calculateNilaiB['calculatedNilai'];
        $mapelNilaiBP = $calculateNilaiB['listOfMapel'];

        // KELOMPOK B. MUATAN KEWILAYAHAN TINGKAT SEPULUH
        $calculateNilaiB10 = $nilaiService->calculate($b, 'Sepuluh');
        $nilaiB10 = $calculateNilaiB10['calculatedNilai'];
        $mapelNilaiBP10 = $calculateNilaiB10['listOfMapel'];

        // KELOMPOK C1. MUATAN KEAHLIAN SEPULUH
        $calculateNilaiC1 = $nilaiService->calculate($c1, 'Sepuluh');
        $nilaiC1 = $calculateNilaiC1['calculatedNilai'];
        $mapelNilaiCP1 = $calculateNilaiC1['listOfMapel'];

        // KELOMPOK C2. DASAR PROGRAM KEAHLIAN AK SEPULUH
        $calculateNilaiC2AK = $nilaiService->calculate($c2ak, 'Sepuluh');
        $nilaiC2AK = $calculateNilaiC2AK['calculatedNilai'];
        $mapelNilaiCP2AK = $calculateNilaiC2AK['listOfMapel'];

        // KELOMPOK C2. DASAR PROGRAM KEAHLIAN BDP SEPULUH
        $calculateNilaiC2BDP = $nilaiService->calculate($c2bdp, 'Sepuluh');
        $nilaiC2BDP = $calculateNilaiC2BDP['calculatedNilai'];
        $mapelNilaiCP2BDP = $calculateNilaiC2BDP['listOfMapel'];

        // KELOMPOK C2. DASAR PROGRAM KEAHLIAN RPL SEPULUH
        $calculateNilaiC2RPL = $nilaiService->calculate($c2rpl, 'Sepuluh');
        $nilaiC2RPL = $calculateNilaiC2RPL['calculatedNilai'];
        $mapelNilaiCP2RPL = $calculateNilaiC2RPL['listOfMapel'];

        // KELOMPOK C2. DASAR PROGRAM KEAHLIAN OTO SEPULUH
        $calculateNilaiC2OTO = $nilaiService->calculate($c2oto, 'Sepuluh');
        $nilaiC2OTO = $calculateNilaiC2OTO['calculatedNilai'];
        $mapelNilaiCP2OTO = $calculateNilaiC2OTO['listOfMapel'];

        // KELOMPOK C3. DASAR PROGRAM KEAHLIAN AK Sebelas
        $calculateNilaiC3AK = $nilaiService->calculate($c3ak, 'Sebelas');
        $nilaiC3AK = $calculateNilaiC3AK['calculatedNilai'];
        $mapelNilaiCP3AK = $calculateNilaiC3AK['listOfMapel'];

        // KELOMPOK C3. DASAR PROGRAM KEAHLIAN BDP Sebelas
        $calculateNilaiC3BDP = $nilaiService->calculate($c3bdp, 'Sebelas');
        $nilaiC3BDP = $calculateNilaiC3BDP['calculatedNilai'];
        $mapelNilaiCP3BDP = $calculateNilaiC3BDP['listOfMapel'];

        // KELOMPOK C3. DASAR PROGRAM KEAHLIAN RPL Sebelas
        $calculateNilaiC3RPL = $nilaiService->calculate($c3rpl, 'Sebelas');
        $nilaiC3RPL = $calculateNilaiC3RPL['calculatedNilai'];
        $mapelNilaiCP3RPL = $calculateNilaiC3RPL['listOfMapel'];

        // KELOMPOK C3. DASAR PROGRAM KEAHLIAN TBSM Sebelas
        $calculateNilaiC3TBSM = $nilaiService->calculate($c3tbsm, 'Sebelas');
        $nilaiC3TBSM = $calculateNilaiC3TBSM['calculatedNilai'];
        $mapelNilaiCP3TBSM = $calculateNilaiC3TBSM['listOfMapel'];

        // KELOMPOK C3. DASAR PROGRAM KEAHLIAN TKRO Sebelas
        $calculateNilaiC3TKRO = $nilaiService->calculate($c3tkro, 'Sebelas');
        $nilaiC3TKRO = $calculateNilaiC3TKRO['calculatedNilai'];
        $mapelNilaiCP3TKRO = $calculateNilaiC3TKRO['listOfMapel'];

        // KELOMPOK C3. DASAR PROGRAM KEAHLIAN AK Duabelas
        $calculateNilaiC3AK12 = $nilaiService->calculate($c3ak, 'Duabelas');
        $nilaiC3AK12 = $calculateNilaiC3AK12['calculatedNilai'];
        $mapelNilaiCP3AK12 = $calculateNilaiC3AK12['listOfMapel'];

        // KELOMPOK C3. DASAR PROGRAM KEAHLIAN BDP Duabelas
        $calculateNilaiC3BDP12 = $nilaiService->calculate($c3bdp, 'Duabelas');
        $nilaiC3BDP12 = $calculateNilaiC3BDP12['calculatedNilai'];
        $mapelNilaiCP3BDP12 = $calculateNilaiC3BDP12['listOfMapel'];

        // KELOMPOK C3. DASAR PROGRAM KEAHLIAN RPL Duabelas
        $calculateNilaiC3RPL12 = $nilaiService->calculate($c3rpl, 'Duabelas');
        $nilaiC3RPL12 = $calculateNilaiC3RPL12['calculatedNilai'];
        $mapelNilaiCP3RPL12 = $calculateNilaiC3RPL12['listOfMapel'];

        // KELOMPOK C3. DASAR PROGRAM KEAHLIAN TBSM Duabelas
        $calculateNilaiC3TBSM12 = $nilaiService->calculate($c3tbsm, 'Duabelas');
        $nilaiC3TBSM12 = $calculateNilaiC3TBSM12['calculatedNilai'];
        $mapelNilaiCP3TBSM12 = $calculateNilaiC3TBSM12['listOfMapel'];

        // KELOMPOK C3. DASAR PROGRAM KEAHLIAN TKRO Duabelas
        $calculateNilaiC3TKRO12 = $nilaiService->calculate($c3tkro, 'Duabelas');
        $nilaiC3TKRO12 = $calculateNilaiC3TKRO12['calculatedNilai'];
        $mapelNilaiCP3TKRO12 = $calculateNilaiC3TKRO12['listOfMapel'];

        // KELOMPOK C3. DASAR PROGRAM KEAHLIAN ALL Semua
        $calculateNilaiC3ALL = $nilaiService->calculate($c3all, 'Semua');
        $nilaiC3ALL = $calculateNilaiC3ALL['calculatedNilai'];
        $mapelNilaiCP3ALL = $calculateNilaiC3ALL['listOfMapel'];

        // KELOMPOK D. Muatan Kewilayahan Semua
        $calculateNilaiD = $nilaiService->calculate($d, 'Semua');
        $nilaiD = $calculateNilaiD['calculatedNilai'];
        $mapelNilaiDP = $calculateNilaiD['listOfMapel'];

        //End Pengetahuan
        $tahun_ajaran_id = TahunAjaran::where('is_active',1)->first();
        $mappingWaliKelas =MappingWaliKelas::where('kelas_id',$mappingSiswa->kelas_id)->where('tahun_ajaran_id',$mappingSiswa->tahun_ajaran_id)->first();
        $nilaiAbsensi = Absen::where('siswa_id',$mappingSiswa->siswa_id)->where('tahun_ajaran_id',$tahun_ajaran_id->id)->where('semester',$semester)->first();
        $nilaiEkskul = NilaiEkstrakulikuler::where('siswa_id',$mappingSiswa->siswa_id)->where('tahun_ajaran_id',$tahun_ajaran_id->id)->where('semester',$semester)->get();
        $catatan = Catatan::where('siswa_id',$mappingSiswa->siswa_id)->where('tahun_ajaran_id',$tahun_ajaran_id->id)->where('semester',$semester)->first();

        $curentDate = Carbon::now('Asia/Jakarta');
        $dateFormat = $curentDate->format('d F Y');

        $nilaiPrakerin = NilaiPrakerin::where('siswa_id',$mappingSiswa->siswa_id)->first();

        return view('cetak-sampul-raport.cetakPasMerdeka',compact('mappingSiswa','mapelNilaiPA','mapelNilaiPA10','mapelNilaiBP','mapelNilaiBP10','mapelNilaiCP1','mapelNilaiCP2AK','mapelNilaiCP2BDP','mapelNilaiCP2RPL','mapelNilaiCP2OTO','mapelNilaiCP3AK','mapelNilaiCP3BDP','mapelNilaiCP3RPL','mapelNilaiCP3TBSM','mapelNilaiCP3TKRO','mapelNilaiCP3ALL','mapelNilaiDP','mapelNilaiCP3AK12','mapelNilaiCP3BDP12','mapelNilaiCP3RPL12','mapelNilaiCP3TBSM12','mapelNilaiCP3TKRO12','mappingWaliKelas','nilaiA','nilaiA10','nilaiB','nilaiB10','nilaiC1','nilaiC2AK','nilaiC2BDP','nilaiC2RPL','nilaiC2OTO','nilaiC3AK','nilaiC3BDP','nilaiC3RPL','nilaiC3TBSM','nilaiC3TKRO','nilaiC3ALL','nilaiD','nilaiC3AK12','nilaiC3BDP12','nilaiC3RPL12','nilaiC3TBSM12','nilaiC3TKRO12','nilaiAbsensi','nilaiEkskul','catatan', 'semester', 'dateFormat',"nilaiPrakerin"));
    }

    // public function showCetakPasK13($id)
    // {
    //     $a = "A. Muatan Nasional";
    //     $b = "B. Muatan Kewilayahan";
    //     $c1 = "C1. Bidang Dasar Keahlian";
    //     $c2ak = "C2. Dasar Program Keahlian AK";
    //     $c2bdp = "C2. Dasar Program Keahlian BDP";
    //     $c2rpl = "C2. Dasar Program Keahlian RPL";
    //     $c2oto = "C2. Dasar Program Keahlian Otomotif";
    //     $c3ak = "C3. Kompetensi Keahlian AK";
    //     $c3bdp = "C3. Kompetensi Keahlian BDP";
    //     $c3rpl = "C3. Kompetensi Keahlian RPL";
    //     $c3tbsm = "C3. Kompetensi Keahlian TBSM";
    //     $c3tkro = "C3. Kompetensi Keahlian TKRO";
    //     $c3all = "C3. KOMPETENSI KEAHLIAN SEMUA JURUSAN";
    //     $d = "D. Muatan Lokal";

    //     $mappingSiswa = MappingSiswa::find($id);

    //     // KELOMPOK A. MUATAN NASIONAL
    //     $nilaiService = new NilaiService($mappingSiswa);
    //     $calculateNilaiA = $nilaiService->calculate($a, 'Semua');
    //     $nilaiA = $calculateNilaiA['calculatedNilai'];
    //     $mapelNilaiPA = $calculateNilaiA['listOfMapel'];

    //     // KELOMPOK A. MUATAN NASIONAL TINGKAT SEPULUH
    //     $calculateNilaiA10 = $nilaiService->calculate($a, 'Sepuluh');
    //     $nilaiA10 = $calculateNilaiA10['calculatedNilai'];
    //     $mapelNilaiPA10 = $calculateNilaiA10['listOfMapel'];

    //     // KELOMPOK B. MUATAN KEWILAYAHAN SEMUA TINGKAT
    //     $calculateNilaiB = $nilaiService->calculate($b, 'Semua');
    //     $nilaiB = $calculateNilaiB['calculatedNilai'];
    //     $mapelNilaiBP = $calculateNilaiB['listOfMapel'];

    //     // KELOMPOK B. MUATAN KEWILAYAHAN TINGKAT SEPULUH
    //     $calculateNilaiB10 = $nilaiService->calculate($b, 'Sepuluh');
    //     $nilaiB10 = $calculateNilaiB10['calculatedNilai'];
    //     $mapelNilaiBP10 = $calculateNilaiB10['listOfMapel'];

    //     // KELOMPOK C1. MUATAN KEAHLIAN SEPULUH
    //     $calculateNilaiC1 = $nilaiService->calculate($c1, 'Sepuluh');
    //     $nilaiC1 = $calculateNilaiC1['calculatedNilai'];
    //     $mapelNilaiCP1 = $calculateNilaiC1['listOfMapel'];

    //     // KELOMPOK C2. DASAR PROGRAM KEAHLIAN AK SEPULUH
    //     $calculateNilaiC2AK = $nilaiService->calculate($c2ak, 'Sepuluh');
    //     $nilaiC2AK = $calculateNilaiC2AK['calculatedNilai'];
    //     $mapelNilaiCP2AK = $calculateNilaiC2AK['listOfMapel'];

    //     // KELOMPOK C2. DASAR PROGRAM KEAHLIAN BDP SEPULUH
    //     $calculateNilaiC2BDP = $nilaiService->calculate($c2bdp, 'Sepuluh');
    //     $nilaiC2BDP = $calculateNilaiC2BDP['calculatedNilai'];
    //     $mapelNilaiCP2BDP = $calculateNilaiC2BDP['listOfMapel'];

    //     // KELOMPOK C2. DASAR PROGRAM KEAHLIAN RPL SEPULUH
    //     $calculateNilaiC2RPL = $nilaiService->calculate($c2rpl, 'Sepuluh');
    //     $nilaiC2RPL = $calculateNilaiC2RPL['calculatedNilai'];
    //     $mapelNilaiCP2RPL = $calculateNilaiC2RPL['listOfMapel'];

    //     // KELOMPOK C2. DASAR PROGRAM KEAHLIAN OTO SEPULUH
    //     $calculateNilaiC2OTO = $nilaiService->calculate($c2oto, 'Sepuluh');
    //     $nilaiC2OTO = $calculateNilaiC2OTO['calculatedNilai'];
    //     $mapelNilaiCP2OTO = $calculateNilaiC2OTO['listOfMapel'];

    //     // KELOMPOK C3. DASAR PROGRAM KEAHLIAN AK Sebelas
    //     $calculateNilaiC3AK = $nilaiService->calculate($c3ak, 'Sebelas');
    //     $nilaiC3AK = $calculateNilaiC3AK['calculatedNilai'];
    //     $mapelNilaiCP3AK = $calculateNilaiC3AK['listOfMapel'];

    //     // KELOMPOK C3. DASAR PROGRAM KEAHLIAN BDP Sebelas
    //     $calculateNilaiC3BDP = $nilaiService->calculate($c3bdp, 'Sebelas');
    //     $nilaiC3BDP = $calculateNilaiC3BDP['calculatedNilai'];
    //     $mapelNilaiCP3BDP = $calculateNilaiC3BDP['listOfMapel'];

    //     // KELOMPOK C3. DASAR PROGRAM KEAHLIAN RPL Sebelas
    //     $calculateNilaiC3RPL = $nilaiService->calculate($c3rpl, 'Sebelas');
    //     $nilaiC3RPL = $calculateNilaiC3RPL['calculatedNilai'];
    //     $mapelNilaiCP3RPL = $calculateNilaiC3RPL['listOfMapel'];

    //     // // KELOMPOK C3. DASAR PROGRAM KEAHLIAN RPL Sebelas
    //     // $calculateNilaiC3RPL11 = $nilaiService->calculate($c3rpl, 'Sebelas');
    //     // $nilaiC3RPL11 = $calculateNilaiC3RPL11['calculatedNilai'];
    //     // $mapelNilaiCP3RPL11 = $calculateNilaiC3RPL11['listOfMapel'];

    //     // KELOMPOK C3. DASAR PROGRAM KEAHLIAN TBSM Sebelas
    //     $calculateNilaiC3TBSM = $nilaiService->calculate($c3tbsm, 'Sebelas');
    //     $nilaiC3TBSM = $calculateNilaiC3TBSM['calculatedNilai'];
    //     $mapelNilaiCP3TBSM = $calculateNilaiC3TBSM['listOfMapel'];

    //     // KELOMPOK C3. DASAR PROGRAM KEAHLIAN TKRO Sebelas
    //     $calculateNilaiC3TKRO = $nilaiService->calculate($c3tkro, 'Sebelas');
    //     $nilaiC3TKRO = $calculateNilaiC3TKRO['calculatedNilai'];
    //     $mapelNilaiCP3TKRO = $calculateNilaiC3TKRO['listOfMapel'];

    //     // KELOMPOK C3. DASAR PROGRAM KEAHLIAN ALL Semua
    //     $calculateNilaiC3ALL = $nilaiService->calculate($c3all, 'Semua');
    //     $nilaiC3ALL = $calculateNilaiC3ALL['calculatedNilai'];
    //     $mapelNilaiCP3ALL = $calculateNilaiC3ALL['listOfMapel'];

    //     // KELOMPOK D. Muatan Kewilayahan Semua
    //     $calculateNilaiD = $nilaiService->calculate($d, 'Semua');
    //     $nilaiD = $calculateNilaiD['calculatedNilai'];
    //     $mapelNilaiDP = $calculateNilaiD['listOfMapel'];


    //     $mappingWaliKelas =MappingWaliKelas::where('kelas_id',$mappingSiswa->kelas_id)->first();
    //     $nilaiAbsensi = Absen::where('siswa_id',$mappingSiswa->siswa_id)->first();
    //     $nilaiEkskul = NilaiEkstrakulikuler::where('siswa_id',$mappingSiswa->siswa_id)->get();
    //     $catatan = Catatan::where('siswa_id',$mappingSiswa->siswa_id)->first();

    //     return view('cetak-sampul-raport.cetakPasK13',compact('mappingSiswa','mapelNilaiPA','mapelNilaiPA10','mapelNilaiBP','mapelNilaiBP10','mapelNilaiCP1','mapelNilaiCP2AK','mapelNilaiCP2BDP','mapelNilaiCP2RPL','mapelNilaiCP2OTO','mapelNilaiCP3AK','mapelNilaiCP3BDP','mapelNilaiCP3RPL','mapelNilaiCP3RPL11','mapelNilaiCP3TBSM','mapelNilaiCP3TKRO','mapelNilaiCP3ALL','mapelNilaiDP','mapelNilaiDP11','mappingWaliKelas','nilaiA','nilaiA10','nilaiB','nilaiB10','nilaiC1','nilaiC2AK','nilaiC2BDP','nilaiC2RPL','nilaiC2OTO','nilaiC3AK','nilaiC3BDP','nilaiC3RPL','nilaiC3RPL11','nilaiC3TBSM','nilaiC3TKRO','nilaiC3ALL','nilaiD','nilaiD11','nilaiAbsensi','nilaiEkskul','catatan'));
    // }

    public function show($id)
    {
        $a = "A. Muatan Nasional";
        $b = "B. Muatan Kewilayahan";
        $c1 = "C1. Bidang Dasar Keahlian";
        $c2ak = "C2. Dasar Program Keahlian AK";
        $c2bdp = "C2. Dasar Program Keahlian BDP";
        $c2rpl = "C2. Dasar Program Keahlian RPL";
        $c2oto = "C2. Dasar Program Keahlian Otomotif";
        $c3ak = "C3. Kompetensi Keahlian AK";
        $c3bdp = "C3. Kompetensi Keahlian BDP";
        $c3rpl = "C3. Kompetensi Keahlian RPL";
        $c3tbsm = "C3. Kompetensi Keahlian TBSM";
        $c3tkro = "C3. Kompetensi Keahlian TKRO";
        $c3all = "C3. KOMPETENSI KEAHLIAN SEMUA JURUSAN";
        $d = "D. Muatan Lokal";

        $mappingSiswa = MappingSiswa::find($id);
        $semester = Semester::where('is_active', true)->first()->kode;

        // KELOMPOK A. MUATAN NASIONAL
        $nilaiService = new NilaiService($mappingSiswa);
        $calculateNilaiA = $nilaiService->calculate($a, 'Semua');
        $nilaiA = $calculateNilaiA['calculatedNilai'];
        $mapelNilaiPA = $calculateNilaiA['listOfMapel'];

        // KELOMPOK A. MUATAN NASIONAL TINGKAT SEPULUH
        $calculateNilaiA10 = $nilaiService->calculate($a, 'Sepuluh');
        $nilaiA10 = $calculateNilaiA10['calculatedNilai'];
        $mapelNilaiPA10 = $calculateNilaiA10['listOfMapel'];

        // KELOMPOK B. MUATAN KEWILAYAHAN SEMUA TINGKAT
        $calculateNilaiB = $nilaiService->calculate($b, 'Semua');
        $nilaiB = $calculateNilaiB['calculatedNilai'];
        $mapelNilaiBP = $calculateNilaiB['listOfMapel'];

        // KELOMPOK B. MUATAN KEWILAYAHAN TINGKAT SEPULUH
        $calculateNilaiB10 = $nilaiService->calculate($b, 'Sepuluh');
        $nilaiB10 = $calculateNilaiB10['calculatedNilai'];
        $mapelNilaiBP10 = $calculateNilaiB10['listOfMapel'];

        // KELOMPOK C1. MUATAN KEAHLIAN SEPULUH
        $calculateNilaiC1 = $nilaiService->calculate($c1, 'Sepuluh');
        $nilaiC1 = $calculateNilaiC1['calculatedNilai'];
        $mapelNilaiCP1 = $calculateNilaiC1['listOfMapel'];

        // KELOMPOK C2. DASAR PROGRAM KEAHLIAN AK SEPULUH
        $calculateNilaiC2AK = $nilaiService->calculate($c2ak, 'Sepuluh');
        $nilaiC2AK = $calculateNilaiC2AK['calculatedNilai'];
        $mapelNilaiCP2AK = $calculateNilaiC2AK['listOfMapel'];

        // KELOMPOK C2. DASAR PROGRAM KEAHLIAN BDP SEPULUH
        $calculateNilaiC2BDP = $nilaiService->calculate($c2bdp, 'Sepuluh');
        $nilaiC2BDP = $calculateNilaiC2BDP['calculatedNilai'];
        $mapelNilaiCP2BDP = $calculateNilaiC2BDP['listOfMapel'];

        // KELOMPOK C2. DASAR PROGRAM KEAHLIAN RPL SEPULUH
        $calculateNilaiC2RPL = $nilaiService->calculate($c2rpl, 'Sepuluh');
        $nilaiC2RPL = $calculateNilaiC2RPL['calculatedNilai'];
        $mapelNilaiCP2RPL = $calculateNilaiC2RPL['listOfMapel'];

        // KELOMPOK C2. DASAR PROGRAM KEAHLIAN OTO SEPULUH
        $calculateNilaiC2OTO = $nilaiService->calculate($c2oto, 'Sepuluh');
        $nilaiC2OTO = $calculateNilaiC2OTO['calculatedNilai'];
        $mapelNilaiCP2OTO = $calculateNilaiC2OTO['listOfMapel'];

        // KELOMPOK C3. DASAR PROGRAM KEAHLIAN AK Sebelas
        $calculateNilaiC3AK = $nilaiService->calculate($c3ak, 'Sebelas');
        $nilaiC3AK = $calculateNilaiC3AK['calculatedNilai'];
        $mapelNilaiCP3AK = $calculateNilaiC3AK['listOfMapel'];

        // KELOMPOK C3. DASAR PROGRAM KEAHLIAN BDP Sebelas
        $calculateNilaiC3BDP = $nilaiService->calculate($c3bdp, 'Sebelas');
        $nilaiC3BDP = $calculateNilaiC3BDP['calculatedNilai'];
        $mapelNilaiCP3BDP = $calculateNilaiC3BDP['listOfMapel'];

        // KELOMPOK C3. DASAR PROGRAM KEAHLIAN RPL Sebelas
        $calculateNilaiC3RPL = $nilaiService->calculate($c3rpl, 'sebelas');
        $nilaiC3RPL = $calculateNilaiC3RPL['calculatedNilai'];
        $mapelNilaiCP3RPL = $calculateNilaiC3RPL['listOfMapel'];

        // KELOMPOK C3. DASAR PROGRAM KEAHLIAN TBSM Sebelas
        $calculateNilaiC3TBSM = $nilaiService->calculate($c3tbsm, 'Sebelas');
        $nilaiC3TBSM = $calculateNilaiC3TBSM['calculatedNilai'];
        $mapelNilaiCP3TBSM = $calculateNilaiC3TBSM['listOfMapel'];

        // KELOMPOK C3. DASAR PROGRAM KEAHLIAN TKRO Sebelas
        $calculateNilaiC3TKRO = $nilaiService->calculate($c3tkro, 'Sebelas');
        $nilaiC3TKRO = $calculateNilaiC3TKRO['calculatedNilai'];
        $mapelNilaiCP3TKRO = $calculateNilaiC3TKRO['listOfMapel'];

        // KELOMPOK C3. DASAR PROGRAM KEAHLIAN AK Duabelas
        $calculateNilaiC3AK12 = $nilaiService->calculate($c3ak, 'Duabelas');
        $nilaiC3AK12 = $calculateNilaiC3AK12['calculatedNilai'];
        $mapelNilaiCP3AK12 = $calculateNilaiC3AK12['listOfMapel'];

        // KELOMPOK C3. DASAR PROGRAM KEAHLIAN BDP Duabelas
        $calculateNilaiC3BDP12 = $nilaiService->calculate($c3bdp, 'Duabelas');
        $nilaiC3BDP12 = $calculateNilaiC3BDP12['calculatedNilai'];
        $mapelNilaiCP3BDP12 = $calculateNilaiC3BDP12['listOfMapel'];

        // KELOMPOK C3. DASAR PROGRAM KEAHLIAN RPL Duabelas
        $calculateNilaiC3RPL12 = $nilaiService->calculate($c3rpl, 'Duabelas');
        $nilaiC3RPL12 = $calculateNilaiC3RPL12['calculatedNilai'];
        $mapelNilaiCP3RPL12 = $calculateNilaiC3RPL12['listOfMapel'];

        // KELOMPOK C3. DASAR PROGRAM KEAHLIAN TBSM Duabelas
        $calculateNilaiC3TBSM12 = $nilaiService->calculate($c3tbsm, 'Duabelas');
        $nilaiC3TBSM12 = $calculateNilaiC3TBSM12['calculatedNilai'];
        $mapelNilaiCP3TBSM12 = $calculateNilaiC3TBSM12['listOfMapel'];

        // KELOMPOK C3. DASAR PROGRAM KEAHLIAN TKRO Duabelas
        $calculateNilaiC3TKRO12 = $nilaiService->calculate($c3tkro, 'Duabelas');
        $nilaiC3TKRO12 = $calculateNilaiC3TKRO12['calculatedNilai'];
        $mapelNilaiCP3TKRO12 = $calculateNilaiC3TKRO12['listOfMapel'];

        // KELOMPOK C3. DASAR PROGRAM KEAHLIAN ALL Semua
        $calculateNilaiC3ALL = $nilaiService->calculate($c3all, 'Semua');
        $nilaiC3ALL = $calculateNilaiC3ALL['calculatedNilai'];
        $mapelNilaiCP3ALL = $calculateNilaiC3ALL['listOfMapel'];

        // KELOMPOK D. Muatan Kewilayahan Semua
        $calculateNilaiD = $nilaiService->calculate($d, 'Semua');
        $nilaiD = $calculateNilaiD['calculatedNilai'];
        $mapelNilaiDP = $calculateNilaiD['listOfMapel'];

        $calculateNilaiD12 = $nilaiService->calculate($d, 'Semua');
        $nilaiD12 = $calculateNilaiD12['calculatedNilai'];
        $mapelNilaiDP12 = $calculateNilaiD12['listOfMapel'];

        //End Pengetahuan
        $mappingWaliKelas =MappingWaliKelas::where('kelas_id',$mappingSiswa->kelas_id)->where('tahun_ajaran_id',$mappingSiswa->tahun_ajaran_id)->first();
        $nilaiAbsensi = Absen::where('siswa_id',$mappingSiswa->siswa_id)->first();
        $nilaiEkskul = NilaiEkstrakulikuler::where('siswa_id',$mappingSiswa->siswa_id)->get();
        $catatan = Catatan::where('siswa_id',$mappingSiswa->siswa_id)->first();

        $curentDate = Carbon::now('Asia/Jakarta');
        $dateFormat = $curentDate->format('d F Y');

        return view('cetak-sampul-raport.show',compact('mappingSiswa','mapelNilaiPA','mapelNilaiPA10','mapelNilaiBP','mapelNilaiBP10','mapelNilaiCP1','mapelNilaiCP2AK','mapelNilaiCP2BDP','mapelNilaiCP2RPL','mapelNilaiCP2OTO','mapelNilaiCP3AK','mapelNilaiCP3BDP','mapelNilaiCP3RPL','mapelNilaiCP3TBSM','mapelNilaiCP3TKRO','mapelNilaiCP3ALL','mapelNilaiDP','mapelNilaiCP3AK12','mapelNilaiCP3BDP12','mapelNilaiCP3RPL12','mapelNilaiCP3TBSM12','mapelNilaiCP3TKRO12','mappingWaliKelas','nilaiA','nilaiA10','nilaiB','nilaiB10','nilaiC1','nilaiC2AK','nilaiC2BDP','nilaiC2RPL','nilaiC2OTO','nilaiC3AK','nilaiC3BDP','nilaiC3RPL','nilaiC3TBSM','nilaiC3TKRO','nilaiC3ALL','nilaiD','nilaiC3AK12','nilaiC3BDP12','nilaiC3RPL12','nilaiC3TBSM12','nilaiC3TKRO12','nilaiAbsensi','nilaiEkskul','catatan', 'semester', 'dateFormat'));
    }

    public function sampul2($id)
    {
        $mappingSiswa = MappingSiswa::find($id);
        return view('cetak-sampul-raport.sampul2',compact('mappingSiswa'));
    }

    public function sampul3($id)
    {
        $mappingSiswa = MappingSiswa::find($id);
        return view('cetak-sampul-raport.sampul3',compact('mappingSiswa'));
    }

    public function legger($id) {
        $siswa = MappingSiswa::where('kelas_id', $id)->get();
        $mappingWaliKelas = MappingWaliKelas::where('guru_id', Auth::user()->model_id)->first();
        foreach ($siswa as $key) {
            $siswa_id = $key->siswa_id;
        }
        //End Pengetahuan
        return view('cetak-sampul-raport.legger',compact('siswa','mappingWaliKelas'));
    }
    /**
     * Show the form for editing the specified resource.
     */
    public function absensiRaport()
    {
        $kelas = Kelas::orderBy('nama_kelas','ASC')->get();
        return view('cetak-sampul-raport.absensi',compact('kelas'));
    }

    public function cetakAbsensiRaport(Request $request)
    {
        $kelas = Kelas::orderBy('nama_kelas','ASC')->get();
        $waliKelas = MappingWaliKelas::where('kelas_id',$kelas)->first();
        $mappingSiswa = MappingSiswa::where('kelas_id',$kelas)->get();
        return view('cetak-sampul-raport.cetakAbsensi',compact('mappingSiswa','waliKelas'));
    }


}
