<?php

namespace App\Http\Controllers;

use App\Models\Kelas;
use App\Models\MappingSiswa;
use App\Models\MappingWaliKelas;
use App\Models\NilaiKeterampilan;
use App\Models\NilaiPas;
use App\Models\NilaiPengetahuan;
use App\Models\NilaiPts;
use App\Models\RateNilai;
use App\Models\Semester;
use App\Models\TahunAjaran;
use App\Models\Tingkatan;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class CetakRangkingController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $kelas_id = $request->kelas;
        $activeTahunAjaran = TahunAjaran::where('is_active', 1)->first();
        $kelas = Kelas::orderBy('nama_kelas','ASC')->get();
        $mappingWalikelas = MappingWaliKelas::where('guru_id', Auth::user()->model_id)
                                             ->where('tahun_ajaran_id', $activeTahunAjaran->id)->first();
        $mappingSiswa = MappingSiswa::where('kelas_id', $kelas_id)
                                    ->where('tahun_ajaran_id',$activeTahunAjaran->id)->get();
        $semesterActive = Semester::where('is_active', 1)->first();
        $rasio = RateNilai::where('is_active', 1)->first();
        $summary = [];

        foreach ($mappingSiswa as $siswa) {
            $nilaiPengetahuan = NilaiPengetahuan::where('siswa_id', $siswa->siswa_id)
                ->where('tahun_ajaran_id', $activeTahunAjaran->id)
                ->where('semester', $semesterActive->kode)
                ->sum('nilai');

            $nilaiKeterampilan = NilaiKeterampilan::where('siswa_id', $siswa->siswa_id)
                ->where('tahun_ajaran_id', $activeTahunAjaran->id)
                ->where('semester', $semesterActive->kode)
                ->sum('nilai');

            $nilaiPts = NilaiPts::where('siswa_id', $siswa->siswa_id)
                ->where('tahun_ajaran_id', $activeTahunAjaran->id)
                ->where('semester', $semesterActive->kode)
                ->sum('nilai');

            $nilaiPas = NilaiPas::where('siswa_id', $siswa->siswa_id)
                ->where('tahun_ajaran_id', $activeTahunAjaran->id)
                ->where('semester', $semesterActive->kode)
                ->sum('nilai');

            $totalNilai = $nilaiPengetahuan + $nilaiKeterampilan + $nilaiPts + $nilaiPas;

            // Simpan informasi siswa ke dalam array summary
            $summary[] = [
                'siswa' => $siswa->siswa,
                'nilai_pengetahuan' => $nilaiPengetahuan,
                'nilai_keterampilan' => $nilaiKeterampilan,
                'nilai_pts' => $nilaiPts,
                'nilai_pas' => $nilaiPas,
                'total_nilai' => intval($totalNilai / 8), // Konversi ke bilangan bulat
            ];
        }

        usort($summary, function ($a, $b) {
            return $b['total_nilai'] - $a['total_nilai']; // Urutkan berdasarkan nilai bulat
        });

        return view('cetak-rangking.index',compact('mappingSiswa','kelas','kelas_id','summary','mappingWalikelas'));
    }

    /**
     * Display the specified resource.
     */
    public function show(Request $request)
{
    $kelas_id = $request->kelas;

    $activeTahunAjaran = TahunAjaran::where('is_active', 1)->first();
    // Ambil mapping wali kelas
    $mappingWalikelas = MappingWaliKelas::where('guru_id', Auth::user()->model_id)->first();

    // Ambil siswa yang sesuai dengan kelas_id
    $mappingSiswa = MappingSiswa::where('kelas_id', $kelas_id)
    ->where('tahun_ajaran_id',$activeTahunAjaran->id)->get();


    // Ambil tahun ajaran dan semester aktif
    $activeTahunAjaran = TahunAjaran::where('is_active', true)->first();
    $semesterActive = Semester::where('is_active', true)->first();

    // Ambil rasio nilai
    $rasio = RateNilai::where('kode', 'AS')->first();

    $summary = [];

    foreach ($mappingSiswa as $siswa) {
        // Ambil nilai berdasarkan siswa_id, tahun ajaran, dan semester
        $nilaiPengetahuan = NilaiPengetahuan::where('siswa_id', $siswa->siswa_id)
            ->where('tahun_ajaran_id', $activeTahunAjaran->id)
            ->where('semester', $semesterActive->kode)
            ->sum('nilai');

        $nilaiKeterampilan = NilaiKeterampilan::where('siswa_id', $siswa->siswa_id)
            ->where('tahun_ajaran_id', $activeTahunAjaran->id)
            ->where('semester', $semesterActive->kode)
            ->sum('nilai');

        $nilaiPts = NilaiPts::where('siswa_id', $siswa->siswa_id)
            ->where('tahun_ajaran_id', $activeTahunAjaran->id)
            ->where('semester', $semesterActive->kode)
            ->sum('nilai');

        $nilaiPas = NilaiPas::where('siswa_id', $siswa->siswa_id)
            ->where('tahun_ajaran_id', $activeTahunAjaran->id)
            ->where('semester', $semesterActive->kode)
            ->sum('nilai');

        $totalNilai = $nilaiPengetahuan + $nilaiKeterampilan + $nilaiPts + $nilaiPas;

        // Simpan informasi siswa ke dalam array summary
        $summary[] = [
            'siswa' => $siswa->siswa,
            'nilai_pengetahuan' => $nilaiPengetahuan,
            'nilai_keterampilan' => $nilaiKeterampilan,
            'nilai_pts' => $nilaiPts,
            'nilai_pas' => $nilaiPas,
            'total_nilai' => intval($totalNilai / 8), // Konversi ke bilangan bulat
        ];
    }

    // Urutkan summary berdasarkan total nilai
    usort($summary, function ($a, $b) {
        return $b['total_nilai'] - $a['total_nilai']; // Urutkan berdasarkan nilai bulat
    });

    return view('cetak-rangking.show', compact('mappingSiswa', 'kelas_id', 'summary'));
}
}
