<?php

namespace App\Http\Controllers;

use App\Models\Catatan;
use App\Models\MappingSiswa;
use App\Models\MappingWaliKelas;
use App\Models\TahunAjaran;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class CatatanController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $tahun_ajaran = TahunAjaran::where('is_active',1)->first();
        $mapping_walikelas = MappingWaliKelas::where('guru_id',Auth::user()->model_id)
                                            ->where('tahun_ajaran_id',$tahun_ajaran->id)->first();
        $mapping_siswa = MappingSiswa::join('siswa', 'mapping_siswa.siswa_id', '=', 'siswa.id')
                                            ->where('mapping_siswa.kelas_id', $mapping_walikelas->kelas->id)
                                            ->where('mapping_siswa.tahun_ajaran_id', $tahun_ajaran->id)
                                            ->select('mapping_siswa.*', 'siswa.nama_siswa')
                                            ->orderBy('siswa.nama_siswa', 'ASC')
                                            ->get();
        $catatan = Catatan::where('kelas_id',$mapping_walikelas->kelas_id)
                            ->where('tahun_ajaran_id',$tahun_ajaran->id)->get();
        return view('catatan.index',compact('catatan','mapping_siswa','mapping_walikelas','tahun_ajaran'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'tahun_ajaran_id' => 'required|integer',
            'mapping_walikelas_id' => 'required|integer',
            'kelas_id' => 'required|integer',
            'siswa' => 'required|array',
            'siswa.*.status' => 'required|string',
            'siswa.*.catatan_walikelas' => 'required|string',
        ]);

        $tahun_ajaran = $request->tahun_ajaran_id;
        $mapping_walikelas = $request->mapping_walikelas_id;
        $kelas = $request->kelas_id;

        foreach ($request->siswa as $siswa_id => $value) {
            $status = $value['status'] ?? '-';
            $catatan_walikelas = $value['catatan_walikelas'] ?? '-';

            Catatan::updateOrCreate(
                [
                    'siswa_id' => $siswa_id,
                    'tahun_ajaran_id' => $tahun_ajaran,
                    'mapping_walikelas_id' => $mapping_walikelas,
                    'kelas_id' => $kelas,
                    'semester' => \App\Models\Semester::where('is_active', true)->first()->kode,
                ],
                [
                    'status' => $status,
                    'catatan_walikelas' => $catatan_walikelas,
                ]
            );
        }


        return redirect()->back()->with('sukses','Catatan berhasil disimpan');


    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
