<?php

namespace App\Http\Controllers;

use App\Models\User;
use Carbon\Carbon;
use Illuminate\Auth\Events\PasswordReset;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Password;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Str;

class AuthController extends Controller
{
    public function index() {
        return view('auth_template.login');
    }

    public function store(Request $request)
    {
        $request->validate([
            'email' => 'required|email',
            'password' => 'required',
        ]);

        $data = [
            'email' => $request->email,
            'password' => $request->password,
        ];

        if (Auth::attempt($data)) {
            return redirect('/');
        }else{
            return redirect()->route('login.index')->with('gagal', 'Incorrect login details');
        }

    }

    public function forgot_password() {
        return view('auth_template.forgot_password');
    }

    public function forgot_password_store(Request $request) {
        $request->validate(([
            'email' => 'required|email',
        ]));

        $status = Password::sendResetLink(
            $request->only('email')
        );

        return $status === Password::RESET_LINK_SENT
                    ? back()->with(['status' => __($status)])
                    : back()->withErrors(['email' => __($status)]);
    }

    public function reset_password($token) {
        return view('auth_template.reset_password',['token'=> $token]);
    }

    public function reset_password_store(Request $request) {
        $request->validate([
            'token' => 'required',
            'email' => 'required|email',
            'password' => 'required|min:8|confirmed',
        ]);

        $data = User::where('email',$request->email)->update([
            'password' => Hash::make(($request->password)),
            'remember_token' => Str::random(60),
        ]);

        return redirect()->route('login.index')->with('status', 'Berhasil');

    }

    public function logout(Request $request) {
        Auth::logout();

        $request->session()->invalidate();

        $request->session()->regenerateToken();

        return redirect('/login');
    }
}
