<?php

namespace App\Exports;

use App\Invoice;
use App\Models\MappingSiswa;
use App\Models\Siswa;
use Maatwebsite\Excel\Concerns\FromArray;

class TemplateExport implements FromArray
{
    public function array(): array
    {
        $mappingSiswa = MappingSiswa::join('siswa', 'mapping_siswa.siswa_id', '=', 'siswa.id')
            ->where('mapping_siswa.kelas_id', request()->kelas_id)
            ->where('mapping_siswa.tahun_ajaran_id', request()->tahun_ajaran_id)
            ->orderBy('siswa.nama_siswa', 'ASC')
            ->get();

        $data = [
            ['No', 'Nama Siswa', 'Nilai']
        ];

        $no = 1;
        foreach($mappingSiswa as $ms){
            $siswa = Siswa::find($ms->siswa_id);
            array_push($data, [
                $no++,
                $siswa->nama_siswa,
                ''
            ]);
        }

        return $data;
    }
}
