<?php

namespace App\Exports;

use Illuminate\Support\Facades\Log;
use Maatwebsite\Excel\Concerns\FromArray;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithStyles;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Events\AfterSheet;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use PhpOffice\PhpSpreadsheet\Cell\Coordinate;

class LeggerExport implements FromArray, WithHeadings, WithStyles, WithEvents, WithHeadingRow
{
    protected $data;

    public function __construct($data)
    {
        $this->data = $data;
    }

    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function(AfterSheet $event){
                $sheet = $event->sheet;
                $headings = $this->headings();

                [$labelHeadings, $npNK] = $headings;

                $sheet->mergeCells('A1:A2');
                $sheet->setCellValue('A1', 'Nama');
                
                $letterStartingCellNamaMapel = 'B';
                $numberStartingCellNamaMapel = 1;
                $startingCellNamaMapel = $letterStartingCellNamaMapel . $numberStartingCellNamaMapel;
                foreach($labelHeadings as $heading){
                    $letterStartingCellNamaMapel++;
                    $nextLetterStartingCellNamaMapel = $letterStartingCellNamaMapel;
                    $nextStartingCellNamaMapel = $nextLetterStartingCellNamaMapel . $numberStartingCellNamaMapel;
                    $sheet->mergeCells("$startingCellNamaMapel:$nextStartingCellNamaMapel");
                    $sheet->setCellValue($startingCellNamaMapel, $heading);
                    $letterStartingCellNamaMapel++;
                    $nextValue = $letterStartingCellNamaMapel;
                    $startingCellNamaMapel = $nextValue . $numberStartingCellNamaMapel;
                }

                // set np nk for each mapel
                $letterStart = 'B';
                $numberStart = 2;
                $cellStart = $letterStart . $numberStart;
                foreach($npNK as $np){
                    $letterStart++;
                    $sheet->setCellValue($cellStart, $np);
                    $nextLetter = $letterStart;
                    $cellStart = $nextLetter . $numberStart;
                }
            }
        ];
    }

    public function array(): array
    {
        $formattedData = [];
        foreach ($this->data as $item) {
            $row = [$item['nama']];
            // Cek apakah 'nilai' ada dan jika ada, format data
            if (isset($item['nilai']) && is_array($item['nilai'])) {
                foreach ($item['nilai'] as $nilai) {
                    $row[] = $nilai['NP'];
                    $row[] = $nilai['NK'];
                }
            }

            $formattedData[] = $row;
        }
        return $formattedData;
    }

    public function headings(): array
    {
        $firstItem = reset($this->data);
        $firstItem = collect($firstItem)->first();
        $subjects = [];

        // Cek apakah 'nilai' ada dan ambil daftar mata pelajaran beserta NP dan NK
        foreach ($firstItem['nilai'] as $key => $value) {
            $subjects[] = $key;
        }

        $completeSubjects = array_merge($subjects);
        $labelNpNk = [];
        foreach($completeSubjects as $key => $subject){
            $labelNpNk[] = 'NP';
            $labelNpNk[] = 'NK';
        }

        $finalHeadings = [];

        array_push($finalHeadings, $completeSubjects);
        array_push($finalHeadings, $labelNpNk);

        return $finalHeadings;
    }

    public function styles(Worksheet $sheet)
    {
        $headerStyleArray = [
            'font' => [
                'bold' => true,
            ],
        ];

        $dangerStyleArray = [
            'font' => [
                'color' => ['argb' => 'FF0000'],
            ],
        ];

        // Terapkan gaya pada sel header
        $sheet->getStyle('A1:' . $sheet->getHighestColumn() . '1')->applyFromArray($headerStyleArray);

        // Dapatkan indeks kolom tertinggi
        $highestColumn = $sheet->getHighestColumn();
        $highestColumnIndex = Coordinate::columnIndexFromString($highestColumn);

        // Terapkan gaya pada sel data
        $dataRowCount = count($this->data) + 1; // Hitung jumlah baris data
        for ($row = 2; $row <= $dataRowCount; $row++) {
            for ($col = 2; $col <= $highestColumnIndex; $col++) {
                $cell = $sheet->getCellByColumnAndRow($col, $row);
                if ($cell->getValue() < 75) {
                    $sheet->getStyleByColumnAndRow($col, $row)->applyFromArray($dangerStyleArray);
                }
            }
        }

        return [
            1 => $headerStyleArray,
        ];
    }

}
